/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.textview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.link.QMUILinkTouchMovementMethod;
import com.qmuiteam.qmui.link.QMUILinkify;
import com.qmuiteam.qmui.span.QMUIOnSpanClickListener;
import java.util.HashSet;
import java.util.Set;

public class QMUILinkTextView
extends QMUIAlphaTextView
implements QMUIOnSpanClickListener {
    private static final String TAG = "LinkTextView";
    private static final int MSG_CHECK_DOUBLE_TAP_TIMEOUT = 1000;
    public static int AUTO_LINK_MASK_REQUIRED = 7;
    private static Set<String> AUTO_LINK_SCHEME_INTERRUPTED = new HashSet<String>();
    private CharSequence mOriginText = null;
    private ColorStateList mLinkTextColor;
    private ColorStateList mLinkBgColor;
    private int mAutoLinkMaskCompat;
    private OnLinkClickListener mOnLinkClickListener;
    private OnLinkLongClickListener mOnLinkLongClickListener;
    private long mDownMillis = 0L;
    private static final long TAP_TIMEOUT = 200L;
    private static final long DOUBLE_TAP_TIMEOUT;
    private Handler mSingleTapConfirmedHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (1000 != msg.what) {
                return;
            }
            Log.d((String)QMUILinkTextView.TAG, (String)("handleMessage: " + msg.obj));
            if (msg.obj instanceof String) {
                String url = (String)msg.obj;
                if (null != QMUILinkTextView.this.mOnLinkClickListener && !TextUtils.isEmpty((CharSequence)url)) {
                    String schemeUrl = url.toLowerCase();
                    if (schemeUrl.startsWith("tel:")) {
                        String phoneNumber = Uri.parse((String)url).getSchemeSpecificPart();
                        QMUILinkTextView.this.mOnLinkClickListener.onTelLinkClick(phoneNumber);
                    } else if (schemeUrl.startsWith("mailto:")) {
                        String mailAddr = Uri.parse((String)url).getSchemeSpecificPart();
                        QMUILinkTextView.this.mOnLinkClickListener.onMailLinkClick(mailAddr);
                    } else if (schemeUrl.startsWith("http") || schemeUrl.startsWith("https")) {
                        QMUILinkTextView.this.mOnLinkClickListener.onWebUrlLinkClick(url);
                    }
                }
            }
        }
    };

    public QMUILinkTextView(Context context) {
        this(context, null);
        this.mLinkBgColor = null;
        this.mLinkTextColor = ContextCompat.getColorStateList((Context)context, (int)R.color.qmui_s_link_color);
    }

    public QMUILinkTextView(Context context, ColorStateList linkTextColor, ColorStateList linkBgColor) {
        this(context, null);
        this.mLinkBgColor = linkBgColor;
        this.mLinkTextColor = linkTextColor;
    }

    public QMUILinkTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mAutoLinkMaskCompat = this.getAutoLinkMask() | AUTO_LINK_MASK_REQUIRED;
        this.setAutoLinkMask(0);
        this.setMovementMethodCompat(QMUILinkTouchMovementMethod.getInstance());
        this.setHighlightColor(0);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUILinkTextView);
        this.mLinkBgColor = array.getColorStateList(R.styleable.QMUILinkTextView_qmui_linkBackgroundColor);
        this.mLinkTextColor = array.getColorStateList(R.styleable.QMUILinkTextView_qmui_linkTextColor);
        array.recycle();
        if (this.mOriginText != null) {
            this.setText(this.mOriginText);
        }
        this.setChangeAlphaWhenPress(false);
    }

    public void setOnLinkClickListener(OnLinkClickListener onLinkClickListener) {
        this.mOnLinkClickListener = onLinkClickListener;
    }

    public void setOnLinkLongClickListener(OnLinkLongClickListener onLinkLongClickListener) {
        this.mOnLinkLongClickListener = onLinkLongClickListener;
    }

    public int getAutoLinkMaskCompat() {
        return this.mAutoLinkMaskCompat;
    }

    public void setAutoLinkMaskCompat(int mask) {
        this.mAutoLinkMaskCompat = mask;
    }

    public void addAutoLinkMaskCompat(int mask) {
        this.mAutoLinkMaskCompat |= mask;
    }

    public void removeAutoLinkMaskCompat(int mask) {
        this.mAutoLinkMaskCompat &= ~mask;
    }

    public void setLinkColor(ColorStateList linkTextColor) {
        this.mLinkTextColor = linkTextColor;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.mOriginText = text;
        if (!TextUtils.isEmpty((CharSequence)text)) {
            SpannableStringBuilder builder = new SpannableStringBuilder(text);
            QMUILinkify.addLinks((Spannable)builder, this.mAutoLinkMaskCompat, this.mLinkTextColor, this.mLinkBgColor, (QMUIOnSpanClickListener)this);
            text = builder;
        }
        super.setText(text, type);
    }

    @Override
    public boolean onSpanClick(String text) {
        if (null == text) {
            Log.w((String)TAG, (String)"onSpanClick interrupt null text");
            return true;
        }
        long clickUpTime = SystemClock.uptimeMillis() - this.mDownMillis;
        Log.w((String)TAG, (String)("onSpanClick clickUpTime: " + clickUpTime));
        if (this.mSingleTapConfirmedHandler.hasMessages(1000)) {
            this.disallowOnSpanClickInterrupt();
            return true;
        }
        if (200L < clickUpTime) {
            Log.w((String)TAG, (String)("onSpanClick interrupted because of TAP_TIMEOUT: " + clickUpTime));
            return true;
        }
        String scheme = Uri.parse((String)text).getScheme();
        if (scheme != null) {
            scheme = scheme.toLowerCase();
        }
        if (AUTO_LINK_SCHEME_INTERRUPTED.contains(scheme)) {
            long waitTime = DOUBLE_TAP_TIMEOUT - clickUpTime;
            this.mSingleTapConfirmedHandler.removeMessages(1000);
            Message msg = Message.obtain();
            msg.what = 1000;
            msg.obj = text;
            this.mSingleTapConfirmedHandler.sendMessageDelayed(msg, waitTime);
            return true;
        }
        return false;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                boolean hasSingleTap = this.mSingleTapConfirmedHandler.hasMessages(1000);
                Log.w((String)TAG, (String)("onTouchEvent hasSingleTap: " + hasSingleTap));
                if (!hasSingleTap) {
                    this.mDownMillis = SystemClock.uptimeMillis();
                    break;
                }
                Log.w((String)TAG, (String)"onTouchEvent disallow onSpanClick mSingleTapConfirmedHandler because of DOUBLE TAP");
                this.disallowOnSpanClickInterrupt();
            }
        }
        return super.onTouchEvent(event);
    }

    private void disallowOnSpanClickInterrupt() {
        this.mSingleTapConfirmedHandler.removeMessages(1000);
        this.mDownMillis = 0L;
    }

    protected boolean performSpanLongClick(String text) {
        if (this.mOnLinkLongClickListener != null) {
            this.mOnLinkLongClickListener.onLongClick(text);
            return true;
        }
        return false;
    }

    @Override
    public boolean performLongClick() {
        int end = this.getSelectionEnd();
        if (end > 0) {
            String selectStr = this.getText().subSequence(this.getSelectionStart(), end).toString();
            return this.performSpanLongClick(selectStr) || super.performLongClick();
        }
        return super.performLongClick();
    }

    static {
        AUTO_LINK_SCHEME_INTERRUPTED.add("tel");
        AUTO_LINK_SCHEME_INTERRUPTED.add("mailto");
        AUTO_LINK_SCHEME_INTERRUPTED.add("http");
        AUTO_LINK_SCHEME_INTERRUPTED.add("https");
        DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    }

    public static interface OnLinkLongClickListener {
        public void onLongClick(String var1);
    }

    public static interface OnLinkClickListener {
        public void onTelLinkClick(String var1);

        public void onMailLinkClick(String var1);

        public void onWebUrlLinkClick(String var1);
    }
}

