/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.section;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public class QMUISection<H extends Model<H>, T extends Model<T>> {
    public static final int SECTION_INDEX_UNKNOWN = -1;
    public static final int ITEM_INDEX_UNKNOWN = -1;
    public static final int ITEM_INDEX_SECTION_HEADER = -2;
    public static final int ITEM_INDEX_LOAD_BEFORE = -3;
    public static final int ITEM_INDEX_LOAD_AFTER = -4;
    public static final int ITEM_INDEX_INTERNAL_END = -4;
    public static final int ITEM_INDEX_CUSTOM_OFFSET = -1000;
    private H mHeader;
    private ArrayList<T> mItemList;
    private boolean mIsFold;
    private boolean mIsLocked;
    private boolean mExistBeforeDataToLoad;
    private boolean mExistAfterDataToLoad;
    private boolean mIsErrorToLoadBefore = false;
    private boolean mIsErrorToLoadAfter = false;

    public QMUISection(@NonNull H header, @Nullable List<T> itemList) {
        this(header, itemList, false);
    }

    public QMUISection(@NonNull H header, @Nullable List<T> itemList, boolean isFold) {
        this(header, itemList, isFold, false, false, false);
    }

    public QMUISection(@NonNull H header, @Nullable List<T> itemList, boolean isFold, boolean isLocked, boolean existBeforeDataToLoad, boolean existAfterDataToLoad) {
        this.mHeader = header;
        this.mItemList = new ArrayList();
        if (itemList != null) {
            this.mItemList.addAll(itemList);
        }
        this.mIsFold = isFold;
        this.mIsLocked = isLocked;
        this.mExistBeforeDataToLoad = existBeforeDataToLoad;
        this.mExistAfterDataToLoad = existAfterDataToLoad;
    }

    public H getHeader() {
        return this.mHeader;
    }

    public boolean isFold() {
        return this.mIsFold;
    }

    public void setFold(boolean fold) {
        this.mIsFold = fold;
    }

    public boolean isLocked() {
        return this.mIsLocked;
    }

    public void setLocked(boolean locked) {
        this.mIsLocked = locked;
    }

    public boolean isExistBeforeDataToLoad() {
        return this.mExistBeforeDataToLoad;
    }

    public void setExistBeforeDataToLoad(boolean existBeforeDataToLoad) {
        this.mExistBeforeDataToLoad = existBeforeDataToLoad;
    }

    public boolean isExistAfterDataToLoad() {
        return this.mExistAfterDataToLoad;
    }

    public void setExistAfterDataToLoad(boolean existAfterDataToLoad) {
        this.mExistAfterDataToLoad = existAfterDataToLoad;
    }

    public boolean isErrorToLoadBefore() {
        return this.mIsErrorToLoadBefore;
    }

    public void setErrorToLoadBefore(boolean errorToLoadBefore) {
        this.mIsErrorToLoadBefore = errorToLoadBefore;
    }

    public boolean isErrorToLoadAfter() {
        return this.mIsErrorToLoadAfter;
    }

    public void setErrorToLoadAfter(boolean errorToLoadAfter) {
        this.mIsErrorToLoadAfter = errorToLoadAfter;
    }

    public int getItemCount() {
        return this.mItemList.size();
    }

    public T getItemAt(int index) {
        if (index < 0 || index >= this.mItemList.size()) {
            return null;
        }
        return (T)((Model)this.mItemList.get(index));
    }

    public boolean existItem(T item) {
        return this.mItemList.contains(item);
    }

    public void finishLoadMore(@Nullable List<T> data, boolean isLoadBefore, boolean existMoreData) {
        if (isLoadBefore) {
            if (data != null) {
                this.mItemList.addAll(0, data);
            }
            this.mExistBeforeDataToLoad = existMoreData;
        } else {
            if (data != null) {
                this.mItemList.addAll(data);
            }
            this.mExistAfterDataToLoad = existMoreData;
        }
    }

    public void cloneStatusTo(QMUISection<H, T> other) {
        other.mExistBeforeDataToLoad = this.mExistBeforeDataToLoad;
        other.mExistAfterDataToLoad = this.mExistAfterDataToLoad;
        other.mIsFold = this.mIsFold;
        other.mIsLocked = this.mIsLocked;
        other.mIsErrorToLoadBefore = this.mIsErrorToLoadBefore;
        other.mIsErrorToLoadAfter = this.mIsErrorToLoadAfter;
    }

    public QMUISection<H, T> mutate() {
        QMUISection<H, T> section = new QMUISection<H, T>(this.mHeader, this.mItemList, this.mIsFold, this.mIsLocked, this.mExistBeforeDataToLoad, this.mExistAfterDataToLoad);
        section.mIsErrorToLoadBefore = this.mIsErrorToLoadBefore;
        section.mIsErrorToLoadAfter = this.mIsErrorToLoadAfter;
        return section;
    }

    public QMUISection<H, T> cloneForDiff() {
        ArrayList newList = new ArrayList();
        for (Model item : this.mItemList) {
            newList.add(item.cloneForDiff());
        }
        QMUISection section = new QMUISection((Model)this.mHeader.cloneForDiff(), newList, this.mIsFold, this.mIsLocked, this.mExistBeforeDataToLoad, this.mExistAfterDataToLoad);
        section.mIsErrorToLoadBefore = this.mIsErrorToLoadBefore;
        section.mIsErrorToLoadAfter = this.mIsErrorToLoadAfter;
        return section;
    }

    public static final boolean isCustomItemIndex(int index) {
        return index < -4;
    }

    public static interface Model<T> {
        public T cloneForDiff();

        public boolean isSameItem(T var1);

        public boolean isSameContent(T var1);
    }
}

