/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.roundwidget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.qmuiteam.qmui.R;

public class QMUIRoundButtonDrawable
extends GradientDrawable {
    private boolean mRadiusAdjustBounds = true;
    private ColorStateList mFillColors;
    private int mStrokeWidth = 0;
    private ColorStateList mStrokeColors;

    public void setBgData(@Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setColor(colors);
        } else {
            this.mFillColors = colors;
            int currentColor = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setColor(currentColor);
        }
    }

    public void setStrokeData(int width, @Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setStroke(width, colors);
        } else {
            this.mStrokeWidth = width;
            this.mStrokeColors = colors;
            int currentColor = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setStroke(width, currentColor);
        }
    }

    private boolean hasNativeStateListAPI() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public void setIsRadiusAdjustBounds(boolean isRadiusAdjustBounds) {
        this.mRadiusAdjustBounds = isRadiusAdjustBounds;
    }

    protected boolean onStateChange(int[] stateSet) {
        int color2;
        boolean superRet = super.onStateChange(stateSet);
        if (this.mFillColors != null) {
            color2 = this.mFillColors.getColorForState(stateSet, 0);
            this.setColor(color2);
            superRet = true;
        }
        if (this.mStrokeColors != null) {
            color2 = this.mStrokeColors.getColorForState(stateSet, 0);
            this.setStroke(this.mStrokeWidth, color2);
            superRet = true;
        }
        return superRet;
    }

    public boolean isStateful() {
        return this.mFillColors != null && this.mFillColors.isStateful() || this.mStrokeColors != null && this.mStrokeColors.isStateful() || super.isStateful();
    }

    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        if (this.mRadiusAdjustBounds) {
            this.setCornerRadius(Math.min(r.width(), r.height()) / 2);
        }
    }

    public static QMUIRoundButtonDrawable fromAttributeSet(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.QMUIRoundButton, defStyleAttr, 0);
        ColorStateList colorBg = typedArray.getColorStateList(R.styleable.QMUIRoundButton_qmui_backgroundColor);
        ColorStateList colorBorder = typedArray.getColorStateList(R.styleable.QMUIRoundButton_qmui_borderColor);
        int borderWidth = typedArray.getDimensionPixelSize(R.styleable.QMUIRoundButton_qmui_borderWidth, 0);
        boolean isRadiusAdjustBounds = typedArray.getBoolean(R.styleable.QMUIRoundButton_qmui_isRadiusAdjustBounds, false);
        int mRadius = typedArray.getDimensionPixelSize(R.styleable.QMUIRoundButton_qmui_radius, 0);
        int mRadiusTopLeft = typedArray.getDimensionPixelSize(R.styleable.QMUIRoundButton_qmui_radiusTopLeft, 0);
        int mRadiusTopRight = typedArray.getDimensionPixelSize(R.styleable.QMUIRoundButton_qmui_radiusTopRight, 0);
        int mRadiusBottomLeft = typedArray.getDimensionPixelSize(R.styleable.QMUIRoundButton_qmui_radiusBottomLeft, 0);
        int mRadiusBottomRight = typedArray.getDimensionPixelSize(R.styleable.QMUIRoundButton_qmui_radiusBottomRight, 0);
        typedArray.recycle();
        QMUIRoundButtonDrawable bg = new QMUIRoundButtonDrawable();
        bg.setBgData(colorBg);
        bg.setStrokeData(borderWidth, colorBorder);
        if (mRadiusTopLeft > 0 || mRadiusTopRight > 0 || mRadiusBottomLeft > 0 || mRadiusBottomRight > 0) {
            float[] radii = new float[]{mRadiusTopLeft, mRadiusTopLeft, mRadiusTopRight, mRadiusTopRight, mRadiusBottomRight, mRadiusBottomRight, mRadiusBottomLeft, mRadiusBottomLeft};
            bg.setCornerRadii(radii);
            isRadiusAdjustBounds = false;
        } else {
            bg.setCornerRadius(mRadius);
            if (mRadius > 0) {
                isRadiusAdjustBounds = false;
            }
        }
        bg.setIsRadiusAdjustBounds(isRadiusAdjustBounds);
        return bg;
    }
}

