/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.pullRefreshLayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.CircularProgressDrawable;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Scroller;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.nestedScroll.QMUIContinuousNestedScrollLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.pullRefreshLayout.QMUIDefaultRefreshOffsetCalculator;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionLayout;

public class QMUIPullRefreshLayout
extends ViewGroup
implements NestedScrollingParent {
    private static final String TAG = "QMUIPullRefreshLayout";
    private static final int INVALID_POINTER = -1;
    private static final int FLAG_NEED_SCROLL_TO_INIT_POSITION = 1;
    private static final int FLAG_NEED_SCROLL_TO_REFRESH_POSITION = 2;
    private static final int FLAG_NEED_DO_REFRESH = 4;
    private static final int FLAG_NEED_DELIVER_VELOCITY = 8;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    boolean mIsRefreshing = false;
    private View mTargetView;
    private IRefreshView mIRefreshView;
    private View mRefreshView;
    private int mRefreshZIndex = -1;
    private int mSystemTouchSlop;
    private int mTouchSlop;
    private OnPullListener mListener;
    private OnChildScrollUpCallback mChildScrollUpCallback;
    private int mRefreshInitOffset;
    private int mRefreshEndOffset;
    private int mRefreshCurrentOffset;
    private boolean mAutoCalculateRefreshInitOffset = true;
    private boolean mAutoCalculateRefreshEndOffset = true;
    private boolean mEqualTargetRefreshOffsetToRefreshViewHeight = false;
    private int mAutoScrollToRefreshMinOffset = -1;
    private int mTargetInitOffset;
    private int mTargetCurrentOffset;
    private int mTargetRefreshOffset;
    private boolean mDisableNestScrollImpl = false;
    private boolean mEnableOverPull = true;
    private boolean mNestedScrollInProgress;
    private int mActivePointerId = -1;
    private boolean mIsDragging;
    private float mInitialDownY;
    private float mInitialDownX;
    private float mInitialMotionY;
    private float mLastMotionY;
    private float mDragRate = 0.65f;
    private RefreshOffsetCalculator mRefreshOffsetCalculator;
    private VelocityTracker mVelocityTracker;
    private float mMaxVelocity;
    private float mMiniVelocity;
    private Scroller mScroller;
    private int mScrollFlag = 0;
    private boolean mNestScrollDurationRefreshing = false;
    private Runnable mPendingRefreshDirectlyAction = null;
    private boolean mSafeDisallowInterceptTouchEvent = false;

    public QMUIPullRefreshLayout(Context context) {
        this(context, null);
    }

    public QMUIPullRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUIPullRefreshLayoutStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QMUIPullRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mMaxVelocity = vc.getScaledMaximumFlingVelocity();
        this.mMiniVelocity = vc.getScaledMinimumFlingVelocity();
        this.mSystemTouchSlop = vc.getScaledTouchSlop();
        this.mTouchSlop = QMUIDisplayHelper.px2dp(context, this.mSystemTouchSlop);
        this.mScroller = new Scroller(this.getContext());
        this.mScroller.setFriction(this.getScrollerFriction());
        this.addRefreshView();
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIPullRefreshLayout, defStyleAttr, 0);
        try {
            this.mRefreshInitOffset = array.getDimensionPixelSize(R.styleable.QMUIPullRefreshLayout_qmui_refresh_init_offset, Integer.MIN_VALUE);
            this.mRefreshEndOffset = array.getDimensionPixelSize(R.styleable.QMUIPullRefreshLayout_qmui_refresh_end_offset, Integer.MIN_VALUE);
            this.mTargetInitOffset = array.getDimensionPixelSize(R.styleable.QMUIPullRefreshLayout_qmui_target_init_offset, 0);
            this.mTargetRefreshOffset = array.getDimensionPixelSize(R.styleable.QMUIPullRefreshLayout_qmui_target_refresh_offset, QMUIDisplayHelper.dp2px(this.getContext(), 72));
            this.mAutoCalculateRefreshInitOffset = this.mRefreshInitOffset == Integer.MIN_VALUE || array.getBoolean(R.styleable.QMUIPullRefreshLayout_qmui_auto_calculate_refresh_init_offset, false);
            this.mAutoCalculateRefreshEndOffset = this.mRefreshEndOffset == Integer.MIN_VALUE || array.getBoolean(R.styleable.QMUIPullRefreshLayout_qmui_auto_calculate_refresh_end_offset, false);
            this.mEqualTargetRefreshOffsetToRefreshViewHeight = array.getBoolean(R.styleable.QMUIPullRefreshLayout_qmui_equal_target_refresh_offset_to_refresh_view_height, false);
        }
        finally {
            array.recycle();
        }
        this.mRefreshCurrentOffset = this.mRefreshInitOffset;
        this.mTargetCurrentOffset = this.mTargetInitOffset;
    }

    public static boolean defaultCanScrollUp(View view) {
        if (view == null) {
            return false;
        }
        if (view instanceof QMUIContinuousNestedScrollLayout) {
            QMUIContinuousNestedScrollLayout layout2 = (QMUIContinuousNestedScrollLayout)view;
            return layout2.getCurrentScroll() > 0;
        }
        if (view instanceof QMUIStickySectionLayout) {
            QMUIStickySectionLayout layout3 = (QMUIStickySectionLayout)view;
            return QMUIPullRefreshLayout.defaultCanScrollUp((View)layout3.getRecyclerView());
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                AbsListView absListView = (AbsListView)view;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)view, (int)-1) || view.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)view, (int)-1);
    }

    public void setOnPullListener(OnPullListener listener) {
        this.mListener = listener;
    }

    public void setDisableNestScrollImpl(boolean disableNestScrollImpl) {
        this.mDisableNestScrollImpl = disableNestScrollImpl;
    }

    public void setDragRate(float dragRate) {
        this.mDisableNestScrollImpl = true;
        this.mDragRate = dragRate;
    }

    public void setChildScrollUpCallback(OnChildScrollUpCallback childScrollUpCallback) {
        this.mChildScrollUpCallback = childScrollUpCallback;
    }

    protected float getScrollerFriction() {
        return ViewConfiguration.getScrollFriction();
    }

    public void setAutoScrollToRefreshMinOffset(int autoScrollToRefreshMinOffset) {
        this.mAutoScrollToRefreshMinOffset = autoScrollToRefreshMinOffset;
    }

    protected View createRefreshView() {
        return new RefreshView(this.getContext());
    }

    private void addRefreshView() {
        if (this.mRefreshView == null) {
            this.mRefreshView = this.createRefreshView();
        }
        if (!(this.mRefreshView instanceof IRefreshView)) {
            throw new RuntimeException("refreshView must be a instance of IRefreshView");
        }
        this.mIRefreshView = (IRefreshView)this.mRefreshView;
        if (this.mRefreshView.getLayoutParams() == null) {
            this.mRefreshView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        }
        this.addView(this.mRefreshView);
    }

    public void setRefreshOffsetCalculator(RefreshOffsetCalculator refreshOffsetCalculator) {
        this.mRefreshOffsetCalculator = refreshOffsetCalculator;
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mRefreshZIndex < 0) {
            return i;
        }
        if (i == this.mRefreshZIndex) {
            return childCount - 1;
        }
        if (i > this.mRefreshZIndex) {
            return i - 1;
        }
        return i;
    }

    public void openSafeDisallowInterceptTouchEvent() {
        this.mSafeDisallowInterceptTouchEvent = true;
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (this.mSafeDisallowInterceptTouchEvent) {
            super.requestDisallowInterceptTouchEvent(b);
            this.mSafeDisallowInterceptTouchEvent = false;
        }
        if (!(Build.VERSION.SDK_INT < 21 && this.mTargetView instanceof AbsListView || this.mTargetView != null && !ViewCompat.isNestedScrollingEnabled((View)this.mTargetView))) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.ensureTargetView();
        if (this.mTargetView == null) {
            Log.d((String)TAG, (String)"onMeasure: mTargetView == null");
            return;
        }
        int targetMeasureWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000);
        int targetMeasureHeightSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000);
        this.mTargetView.measure(targetMeasureWidthSpec, targetMeasureHeightSpec);
        this.measureChild(this.mRefreshView, widthMeasureSpec, heightMeasureSpec);
        this.mRefreshZIndex = -1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i) != this.mRefreshView) continue;
            this.mRefreshZIndex = i;
            break;
        }
        int refreshViewHeight = this.mRefreshView.getMeasuredHeight();
        if (this.mAutoCalculateRefreshInitOffset && this.mRefreshInitOffset != -refreshViewHeight) {
            this.mRefreshCurrentOffset = this.mRefreshInitOffset = -refreshViewHeight;
        }
        if (this.mEqualTargetRefreshOffsetToRefreshViewHeight) {
            this.mTargetRefreshOffset = refreshViewHeight;
        }
        if (this.mAutoCalculateRefreshEndOffset) {
            this.mRefreshEndOffset = (this.mTargetRefreshOffset - refreshViewHeight) / 2;
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (this.getChildCount() == 0) {
            return;
        }
        this.ensureTargetView();
        if (this.mTargetView == null) {
            Log.d((String)TAG, (String)"onLayout: mTargetView == null");
            return;
        }
        int childLeft = this.getPaddingLeft();
        int childTop = this.getPaddingTop();
        int childWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int childHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        this.mTargetView.layout(childLeft, childTop + this.mTargetCurrentOffset, childLeft + childWidth, childTop + childHeight + this.mTargetCurrentOffset);
        int refreshViewWidth = this.mRefreshView.getMeasuredWidth();
        int refreshViewHeight = this.mRefreshView.getMeasuredHeight();
        this.mRefreshView.layout(width / 2 - refreshViewWidth / 2, this.mRefreshCurrentOffset, width / 2 + refreshViewWidth / 2, this.mRefreshCurrentOffset + refreshViewHeight);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTargetView();
        int action = ev.getAction();
        if (!this.isEnabled() || this.canChildScrollUp() || this.mNestedScrollInProgress) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mIsDragging = false;
                this.mActivePointerId = ev.getPointerId(0);
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    return false;
                }
                this.mInitialDownX = ev.getX(pointerIndex);
                this.mInitialDownY = ev.getY(pointerIndex);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    Log.e((String)TAG, (String)"Got ACTION_MOVE event but have an invalid active pointer id.");
                    return false;
                }
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                this.startDragging(x, y);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mIsDragging = false;
                this.mActivePointerId = -1;
            }
        }
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (!this.isEnabled() || this.canChildScrollUp() || this.mNestedScrollInProgress) {
            Log.d((String)TAG, (String)("fast end onTouchEvent: isEnabled = " + this.isEnabled() + "; canChildScrollUp = " + this.canChildScrollUp() + " ; mNestedScrollInProgress = " + this.mNestedScrollInProgress));
            return false;
        }
        this.acquireVelocityTracker(ev);
        switch (action) {
            case 0: {
                this.mIsDragging = false;
                this.mScrollFlag = 0;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    Log.e((String)TAG, (String)"onTouchEvent Got ACTION_MOVE event but have an invalid active pointer id.");
                    return false;
                }
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                this.startDragging(x, y);
                if (!this.mIsDragging) break;
                float dy = (y - this.mLastMotionY) * this.mDragRate;
                if (dy >= 0.0f) {
                    this.moveTargetView(dy, true);
                } else {
                    int move = this.moveTargetView(dy, true);
                    float delta = Math.abs(dy) - (float)Math.abs(move);
                    if (delta > 0.0f) {
                        ev.setAction(0);
                        float offsetLoc = this.mSystemTouchSlop + 1;
                        if (delta > offsetLoc) {
                            offsetLoc = delta;
                        }
                        ev.offsetLocation(0.0f, offsetLoc);
                        super.dispatchTouchEvent(ev);
                        ev.setAction(action);
                        ev.offsetLocation(0.0f, -offsetLoc);
                        super.dispatchTouchEvent(ev);
                    }
                }
                this.mLastMotionY = y;
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                if (pointerIndex < 0) {
                    Log.e((String)TAG, (String)"Got ACTION_POINTER_DOWN event but have an invalid action index.");
                    return false;
                }
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    Log.e((String)TAG, (String)"Got ACTION_UP event but don't have an active pointer id.");
                    return false;
                }
                if (this.mIsDragging) {
                    this.mIsDragging = false;
                    this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaxVelocity);
                    float vy = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                    if (Math.abs(vy) < this.mMiniVelocity) {
                        vy = 0.0f;
                    }
                    this.finishPull((int)vy);
                }
                this.mActivePointerId = -1;
                this.releaseVelocityTracker();
                return false;
            }
            case 3: {
                this.releaseVelocityTracker();
                return false;
            }
        }
        return true;
    }

    private void ensureTargetView() {
        if (this.mTargetView == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                if (view.equals(this.mRefreshView)) continue;
                this.onSureTargetView(view);
                this.mTargetView = view;
                break;
            }
        }
        if (this.mTargetView != null && this.mPendingRefreshDirectlyAction != null) {
            Runnable runnable = this.mPendingRefreshDirectlyAction;
            this.mPendingRefreshDirectlyAction = null;
            runnable.run();
        }
    }

    protected void onSureTargetView(View targetView) {
    }

    protected void onFinishPull(int vy, int refreshInitOffset, int refreshEndOffset, int refreshViewHeight, int targetCurrentOffset, int targetInitOffset, int targetRefreshOffset) {
    }

    private void finishPull(int vy) {
        this.info("finishPull: vy = " + vy + " ; mTargetCurrentOffset = " + this.mTargetCurrentOffset + " ; mTargetRefreshOffset = " + this.mTargetRefreshOffset + " ; mTargetInitOffset = " + this.mTargetInitOffset + " ; mScroller.isFinished() = " + this.mScroller.isFinished());
        int miniVy = vy / 1000;
        this.onFinishPull(miniVy, this.mRefreshInitOffset, this.mRefreshEndOffset, this.mRefreshView.getHeight(), this.mTargetCurrentOffset, this.mTargetInitOffset, this.mTargetRefreshOffset);
        if (this.mTargetCurrentOffset >= this.mTargetRefreshOffset) {
            if (miniVy > 0) {
                this.mScrollFlag = 6;
                this.mScroller.fling(0, this.mTargetCurrentOffset, 0, miniVy, 0, 0, this.mTargetInitOffset, Integer.MAX_VALUE);
                this.invalidate();
            } else if (miniVy < 0) {
                this.mScroller.fling(0, this.mTargetCurrentOffset, 0, vy, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
                if (this.mScroller.getFinalY() < this.mTargetInitOffset) {
                    this.mScrollFlag = 8;
                } else if (this.mScroller.getFinalY() < this.mTargetRefreshOffset) {
                    int dy = this.mTargetInitOffset - this.mTargetCurrentOffset;
                    this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, dy);
                } else if (this.mScroller.getFinalY() == this.mTargetRefreshOffset) {
                    this.mScrollFlag = 4;
                } else {
                    this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetRefreshOffset - this.mTargetCurrentOffset);
                    this.mScrollFlag = 4;
                }
                this.invalidate();
            } else {
                if (this.mTargetCurrentOffset > this.mTargetRefreshOffset) {
                    this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetRefreshOffset - this.mTargetCurrentOffset);
                }
                this.mScrollFlag = 4;
                this.invalidate();
            }
        } else if (miniVy > 0) {
            this.mScroller.fling(0, this.mTargetCurrentOffset, 0, miniVy, 0, 0, this.mTargetInitOffset, Integer.MAX_VALUE);
            if (this.mScroller.getFinalY() > this.mTargetRefreshOffset) {
                this.mScrollFlag = 6;
            } else if (this.mAutoScrollToRefreshMinOffset >= 0 && this.mScroller.getFinalY() > this.mAutoScrollToRefreshMinOffset) {
                this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetRefreshOffset - this.mTargetCurrentOffset);
                this.mScrollFlag = 4;
            } else {
                this.mScrollFlag = 1;
            }
            this.invalidate();
        } else if (miniVy < 0) {
            this.mScrollFlag = 0;
            this.mScroller.fling(0, this.mTargetCurrentOffset, 0, vy, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            if (this.mScroller.getFinalY() < this.mTargetInitOffset) {
                this.mScrollFlag = 8;
            } else {
                this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetInitOffset - this.mTargetCurrentOffset);
                this.mScrollFlag = 0;
            }
            this.invalidate();
        } else {
            if (this.mTargetCurrentOffset == this.mTargetInitOffset) {
                return;
            }
            if (this.mAutoScrollToRefreshMinOffset >= 0 && this.mTargetCurrentOffset >= this.mAutoScrollToRefreshMinOffset) {
                this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetRefreshOffset - this.mTargetCurrentOffset);
                this.mScrollFlag = 4;
            } else {
                this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetInitOffset - this.mTargetCurrentOffset);
                this.mScrollFlag = 0;
            }
            this.invalidate();
        }
    }

    protected void onRefresh() {
        if (this.mIsRefreshing) {
            return;
        }
        this.mIsRefreshing = true;
        this.mIRefreshView.doRefresh();
        if (this.mListener != null) {
            this.mListener.onRefresh();
        }
    }

    public void finishRefresh() {
        this.mIsRefreshing = false;
        this.mIRefreshView.stop();
        this.mScrollFlag = 1;
        this.mScroller.forceFinished(true);
        this.invalidate();
    }

    public void setToRefreshDirectly() {
        this.setToRefreshDirectly(0L);
    }

    public void setToRefreshDirectly(final long delay) {
        if (this.mTargetView != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    QMUIPullRefreshLayout.this.setTargetViewToTop(QMUIPullRefreshLayout.this.mTargetView);
                    QMUIPullRefreshLayout.this.onRefresh();
                    QMUIPullRefreshLayout.this.mScrollFlag = 2;
                    QMUIPullRefreshLayout.this.invalidate();
                }
            }, delay);
        } else {
            this.mPendingRefreshDirectlyAction = new Runnable(){

                @Override
                public void run() {
                    QMUIPullRefreshLayout.this.setToRefreshDirectly(delay);
                }
            };
        }
    }

    public void setEnableOverPull(boolean enableOverPull) {
        this.mEnableOverPull = enableOverPull;
    }

    protected void setTargetViewToTop(View targetView) {
        if (targetView instanceof RecyclerView) {
            ((RecyclerView)targetView).scrollToPosition(0);
        } else if (targetView instanceof AbsListView) {
            AbsListView listView = (AbsListView)targetView;
            if (Build.VERSION.SDK_INT >= 21) {
                listView.setSelectionFromTop(0, 0);
            } else {
                listView.setSelection(0);
            }
        } else {
            targetView.scrollTo(0, 0);
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    public void reset() {
        this.moveTargetViewTo(this.mTargetInitOffset, false);
        this.mIRefreshView.stop();
        this.mIsRefreshing = false;
        this.mScroller.forceFinished(true);
        this.mScrollFlag = 0;
    }

    protected void startDragging(float x, float y) {
        float dx = x - this.mInitialDownX;
        float dy = y - this.mInitialDownY;
        boolean isYDrag = this.isYDrag(dx, dy);
        if (isYDrag && (dy > (float)this.mTouchSlop || dy < (float)(-this.mTouchSlop) && this.mTargetCurrentOffset > this.mTargetInitOffset) && !this.mIsDragging) {
            this.mLastMotionY = this.mInitialMotionY = this.mInitialDownY + (float)this.mTouchSlop;
            this.mIsDragging = true;
        }
    }

    protected boolean isYDrag(float dx, float dy) {
        return Math.abs(dy) > Math.abs(dx);
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.reset();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.reset();
            this.invalidate();
        }
    }

    public boolean canChildScrollUp() {
        if (this.mChildScrollUpCallback != null) {
            return this.mChildScrollUpCallback.canChildScrollUp(this, this.mTargetView);
        }
        return QMUIPullRefreshLayout.defaultCanScrollUp(this.mTargetView);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        this.info("onStartNestedScroll: nestedScrollAxes = " + nestedScrollAxes);
        return !this.mDisableNestScrollImpl && this.isEnabled() && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.info("onNestedScrollAccepted: axes = " + axes);
        this.mScroller.abortAnimation();
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.mNestedScrollInProgress = true;
        this.mIsDragging = true;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.info("onNestedPreScroll: dx = " + dx + " ; dy = " + dy);
        int parentCanConsume = this.mTargetCurrentOffset - this.mTargetInitOffset;
        if (dy > 0 && parentCanConsume > 0) {
            if (dy >= parentCanConsume) {
                consumed[1] = parentCanConsume;
                this.moveTargetViewTo(this.mTargetInitOffset, true);
            } else {
                consumed[1] = dy;
                this.moveTargetView(-dy, true);
            }
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.info("onNestedScroll: dxConsumed = " + dxConsumed + " ; dyConsumed = " + dyConsumed + " ; dxUnconsumed = " + dxUnconsumed + " ; dyUnconsumed = " + dyUnconsumed);
        if (dyUnconsumed < 0 && !this.canChildScrollUp() && this.mScroller.isFinished() && this.mScrollFlag == 0) {
            this.moveTargetView(-dyUnconsumed, true);
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View child) {
        this.info("onStopNestedScroll: mNestedScrollInProgress = " + this.mNestedScrollInProgress);
        this.mNestedScrollingParentHelper.onStopNestedScroll(child);
        if (this.mNestedScrollInProgress) {
            this.mNestedScrollInProgress = false;
            this.mIsDragging = false;
            if (!this.mNestScrollDurationRefreshing) {
                this.finishPull(0);
            }
        }
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        this.info("onNestedPreFling: mTargetCurrentOffset = " + this.mTargetCurrentOffset + " ; velocityX = " + velocityX + " ; velocityY = " + velocityY);
        if (this.mTargetCurrentOffset > this.mTargetInitOffset) {
            this.mNestedScrollInProgress = false;
            this.mIsDragging = false;
            if (!this.mNestScrollDurationRefreshing) {
                this.finishPull((int)(-velocityY));
            }
            return true;
        }
        return false;
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        try {
            return super.onNestedFling(target, velocityX, velocityY, consumed);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private int moveTargetView(float dy, boolean isDragging) {
        int target = (int)((float)this.mTargetCurrentOffset + dy);
        return this.moveTargetViewTo(target, isDragging);
    }

    private int moveTargetViewTo(int target, boolean isDragging) {
        return this.moveTargetViewTo(target, isDragging, false);
    }

    private int moveTargetViewTo(int target, boolean isDragging, boolean calculateAnyWay) {
        target = this.calculateTargetOffset(target, this.mTargetInitOffset, this.mTargetRefreshOffset, this.mEnableOverPull);
        int offset = 0;
        if (target != this.mTargetCurrentOffset || calculateAnyWay) {
            int newRefreshOffset;
            offset = target - this.mTargetCurrentOffset;
            ViewCompat.offsetTopAndBottom((View)this.mTargetView, (int)offset);
            this.mTargetCurrentOffset = target;
            int total = this.mTargetRefreshOffset - this.mTargetInitOffset;
            if (isDragging) {
                this.mIRefreshView.onPull(Math.min(this.mTargetCurrentOffset - this.mTargetInitOffset, total), total, this.mTargetCurrentOffset - this.mTargetRefreshOffset);
            }
            this.onMoveTargetView(this.mTargetCurrentOffset);
            if (this.mListener != null) {
                this.mListener.onMoveTarget(this.mTargetCurrentOffset);
            }
            if (this.mRefreshOffsetCalculator == null) {
                this.mRefreshOffsetCalculator = new QMUIDefaultRefreshOffsetCalculator();
            }
            if ((newRefreshOffset = this.mRefreshOffsetCalculator.calculateRefreshOffset(this.mRefreshInitOffset, this.mRefreshEndOffset, this.mRefreshView.getHeight(), this.mTargetCurrentOffset, this.mTargetInitOffset, this.mTargetRefreshOffset)) != this.mRefreshCurrentOffset) {
                ViewCompat.offsetTopAndBottom((View)this.mRefreshView, (int)(newRefreshOffset - this.mRefreshCurrentOffset));
                this.mRefreshCurrentOffset = newRefreshOffset;
                this.onMoveRefreshView(this.mRefreshCurrentOffset);
                if (this.mListener != null) {
                    this.mListener.onMoveRefreshView(this.mRefreshCurrentOffset);
                }
            }
        }
        return offset;
    }

    protected int calculateTargetOffset(int target, int targetInitOffset, int targetRefreshOffset, boolean enableOverPull) {
        target = Math.max(target, targetInitOffset);
        if (!enableOverPull) {
            target = Math.min(target, targetRefreshOffset);
        }
        return target;
    }

    private void acquireVelocityTracker(MotionEvent event) {
        if (null == this.mVelocityTracker) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (null != this.mVelocityTracker) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public int getRefreshInitOffset() {
        return this.mRefreshInitOffset;
    }

    public int getRefreshEndOffset() {
        return this.mRefreshEndOffset;
    }

    public int getTargetInitOffset() {
        return this.mTargetInitOffset;
    }

    public int getTargetRefreshOffset() {
        return this.mTargetRefreshOffset;
    }

    public void setTargetRefreshOffset(int targetRefreshOffset) {
        this.mEqualTargetRefreshOffsetToRefreshViewHeight = false;
        this.mTargetRefreshOffset = targetRefreshOffset;
    }

    public View getTargetView() {
        return this.mTargetView;
    }

    protected void onMoveTargetView(int offset) {
    }

    protected void onMoveRefreshView(int offset) {
    }

    private boolean hasFlag(int flag) {
        return (this.mScrollFlag & flag) == flag;
    }

    private void removeFlag(int flag) {
        this.mScrollFlag &= ~flag;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int offsetY = this.mScroller.getCurrY();
            this.moveTargetViewTo(offsetY, false);
            if (offsetY <= 0 && this.hasFlag(8)) {
                this.deliverVelocity();
                this.mScroller.forceFinished(true);
            }
            this.invalidate();
        } else if (this.hasFlag(1)) {
            this.removeFlag(1);
            if (this.mTargetCurrentOffset != this.mTargetInitOffset) {
                this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetInitOffset - this.mTargetCurrentOffset);
            }
            this.invalidate();
        } else if (this.hasFlag(2)) {
            this.removeFlag(2);
            if (this.mTargetCurrentOffset != this.mTargetRefreshOffset) {
                this.mScroller.startScroll(0, this.mTargetCurrentOffset, 0, this.mTargetRefreshOffset - this.mTargetCurrentOffset);
            } else {
                this.moveTargetViewTo(this.mTargetRefreshOffset, false, true);
            }
            this.invalidate();
        } else if (this.hasFlag(4)) {
            this.removeFlag(4);
            this.onRefresh();
            this.moveTargetViewTo(this.mTargetRefreshOffset, false, true);
        } else {
            this.deliverVelocity();
        }
    }

    private void deliverVelocity() {
        if (this.hasFlag(8)) {
            this.removeFlag(8);
            if (this.mScroller.getCurrVelocity() > this.mMiniVelocity) {
                this.info("deliver velocity: " + this.mScroller.getCurrVelocity());
                if (this.mTargetView instanceof RecyclerView) {
                    ((RecyclerView)this.mTargetView).fling(0, (int)this.mScroller.getCurrVelocity());
                } else if (this.mTargetView instanceof AbsListView && Build.VERSION.SDK_INT >= 21) {
                    ((AbsListView)this.mTargetView).fling((int)this.mScroller.getCurrVelocity());
                }
            }
        }
    }

    private void info(String msg) {
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 0) {
            this.mNestScrollDurationRefreshing = this.mIsRefreshing || (this.mScrollFlag & 4) != 0;
        } else if (this.mNestScrollDurationRefreshing) {
            if (action == 2) {
                if (!this.mIsRefreshing && this.mScroller.isFinished() && this.mScrollFlag == 0) {
                    ev.offsetLocation(0.0f, (float)(-this.mSystemTouchSlop - 1));
                    ev.setAction(0);
                    super.dispatchTouchEvent(ev);
                    this.mNestScrollDurationRefreshing = false;
                    ev.setAction(action);
                    ev.offsetLocation(0.0f, (float)(this.mSystemTouchSlop + 1));
                }
            } else {
                this.mNestScrollDurationRefreshing = false;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public static class RefreshView
    extends AppCompatImageView
    implements IRefreshView {
        private static final int MAX_ALPHA = 255;
        private static final float TRIM_RATE = 0.85f;
        private static final float TRIM_OFFSET = 0.4f;
        static final int CIRCLE_DIAMETER = 40;
        static final int CIRCLE_DIAMETER_LARGE = 56;
        private CircularProgressDrawable mProgress;
        private int mCircleDiameter;

        public RefreshView(Context context) {
            super(context);
            this.mProgress = new CircularProgressDrawable(context);
            this.setColorSchemeColors(QMUIResHelper.getAttrColor(context, R.attr.qmui_config_color_blue));
            this.mProgress.setStyle(0);
            this.mProgress.setAlpha(255);
            this.mProgress.setArrowScale(0.8f);
            this.setImageDrawable((Drawable)this.mProgress);
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.mCircleDiameter = (int)(40.0f * metrics.density);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.mCircleDiameter, this.mCircleDiameter);
        }

        @Override
        public void onPull(int offset, int total, int overPull) {
            if (this.mProgress.isRunning()) {
                return;
            }
            float end = 0.85f * (float)offset / (float)total;
            float rotate = 0.4f * (float)offset / (float)total;
            if (overPull > 0) {
                rotate += 0.4f * (float)overPull / (float)total;
            }
            this.mProgress.setArrowEnabled(true);
            this.mProgress.setStartEndTrim(0.0f, end);
            this.mProgress.setProgressRotation(rotate);
        }

        public void setSize(int size) {
            if (size != 0 && size != 1) {
                return;
            }
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.mCircleDiameter = size == 0 ? (int)(56.0f * metrics.density) : (int)(40.0f * metrics.density);
            this.setImageDrawable(null);
            this.mProgress.setStyle(size);
            this.setImageDrawable((Drawable)this.mProgress);
        }

        @Override
        public void stop() {
            this.mProgress.stop();
        }

        @Override
        public void doRefresh() {
            this.mProgress.start();
        }

        public void setColorSchemeResources(int ... colorResIds) {
            Context context = this.getContext();
            int[] colorRes = new int[colorResIds.length];
            for (int i = 0; i < colorResIds.length; ++i) {
                colorRes[i] = ContextCompat.getColor((Context)context, (int)colorResIds[i]);
            }
            this.setColorSchemeColors(colorRes);
        }

        public void setColorSchemeColors(int ... colors) {
            this.mProgress.setColorSchemeColors(colors);
        }
    }

    public static interface IRefreshView {
        public void stop();

        public void doRefresh();

        public void onPull(int var1, int var2, int var3);
    }

    public static interface RefreshOffsetCalculator {
        public int calculateRefreshOffset(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface OnChildScrollUpCallback {
        public boolean canChildScrollUp(QMUIPullRefreshLayout var1, @Nullable View var2);
    }

    public static interface OnPullListener {
        public void onMoveTarget(int var1);

        public void onMoveRefreshView(int var1);

        public void onRefresh();
    }
}

