/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUILoadingView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUITipDialog
extends Dialog {
    public QMUITipDialog(Context context) {
        this(context, R.style.QMUI_TipDialog);
    }

    public QMUITipDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.setCanceledOnTouchOutside(false);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDialogWidth();
    }

    private void initDialogWidth() {
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams wmLp = window.getAttributes();
            wmLp.width = -1;
            window.setAttributes(wmLp);
        }
    }

    public static class CustomBuilder {
        private Context mContext;
        private int mContentLayoutId;

        public CustomBuilder(Context context) {
            this.mContext = context;
        }

        public CustomBuilder setContent(@LayoutRes int layoutId) {
            this.mContentLayoutId = layoutId;
            return this;
        }

        public QMUITipDialog create() {
            QMUITipDialog dialog = new QMUITipDialog(this.mContext);
            dialog.setContentView(R.layout.qmui_tip_dialog_layout);
            ViewGroup contentWrap = (ViewGroup)dialog.findViewById(R.id.contentWrap);
            LayoutInflater.from((Context)this.mContext).inflate(this.mContentLayoutId, contentWrap, true);
            return dialog;
        }
    }

    public static class Builder {
        public static final int ICON_TYPE_NOTHING = 0;
        public static final int ICON_TYPE_LOADING = 1;
        public static final int ICON_TYPE_SUCCESS = 2;
        public static final int ICON_TYPE_FAIL = 3;
        public static final int ICON_TYPE_INFO = 4;
        private int mCurrentIconType = 0;
        private Context mContext;
        private CharSequence mTipWord;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setIconType(int iconType) {
            this.mCurrentIconType = iconType;
            return this;
        }

        public Builder setTipWord(CharSequence tipWord) {
            this.mTipWord = tipWord;
            return this;
        }

        public QMUITipDialog create() {
            return this.create(true);
        }

        public QMUITipDialog create(boolean cancelable) {
            QMUITipDialog dialog = new QMUITipDialog(this.mContext);
            dialog.setCancelable(cancelable);
            dialog.setContentView(R.layout.qmui_tip_dialog_layout);
            ViewGroup contentWrap = (ViewGroup)dialog.findViewById(R.id.contentWrap);
            if (this.mCurrentIconType == 1) {
                QMUILoadingView loadingView = new QMUILoadingView(this.mContext);
                loadingView.setColor(-1);
                loadingView.setSize(QMUIDisplayHelper.dp2px(this.mContext, 32));
                LinearLayout.LayoutParams loadingViewLP = new LinearLayout.LayoutParams(-2, -2);
                loadingView.setLayoutParams((ViewGroup.LayoutParams)loadingViewLP);
                contentWrap.addView((View)loadingView);
            } else if (this.mCurrentIconType == 2 || this.mCurrentIconType == 3 || this.mCurrentIconType == 4) {
                ImageView imageView = new ImageView(this.mContext);
                LinearLayout.LayoutParams imageViewLP = new LinearLayout.LayoutParams(-2, -2);
                imageView.setLayoutParams((ViewGroup.LayoutParams)imageViewLP);
                if (this.mCurrentIconType == 2) {
                    imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.qmui_icon_notify_done));
                } else if (this.mCurrentIconType == 3) {
                    imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.qmui_icon_notify_error));
                } else {
                    imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.qmui_icon_notify_info));
                }
                contentWrap.addView((View)imageView);
            }
            if (this.mTipWord != null && this.mTipWord.length() > 0) {
                TextView tipView = new TextView(this.mContext);
                LinearLayout.LayoutParams tipViewLP = new LinearLayout.LayoutParams(-2, -2);
                if (this.mCurrentIconType != 0) {
                    tipViewLP.topMargin = QMUIDisplayHelper.dp2px(this.mContext, 12);
                }
                tipView.setLayoutParams((ViewGroup.LayoutParams)tipViewLP);
                tipView.setEllipsize(TextUtils.TruncateAt.END);
                tipView.setGravity(17);
                tipView.setMaxLines(2);
                tipView.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.qmui_config_color_white));
                tipView.setTextSize(2, 14.0f);
                tipView.setText(this.mTipWord);
                contentWrap.addView((View)tipView);
            }
            return dialog;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IconType {
        }
    }
}

