/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

public class QMUIFontFitTextView
extends TextView {
    private Paint mTestPaint = new Paint();
    private float minSize;
    private float maxSize;

    public QMUIFontFitTextView(Context context) {
        this(context, null);
    }

    public QMUIFontFitTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTestPaint.set((Paint)this.getPaint());
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIFontFitTextView);
        this.minSize = array.getDimensionPixelSize(R.styleable.QMUIFontFitTextView_qmui_minTextSize, Math.round(14.0f * QMUIDisplayHelper.DENSITY));
        this.maxSize = array.getDimensionPixelSize(R.styleable.QMUIFontFitTextView_qmui_maxTextSize, Math.round(18.0f * QMUIDisplayHelper.DENSITY));
        array.recycle();
    }

    private void refitText(String text, int textWidth) {
        if (textWidth <= 0) {
            return;
        }
        int targetWidth = textWidth - this.getPaddingLeft() - this.getPaddingRight();
        float hi = this.maxSize;
        float lo = this.minSize;
        float threshold = 0.5f;
        this.mTestPaint.set((Paint)this.getPaint());
        this.mTestPaint.setTextSize(this.maxSize);
        if (this.mTestPaint.measureText(text) <= (float)targetWidth) {
            lo = this.maxSize;
        } else {
            this.mTestPaint.setTextSize(this.minSize);
            if (this.mTestPaint.measureText(text) < (float)targetWidth) {
                while (hi - lo > 0.5f) {
                    float size = (hi + lo) / 2.0f;
                    this.mTestPaint.setTextSize(size);
                    if (this.mTestPaint.measureText(text) >= (float)targetWidth) {
                        hi = size;
                        continue;
                    }
                    lo = size;
                }
            }
        }
        this.setTextSize(0, lo);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = this.getMeasuredHeight();
        this.refitText(this.getText().toString(), parentWidth);
        this.setMeasuredDimension(parentWidth, height);
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.refitText(text.toString(), this.getWidth());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (w != oldw) {
            this.refitText(this.getText().toString(), w);
        }
    }
}

