/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.support.v4.view.ViewCompat;
import android.view.View;

public class QMUIViewOffsetHelper {
    private final View mView;
    private int mLayoutTop;
    private int mLayoutLeft;
    private int mOffsetTop;
    private int mOffsetLeft;
    private boolean mVerticalOffsetEnabled = true;
    private boolean mHorizontalOffsetEnabled = true;

    public QMUIViewOffsetHelper(View view) {
        this.mView = view;
    }

    public void onViewLayout() {
        this.mLayoutTop = this.mView.getTop();
        this.mLayoutLeft = this.mView.getLeft();
        this.updateOffsets();
    }

    private void updateOffsets() {
        ViewCompat.offsetTopAndBottom((View)this.mView, (int)(this.mOffsetTop - (this.mView.getTop() - this.mLayoutTop)));
        ViewCompat.offsetLeftAndRight((View)this.mView, (int)(this.mOffsetLeft - (this.mView.getLeft() - this.mLayoutLeft)));
    }

    public boolean setTopAndBottomOffset(int offset) {
        if (this.mVerticalOffsetEnabled && this.mOffsetTop != offset) {
            this.mOffsetTop = offset;
            this.updateOffsets();
            return true;
        }
        return false;
    }

    public boolean setLeftAndRightOffset(int offset) {
        if (this.mHorizontalOffsetEnabled && this.mOffsetLeft != offset) {
            this.mOffsetLeft = offset;
            this.updateOffsets();
            return true;
        }
        return false;
    }

    public boolean setOffset(int leftOffset, int topOffset) {
        if (!this.mHorizontalOffsetEnabled && !this.mVerticalOffsetEnabled) {
            return false;
        }
        if (this.mHorizontalOffsetEnabled && this.mVerticalOffsetEnabled) {
            if (this.mOffsetLeft != leftOffset || this.mOffsetTop != topOffset) {
                this.mOffsetLeft = leftOffset;
                this.mOffsetTop = topOffset;
                this.updateOffsets();
                return true;
            }
            return false;
        }
        if (this.mHorizontalOffsetEnabled) {
            return this.setLeftAndRightOffset(leftOffset);
        }
        return this.setTopAndBottomOffset(topOffset);
    }

    public int getTopAndBottomOffset() {
        return this.mOffsetTop;
    }

    public int getLeftAndRightOffset() {
        return this.mOffsetLeft;
    }

    public int getLayoutTop() {
        return this.mLayoutTop;
    }

    public int getLayoutLeft() {
        return this.mLayoutLeft;
    }

    public void setHorizontalOffsetEnabled(boolean horizontalOffsetEnabled) {
        this.mHorizontalOffsetEnabled = horizontalOffsetEnabled;
    }

    public boolean isHorizontalOffsetEnabled() {
        return this.mHorizontalOffsetEnabled;
    }

    public void setVerticalOffsetEnabled(boolean verticalOffsetEnabled) {
        this.mVerticalOffsetEnabled = verticalOffsetEnabled;
    }

    public boolean isVerticalOffsetEnabled() {
        return this.mVerticalOffsetEnabled;
    }
}

