/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import com.qmuiteam.qmui.span.QMUIMarginImageSpan;

public class QMUISpanHelper {
    public static CharSequence generateSideIconText(boolean left, int iconPadding, CharSequence text, Drawable icon) {
        return QMUISpanHelper.generateSideIconText(left, iconPadding, text, icon, 0);
    }

    public static CharSequence generateSideIconText(boolean left, int iconPadding, CharSequence text, Drawable icon, int iconOffsetY) {
        return QMUISpanHelper.generateHorIconText(text, left ? iconPadding : 0, (Drawable)(left ? icon : null), left ? 0 : iconPadding, left ? null : icon, iconOffsetY);
    }

    public static CharSequence generateHorIconText(CharSequence text, int leftPadding, Drawable iconLeft, int rightPadding, Drawable iconRight) {
        return QMUISpanHelper.generateHorIconText(text, leftPadding, iconLeft, rightPadding, iconRight, 0);
    }

    public static CharSequence generateHorIconText(CharSequence text, int leftPadding, Drawable iconLeft, int rightPadding, Drawable iconRight, int iconOffsetY) {
        QMUIMarginImageSpan imageSpan;
        int end;
        int start;
        if (iconLeft == null && iconRight == null) {
            return text;
        }
        String iconTag = "[icon]";
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (iconLeft != null) {
            iconLeft.setBounds(0, 0, iconLeft.getIntrinsicWidth(), iconLeft.getIntrinsicHeight());
            start = 0;
            builder.append((CharSequence)iconTag);
            end = builder.length();
            imageSpan = new QMUIMarginImageSpan(iconLeft, -100, 0, leftPadding, iconOffsetY);
            imageSpan.setAvoidSuperChangeFontMetrics(true);
            builder.setSpan((Object)imageSpan, start, end, 17);
        }
        builder.append(text);
        if (iconRight != null) {
            iconRight.setBounds(0, 0, iconRight.getIntrinsicWidth(), iconRight.getIntrinsicHeight());
            start = builder.length();
            builder.append((CharSequence)iconTag);
            end = builder.length();
            imageSpan = new QMUIMarginImageSpan(iconRight, -100, rightPadding, 0, iconOffsetY);
            imageSpan.setAvoidSuperChangeFontMetrics(true);
            builder.setSpan((Object)imageSpan, start, end, 17);
        }
        return builder;
    }
}

