/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedBottomView;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedScrollCommon;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedTopView;
import com.qmuiteam.qmui.nestedScroll.QMUIContinuousNestedBottomAreaBehavior;
import com.qmuiteam.qmui.nestedScroll.QMUIContinuousNestedTopAreaBehavior;
import com.qmuiteam.qmui.nestedScroll.QMUIDraggableScrollBar;
import com.qmuiteam.qmui.util.QMUILangHelper;
import java.util.ArrayList;
import java.util.List;

public class QMUIContinuousNestedScrollLayout
extends CoordinatorLayout
implements QMUIContinuousNestedTopAreaBehavior.Callback,
QMUIDraggableScrollBar.Callback {
    public static final String KEY_SCROLL_INFO_OFFSET = "@qmui_nested_scroll_layout_offset";
    private IQMUIContinuousNestedTopView mTopView;
    private IQMUIContinuousNestedBottomView mBottomView;
    private QMUIContinuousNestedTopAreaBehavior mTopAreaBehavior;
    private QMUIContinuousNestedBottomAreaBehavior mBottomAreaBehavior;
    private List<OnScrollListener> mOnScrollListeners = new ArrayList<OnScrollListener>();
    private Runnable mCheckLayoutAction = new Runnable(){

        @Override
        public void run() {
            QMUIContinuousNestedScrollLayout.this.checkLayout();
        }
    };
    private boolean mKeepBottomAreaStableWhenCheckLayout = false;
    private QMUIDraggableScrollBar mDraggableScrollBar;
    private boolean mEnableScrollBarFadeInOut = true;
    private boolean mIsDraggableScrollBarEnabled = false;
    private int mCurrentScrollState = 0;
    private boolean mIsDismissDownEvent = false;
    private float mDismissDownY = 0.0f;
    private int mTouchSlap = -1;

    public QMUIContinuousNestedScrollLayout(@NonNull Context context) {
        this(context, null);
    }

    public QMUIContinuousNestedScrollLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIContinuousNestedScrollLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void ensureScrollBar() {
        if (this.mDraggableScrollBar == null) {
            this.mDraggableScrollBar = this.createScrollBar(this.getContext());
            this.mDraggableScrollBar.setEnableFadeInAndOut(this.mEnableScrollBarFadeInOut);
            this.mDraggableScrollBar.setCallback(this);
            CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(-2, -1);
            lp.gravity = 5;
            this.addView(this.mDraggableScrollBar, (ViewGroup.LayoutParams)lp);
        }
    }

    public void setDraggableScrollBarEnabled(boolean draggableScrollBarEnabled) {
        if (this.mIsDraggableScrollBarEnabled != draggableScrollBarEnabled) {
            this.mIsDraggableScrollBarEnabled = draggableScrollBarEnabled;
            if (this.mIsDraggableScrollBarEnabled && !this.mEnableScrollBarFadeInOut) {
                this.ensureScrollBar();
                this.mDraggableScrollBar.setPercent(this.getCurrentScrollPercent());
                this.mDraggableScrollBar.awakenScrollBar();
            }
            if (this.mDraggableScrollBar != null) {
                this.mDraggableScrollBar.setVisibility(draggableScrollBarEnabled ? 0 : 8);
            }
        }
    }

    public void setEnableScrollBarFadeInOut(boolean enableScrollBarFadeInOut) {
        if (this.mEnableScrollBarFadeInOut != enableScrollBarFadeInOut) {
            this.mEnableScrollBarFadeInOut = enableScrollBarFadeInOut;
            if (this.mIsDraggableScrollBarEnabled && !this.mEnableScrollBarFadeInOut) {
                this.ensureScrollBar();
                this.mDraggableScrollBar.setPercent(this.getCurrentScrollPercent());
                this.mDraggableScrollBar.awakenScrollBar();
            }
            if (this.mDraggableScrollBar != null) {
                this.mDraggableScrollBar.setEnableFadeInAndOut(enableScrollBarFadeInOut);
                this.mDraggableScrollBar.invalidate();
            }
        }
    }

    protected QMUIDraggableScrollBar createScrollBar(Context context) {
        return new QMUIDraggableScrollBar(context);
    }

    @Override
    public void onDragStarted() {
        this.stopScroll();
    }

    @Override
    public void onDragToPercent(float percent) {
        int targetScroll = (int)((float)this.getScrollRange() * percent);
        this.scrollBy(targetScroll - this.getCurrentScroll());
    }

    @Override
    public void onDragEnd() {
    }

    public int getCurrentScroll() {
        int currentScroll = 0;
        if (this.mTopView != null) {
            currentScroll += this.mTopView.getCurrentScroll();
        }
        currentScroll += this.getOffsetCurrent();
        if (this.mBottomView != null) {
            currentScroll += this.mBottomView.getCurrentScroll();
        }
        return currentScroll;
    }

    public int getScrollRange() {
        int totalRange = 0;
        if (this.mTopView != null) {
            totalRange += this.mTopView.getScrollOffsetRange();
        }
        totalRange += this.getOffsetRange();
        if (this.mBottomView != null) {
            totalRange += this.mBottomView.getScrollOffsetRange();
        }
        return totalRange;
    }

    public float getCurrentScrollPercent() {
        int scrollRange = this.getScrollRange();
        if (scrollRange == 0) {
            return 0.0f;
        }
        return (float)this.getCurrentScroll() * 1.0f / (float)scrollRange;
    }

    public void addOnScrollListener(@NonNull OnScrollListener onScrollListener) {
        if (!this.mOnScrollListeners.contains(onScrollListener)) {
            this.mOnScrollListeners.add(onScrollListener);
        }
    }

    public void removeOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListeners.remove(onScrollListener);
    }

    public void setKeepBottomAreaStableWhenCheckLayout(boolean keepBottomAreaStableWhenCheckLayout) {
        this.mKeepBottomAreaStableWhenCheckLayout = keepBottomAreaStableWhenCheckLayout;
    }

    public boolean isKeepBottomAreaStableWhenCheckLayout() {
        return this.mKeepBottomAreaStableWhenCheckLayout;
    }

    public void setTopAreaView(View topView, @Nullable CoordinatorLayout.LayoutParams layoutParams) {
        CoordinatorLayout.Behavior behavior;
        if (!(topView instanceof IQMUIContinuousNestedTopView)) {
            throw new IllegalStateException("topView must implement from IQMUIContinuousNestedTopView");
        }
        if (this.mTopView != null) {
            this.removeView((View)this.mTopView);
        }
        this.mTopView = (IQMUIContinuousNestedTopView)topView;
        this.mTopView.injectScrollNotifier(new IQMUIContinuousNestedScrollCommon.OnScrollNotifier(){

            @Override
            public void notify(int innerOffset, int innerRange) {
                int offsetCurrent = QMUIContinuousNestedScrollLayout.this.mTopAreaBehavior == null ? 0 : -QMUIContinuousNestedScrollLayout.this.mTopAreaBehavior.getTopAndBottomOffset();
                int bottomCurrent = QMUIContinuousNestedScrollLayout.this.mBottomView == null ? 0 : QMUIContinuousNestedScrollLayout.this.mBottomView.getCurrentScroll();
                int bottomRange = QMUIContinuousNestedScrollLayout.this.mBottomView == null ? 0 : QMUIContinuousNestedScrollLayout.this.mBottomView.getScrollOffsetRange();
                QMUIContinuousNestedScrollLayout.this.dispatchScroll(innerOffset, innerRange, offsetCurrent, QMUIContinuousNestedScrollLayout.this.getOffsetRange(), bottomCurrent, bottomRange);
            }

            @Override
            public void onScrollStateChange(View view, int newScrollState) {
            }
        });
        if (layoutParams == null) {
            layoutParams = new CoordinatorLayout.LayoutParams(-1, -2);
        }
        if ((behavior = layoutParams.getBehavior()) instanceof QMUIContinuousNestedTopAreaBehavior) {
            this.mTopAreaBehavior = (QMUIContinuousNestedTopAreaBehavior)behavior;
        } else {
            this.mTopAreaBehavior = new QMUIContinuousNestedTopAreaBehavior(this.getContext());
            layoutParams.setBehavior((CoordinatorLayout.Behavior)this.mTopAreaBehavior);
        }
        this.mTopAreaBehavior.setCallback(this);
        this.addView(topView, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    public IQMUIContinuousNestedTopView getTopView() {
        return this.mTopView;
    }

    public IQMUIContinuousNestedBottomView getBottomView() {
        return this.mBottomView;
    }

    public QMUIContinuousNestedTopAreaBehavior getTopAreaBehavior() {
        return this.mTopAreaBehavior;
    }

    public QMUIContinuousNestedBottomAreaBehavior getBottomAreaBehavior() {
        return this.mBottomAreaBehavior;
    }

    public void setBottomAreaView(View bottomView, @Nullable CoordinatorLayout.LayoutParams layoutParams) {
        CoordinatorLayout.Behavior behavior;
        if (!(bottomView instanceof IQMUIContinuousNestedBottomView)) {
            throw new IllegalStateException("bottomView must implement from IQMUIContinuousNestedBottomView");
        }
        if (this.mBottomView != null) {
            this.removeView((View)this.mBottomView);
        }
        this.mBottomView = (IQMUIContinuousNestedBottomView)bottomView;
        this.mBottomView.injectScrollNotifier(new IQMUIContinuousNestedScrollCommon.OnScrollNotifier(){

            @Override
            public void notify(int innerOffset, int innerRange) {
                int topCurrent = QMUIContinuousNestedScrollLayout.this.mTopView == null ? 0 : QMUIContinuousNestedScrollLayout.this.mTopView.getCurrentScroll();
                int topRange = QMUIContinuousNestedScrollLayout.this.mTopView == null ? 0 : QMUIContinuousNestedScrollLayout.this.mTopView.getScrollOffsetRange();
                int offsetCurrent = QMUIContinuousNestedScrollLayout.this.mTopAreaBehavior == null ? 0 : -QMUIContinuousNestedScrollLayout.this.mTopAreaBehavior.getTopAndBottomOffset();
                QMUIContinuousNestedScrollLayout.this.dispatchScroll(topCurrent, topRange, offsetCurrent, QMUIContinuousNestedScrollLayout.this.getOffsetRange(), innerOffset, innerRange);
            }

            @Override
            public void onScrollStateChange(View view, int newScrollState) {
                QMUIContinuousNestedScrollLayout.this.dispatchScrollStateChange(newScrollState, false);
            }
        });
        if (layoutParams == null) {
            layoutParams = new CoordinatorLayout.LayoutParams(-1, -1);
        }
        if ((behavior = layoutParams.getBehavior()) instanceof QMUIContinuousNestedBottomAreaBehavior) {
            this.mBottomAreaBehavior = (QMUIContinuousNestedBottomAreaBehavior)behavior;
        } else {
            this.mBottomAreaBehavior = new QMUIContinuousNestedBottomAreaBehavior();
            layoutParams.setBehavior((CoordinatorLayout.Behavior)this.mBottomAreaBehavior);
        }
        this.addView(bottomView, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.postCheckLayout();
    }

    public void postCheckLayout() {
        this.removeCallbacks(this.mCheckLayoutAction);
        this.post(this.mCheckLayoutAction);
    }

    public void checkLayout() {
        if (this.mTopView == null || this.mBottomView == null) {
            return;
        }
        int topCurrent = this.mTopView.getCurrentScroll();
        int topRange = this.mTopView.getScrollOffsetRange();
        int offsetCurrent = -this.mTopAreaBehavior.getTopAndBottomOffset();
        int offsetRange = this.getOffsetRange();
        if (offsetRange <= 0) {
            return;
        }
        if (offsetCurrent >= offsetRange || offsetCurrent > 0 && this.mKeepBottomAreaStableWhenCheckLayout) {
            this.mTopView.consumeScroll(Integer.MAX_VALUE);
            if (this.mBottomView.getCurrentScroll() > 0) {
                this.mTopAreaBehavior.setTopAndBottomOffset(-offsetRange);
            }
            return;
        }
        if (this.mBottomView.getCurrentScroll() > 0) {
            this.mBottomView.consumeScroll(Integer.MIN_VALUE);
        }
        if (topCurrent < topRange && offsetCurrent > 0) {
            int remain = topRange - topCurrent;
            if (offsetCurrent >= remain) {
                this.mTopView.consumeScroll(Integer.MAX_VALUE);
                this.mTopAreaBehavior.setTopAndBottomOffset(remain - offsetCurrent);
            } else {
                this.mTopView.consumeScroll(offsetCurrent);
                this.mTopAreaBehavior.setTopAndBottomOffset(0);
            }
        }
    }

    public void scrollBottomViewToTop() {
        if (this.mTopView != null) {
            this.mTopView.consumeScroll(Integer.MAX_VALUE);
        }
        if (this.mBottomView != null) {
            this.mBottomView.consumeScroll(Integer.MIN_VALUE);
            int contentHeight = this.mBottomView.getContentHeight();
            if (contentHeight != -1) {
                this.mTopAreaBehavior.setTopAndBottomOffset(this.getHeight() - contentHeight - ((View)this.mTopView).getHeight());
            } else {
                this.mTopAreaBehavior.setTopAndBottomOffset(this.getHeight() - ((View)this.mBottomView).getHeight() - ((View)this.mTopView).getHeight());
            }
        }
    }

    private void dispatchScroll(int topCurrent, int topRange, int offsetCurrent, int offsetRange, int bottomCurrent, int bottomRange) {
        if (this.mIsDraggableScrollBarEnabled) {
            this.ensureScrollBar();
            this.mDraggableScrollBar.setPercent(this.getCurrentScrollPercent());
            this.mDraggableScrollBar.awakenScrollBar();
        }
        for (OnScrollListener onScrollListener : this.mOnScrollListeners) {
            onScrollListener.onScroll(topCurrent, topRange, offsetCurrent, offsetRange, bottomCurrent, bottomRange);
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        super.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type);
        if (dyUnconsumed > 0 && this.getCurrentScroll() >= this.getScrollRange()) {
            this.stopScroll();
        }
    }

    private void dispatchScrollStateChange(int newScrollState, boolean fromTopBehavior) {
        for (OnScrollListener onScrollListener : this.mOnScrollListeners) {
            onScrollListener.onScrollStateChange(newScrollState, fromTopBehavior);
        }
        this.mCurrentScrollState = newScrollState;
    }

    public void scrollBy(int dy) {
        if (dy > 0 && this.mTopAreaBehavior != null) {
            this.mTopAreaBehavior.scroll(this, (View)this.mTopView, dy);
        } else if (dy != 0 && this.mBottomView != null) {
            this.mBottomView.consumeScroll(dy);
        }
    }

    public void smoothScrollBy(int dy, int duration) {
        if (dy == 0) {
            return;
        }
        if (dy > 0 && this.mTopAreaBehavior != null) {
            this.mTopAreaBehavior.smoothScrollBy(this, (View)this.mTopView, dy, duration);
        } else if (this.mBottomView != null) {
            this.mBottomView.smoothScrollYBy(dy, duration);
        }
    }

    public void stopScroll() {
        if (this.mBottomView != null) {
            this.mBottomView.stopScroll();
        }
        if (this.mTopAreaBehavior != null) {
            this.mTopAreaBehavior.stopFlingOrScroll();
        }
    }

    public void scrollToTop() {
        if (this.mBottomView != null) {
            this.mBottomView.consumeScroll(Integer.MIN_VALUE);
        }
        if (this.mTopView != null) {
            this.mTopAreaBehavior.setTopAndBottomOffset(0);
            this.mTopView.consumeScroll(Integer.MIN_VALUE);
        }
    }

    public void scrollToBottom() {
        if (this.mTopView != null) {
            this.mTopView.consumeScroll(Integer.MAX_VALUE);
            if (this.mBottomView != null) {
                int contentHeight = this.mBottomView.getContentHeight();
                if (contentHeight != -1) {
                    View topView = (View)this.mTopView;
                    if (topView.getHeight() + contentHeight < this.getHeight()) {
                        this.mTopAreaBehavior.setTopAndBottomOffset(0);
                    } else {
                        this.mTopAreaBehavior.setTopAndBottomOffset(this.getHeight() - contentHeight - ((View)this.mTopView).getHeight());
                    }
                } else {
                    this.mTopAreaBehavior.setTopAndBottomOffset(this.getHeight() - ((View)this.mBottomView).getHeight() - ((View)this.mTopView).getHeight());
                }
            }
        }
        if (this.mBottomView != null) {
            this.mBottomView.consumeScroll(Integer.MAX_VALUE);
        }
    }

    public int getOffsetCurrent() {
        return this.mTopAreaBehavior == null ? 0 : -this.mTopAreaBehavior.getTopAndBottomOffset();
    }

    public int getOffsetRange() {
        if (this.mTopView == null || this.mBottomView == null) {
            return 0;
        }
        int contentHeight = this.mBottomView.getContentHeight();
        if (contentHeight != -1) {
            return Math.max(0, ((View)this.mTopView).getHeight() + contentHeight - this.getHeight());
        }
        return Math.max(0, ((View)this.mTopView).getHeight() + ((View)this.mBottomView).getHeight() - this.getHeight());
    }

    @Override
    public void onTopAreaOffset(int offset) {
        int topCurrent = this.mTopView == null ? 0 : this.mTopView.getCurrentScroll();
        int topRange = this.mTopView == null ? 0 : this.mTopView.getScrollOffsetRange();
        int bottomCurrent = this.mBottomView == null ? 0 : this.mBottomView.getCurrentScroll();
        int bottomRange = this.mBottomView == null ? 0 : this.mBottomView.getScrollOffsetRange();
        this.dispatchScroll(topCurrent, topRange, -offset, this.getOffsetRange(), bottomCurrent, bottomRange);
    }

    @Override
    public void onTopBehaviorTouchBegin() {
        this.dispatchScrollStateChange(1, true);
    }

    @Override
    public void onTopBehaviorTouchEnd() {
        this.dispatchScrollStateChange(0, true);
    }

    @Override
    public void onTopBehaviorFlingOrScrollStart() {
        this.dispatchScrollStateChange(2, true);
    }

    @Override
    public void onTopBehaviorFlingOrScrollEnd() {
        this.dispatchScrollStateChange(0, true);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            if (this.mCurrentScrollState != 0) {
                this.stopScroll();
                this.mIsDismissDownEvent = true;
                this.mDismissDownY = ev.getY();
                if (this.mTouchSlap < 0) {
                    this.mTouchSlap = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
                }
                return true;
            }
        } else if (ev.getAction() == 2 && this.mIsDismissDownEvent) {
            if (Math.abs(ev.getY() - this.mDismissDownY) > (float)this.mTouchSlap) {
                MotionEvent down = MotionEvent.obtain((MotionEvent)ev);
                down.setAction(0);
                down.offsetLocation(0.0f, this.mDismissDownY - ev.getY());
                super.dispatchTouchEvent(down);
                down.recycle();
            } else {
                return true;
            }
        }
        this.mIsDismissDownEvent = false;
        return super.dispatchTouchEvent(ev);
    }

    public void saveScrollInfo(@NonNull Bundle bundle) {
        if (this.mTopView != null) {
            this.mTopView.saveScrollInfo(bundle);
        }
        if (this.mBottomView != null) {
            this.mBottomView.saveScrollInfo(bundle);
        }
        bundle.putInt(KEY_SCROLL_INFO_OFFSET, this.getOffsetCurrent());
    }

    public void restoreScrollInfo(@Nullable Bundle bundle) {
        if (bundle == null) {
            return;
        }
        if (this.mTopAreaBehavior != null) {
            int offset = bundle.getInt(KEY_SCROLL_INFO_OFFSET, 0);
            this.mTopAreaBehavior.setTopAndBottomOffset(QMUILangHelper.constrain(-offset, -this.getOffsetRange(), 0));
        }
        if (this.mTopView != null) {
            this.mTopView.restoreScrollInfo(bundle);
        }
        if (this.mBottomView != null) {
            this.mBottomView.restoreScrollInfo(bundle);
        }
    }

    public static interface OnScrollListener {
        public void onScroll(int var1, int var2, int var3, int var4, int var5, int var6);

        public void onScrollStateChange(int var1, boolean var2);
    }
}

