/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import java.util.ArrayList;

public class QMUIPriorityLinearLayout
extends QMUILinearLayout {
    private ArrayList<View> mTempMiniWidthChildList = new ArrayList();
    private ArrayList<View> mTempDisposableChildList = new ArrayList();

    public QMUIPriorityLinearLayout(Context context) {
        super(context);
    }

    public QMUIPriorityLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int orientation = this.getOrientation();
        if (orientation == 0) {
            this.handleHorizontal(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.handleVertical(widthMeasureSpec, heightMeasureSpec);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void handleHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int visibleChildCount = this.getVisibleChildCount();
        if (widthMode == 0 || visibleChildCount == 0 || widthSize <= 0) {
            return;
        }
        int usedWidth = this.handlePriorityIncompressible(widthMeasureSpec, heightMeasureSpec);
        if (usedWidth >= widthSize) {
            LayoutParams lp;
            for (View view : this.mTempMiniWidthChildList) {
                lp = (LayoutParams)view.getLayoutParams();
                view.measure(View.MeasureSpec.makeMeasureSpec((int)lp.miniContentProtectionSize, (int)Integer.MIN_VALUE), heightMeasureSpec);
                lp.width = view.getMeasuredWidth();
            }
            for (View view : this.mTempDisposableChildList) {
                lp = (LayoutParams)view.getLayoutParams();
                lp.width = 0;
            }
        } else {
            LayoutParams lp;
            int usefulWidth = widthSize - usedWidth;
            int miniNeedWidth = 0;
            int miniWidthChildTotalWidth = 0;
            for (View view : this.mTempMiniWidthChildList) {
                lp = (LayoutParams)view.getLayoutParams();
                view.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)Integer.MIN_VALUE), heightMeasureSpec);
                int marginHor = lp.leftMargin + lp.rightMargin;
                miniWidthChildTotalWidth += view.getMeasuredWidth() + marginHor;
                miniNeedWidth += Math.min(view.getMeasuredWidth(), lp.miniContentProtectionSize) + marginHor;
            }
            if (miniNeedWidth >= usefulWidth) {
                for (View view : this.mTempMiniWidthChildList) {
                    lp = (LayoutParams)view.getLayoutParams();
                    lp.width = Math.min(view.getMeasuredWidth(), lp.miniContentProtectionSize);
                }
                for (View view : this.mTempDisposableChildList) {
                    lp = (LayoutParams)view.getLayoutParams();
                    lp.width = 0;
                }
            } else if (miniWidthChildTotalWidth < usefulWidth) {
                if (!this.mTempDisposableChildList.isEmpty()) {
                    this.dispatchSpaceToDisposableChildList(this.mTempDisposableChildList, usefulWidth - miniWidthChildTotalWidth);
                }
            } else {
                for (View view : this.mTempDisposableChildList) {
                    lp = (LayoutParams)view.getLayoutParams();
                    lp.width = 0;
                }
                if (usefulWidth < miniWidthChildTotalWidth && !this.mTempMiniWidthChildList.isEmpty()) {
                    this.dispatchSpaceToMiniWidthChildList(this.mTempMiniWidthChildList, usefulWidth, miniWidthChildTotalWidth);
                }
            }
        }
    }

    private void handleVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom();
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int visibleChildCount = this.getVisibleChildCount();
        if (heightMode == 0 || visibleChildCount == 0 || heightSize <= 0) {
            return;
        }
        int usedHeight = this.handlePriorityIncompressible(widthMeasureSpec, heightMeasureSpec);
        if (usedHeight >= heightSize) {
            LayoutParams lp;
            for (View view : this.mTempMiniWidthChildList) {
                lp = (LayoutParams)view.getLayoutParams();
                view.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)lp.miniContentProtectionSize, (int)Integer.MIN_VALUE));
                lp.height = view.getMeasuredHeight();
            }
            for (View view : this.mTempDisposableChildList) {
                lp = (LayoutParams)view.getLayoutParams();
                lp.height = 0;
            }
        } else {
            LayoutParams lp;
            int usefulSpace = heightSize - usedHeight;
            int miniNeedSpace = 0;
            int miniSizeChildTotalLength = 0;
            for (View view : this.mTempMiniWidthChildList) {
                lp = (LayoutParams)view.getLayoutParams();
                view.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)Integer.MIN_VALUE));
                int marginVer = lp.topMargin + lp.bottomMargin;
                miniSizeChildTotalLength += view.getMeasuredHeight() + marginVer;
                miniNeedSpace += Math.min(view.getMeasuredHeight(), lp.miniContentProtectionSize) + marginVer;
            }
            if (miniNeedSpace >= usefulSpace) {
                for (View view : this.mTempMiniWidthChildList) {
                    lp = (LayoutParams)view.getLayoutParams();
                    lp.height = Math.min(view.getMeasuredHeight(), lp.miniContentProtectionSize);
                }
                for (View view : this.mTempDisposableChildList) {
                    lp = (LayoutParams)view.getLayoutParams();
                    lp.height = 0;
                }
            } else if (miniSizeChildTotalLength < usefulSpace) {
                if (!this.mTempDisposableChildList.isEmpty()) {
                    this.dispatchSpaceToDisposableChildList(this.mTempDisposableChildList, usefulSpace - miniSizeChildTotalLength);
                }
            } else {
                for (View view : this.mTempDisposableChildList) {
                    lp = (LayoutParams)view.getLayoutParams();
                    lp.width = 0;
                }
                if (usefulSpace < miniSizeChildTotalLength && !this.mTempMiniWidthChildList.isEmpty()) {
                    this.dispatchSpaceToMiniWidthChildList(this.mTempMiniWidthChildList, usefulSpace, miniSizeChildTotalLength);
                }
            }
        }
    }

    private int handlePriorityIncompressible(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom();
        int usedSize = 0;
        this.mTempMiniWidthChildList.clear();
        this.mTempDisposableChildList.clear();
        int orientation = this.getOrientation();
        for (int i = 0; i < this.getChildCount(); ++i) {
            int margin;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.backupOrRestore();
            int priority = lp.getPriority(orientation);
            int n = margin = orientation == 0 ? lp.leftMargin + lp.rightMargin : lp.topMargin + lp.bottomMargin;
            if (priority == 3) {
                if (orientation == 0) {
                    if (lp.width >= 0) {
                        usedSize += lp.width + margin;
                        continue;
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)Integer.MIN_VALUE), heightMeasureSpec);
                    usedSize += child.getMeasuredWidth() + margin;
                    continue;
                }
                if (lp.height >= 0) {
                    usedSize += lp.height + margin;
                    continue;
                }
                child.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)Integer.MIN_VALUE));
                usedSize += child.getMeasuredHeight() + margin;
                continue;
            }
            if (priority == 2) {
                this.mTempMiniWidthChildList.add(child);
                continue;
            }
            if (lp.weight != 0.0f) continue;
            this.mTempDisposableChildList.add(child);
        }
        return usedSize;
    }

    protected void dispatchSpaceToDisposableChildList(ArrayList<View> childList, int usefulSpace) {
        for (View view : childList) {
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (this.getOrientation() == 0) {
                usefulSpace -= lp.leftMargin - lp.rightMargin;
                continue;
            }
            usefulSpace -= lp.topMargin - lp.bottomMargin;
        }
        int avgSpace = Math.max(0, usefulSpace / childList.size());
        for (View view : childList) {
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (this.getOrientation() == 0) {
                lp.width = avgSpace;
                continue;
            }
            lp.height = avgSpace;
        }
    }

    protected void dispatchSpaceToMiniWidthChildList(ArrayList<View> childList, int usefulSpace, int calculateTotalLength) {
        int extra = calculateTotalLength - usefulSpace;
        if (extra > 0) {
            for (View view : childList) {
                float radio;
                LayoutParams lp = (LayoutParams)view.getLayoutParams();
                if (this.getOrientation() == 0) {
                    radio = (float)(view.getMeasuredWidth() + lp.leftMargin + lp.rightMargin) * 1.0f / (float)calculateTotalLength;
                    int width = (int)((float)view.getMeasuredWidth() - (float)extra * radio);
                    lp.width = Math.max(0, width);
                    continue;
                }
                radio = (float)(view.getMeasuredHeight() + lp.topMargin + lp.bottomMargin) * 1.0f / (float)calculateTotalLength;
                int height = (int)((float)view.getMeasuredHeight() - (float)extra * radio);
                lp.height = Math.max(0, height);
            }
        }
    }

    private int getVisibleChildCount() {
        int childCount = this.getChildCount();
        int visibleChildCount = 0;
        for (int i = 0; i < childCount; ++i) {
            if (this.getChildAt(i).getVisibility() != 0) continue;
            ++visibleChildCount;
        }
        return visibleChildCount;
    }

    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        return new LayoutParams(lp);
    }

    public LinearLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        static final int PRIORITY_DISPOSABLE = 1;
        static final int PRIORITY_MINI_CONTENT_PROTECTION = 2;
        static final int PRIORITY_INCOMPRESSIBLE = 3;
        private int priority = 2;
        public int miniContentProtectionSize = 0;
        private int backupWidth = Integer.MIN_VALUE;
        private int backupHeight = Integer.MIN_VALUE;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.QMUIPriorityLinearLayout_Layout);
            this.priority = a.getInteger(R.styleable.QMUIPriorityLinearLayout_Layout_qmui_layout_priority, 2);
            this.miniContentProtectionSize = a.getDimensionPixelSize(R.styleable.QMUIPriorityLinearLayout_Layout_qmui_layout_miniContentProtectionSize, 0);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @TargetApi(value=19)
        public LayoutParams(LinearLayout.LayoutParams source) {
            super(source);
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public int getPriority(int orientation) {
            if (this.weight > 0.0f) {
                return 1;
            }
            if (orientation == 0 ? this.width >= 0 : this.height >= 0) {
                return 3;
            }
            return this.priority;
        }

        void backupOrRestore() {
            if (this.backupWidth == Integer.MIN_VALUE) {
                this.backupWidth = this.width;
            } else {
                this.width = this.backupWidth;
            }
            if (this.backupHeight == Integer.MIN_VALUE) {
                this.backupHeight = this.height;
            } else {
                this.height = this.backupHeight;
            }
        }
    }
}

