/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.IQMUILayout;
import com.qmuiteam.qmui.util.QMUIResHelper;
import java.lang.ref.WeakReference;

public class QMUILayoutHelper
implements IQMUILayout {
    private Context mContext;
    private int mWidthLimit = 0;
    private int mHeightLimit = 0;
    private int mWidthMini = 0;
    private int mHeightMini = 0;
    private int mTopDividerHeight = 0;
    private int mTopDividerInsetLeft = 0;
    private int mTopDividerInsetRight = 0;
    private int mTopDividerColor;
    private int mTopDividerAlpha = 255;
    private int mBottomDividerHeight = 0;
    private int mBottomDividerInsetLeft = 0;
    private int mBottomDividerInsetRight = 0;
    private int mBottomDividerColor;
    private int mBottomDividerAlpha = 255;
    private int mLeftDividerWidth = 0;
    private int mLeftDividerInsetTop = 0;
    private int mLeftDividerInsetBottom = 0;
    private int mLeftDividerColor;
    private int mLeftDividerAlpha = 255;
    private int mRightDividerWidth = 0;
    private int mRightDividerInsetTop = 0;
    private int mRightDividerInsetBottom = 0;
    private int mRightDividerColor;
    private int mRightDividerAlpha = 255;
    private Paint mDividerPaint;
    private Paint mClipPaint;
    private PorterDuffXfermode mMode;
    private int mRadius;
    private int mHideRadiusSide = 0;
    private float[] mRadiusArray;
    private RectF mBorderRect;
    private int mBorderColor = 0;
    private int mBorderWidth = 1;
    private int mOuterNormalColor = 0;
    private WeakReference<View> mOwner;
    private boolean mIsOutlineExcludePadding = false;
    private Path mPath = new Path();
    private boolean mIsShowBorderOnlyBeforeL = true;
    private int mShadowElevation = 0;
    private float mShadowAlpha;
    private int mShadowColor = -16777216;
    private int mOutlineInsetLeft = 0;
    private int mOutlineInsetRight = 0;
    private int mOutlineInsetTop = 0;
    private int mOutlineInsetBottom = 0;

    public QMUILayoutHelper(Context context, AttributeSet attrs, int defAttr, View owner) {
        this.mContext = context;
        this.mOwner = new WeakReference<View>(owner);
        this.mBottomDividerColor = this.mTopDividerColor = ContextCompat.getColor((Context)context, (int)R.color.qmui_config_color_separator);
        this.mMode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
        this.mClipPaint = new Paint();
        this.mClipPaint.setAntiAlias(true);
        this.mShadowAlpha = QMUIResHelper.getAttrFloatValue(context, R.attr.qmui_general_shadow_alpha);
        this.mBorderRect = new RectF();
        int radius = 0;
        int shadow = 0;
        boolean useThemeGeneralShadowElevation = false;
        if (null != attrs || defAttr != 0) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.QMUILayout, defAttr, 0);
            int count = ta.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int index = ta.getIndex(i);
                if (index == R.styleable.QMUILayout_android_maxWidth) {
                    this.mWidthLimit = ta.getDimensionPixelSize(index, this.mWidthLimit);
                    continue;
                }
                if (index == R.styleable.QMUILayout_android_maxHeight) {
                    this.mHeightLimit = ta.getDimensionPixelSize(index, this.mHeightLimit);
                    continue;
                }
                if (index == R.styleable.QMUILayout_android_minWidth) {
                    this.mWidthMini = ta.getDimensionPixelSize(index, this.mWidthMini);
                    continue;
                }
                if (index == R.styleable.QMUILayout_android_minHeight) {
                    this.mHeightMini = ta.getDimensionPixelSize(index, this.mHeightMini);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_topDividerColor) {
                    this.mTopDividerColor = ta.getColor(index, this.mTopDividerColor);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_topDividerHeight) {
                    this.mTopDividerHeight = ta.getDimensionPixelSize(index, this.mTopDividerHeight);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_topDividerInsetLeft) {
                    this.mTopDividerInsetLeft = ta.getDimensionPixelSize(index, this.mTopDividerInsetLeft);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_topDividerInsetRight) {
                    this.mTopDividerInsetRight = ta.getDimensionPixelSize(index, this.mTopDividerInsetRight);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_bottomDividerColor) {
                    this.mBottomDividerColor = ta.getColor(index, this.mBottomDividerColor);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_bottomDividerHeight) {
                    this.mBottomDividerHeight = ta.getDimensionPixelSize(index, this.mBottomDividerHeight);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_bottomDividerInsetLeft) {
                    this.mBottomDividerInsetLeft = ta.getDimensionPixelSize(index, this.mBottomDividerInsetLeft);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_bottomDividerInsetRight) {
                    this.mBottomDividerInsetRight = ta.getDimensionPixelSize(index, this.mBottomDividerInsetRight);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_leftDividerColor) {
                    this.mLeftDividerColor = ta.getColor(index, this.mLeftDividerColor);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_leftDividerWidth) {
                    this.mLeftDividerWidth = ta.getDimensionPixelSize(index, this.mBottomDividerHeight);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_leftDividerInsetTop) {
                    this.mLeftDividerInsetTop = ta.getDimensionPixelSize(index, this.mLeftDividerInsetTop);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_leftDividerInsetBottom) {
                    this.mLeftDividerInsetBottom = ta.getDimensionPixelSize(index, this.mLeftDividerInsetBottom);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_rightDividerColor) {
                    this.mRightDividerColor = ta.getColor(index, this.mRightDividerColor);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_rightDividerWidth) {
                    this.mRightDividerWidth = ta.getDimensionPixelSize(index, this.mRightDividerWidth);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_rightDividerInsetTop) {
                    this.mRightDividerInsetTop = ta.getDimensionPixelSize(index, this.mRightDividerInsetTop);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_rightDividerInsetBottom) {
                    this.mRightDividerInsetBottom = ta.getDimensionPixelSize(index, this.mRightDividerInsetBottom);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_borderColor) {
                    this.mBorderColor = ta.getColor(index, this.mBorderColor);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_borderWidth) {
                    this.mBorderWidth = ta.getDimensionPixelSize(index, this.mBorderWidth);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_radius) {
                    radius = ta.getDimensionPixelSize(index, 0);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_outerNormalColor) {
                    this.mOuterNormalColor = ta.getColor(index, this.mOuterNormalColor);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_hideRadiusSide) {
                    this.mHideRadiusSide = ta.getColor(index, this.mHideRadiusSide);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_showBorderOnlyBeforeL) {
                    this.mIsShowBorderOnlyBeforeL = ta.getBoolean(index, this.mIsShowBorderOnlyBeforeL);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_shadowElevation) {
                    shadow = ta.getDimensionPixelSize(index, shadow);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_shadowAlpha) {
                    this.mShadowAlpha = ta.getFloat(index, this.mShadowAlpha);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_useThemeGeneralShadowElevation) {
                    useThemeGeneralShadowElevation = ta.getBoolean(index, false);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_outlineInsetLeft) {
                    this.mOutlineInsetLeft = ta.getDimensionPixelSize(index, 0);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_outlineInsetRight) {
                    this.mOutlineInsetRight = ta.getDimensionPixelSize(index, 0);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_outlineInsetTop) {
                    this.mOutlineInsetTop = ta.getDimensionPixelSize(index, 0);
                    continue;
                }
                if (index == R.styleable.QMUILayout_qmui_outlineInsetBottom) {
                    this.mOutlineInsetBottom = ta.getDimensionPixelSize(index, 0);
                    continue;
                }
                if (index != R.styleable.QMUILayout_qmui_outlineExcludePadding) continue;
                this.mIsOutlineExcludePadding = ta.getBoolean(index, false);
            }
            ta.recycle();
        }
        if (shadow == 0 && useThemeGeneralShadowElevation) {
            shadow = QMUIResHelper.getAttrDimen(context, R.attr.qmui_general_shadow_elevation);
        }
        this.setRadiusAndShadow(radius, this.mHideRadiusSide, shadow, this.mShadowAlpha);
    }

    @Override
    public void setUseThemeGeneralShadowElevation() {
        this.mShadowElevation = QMUIResHelper.getAttrDimen(this.mContext, R.attr.qmui_general_shadow_elevation);
        this.setRadiusAndShadow(this.mRadius, this.mHideRadiusSide, this.mShadowElevation, this.mShadowAlpha);
    }

    @Override
    public void setOutlineExcludePadding(boolean outlineExcludePadding) {
        if (QMUILayoutHelper.useFeature()) {
            View owner = (View)this.mOwner.get();
            if (owner == null) {
                return;
            }
            this.mIsOutlineExcludePadding = outlineExcludePadding;
            owner.invalidateOutline();
        }
    }

    @Override
    public boolean setWidthLimit(int widthLimit) {
        if (this.mWidthLimit != widthLimit) {
            this.mWidthLimit = widthLimit;
            return true;
        }
        return false;
    }

    @Override
    public boolean setHeightLimit(int heightLimit) {
        if (this.mHeightLimit != heightLimit) {
            this.mHeightLimit = heightLimit;
            return true;
        }
        return false;
    }

    @Override
    public int getShadowElevation() {
        return this.mShadowElevation;
    }

    @Override
    public float getShadowAlpha() {
        return this.mShadowAlpha;
    }

    @Override
    public int getShadowColor() {
        return this.mShadowColor;
    }

    @Override
    public void setOutlineInset(int left, int top, int right, int bottom) {
        if (QMUILayoutHelper.useFeature()) {
            View owner = (View)this.mOwner.get();
            if (owner == null) {
                return;
            }
            this.mOutlineInsetLeft = left;
            this.mOutlineInsetRight = right;
            this.mOutlineInsetTop = top;
            this.mOutlineInsetBottom = bottom;
            owner.invalidateOutline();
        }
    }

    @Override
    public void setShowBorderOnlyBeforeL(boolean showBorderOnlyBeforeL) {
        this.mIsShowBorderOnlyBeforeL = showBorderOnlyBeforeL;
        this.invalidate();
    }

    @Override
    public void setShadowElevation(int elevation) {
        if (this.mShadowElevation == elevation) {
            return;
        }
        this.mShadowElevation = elevation;
        this.invalidate();
    }

    @Override
    public void setShadowAlpha(float shadowAlpha) {
        if (this.mShadowAlpha == shadowAlpha) {
            return;
        }
        this.mShadowAlpha = shadowAlpha;
        this.invalidate();
    }

    @Override
    public void setShadowColor(int shadowColor) {
        if (this.mShadowColor == shadowColor) {
            return;
        }
        this.mShadowColor = shadowColor;
        this.setShadowColorInner(this.mShadowColor);
    }

    private void setShadowColorInner(int shadowColor) {
        if (Build.VERSION.SDK_INT >= 28) {
            View owner = (View)this.mOwner.get();
            if (owner == null) {
                return;
            }
            owner.setOutlineAmbientShadowColor(shadowColor);
            owner.setOutlineSpotShadowColor(shadowColor);
        }
    }

    private void invalidate() {
        if (QMUILayoutHelper.useFeature()) {
            View owner = (View)this.mOwner.get();
            if (owner == null) {
                return;
            }
            if (this.mShadowElevation == 0) {
                owner.setElevation(0.0f);
            } else {
                owner.setElevation((float)this.mShadowElevation);
            }
            owner.invalidateOutline();
        }
    }

    @Override
    public void setHideRadiusSide(int hideRadiusSide) {
        if (this.mHideRadiusSide == hideRadiusSide) {
            return;
        }
        this.setRadiusAndShadow(this.mRadius, hideRadiusSide, this.mShadowElevation, this.mShadowAlpha);
    }

    @Override
    public int getHideRadiusSide() {
        return this.mHideRadiusSide;
    }

    @Override
    public void setRadius(int radius) {
        if (this.mRadius != radius) {
            this.setRadiusAndShadow(radius, this.mShadowElevation, this.mShadowAlpha);
        }
    }

    @Override
    public void setRadius(int radius, int hideRadiusSide) {
        if (this.mRadius == radius && hideRadiusSide == this.mHideRadiusSide) {
            return;
        }
        this.setRadiusAndShadow(radius, hideRadiusSide, this.mShadowElevation, this.mShadowAlpha);
    }

    @Override
    public int getRadius() {
        return this.mRadius;
    }

    @Override
    public void setRadiusAndShadow(int radius, int shadowElevation, float shadowAlpha) {
        this.setRadiusAndShadow(radius, this.mHideRadiusSide, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, float shadowAlpha) {
        this.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, this.mShadowColor, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, int shadowColor, float shadowAlpha) {
        View owner = (View)this.mOwner.get();
        if (owner == null) {
            return;
        }
        this.mRadius = radius;
        this.mHideRadiusSide = hideRadiusSide;
        if (this.mRadius > 0) {
            this.mRadiusArray = hideRadiusSide == 1 ? new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius} : (hideRadiusSide == 2 ? new float[]{this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius} : (hideRadiusSide == 3 ? new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f} : (float[])(hideRadiusSide == 4 ? new float[]{0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f} : null)));
        }
        this.mShadowElevation = shadowElevation;
        this.mShadowAlpha = shadowAlpha;
        this.mShadowColor = shadowColor;
        if (QMUILayoutHelper.useFeature()) {
            if (this.mShadowElevation == 0 || this.isRadiusWithSideHidden()) {
                owner.setElevation(0.0f);
            } else {
                owner.setElevation((float)this.mShadowElevation);
            }
            this.setShadowColorInner(this.mShadowColor);
            owner.setOutlineProvider(new ViewOutlineProvider(){

                @TargetApi(value=21)
                public void getOutline(View view, Outline outline) {
                    int w = view.getWidth();
                    int h = view.getHeight();
                    if (w == 0 || h == 0) {
                        return;
                    }
                    if (QMUILayoutHelper.this.isRadiusWithSideHidden()) {
                        int left = 0;
                        int top = 0;
                        int right = w;
                        int bottom = h;
                        if (QMUILayoutHelper.this.mHideRadiusSide == 4) {
                            left -= QMUILayoutHelper.this.mRadius;
                        } else if (QMUILayoutHelper.this.mHideRadiusSide == 1) {
                            top -= QMUILayoutHelper.this.mRadius;
                        } else if (QMUILayoutHelper.this.mHideRadiusSide == 2) {
                            right += QMUILayoutHelper.this.mRadius;
                        } else if (QMUILayoutHelper.this.mHideRadiusSide == 3) {
                            bottom += QMUILayoutHelper.this.mRadius;
                        }
                        outline.setRoundRect(left, top, right, bottom, (float)QMUILayoutHelper.this.mRadius);
                        return;
                    }
                    int top = QMUILayoutHelper.this.mOutlineInsetTop;
                    int bottom = Math.max(top + 1, h - QMUILayoutHelper.this.mOutlineInsetBottom);
                    int left = QMUILayoutHelper.this.mOutlineInsetLeft;
                    int right = w - QMUILayoutHelper.this.mOutlineInsetRight;
                    if (QMUILayoutHelper.this.mIsOutlineExcludePadding) {
                        right = Math.max((left += view.getPaddingLeft()) + 1, right - view.getPaddingRight());
                        bottom = Math.max((top += view.getPaddingTop()) + 1, bottom - view.getPaddingBottom());
                    }
                    float shadowAlpha = QMUILayoutHelper.this.mShadowAlpha;
                    if (QMUILayoutHelper.this.mShadowElevation == 0) {
                        shadowAlpha = 1.0f;
                    }
                    outline.setAlpha(shadowAlpha);
                    if (QMUILayoutHelper.this.mRadius <= 0) {
                        outline.setRect(left, top, right, bottom);
                    } else {
                        outline.setRoundRect(left, top, right, bottom, (float)QMUILayoutHelper.this.mRadius);
                    }
                }
            });
            owner.setClipToOutline(this.mRadius > 0);
        }
        owner.invalidate();
    }

    public boolean isRadiusWithSideHidden() {
        return this.mRadius > 0 && this.mHideRadiusSide != 0;
    }

    @Override
    public void updateTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mTopDividerInsetLeft = topInsetLeft;
        this.mTopDividerInsetRight = topInsetRight;
        this.mTopDividerHeight = topDividerHeight;
        this.mTopDividerColor = topDividerColor;
    }

    @Override
    public void updateBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mBottomDividerInsetLeft = bottomInsetLeft;
        this.mBottomDividerInsetRight = bottomInsetRight;
        this.mBottomDividerColor = bottomDividerColor;
        this.mBottomDividerHeight = bottomDividerHeight;
    }

    @Override
    public void updateLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLeftDividerInsetTop = leftInsetTop;
        this.mLeftDividerInsetBottom = leftInsetBottom;
        this.mLeftDividerWidth = leftDividerWidth;
        this.mLeftDividerColor = leftDividerColor;
    }

    @Override
    public void updateRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mRightDividerInsetTop = rightInsetTop;
        this.mRightDividerInsetBottom = rightInsetBottom;
        this.mRightDividerWidth = rightDividerWidth;
        this.mRightDividerColor = rightDividerColor;
    }

    @Override
    public void onlyShowTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.updateTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.mLeftDividerWidth = 0;
        this.mRightDividerWidth = 0;
        this.mBottomDividerHeight = 0;
    }

    @Override
    public void onlyShowBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.updateBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.mLeftDividerWidth = 0;
        this.mRightDividerWidth = 0;
        this.mTopDividerHeight = 0;
    }

    @Override
    public void onlyShowLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.updateLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.mRightDividerWidth = 0;
        this.mTopDividerHeight = 0;
        this.mBottomDividerHeight = 0;
    }

    @Override
    public void onlyShowRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.updateRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.mLeftDividerWidth = 0;
        this.mTopDividerHeight = 0;
        this.mBottomDividerHeight = 0;
    }

    @Override
    public void setTopDividerAlpha(int dividerAlpha) {
        this.mTopDividerAlpha = dividerAlpha;
    }

    @Override
    public void setBottomDividerAlpha(int dividerAlpha) {
        this.mBottomDividerAlpha = dividerAlpha;
    }

    @Override
    public void setLeftDividerAlpha(int dividerAlpha) {
        this.mLeftDividerAlpha = dividerAlpha;
    }

    @Override
    public void setRightDividerAlpha(int dividerAlpha) {
        this.mRightDividerAlpha = dividerAlpha;
    }

    public int handleMiniWidth(int widthMeasureSpec, int measuredWidth) {
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 && measuredWidth < this.mWidthMini) {
            return View.MeasureSpec.makeMeasureSpec((int)this.mWidthMini, (int)0x40000000);
        }
        return widthMeasureSpec;
    }

    public int handleMiniHeight(int heightMeasureSpec, int measuredHeight) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000 && measuredHeight < this.mHeightMini) {
            return View.MeasureSpec.makeMeasureSpec((int)this.mHeightMini, (int)0x40000000);
        }
        return heightMeasureSpec;
    }

    public int getMeasuredWidthSpec(int widthMeasureSpec) {
        int size;
        if (this.mWidthLimit > 0 && (size = View.MeasureSpec.getSize((int)widthMeasureSpec)) > this.mWidthLimit) {
            int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            widthMeasureSpec = mode == Integer.MIN_VALUE ? View.MeasureSpec.makeMeasureSpec((int)this.mWidthLimit, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)this.mWidthLimit, (int)0x40000000);
        }
        return widthMeasureSpec;
    }

    public int getMeasuredHeightSpec(int heightMeasureSpec) {
        int size;
        if (this.mHeightLimit > 0 && (size = View.MeasureSpec.getSize((int)heightMeasureSpec)) > this.mHeightLimit) {
            int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            heightMeasureSpec = mode == Integer.MIN_VALUE ? View.MeasureSpec.makeMeasureSpec((int)this.mWidthLimit, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)this.mWidthLimit, (int)0x40000000);
        }
        return heightMeasureSpec;
    }

    @Override
    public void setBorderColor(@ColorInt int borderColor) {
        this.mBorderColor = borderColor;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
    }

    @Override
    public void setOuterNormalColor(int color2) {
        this.mOuterNormalColor = color2;
        View owner = (View)this.mOwner.get();
        if (owner != null) {
            owner.invalidate();
        }
    }

    public void drawDividers(Canvas canvas, int w, int h) {
        float y;
        if (this.mDividerPaint == null && (this.mTopDividerHeight > 0 || this.mBottomDividerHeight > 0 || this.mLeftDividerWidth > 0 || this.mRightDividerWidth > 0)) {
            this.mDividerPaint = new Paint();
        }
        if (this.mTopDividerHeight > 0) {
            this.mDividerPaint.setStrokeWidth((float)this.mTopDividerHeight);
            this.mDividerPaint.setColor(this.mTopDividerColor);
            if (this.mTopDividerAlpha < 255) {
                this.mDividerPaint.setAlpha(this.mTopDividerAlpha);
            }
            y = (float)this.mTopDividerHeight * 1.0f / 2.0f;
            canvas.drawLine((float)this.mTopDividerInsetLeft, y, (float)(w - this.mTopDividerInsetRight), y, this.mDividerPaint);
        }
        if (this.mBottomDividerHeight > 0) {
            this.mDividerPaint.setStrokeWidth((float)this.mBottomDividerHeight);
            this.mDividerPaint.setColor(this.mBottomDividerColor);
            if (this.mBottomDividerAlpha < 255) {
                this.mDividerPaint.setAlpha(this.mBottomDividerAlpha);
            }
            y = (float)Math.floor((float)h - (float)this.mBottomDividerHeight * 1.0f / 2.0f);
            canvas.drawLine((float)this.mBottomDividerInsetLeft, y, (float)(w - this.mBottomDividerInsetRight), y, this.mDividerPaint);
        }
        if (this.mLeftDividerWidth > 0) {
            this.mDividerPaint.setStrokeWidth((float)this.mLeftDividerWidth);
            this.mDividerPaint.setColor(this.mLeftDividerColor);
            if (this.mLeftDividerAlpha < 255) {
                this.mDividerPaint.setAlpha(this.mLeftDividerAlpha);
            }
            canvas.drawLine(0.0f, (float)this.mLeftDividerInsetTop, 0.0f, (float)(h - this.mLeftDividerInsetBottom), this.mDividerPaint);
        }
        if (this.mRightDividerWidth > 0) {
            this.mDividerPaint.setStrokeWidth((float)this.mRightDividerWidth);
            this.mDividerPaint.setColor(this.mRightDividerColor);
            if (this.mRightDividerAlpha < 255) {
                this.mDividerPaint.setAlpha(this.mRightDividerAlpha);
            }
            canvas.drawLine((float)w, (float)this.mRightDividerInsetTop, (float)w, (float)(h - this.mRightDividerInsetBottom), this.mDividerPaint);
        }
    }

    public void dispatchRoundBorderDraw(Canvas canvas) {
        boolean needDrawBorder;
        View owner = (View)this.mOwner.get();
        if (owner == null) {
            return;
        }
        boolean needCheckFakeOuterNormalDraw = this.mRadius > 0 && !QMUILayoutHelper.useFeature() && this.mOuterNormalColor != 0;
        boolean bl = needDrawBorder = this.mBorderWidth > 0 && this.mBorderColor != 0;
        if (!needCheckFakeOuterNormalDraw && !needDrawBorder) {
            return;
        }
        if (this.mIsShowBorderOnlyBeforeL && QMUILayoutHelper.useFeature() && this.mShadowElevation != 0) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        if (this.mIsOutlineExcludePadding) {
            this.mBorderRect.set((float)owner.getPaddingLeft(), (float)owner.getPaddingTop(), (float)(width - owner.getPaddingRight()), (float)(height - owner.getPaddingBottom()));
        } else {
            this.mBorderRect.set(0.0f, 0.0f, (float)width, (float)height);
        }
        if (needCheckFakeOuterNormalDraw) {
            int layerId = canvas.saveLayer(0.0f, 0.0f, (float)width, (float)height, null, 31);
            canvas.drawColor(this.mOuterNormalColor);
            this.mClipPaint.setColor(this.mOuterNormalColor);
            this.mClipPaint.setStyle(Paint.Style.FILL);
            this.mClipPaint.setXfermode((Xfermode)this.mMode);
            if (this.mRadiusArray == null) {
                canvas.drawRoundRect(this.mBorderRect, (float)this.mRadius, (float)this.mRadius, this.mClipPaint);
            } else {
                this.drawRoundRect(canvas, this.mBorderRect, this.mRadiusArray, this.mClipPaint);
            }
            this.mClipPaint.setXfermode(null);
            canvas.restoreToCount(layerId);
        }
        if (needDrawBorder) {
            this.mClipPaint.setColor(this.mBorderColor);
            this.mClipPaint.setStrokeWidth((float)this.mBorderWidth);
            this.mClipPaint.setStyle(Paint.Style.STROKE);
            if (this.mRadiusArray != null) {
                this.drawRoundRect(canvas, this.mBorderRect, this.mRadiusArray, this.mClipPaint);
            } else if (this.mRadius <= 0) {
                canvas.drawRect(this.mBorderRect, this.mClipPaint);
            } else {
                canvas.drawRoundRect(this.mBorderRect, (float)this.mRadius, (float)this.mRadius, this.mClipPaint);
            }
        }
    }

    private void drawRoundRect(Canvas canvas, RectF rect, float[] radiusArray, Paint paint) {
        this.mPath.reset();
        this.mPath.addRoundRect(rect, radiusArray, Path.Direction.CW);
        canvas.drawPath(this.mPath, paint);
    }

    public static boolean useFeature() {
        return Build.VERSION.SDK_INT >= 21;
    }
}

