/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.webview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v4.view.WindowInsetsCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.qmuiteam.qmui.util.QMUINotchHelper;
import com.qmuiteam.qmui.widget.QMUIWindowInsetLayout;
import com.qmuiteam.qmui.widget.webview.QMUIWebView;

public class QMUIWebViewContainer
extends QMUIWindowInsetLayout {
    private QMUIWebView mWebView;
    private QMUIWebView.OnScrollChangeListener mOnScrollChangeListener;

    public QMUIWebViewContainer(Context context) {
        super(context);
    }

    public QMUIWebViewContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void addWebView(@NonNull QMUIWebView webView, boolean needDispatchSafeAreaInset) {
        this.mWebView = webView;
        this.mWebView.setNeedDispatchSafeAreaInset(needDispatchSafeAreaInset);
        this.mWebView.addCustomOnScrollChangeListener(new QMUIWebView.OnScrollChangeListener(){

            @Override
            public void onScrollChange(WebView webView, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                if (QMUIWebViewContainer.this.mOnScrollChangeListener != null) {
                    QMUIWebViewContainer.this.mOnScrollChangeListener.onScrollChange(webView, scrollX, scrollY, oldScrollX, oldScrollY);
                }
            }
        });
        this.addView((View)this.mWebView, (ViewGroup.LayoutParams)this.getWebViewLayoutParams());
    }

    protected FrameLayout.LayoutParams getWebViewLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    public void setNeedDispatchSafeAreaInset(boolean needDispatchSafeAreaInset) {
        if (this.mWebView != null) {
            this.mWebView.setNeedDispatchSafeAreaInset(needDispatchSafeAreaInset);
        }
    }

    public void destroy() {
        this.removeView((View)this.mWebView);
        this.removeAllViews();
        this.mWebView.setWebChromeClient(null);
        this.mWebView.setWebViewClient(null);
        this.mWebView.destroy();
    }

    public void setCustomOnScrollChangeListener(QMUIWebView.OnScrollChangeListener onScrollChangeListener) {
        this.mOnScrollChangeListener = onScrollChangeListener;
    }

    @Override
    @TargetApi(value=19)
    public boolean applySystemWindowInsets19(Rect insets) {
        if (this.getFitsSystemWindows()) {
            Rect childInsets = new Rect(insets);
            this.mQMUIWindowInsetHelper.computeInsets((View)this, childInsets);
            this.setPadding(childInsets.left, childInsets.top, childInsets.right, childInsets.bottom);
            return true;
        }
        return super.applySystemWindowInsets19(insets);
    }

    @Override
    @TargetApi(value=21)
    public boolean applySystemWindowInsets21(Object insets) {
        if (this.getFitsSystemWindows()) {
            int insetLeft = 0;
            int insetRight = 0;
            int insetTop = 0;
            int insetBottom = 0;
            if (insets instanceof WindowInsetsCompat) {
                WindowInsetsCompat windowInsetsCompat = (WindowInsetsCompat)insets;
                insetLeft = windowInsetsCompat.getSystemWindowInsetLeft();
                insetRight = windowInsetsCompat.getSystemWindowInsetRight();
                insetTop = windowInsetsCompat.getSystemWindowInsetTop();
                insetBottom = windowInsetsCompat.getSystemWindowInsetBottom();
            } else if (insets instanceof WindowInsets) {
                WindowInsets windowInsets = (WindowInsets)insets;
                insetLeft = windowInsets.getSystemWindowInsetLeft();
                insetRight = windowInsets.getSystemWindowInsetRight();
                insetTop = windowInsets.getSystemWindowInsetTop();
                insetBottom = windowInsets.getSystemWindowInsetBottom();
            }
            if (QMUINotchHelper.needFixLandscapeNotchAreaFitSystemWindow((View)this) && this.getResources().getConfiguration().orientation == 2) {
                insetLeft = Math.max(insetLeft, QMUINotchHelper.getSafeInsetLeft((View)this));
                insetRight = Math.max(insetRight, QMUINotchHelper.getSafeInsetRight((View)this));
            }
            Rect childInsets = new Rect(insetLeft, insetTop, insetRight, insetBottom);
            this.mQMUIWindowInsetHelper.computeInsets((View)this, childInsets);
            this.setPadding(childInsets.left, childInsets.top, childInsets.right, childInsets.bottom);
            return true;
        }
        return super.applySystemWindowInsets21(insets);
    }
}

