/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.webview;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.qmuiteam.qmui.widget.webview.QMUIWebView;

public class QMUIWebViewClient
extends WebViewClient {
    public static final int JS_FAKE_KEY_CODE_EVENT = 112;
    private boolean mNeedDispatchSafeAreaInset;
    private boolean mDisableVideoFullscreenBtnAlways;
    private boolean mIsPageFinished = false;

    public QMUIWebViewClient(boolean needDispatchSafeAreaInset, boolean disableVideoFullscreenBtnAlways) {
        this.mNeedDispatchSafeAreaInset = needDispatchSafeAreaInset;
        this.mDisableVideoFullscreenBtnAlways = disableVideoFullscreenBtnAlways;
    }

    public void setNeedDispatchSafeAreaInset(QMUIWebView webView) {
        if (!this.mNeedDispatchSafeAreaInset) {
            this.mNeedDispatchSafeAreaInset = true;
            if (this.mIsPageFinished) {
                this.dispatchFullscreenRequestAction(webView);
            }
        }
    }

    public void onPageStarted(WebView view, String url, @Nullable Bitmap favicon) {
        this.mIsPageFinished = false;
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.mIsPageFinished = true;
        if (this.mDisableVideoFullscreenBtnAlways) {
            this.runJsCode(view, this.getJsCodeForDisableVideoFullscreenBtn(), null);
        }
        if (this.mNeedDispatchSafeAreaInset && view instanceof QMUIWebView) {
            this.dispatchFullscreenRequestAction((QMUIWebView)view);
        }
    }

    private String getJsCodeForDisableVideoFullscreenBtn() {
        return "(function(){\n   var head = document.getElementsByTagName('head')[0];\n   var style = document.createElement('style');\n   style.type = 'text/css';   style.innerHTML = 'video::-webkit-media-controls-fullscreen-button{display: none !important;}'\n   head.appendChild(style);\n})()";
    }

    private String getJsCodeForFullscreenHtml() {
        return "(function(){\n   document.body.addEventListener('keydown', function(e){\n        if(e.keyCode == 112){\n             var html = document.documentElement;\n             var requestFullscreen = html.requestFullscreen || html.webkitRequestFullscreen;\n             requestFullscreen.call(html);\n        }\n    })\n})()";
    }

    private void dispatchFullscreenRequestAction(final QMUIWebView webView) {
        boolean sureNotSupportModifyCssEnv = webView.isNotSupportChangeCssEnv();
        if (sureNotSupportModifyCssEnv) {
            return;
        }
        if (!this.mDisableVideoFullscreenBtnAlways) {
            this.runJsCode(webView, this.getJsCodeForDisableVideoFullscreenBtn(), null);
        }
        this.runJsCode(webView, this.getJsCodeForFullscreenHtml(), new Runnable(){

            @Override
            public void run() {
                QMUIWebViewClient.this.dispatchFullscreenRequestEvent(webView);
            }
        });
    }

    private void dispatchFullscreenRequestEvent(WebView webView) {
        KeyEvent keyEvent = new KeyEvent(SystemClock.uptimeMillis(), SystemClock.uptimeMillis(), 0, 131, 0, 0, -1, 0);
        webView.dispatchKeyEvent(keyEvent);
    }

    private void runJsCode(WebView webView, @NonNull String jsCode, final @Nullable Runnable finishAction) {
        if (Build.VERSION.SDK_INT > 19) {
            if (finishAction == null) {
                webView.evaluateJavascript(jsCode, null);
            } else {
                webView.evaluateJavascript(jsCode, (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                        finishAction.run();
                    }
                });
            }
        } else {
            webView.loadUrl("javascript:" + jsCode);
            if (finishAction != null) {
                webView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        finishAction.run();
                    }
                }, 250L);
            }
        }
    }
}

