/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.textview;

import android.content.Context;
import android.support.v7.widget.AppCompatTextView;
import android.text.Spannable;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.qmuiteam.qmui.link.QMUILinkTouchMovementMethod;
import com.qmuiteam.qmui.widget.textview.ISpanTouchFix;

public class QMUISpanTouchFixTextView
extends AppCompatTextView
implements ISpanTouchFix {
    protected boolean mTouchSpanHit;
    private boolean mIsPressedRecord = false;
    private boolean mNeedForceEventToParent = false;

    public QMUISpanTouchFixTextView(Context context) {
        this(context, null);
    }

    public QMUISpanTouchFixTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUISpanTouchFixTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHighlightColor(0);
    }

    public void setNeedForceEventToParent(boolean needForceEventToParent) {
        this.mNeedForceEventToParent = needForceEventToParent;
        this.setFocusable(!needForceEventToParent);
        this.setClickable(!needForceEventToParent);
        this.setLongClickable(!needForceEventToParent);
    }

    public void setMovementMethodDefault() {
        this.setMovementMethodCompat(QMUILinkTouchMovementMethod.getInstance());
    }

    public void setMovementMethodCompat(MovementMethod movement) {
        this.setMovementMethod(movement);
        if (this.mNeedForceEventToParent) {
            this.setNeedForceEventToParent(true);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!(this.getText() instanceof Spannable)) {
            return super.onTouchEvent(event);
        }
        this.mTouchSpanHit = true;
        boolean ret = super.onTouchEvent(event);
        if (this.mNeedForceEventToParent) {
            return this.mTouchSpanHit;
        }
        return ret;
    }

    @Override
    public void setTouchSpanHit(boolean hit) {
        if (this.mTouchSpanHit != hit) {
            this.mTouchSpanHit = hit;
            this.setPressed(this.mIsPressedRecord);
        }
    }

    public boolean performClick() {
        if (!this.mTouchSpanHit && !this.mNeedForceEventToParent) {
            return super.performClick();
        }
        return false;
    }

    public boolean performLongClick() {
        if (!this.mTouchSpanHit && !this.mNeedForceEventToParent) {
            return super.performLongClick();
        }
        return false;
    }

    public final void setPressed(boolean pressed) {
        this.mIsPressedRecord = pressed;
        if (!this.mTouchSpanHit) {
            this.onSetPressed(pressed);
        }
    }

    protected void onSetPressed(boolean pressed) {
        super.setPressed(pressed);
    }
}

