/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.section;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.DiffUtil;
import android.util.SparseIntArray;
import com.qmuiteam.qmui.widget.section.QMUISection;
import java.util.ArrayList;
import java.util.List;

public class QMUISectionDiffCallback<H extends QMUISection.Model<H>, T extends QMUISection.Model<T>>
extends DiffUtil.Callback {
    private ArrayList<QMUISection<H, T>> mOldList = new ArrayList();
    private ArrayList<QMUISection<H, T>> mNewList = new ArrayList();
    private SparseIntArray mOldSectionIndex = new SparseIntArray();
    private SparseIntArray mOldItemIndex = new SparseIntArray();
    private SparseIntArray mNewSectionIndex = new SparseIntArray();
    private SparseIntArray mNewItemIndex = new SparseIntArray();

    public QMUISectionDiffCallback(@Nullable List<QMUISection<H, T>> oldList, @Nullable List<QMUISection<H, T>> newList) {
        if (oldList != null) {
            this.mOldList.addAll(oldList);
        }
        if (newList != null) {
            this.mNewList.addAll(newList);
        }
        this.generateIndex(this.mOldList, this.mOldSectionIndex, this.mOldItemIndex);
        this.generateIndex(this.mNewList, this.mNewSectionIndex, this.mNewItemIndex);
    }

    public void cloneNewIndexTo(@NonNull SparseIntArray sectionIndex, @NonNull SparseIntArray itemIndex) {
        int i;
        sectionIndex.clear();
        itemIndex.clear();
        for (i = 0; i < this.mNewSectionIndex.size(); ++i) {
            sectionIndex.append(this.mNewSectionIndex.keyAt(i), this.mNewSectionIndex.valueAt(i));
        }
        for (i = 0; i < this.mNewItemIndex.size(); ++i) {
            itemIndex.append(this.mNewItemIndex.keyAt(i), this.mNewItemIndex.valueAt(i));
        }
    }

    private void generateIndex(List<QMUISection<H, T>> list, SparseIntArray sectionIndex, SparseIntArray itemIndex) {
        sectionIndex.clear();
        itemIndex.clear();
        IndexGenerationInfo generationInfo = new IndexGenerationInfo(sectionIndex, itemIndex);
        if (list.isEmpty() || !list.get(0).isLocked()) {
            this.onGenerateCustomIndexBeforeSectionList(generationInfo, list);
        }
        for (int i = 0; i < list.size(); ++i) {
            QMUISection<H, T> section = list.get(i);
            if (section.isLocked()) continue;
            generationInfo.appendIndex(i, -2);
            if (section.isFold()) continue;
            this.onGenerateCustomIndexBeforeItemList(generationInfo, section, i);
            if (section.isExistBeforeDataToLoad()) {
                generationInfo.appendIndex(i, -3);
            }
            for (int j = 0; j < section.getItemCount(); ++j) {
                generationInfo.appendIndex(i, j);
            }
            if (section.isExistAfterDataToLoad()) {
                generationInfo.appendIndex(i, -4);
            }
            this.onGenerateCustomIndexAfterItemList(generationInfo, section, i);
        }
        if (list.isEmpty()) {
            this.onGenerateCustomIndexAfterSectionList(generationInfo, list);
        } else {
            QMUISection<H, T> lastSection = list.get(list.size() - 1);
            if (!(lastSection.isLocked() || !lastSection.isFold() && lastSection.isExistAfterDataToLoad())) {
                this.onGenerateCustomIndexAfterSectionList(generationInfo, list);
            }
        }
    }

    protected void onGenerateCustomIndexBeforeSectionList(IndexGenerationInfo generationInfo, List<QMUISection<H, T>> list) {
    }

    protected void onGenerateCustomIndexAfterSectionList(IndexGenerationInfo generationInfo, List<QMUISection<H, T>> list) {
    }

    protected void onGenerateCustomIndexBeforeItemList(IndexGenerationInfo generationInfo, QMUISection<H, T> section, int sectionIndex) {
    }

    protected void onGenerateCustomIndexAfterItemList(IndexGenerationInfo generationInfo, QMUISection<H, T> section, int sectionIndex) {
    }

    protected boolean areCustomContentsTheSame(@Nullable QMUISection<H, T> oldSection, int oldItemIndex, @Nullable QMUISection<H, T> newSection, int newItemIndex) {
        return false;
    }

    public int getOldListSize() {
        return this.mOldSectionIndex.size();
    }

    public int getNewListSize() {
        return this.mNewSectionIndex.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        int oldSectionIndex = this.mOldSectionIndex.get(oldItemPosition);
        int oldItemIndex = this.mOldItemIndex.get(oldItemPosition);
        int newSectionIndex = this.mNewSectionIndex.get(newItemPosition);
        int newItemIndex = this.mNewItemIndex.get(newItemPosition);
        if (oldSectionIndex < 0 || newSectionIndex < 0) {
            return oldSectionIndex == newSectionIndex && oldItemIndex == newItemIndex;
        }
        QMUISection<H, T> oldModel = this.mOldList.get(oldSectionIndex);
        QMUISection<H, T> newModel = this.mNewList.get(newSectionIndex);
        if (!oldModel.getHeader().isSameItem(newModel.getHeader())) {
            return false;
        }
        if (oldItemIndex < 0 && oldItemIndex == newItemIndex) {
            return true;
        }
        if (oldItemIndex < 0 || newItemIndex < 0) {
            return false;
        }
        T oldItem = oldModel.getItemAt(oldItemIndex);
        T newItem = newModel.getItemAt(newItemIndex);
        return oldItem == null && newItem == null || oldItem != null && newItem != null && oldItem.isSameItem(newItem);
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        int oldSectionIndex = this.mOldSectionIndex.get(oldItemPosition);
        int oldItemIndex = this.mOldItemIndex.get(oldItemPosition);
        int newSectionIndex = this.mNewSectionIndex.get(newItemPosition);
        int newItemIndex = this.mNewItemIndex.get(newItemPosition);
        if (newSectionIndex < 0) {
            return this.areCustomContentsTheSame(null, oldItemIndex, null, newItemIndex);
        }
        QMUISection<H, T> oldModel = this.mOldList.get(oldSectionIndex);
        QMUISection<H, T> newModel = this.mNewList.get(newSectionIndex);
        if (oldItemIndex == -2) {
            return oldModel.isFold() == newModel.isFold() && oldModel.getHeader().isSameContent(newModel.getHeader());
        }
        if (oldItemIndex == -3 || oldItemIndex == -4) {
            return false;
        }
        if (QMUISection.isCustomItemIndex(oldItemIndex)) {
            return this.areCustomContentsTheSame(oldModel, oldItemIndex, newModel, newItemIndex);
        }
        T oldItem = oldModel.getItemAt(oldItemIndex);
        T newItem = newModel.getItemAt(newItemIndex);
        return oldItem == null && newItem == null || oldItem != null && newItem != null && oldItem.isSameContent(newItem);
    }

    public static class IndexGenerationInfo {
        private SparseIntArray sectionIndexArray;
        private SparseIntArray itemIndexArray;
        private int currentPosition;

        private IndexGenerationInfo(SparseIntArray sectionIndex, SparseIntArray itemIndex) {
            this.sectionIndexArray = sectionIndex;
            this.itemIndexArray = itemIndex;
            this.currentPosition = 0;
        }

        public final void appendCustomIndex(int sectionIndex, int itemIndex) {
            int offset = -1000 + itemIndex;
            if (!QMUISection.isCustomItemIndex(offset)) {
                throw new IllegalArgumentException("Index conflicts with index used internally, please use negative number for custom item");
            }
            this.appendIndex(sectionIndex, offset);
        }

        private final void appendIndex(int sectionIndex, int itemIndex) {
            if (sectionIndex < 0) {
                throw new IllegalArgumentException("use appendWholeListCustomIndex for whole list");
            }
            this.sectionIndexArray.append(this.currentPosition, sectionIndex);
            this.itemIndexArray.append(this.currentPosition, itemIndex);
            ++this.currentPosition;
        }

        public final void appendWholeListCustomIndex(int itemIndex) {
            int offset = -1000 + itemIndex;
            if (!QMUISection.isCustomItemIndex(offset)) {
                throw new IllegalArgumentException("Index conflicts with index used internally, please use negative number for custom item");
            }
            this.appendWholeListIndex(offset);
        }

        private final void appendWholeListIndex(int itemIndex) {
            this.sectionIndexArray.append(this.currentPosition, -1);
            this.itemIndexArray.append(this.currentPosition, itemIndex);
            ++this.currentPosition;
        }
    }
}

