/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.grouplist;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUILangHelper;

public class QMUIGroupListSectionHeaderFooterView
extends LinearLayout {
    private TextView mTextView;

    public QMUIGroupListSectionHeaderFooterView(Context context) {
        this(context, null, R.attr.QMUIGroupListSectionViewStyle);
    }

    public QMUIGroupListSectionHeaderFooterView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUIGroupListSectionViewStyle);
    }

    public QMUIGroupListSectionHeaderFooterView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public QMUIGroupListSectionHeaderFooterView(Context context, CharSequence titleText) {
        this(context);
        this.setText(titleText);
    }

    public QMUIGroupListSectionHeaderFooterView(Context context, CharSequence titleText, boolean isFooter) {
        this(context);
        if (isFooter) {
            this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), 0);
        }
        this.setText(titleText);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.qmui_group_list_section_layout, (ViewGroup)this, true);
        this.setGravity(80);
        this.mTextView = (TextView)this.findViewById(R.id.group_list_section_header_textView);
    }

    public void setText(CharSequence text) {
        if (QMUILangHelper.isNullOrEmpty(text)) {
            this.mTextView.setVisibility(8);
        } else {
            this.mTextView.setVisibility(0);
        }
        this.mTextView.setText(text);
    }

    public TextView getTextView() {
        return this.mTextView;
    }

    public void setTextGravity(int gravity) {
        this.mTextView.setGravity(gravity);
    }
}

