/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.v4.content.ContextCompat;
import android.view.View;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIButton;
import com.qmuiteam.qmui.util.QMUISpanHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUIDialogAction {
    public static final int ACTION_PROP_POSITIVE = 0;
    public static final int ACTION_PROP_NEUTRAL = 1;
    public static final int ACTION_PROP_NEGATIVE = 2;
    private Context mContext;
    private CharSequence mStr;
    private int mIconRes;
    private int mActionProp;
    private ActionListener mOnClickListener;
    private QMUIButton mButton;
    private boolean mIsEnabled = true;

    public QMUIDialogAction(Context context, int strRes, ActionListener onClickListener) {
        this(context, context.getResources().getString(strRes), 1, onClickListener);
    }

    public QMUIDialogAction(Context context, String str, ActionListener onClickListener) {
        this(context, str, 1, onClickListener);
    }

    public QMUIDialogAction(Context context, int strRes, int actionProp, ActionListener onClickListener) {
        this.mContext = context;
        this.mStr = this.mContext.getResources().getString(strRes);
        this.mActionProp = actionProp;
        this.mOnClickListener = onClickListener;
    }

    public QMUIDialogAction(Context context, CharSequence str, int actionProp, ActionListener onClickListener) {
        this.mContext = context;
        this.mStr = str;
        this.mActionProp = actionProp;
        this.mOnClickListener = onClickListener;
    }

    public QMUIDialogAction(Context context, int iconRes, CharSequence str, int actionProp, ActionListener onClickListener) {
        this.mContext = context;
        this.mIconRes = iconRes;
        this.mStr = str;
        this.mActionProp = actionProp;
        this.mOnClickListener = onClickListener;
    }

    public void setOnClickListener(ActionListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
        if (this.mButton != null) {
            this.mButton.setEnabled(enabled);
        }
    }

    public QMUIButton buildActionView(final QMUIDialog dialog, final int index) {
        this.mButton = this.generateActionButton(dialog.getContext(), this.mStr, this.mIconRes);
        this.mButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QMUIDialogAction.this.mOnClickListener != null && QMUIDialogAction.this.mButton.isEnabled()) {
                    QMUIDialogAction.this.mOnClickListener.onClick(dialog, index);
                }
            }
        });
        return this.mButton;
    }

    private QMUIButton generateActionButton(Context context, CharSequence text, int iconRes) {
        QMUIButton button = new QMUIButton(context);
        QMUIViewHelper.setBackground((View)button, null);
        button.setMinHeight(0);
        button.setMinimumHeight(0);
        button.setChangeAlphaWhenDisable(true);
        button.setChangeAlphaWhenPress(true);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogActionStyleDef, R.attr.qmui_dialog_action_style, 0);
        int count = a.getIndexCount();
        int paddingHor = 0;
        int iconSpace = 0;
        ColorStateList negativeTextColor = null;
        ColorStateList positiveTextColor = null;
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_gravity) {
                button.setGravity(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_textColor) {
                button.setTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_textSize) {
                button.setTextSize(0, a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_action_button_padding_horizontal) {
                paddingHor = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_background) {
                QMUIViewHelper.setBackground((View)button, a.getDrawable(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_minWidth) {
                int miniWidth = a.getDimensionPixelSize(attr2, 0);
                button.setMinWidth(miniWidth);
                button.setMinimumWidth(miniWidth);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_positive_action_text_color) {
                positiveTextColor = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_negative_action_text_color) {
                negativeTextColor = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_action_icon_space) {
                iconSpace = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 != R.styleable.QMUITextCommonStyleDef_android_textStyle) continue;
            int styleIndex = a.getInt(attr2, -1);
            button.setTypeface(null, styleIndex);
        }
        a.recycle();
        button.setPadding(paddingHor, 0, paddingHor, 0);
        if (iconRes <= 0) {
            button.setText(text);
        } else {
            button.setText(QMUISpanHelper.generateSideIconText(true, iconSpace, text, ContextCompat.getDrawable((Context)context, (int)iconRes)));
        }
        button.setClickable(true);
        button.setEnabled(this.mIsEnabled);
        if (this.mActionProp == 2) {
            button.setTextColor(negativeTextColor);
        } else if (this.mActionProp == 0) {
            button.setTextColor(positiveTextColor);
        }
        return button;
    }

    public int getActionProp() {
        return this.mActionProp;
    }

    public static interface ActionListener {
        public void onClick(QMUIDialog var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Prop {
    }
}

