/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.method.TransformationMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIWindowHelper;
import com.qmuiteam.qmui.widget.QMUIWrapContentScrollView;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogBuilder;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogMenuItemView;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;
import java.util.ArrayList;

public class QMUIDialog
extends Dialog {
    boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = true;
    private boolean mCanceledOnTouchOutsideSet;
    private Context mBaseContext;

    public QMUIDialog(Context context) {
        this(context, R.style.QMUI_Dialog);
    }

    public QMUIDialog(Context context, int styleRes) {
        super(context, styleRes);
        this.mBaseContext = context;
        this.init();
    }

    private void init() {
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDialog();
    }

    private void initDialog() {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams wmlp = window.getAttributes();
        wmlp.width = -1;
        wmlp.gravity = 17;
        window.setAttributes(wmlp);
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        this.mCancelable = cancelable;
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        if (cancel && !this.mCancelable) {
            this.mCancelable = true;
        }
        this.mCanceledOnTouchOutside = cancel;
        this.mCanceledOnTouchOutsideSet = true;
    }

    boolean shouldWindowCloseOnTouchOutside() {
        if (!this.mCanceledOnTouchOutsideSet) {
            if (Build.VERSION.SDK_INT < 11) {
                this.mCanceledOnTouchOutside = true;
            } else {
                TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16843611});
                this.mCanceledOnTouchOutside = a.getBoolean(0, true);
                a.recycle();
            }
            this.mCanceledOnTouchOutsideSet = true;
        }
        return this.mCanceledOnTouchOutside;
    }

    void cancelOutSide() {
        if (this.mCancelable && this.isShowing() && this.shouldWindowCloseOnTouchOutside()) {
            this.cancel();
        }
    }

    public void showWithImmersiveCheck(Activity activity) {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        Window activityWindow = activity.getWindow();
        int activitySystemUi = activityWindow.getDecorView().getSystemUiVisibility();
        if ((activitySystemUi & 0x400) == 1024 || (activitySystemUi & 4) == 4) {
            window.setFlags(8, 8);
            window.getDecorView().setSystemUiVisibility(activity.getWindow().getDecorView().getSystemUiVisibility());
            super.show();
            window.clearFlags(8);
        } else {
            super.show();
        }
    }

    public void showWithImmersiveCheck() {
        if (!(this.mBaseContext instanceof Activity)) {
            super.show();
            return;
        }
        Activity activity = (Activity)this.mBaseContext;
        this.showWithImmersiveCheck(activity);
    }

    public void show() {
        super.show();
    }

    public static abstract class AutoResizeDialogBuilder
    extends QMUIDialogBuilder {
        private ScrollView mScrollerView;
        private boolean mAnchorHeightFirstSet = false;
        private int mAnchorHeight = 0;
        private int mScrollHeight = 0;
        private Rect mVisibleInsetRect = null;
        private Rect mVisibleDisplayFrame = new Rect();

        public AutoResizeDialogBuilder(Context context) {
            super(context);
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            this.mScrollerView = new ScrollView(context);
            this.mScrollerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.onGetScrollHeight()));
            this.mScrollerView.addView(this.onBuildContent(dialog, this.mScrollerView));
            parent.addView((View)this.mScrollerView);
        }

        @Override
        protected void onAfter(QMUIDialog dialog, LinearLayout parent, Context context) {
            super.onAfter(dialog, parent, context);
            this.bindEvent(context, (View)parent);
        }

        public abstract View onBuildContent(QMUIDialog var1, ScrollView var2);

        public int onGetScrollHeight() {
            return -2;
        }

        private void bindEvent(final Context context, View rootView) {
            if (ViewCompat.isAttachedToWindow((View)rootView)) {
                this.mVisibleInsetRect = QMUIWindowHelper.unSafeGetWindowVisibleInsets(rootView);
            } else {
                rootView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                        AutoResizeDialogBuilder.this.mVisibleInsetRect = QMUIWindowHelper.unSafeGetWindowVisibleInsets(v);
                    }

                    public void onViewDetachedFromWindow(View v) {
                        AutoResizeDialogBuilder.this.mVisibleInsetRect = null;
                    }
                });
            }
            this.mAnchorTopView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AutoResizeDialogBuilder.this.mDialog.dismiss();
                }
            });
            this.mAnchorBottomView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AutoResizeDialogBuilder.this.mDialog.dismiss();
                }
            });
            rootView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    int anchorShouldHeight;
                    int fullHeight;
                    v.getWindowVisibleDisplayFrame(AutoResizeDialogBuilder.this.mVisibleDisplayFrame);
                    if (AutoResizeDialogBuilder.this.mVisibleInsetRect != null) {
                        fullHeight = AutoResizeDialogBuilder.this.mVisibleDisplayFrame.height() + ((AutoResizeDialogBuilder)AutoResizeDialogBuilder.this).mVisibleInsetRect.top + ((AutoResizeDialogBuilder)AutoResizeDialogBuilder.this).mVisibleInsetRect.bottom;
                        anchorShouldHeight = ((AutoResizeDialogBuilder)AutoResizeDialogBuilder.this).mVisibleInsetRect.bottom;
                    } else {
                        fullHeight = QMUIDisplayHelper.getScreenHeight(context);
                        anchorShouldHeight = Math.max(0, fullHeight - ((AutoResizeDialogBuilder)AutoResizeDialogBuilder.this).mVisibleDisplayFrame.bottom);
                    }
                    if (anchorShouldHeight != AutoResizeDialogBuilder.this.mAnchorHeight) {
                        AutoResizeDialogBuilder.this.mAnchorHeightFirstSet = true;
                        AutoResizeDialogBuilder.this.mAnchorHeight = anchorShouldHeight;
                        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)AutoResizeDialogBuilder.this.mAnchorBottomView.getLayoutParams();
                        lp.height = AutoResizeDialogBuilder.this.mAnchorHeight;
                        AutoResizeDialogBuilder.this.mAnchorBottomView.setLayoutParams((ViewGroup.LayoutParams)lp);
                        LinearLayout.LayoutParams slp = (LinearLayout.LayoutParams)AutoResizeDialogBuilder.this.mScrollerView.getLayoutParams();
                        if (AutoResizeDialogBuilder.this.onGetScrollHeight() == -2) {
                            AutoResizeDialogBuilder.this.mScrollHeight = Math.max(AutoResizeDialogBuilder.this.mScrollHeight, AutoResizeDialogBuilder.this.mScrollerView.getMeasuredHeight());
                        } else {
                            AutoResizeDialogBuilder.this.mScrollHeight = AutoResizeDialogBuilder.this.onGetScrollHeight();
                        }
                        if (AutoResizeDialogBuilder.this.mAnchorHeight == 0) {
                            slp.height = AutoResizeDialogBuilder.this.mScrollHeight;
                        } else {
                            AutoResizeDialogBuilder.this.mScrollerView.getChildAt(0).requestFocus();
                            slp.height = AutoResizeDialogBuilder.this.mScrollHeight - AutoResizeDialogBuilder.this.mAnchorHeight;
                        }
                        AutoResizeDialogBuilder.this.mScrollerView.setLayoutParams((ViewGroup.LayoutParams)slp);
                    } else if (!AutoResizeDialogBuilder.this.mAnchorHeightFirstSet) {
                        AutoResizeDialogBuilder.this.mAnchorHeightFirstSet = true;
                        if (AutoResizeDialogBuilder.this.onGetScrollHeight() == -2) {
                            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)AutoResizeDialogBuilder.this.mDialogView.getLayoutParams();
                            int scrollMaxHeight = fullHeight - lp.bottomMargin - lp.topMargin;
                            if (AutoResizeDialogBuilder.this.hasTitle()) {
                                scrollMaxHeight -= AutoResizeDialogBuilder.this.mTitleView.getMeasuredHeight();
                            }
                            if (AutoResizeDialogBuilder.this.mActionContainer != null) {
                                scrollMaxHeight -= QMUIDisplayHelper.dp2px(context, 150);
                            }
                            int scrollContentMeasureHeight = this.getScrollContentMeasureHeight();
                            AutoResizeDialogBuilder.this.mScrollHeight = Math.min(scrollMaxHeight, scrollContentMeasureHeight);
                            LinearLayout.LayoutParams slp = (LinearLayout.LayoutParams)AutoResizeDialogBuilder.this.mScrollerView.getLayoutParams();
                            slp.height = AutoResizeDialogBuilder.this.mScrollHeight;
                            AutoResizeDialogBuilder.this.mScrollerView.setLayoutParams((ViewGroup.LayoutParams)slp);
                        }
                    }
                }

                private int getScrollContentMeasureHeight() {
                    if (AutoResizeDialogBuilder.this.mScrollerView.getChildCount() <= 0) {
                        return 0;
                    }
                    return AutoResizeDialogBuilder.this.mScrollerView.getChildAt(0).getMeasuredHeight();
                }
            });
        }
    }

    public static class CustomDialogBuilder
    extends QMUIDialogBuilder {
        private int mLayoutId;

        public CustomDialogBuilder(Context context) {
            super(context);
        }

        public CustomDialogBuilder setLayout(@LayoutRes int layoutResId) {
            this.mLayoutId = layoutResId;
            return this;
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            parent.addView(LayoutInflater.from((Context)context).inflate(this.mLayoutId, parent, false));
        }
    }

    public static class MultiCheckableDialogBuilder
    extends MenuBaseDialogBuilder<MultiCheckableDialogBuilder> {
        private int mCheckedItems;

        public MultiCheckableDialogBuilder(Context context) {
            super(context);
        }

        public MultiCheckableDialogBuilder setCheckedItems(int checkedItems) {
            this.mCheckedItems = checkedItems;
            return this;
        }

        public MultiCheckableDialogBuilder setCheckedItems(int[] checkedIndexes) {
            int checkedItemRecord = 0;
            if (checkedIndexes != null && checkedIndexes.length > 0) {
                for (int checkedIndexe : checkedIndexes) {
                    checkedItemRecord += 2 << checkedIndexe;
                }
            }
            return this.setCheckedItems(checkedItemRecord);
        }

        public MultiCheckableDialogBuilder addItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            for (final CharSequence item : items) {
                this.addItem(new MenuBaseDialogBuilder.ItemViewFactory(){

                    @Override
                    public QMUIDialogMenuItemView createItemView(Context context) {
                        return new QMUIDialogMenuItemView.CheckItemView(context, true, item);
                    }
                }, listener);
            }
            return this;
        }

        @Override
        public MultiCheckableDialogBuilder addItem(QMUIDialogMenuItemView itemView, DialogInterface.OnClickListener listener) {
            if (this.mMenuItemViewsFactoryList.size() >= 32) {
                throw new RuntimeException("there are more than 32 items, please use LiseView to improve performance!!");
            }
            return (MultiCheckableDialogBuilder)super.addItem(itemView, listener);
        }

        @Override
        public MultiCheckableDialogBuilder addItem(MenuBaseDialogBuilder.ItemViewFactory itemViewFactory, DialogInterface.OnClickListener listener) {
            if (this.mMenuItemViewsFactoryList.size() >= 32) {
                throw new RuntimeException("there are more than 32 items, please use LiseView to improve performance!!");
            }
            return (MultiCheckableDialogBuilder)super.addItem(itemViewFactory, listener);
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            super.onCreateContent(dialog, parent, context);
            for (int i = 0; i < this.mMenuItemViews.size(); ++i) {
                QMUIDialogMenuItemView itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(i);
                int v = 2 << i;
                itemView.setChecked((v & this.mCheckedItems) == v);
            }
        }

        @Override
        protected void onItemClick(int index) {
            QMUIDialogMenuItemView itemView;
            itemView.setChecked(!(itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(index)).isChecked());
        }

        public int getCheckedItemRecord() {
            int output = 0;
            int length = this.mMenuItemViews.size();
            for (int i = 0; i < length; ++i) {
                QMUIDialogMenuItemView itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(i);
                if (!itemView.isChecked()) continue;
                output += 2 << itemView.getMenuIndex();
            }
            this.mCheckedItems = output;
            return output;
        }

        public int[] getCheckedItemIndexes() {
            ArrayList<Integer> array = new ArrayList<Integer>();
            int length = this.mMenuItemViews.size();
            for (int i = 0; i < length; ++i) {
                QMUIDialogMenuItemView itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(i);
                if (!itemView.isChecked()) continue;
                array.add(itemView.getMenuIndex());
            }
            int[] output = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                output[i] = (Integer)array.get(i);
            }
            return output;
        }

        protected boolean existCheckedItem() {
            return this.getCheckedItemRecord() <= 0;
        }
    }

    public static class CheckableDialogBuilder
    extends MenuBaseDialogBuilder<CheckableDialogBuilder> {
        private int mCheckedIndex = -1;

        public CheckableDialogBuilder(Context context) {
            super(context);
        }

        public int getCheckedIndex() {
            return this.mCheckedIndex;
        }

        public CheckableDialogBuilder setCheckedIndex(int checkedIndex) {
            this.mCheckedIndex = checkedIndex;
            return this;
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            super.onCreateContent(dialog, parent, context);
            if (this.mCheckedIndex > -1 && this.mCheckedIndex < this.mMenuItemViews.size()) {
                ((QMUIDialogMenuItemView)this.mMenuItemViews.get(this.mCheckedIndex)).setChecked(true);
            }
        }

        @Override
        protected void onItemClick(int index) {
            for (int i = 0; i < this.mMenuItemViews.size(); ++i) {
                QMUIDialogMenuItemView itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(i);
                if (i == index) {
                    itemView.setChecked(true);
                    this.mCheckedIndex = index;
                    continue;
                }
                itemView.setChecked(false);
            }
        }

        public CheckableDialogBuilder addItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            for (final CharSequence item : items) {
                this.addItem(new MenuBaseDialogBuilder.ItemViewFactory(){

                    @Override
                    public QMUIDialogMenuItemView createItemView(Context context) {
                        return new QMUIDialogMenuItemView.MarkItemView(context, item);
                    }
                }, listener);
            }
            return this;
        }
    }

    public static class MenuDialogBuilder
    extends MenuBaseDialogBuilder<MenuDialogBuilder> {
        public MenuDialogBuilder(Context context) {
            super(context);
        }

        public MenuDialogBuilder addItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            for (CharSequence item : items) {
                this.addItem(item, listener);
            }
            return this;
        }

        public MenuDialogBuilder addItem(final CharSequence item, DialogInterface.OnClickListener listener) {
            this.addItem(new MenuBaseDialogBuilder.ItemViewFactory(){

                @Override
                public QMUIDialogMenuItemView createItemView(Context context) {
                    return new QMUIDialogMenuItemView.TextItemView(context, item);
                }
            }, listener);
            return this;
        }
    }

    public static class MenuBaseDialogBuilder<T extends QMUIDialogBuilder>
    extends QMUIDialogBuilder<T> {
        protected ArrayList<ItemViewFactory> mMenuItemViewsFactoryList;
        protected LinearLayout mMenuItemContainer;
        protected QMUIWrapContentScrollView mContentScrollView;
        protected LinearLayout.LayoutParams mMenuItemLp;
        protected ArrayList<QMUIDialogMenuItemView> mMenuItemViews = new ArrayList();

        public MenuBaseDialogBuilder(Context context) {
            super(context);
            this.mMenuItemViewsFactoryList = new ArrayList();
        }

        public void clear() {
            this.mMenuItemViewsFactoryList.clear();
        }

        @Deprecated
        public T addItem(final QMUIDialogMenuItemView itemView, final DialogInterface.OnClickListener listener) {
            itemView.setMenuIndex(this.mMenuItemViewsFactoryList.size());
            itemView.setListener(new QMUIDialogMenuItemView.MenuItemViewListener(){

                @Override
                public void onClick(int index) {
                    MenuBaseDialogBuilder.this.onItemClick(index);
                    if (listener != null) {
                        listener.onClick((DialogInterface)MenuBaseDialogBuilder.this.mDialog, index);
                    }
                }
            });
            this.mMenuItemViewsFactoryList.add(new ItemViewFactory(){

                @Override
                public QMUIDialogMenuItemView createItemView(Context context) {
                    return itemView;
                }
            });
            return (T)this;
        }

        public T addItem(final ItemViewFactory itemViewFactory, final DialogInterface.OnClickListener listener) {
            this.mMenuItemViewsFactoryList.add(new ItemViewFactory(){

                @Override
                public QMUIDialogMenuItemView createItemView(Context context) {
                    QMUIDialogMenuItemView itemView = itemViewFactory.createItemView(context);
                    itemView.setMenuIndex(MenuBaseDialogBuilder.this.mMenuItemViewsFactoryList.indexOf(this));
                    itemView.setListener(new QMUIDialogMenuItemView.MenuItemViewListener(){

                        @Override
                        public void onClick(int index) {
                            MenuBaseDialogBuilder.this.onItemClick(index);
                            if (listener != null) {
                                listener.onClick((DialogInterface)MenuBaseDialogBuilder.this.mDialog, index);
                            }
                        }
                    });
                    return itemView;
                }
            });
            return (T)this;
        }

        protected void onItemClick(int index) {
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            this.mMenuItemContainer = new LinearLayout(context);
            this.mMenuItemContainer.setOrientation(1);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            this.mMenuItemContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuContainerStyleDef, R.attr.qmui_dialog_menu_container_style, 0);
            int count = a.getIndexCount();
            int paddingTop = 0;
            int paddingBottom = 0;
            int paddingVerWhenSingle = 0;
            int paddingTopWhenTitle = 0;
            int paddingBottomWhenAction = 0;
            int itemHeight = -1;
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_android_paddingTop) {
                    paddingTop = a.getDimensionPixelSize(attr2, paddingTop);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_android_paddingBottom) {
                    paddingBottom = a.getDimensionPixelSize(attr2, paddingBottom);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_container_single_padding_vertical) {
                    paddingVerWhenSingle = a.getDimensionPixelSize(attr2, paddingVerWhenSingle);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_container_padding_top_when_title_exist) {
                    paddingTopWhenTitle = a.getDimensionPixelSize(attr2, paddingTopWhenTitle);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_container_padding_bottom_when_action_exist) {
                    paddingBottomWhenAction = a.getDimensionPixelSize(attr2, paddingBottomWhenAction);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_item_height) continue;
                itemHeight = a.getDimensionPixelSize(attr2, itemHeight);
            }
            a.recycle();
            this.mMenuItemLp = new LinearLayout.LayoutParams(-1, itemHeight);
            this.mMenuItemLp.gravity = 16;
            if (this.mMenuItemViewsFactoryList.size() == 1) {
                paddingBottom = paddingTop = paddingVerWhenSingle;
            }
            if (this.hasTitle()) {
                paddingTop = paddingTopWhenTitle;
            }
            if (this.mActions.size() > 0) {
                paddingBottom = paddingBottomWhenAction;
            }
            this.mMenuItemContainer.setPadding(0, paddingTop, 0, paddingBottom);
            this.mMenuItemViews.clear();
            for (ItemViewFactory factory : this.mMenuItemViewsFactoryList) {
                QMUIDialogMenuItemView itemView = factory.createItemView(context);
                this.mMenuItemContainer.addView((View)itemView, (ViewGroup.LayoutParams)this.mMenuItemLp);
                this.mMenuItemViews.add(itemView);
            }
            this.mContentScrollView = new QMUIWrapContentScrollView(context);
            this.mContentScrollView.setMaxHeight(this.getContentAreaMaxHeight());
            this.mContentScrollView.addView((View)this.mMenuItemContainer);
            this.mContentScrollView.setVerticalScrollBarEnabled(false);
            parent.addView((View)this.mContentScrollView);
        }

        public static interface ItemViewFactory {
            public QMUIDialogMenuItemView createItemView(Context var1);
        }
    }

    public static class EditTextDialogBuilder
    extends QMUIDialogBuilder<EditTextDialogBuilder> {
        protected String mPlaceholder;
        protected TransformationMethod mTransformationMethod;
        protected RelativeLayout mMainLayout;
        protected EditText mEditText;
        protected ImageView mRightImageView;
        private int mInputType = 1;
        private CharSequence mDefaultText = null;

        public EditTextDialogBuilder(Context context) {
            super(context);
        }

        public EditTextDialogBuilder setPlaceholder(String placeholder) {
            this.mPlaceholder = placeholder;
            return this;
        }

        public EditTextDialogBuilder setPlaceholder(int resId) {
            return this.setPlaceholder(this.getBaseContext().getResources().getString(resId));
        }

        public EditTextDialogBuilder setDefaultText(CharSequence defaultText) {
            this.mDefaultText = defaultText;
            return this;
        }

        public EditTextDialogBuilder setTransformationMethod(TransformationMethod transformationMethod) {
            this.mTransformationMethod = transformationMethod;
            return this;
        }

        public EditTextDialogBuilder setInputType(int inputType) {
            this.mInputType = inputType;
            return this;
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            this.mEditText = new AppCompatEditText(context);
            MessageDialogBuilder.assignMessageTvWithAttr((TextView)this.mEditText, this.hasTitle(), R.attr.qmui_dialog_edit_content_style);
            this.mEditText.setFocusable(true);
            this.mEditText.setFocusableInTouchMode(true);
            this.mEditText.setImeOptions(2);
            this.mEditText.setId(R.id.qmui_dialog_edit_input);
            if (!QMUILangHelper.isNullOrEmpty(this.mDefaultText)) {
                this.mEditText.setText(this.mDefaultText);
            }
            this.mRightImageView = new ImageView(context);
            this.mRightImageView.setId(R.id.qmui_dialog_edit_right_icon);
            this.mRightImageView.setVisibility(8);
            this.mMainLayout = new RelativeLayout(context);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
            lp.topMargin = this.mEditText.getPaddingTop();
            lp.leftMargin = this.mEditText.getPaddingLeft();
            lp.rightMargin = this.mEditText.getPaddingRight();
            lp.bottomMargin = this.mEditText.getPaddingBottom();
            this.mMainLayout.setBackgroundResource(R.drawable.qmui_edittext_bg_border_bottom);
            this.mMainLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            if (this.mTransformationMethod != null) {
                this.mEditText.setTransformationMethod(this.mTransformationMethod);
            } else {
                this.mEditText.setInputType(this.mInputType);
            }
            this.mEditText.setBackgroundResource(0);
            this.mEditText.setPadding(0, 0, 0, QMUIDisplayHelper.dpToPx(5));
            RelativeLayout.LayoutParams editLp = new RelativeLayout.LayoutParams(-1, -2);
            editLp.addRule(0, this.mRightImageView.getId());
            editLp.addRule(15, -1);
            if (this.mPlaceholder != null) {
                this.mEditText.setHint((CharSequence)this.mPlaceholder);
            }
            this.mMainLayout.addView((View)this.mEditText, (ViewGroup.LayoutParams)this.createEditTextLayoutParams());
            this.mMainLayout.addView((View)this.mRightImageView, (ViewGroup.LayoutParams)this.createRightIconLayoutParams());
            parent.addView((View)this.mMainLayout);
        }

        protected RelativeLayout.LayoutParams createEditTextLayoutParams() {
            RelativeLayout.LayoutParams editLp = new RelativeLayout.LayoutParams(-1, -2);
            editLp.addRule(0, this.mRightImageView.getId());
            editLp.addRule(15, -1);
            return editLp;
        }

        protected RelativeLayout.LayoutParams createRightIconLayoutParams() {
            RelativeLayout.LayoutParams rightIconLp = new RelativeLayout.LayoutParams(-2, -2);
            rightIconLp.addRule(11, -1);
            rightIconLp.addRule(15, -1);
            rightIconLp.leftMargin = QMUIDisplayHelper.dpToPx(5);
            return rightIconLp;
        }

        @Override
        protected void onAfter(QMUIDialog dialog, LinearLayout parent, Context context) {
            super.onAfter(dialog, parent, context);
            final InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    inputMethodManager.hideSoftInputFromWindow(EditTextDialogBuilder.this.mEditText.getWindowToken(), 0);
                }
            });
            this.mEditText.postDelayed(new Runnable(){

                @Override
                public void run() {
                    EditTextDialogBuilder.this.mEditText.requestFocus();
                    inputMethodManager.showSoftInput((View)EditTextDialogBuilder.this.mEditText, 0);
                }
            }, 300L);
        }

        @Deprecated
        public EditText getEditText() {
            return this.mEditText;
        }

        public ImageView getRightImageView() {
            return this.mRightImageView;
        }
    }

    public static class CheckBoxMessageDialogBuilder
    extends QMUIDialogBuilder<CheckBoxMessageDialogBuilder> {
        private QMUIWrapContentScrollView mScrollContainer;
        protected String mMessage;
        private boolean mIsChecked = false;
        private Drawable mCheckMarkDrawable;
        private QMUISpanTouchFixTextView mTextView;

        public CheckBoxMessageDialogBuilder(Context context) {
            super(context);
            this.mCheckMarkDrawable = QMUIResHelper.getAttrDrawable(context, R.attr.qmui_s_checkbox);
        }

        public CheckBoxMessageDialogBuilder setMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public CheckBoxMessageDialogBuilder setMessage(int resid) {
            return this.setMessage(this.getBaseContext().getResources().getString(resid));
        }

        public boolean isChecked() {
            return this.mIsChecked;
        }

        public CheckBoxMessageDialogBuilder setChecked(boolean checked) {
            if (this.mIsChecked != checked) {
                this.mIsChecked = checked;
                if (this.mTextView != null) {
                    this.mTextView.setSelected(checked);
                }
            }
            return this;
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            if (this.mMessage != null && this.mMessage.length() != 0) {
                this.mScrollContainer = new QMUIWrapContentScrollView(context);
                this.mTextView = new QMUISpanTouchFixTextView(context);
                this.mTextView.setMovementMethodDefault();
                MessageDialogBuilder.assignMessageTvWithAttr((TextView)this.mTextView, this.hasTitle(), R.attr.qmui_dialog_message_content_style);
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                lp.gravity = this.mTextView.getGravity();
                this.mScrollContainer.addView((View)this.mTextView, (ViewGroup.LayoutParams)lp);
                this.mScrollContainer.setVerticalScrollBarEnabled(false);
                this.mScrollContainer.setMaxHeight(this.getContentAreaMaxHeight());
                this.mTextView.setText(this.mMessage);
                this.mCheckMarkDrawable.setBounds(0, 0, this.mCheckMarkDrawable.getIntrinsicWidth(), this.mCheckMarkDrawable.getIntrinsicHeight());
                this.mTextView.setCompoundDrawables(this.mCheckMarkDrawable, null, null, null);
                this.mTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CheckBoxMessageDialogBuilder.this.setChecked(!CheckBoxMessageDialogBuilder.this.mIsChecked);
                    }
                });
                this.mTextView.setSelected(this.mIsChecked);
                parent.addView((View)this.mScrollContainer);
            }
        }

        public QMUISpanTouchFixTextView getTextView() {
            return this.mTextView;
        }
    }

    public static class MessageDialogBuilder
    extends QMUIDialogBuilder<MessageDialogBuilder> {
        protected CharSequence mMessage;
        private QMUIWrapContentScrollView mScrollContainer;
        private QMUISpanTouchFixTextView mTextView;

        public MessageDialogBuilder(Context context) {
            super(context);
        }

        public MessageDialogBuilder setMessage(CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public MessageDialogBuilder setMessage(int resId) {
            return this.setMessage(this.getBaseContext().getResources().getString(resId));
        }

        @Override
        protected void onCreateContent(QMUIDialog dialog, ViewGroup parent, Context context) {
            if (this.mMessage != null && this.mMessage.length() != 0) {
                this.mTextView = new QMUISpanTouchFixTextView(context);
                MessageDialogBuilder.assignMessageTvWithAttr((TextView)this.mTextView, this.hasTitle(), R.attr.qmui_dialog_message_content_style);
                this.mTextView.setText(this.mMessage);
                this.mTextView.setMovementMethodDefault();
                this.mScrollContainer = new QMUIWrapContentScrollView(context);
                this.mScrollContainer.setMaxHeight(this.getContentAreaMaxHeight());
                this.mScrollContainer.setVerticalScrollBarEnabled(false);
                this.mScrollContainer.addView((View)this.mTextView);
                parent.addView((View)this.mScrollContainer);
            }
        }

        @Override
        protected void onConfigTitleView(TextView titleView) {
            super.onConfigTitleView(titleView);
            if (this.mMessage == null || this.mMessage.length() == 0) {
                TypedArray a = titleView.getContext().obtainStyledAttributes(null, R.styleable.QMUIDialogTitleTvCustomDef, R.attr.qmui_dialog_title_style, 0);
                int count = a.getIndexCount();
                for (int i = 0; i < count; ++i) {
                    int attr2 = a.getIndex(i);
                    if (attr2 != R.styleable.QMUIDialogTitleTvCustomDef_qmui_paddingBottomWhenNotContent) continue;
                    titleView.setPadding(titleView.getPaddingLeft(), titleView.getPaddingTop(), titleView.getPaddingRight(), a.getDimensionPixelSize(attr2, titleView.getPaddingBottom()));
                }
                a.recycle();
            }
        }

        public QMUISpanTouchFixTextView getTextView() {
            return this.mTextView;
        }

        public static void assignMessageTvWithAttr(TextView messageTv, boolean hasTitle, int defAttr) {
            QMUIResHelper.assignTextViewWithAttr(messageTv, defAttr);
            if (!hasTitle) {
                TypedArray a = messageTv.getContext().obtainStyledAttributes(null, R.styleable.QMUIDialogMessageTvCustomDef, defAttr, 0);
                int count = a.getIndexCount();
                for (int i = 0; i < count; ++i) {
                    int attr2 = a.getIndex(i);
                    if (attr2 != R.styleable.QMUIDialogMessageTvCustomDef_qmui_paddingTopWhenNotTitle) continue;
                    messageTv.setPadding(messageTv.getPaddingLeft(), a.getDimensionPixelSize(attr2, messageTv.getPaddingTop()), messageTv.getPaddingRight(), messageTv.getPaddingBottom());
                }
                a.recycle();
            }
        }
    }
}

