/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.widget.QMUILoadingView;

public class QMUIEmptyView
extends FrameLayout {
    private QMUILoadingView mLoadingView;
    private TextView mTitleTextView;
    private TextView mDetailTextView;
    protected Button mButton;

    public QMUIEmptyView(Context context) {
        this(context, null);
    }

    public QMUIEmptyView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIEmptyView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.QMUIEmptyView);
        Boolean attrShowLoading = arr.getBoolean(R.styleable.QMUIEmptyView_qmui_show_loading, false);
        String attrTitleText = arr.getString(R.styleable.QMUIEmptyView_qmui_title_text);
        String attrDetailText = arr.getString(R.styleable.QMUIEmptyView_qmui_detail_text);
        String attrBtnText = arr.getString(R.styleable.QMUIEmptyView_qmui_btn_text);
        arr.recycle();
        this.show(attrShowLoading, attrTitleText, attrDetailText, attrBtnText, null);
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.qmui_empty_view, (ViewGroup)this, true);
        this.mLoadingView = (QMUILoadingView)this.findViewById(R.id.empty_view_loading);
        this.mTitleTextView = (TextView)this.findViewById(R.id.empty_view_title);
        this.mDetailTextView = (TextView)this.findViewById(R.id.empty_view_detail);
        this.mButton = (Button)this.findViewById(R.id.empty_view_button);
    }

    public void show(boolean loading, String titleText, String detailText, String buttonText, View.OnClickListener onButtonClickListener) {
        this.setLoadingShowing(loading);
        this.setTitleText(titleText);
        this.setDetailText(detailText);
        this.setButton(buttonText, onButtonClickListener);
        this.show();
    }

    public void show(boolean loading) {
        this.setLoadingShowing(loading);
        this.setTitleText(null);
        this.setDetailText(null);
        this.setButton(null, null);
        this.show();
    }

    public void show(String titleText, String detailText) {
        this.setLoadingShowing(false);
        this.setTitleText(titleText);
        this.setDetailText(detailText);
        this.setButton(null, null);
        this.show();
    }

    public void show() {
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
        this.setLoadingShowing(false);
        this.setTitleText(null);
        this.setDetailText(null);
        this.setButton(null, null);
    }

    public boolean isShowing() {
        return this.getVisibility() == 0;
    }

    public boolean isLoading() {
        return this.mLoadingView.getVisibility() == 0;
    }

    public void setLoadingShowing(boolean show) {
        this.mLoadingView.setVisibility(show ? 0 : 8);
    }

    public void setTitleText(String text) {
        this.mTitleTextView.setText((CharSequence)text);
        this.mTitleTextView.setVisibility(text != null ? 0 : 8);
    }

    public void setDetailText(String text) {
        this.mDetailTextView.setText((CharSequence)text);
        this.mDetailTextView.setVisibility(text != null ? 0 : 8);
    }

    public void setTitleColor(int color2) {
        this.mTitleTextView.setTextColor(color2);
    }

    public void setDetailColor(int color2) {
        this.mDetailTextView.setTextColor(color2);
    }

    public void setButton(String text, View.OnClickListener onClickListener) {
        this.mButton.setText((CharSequence)text);
        this.mButton.setVisibility(text != null ? 0 : 8);
        this.mButton.setOnClickListener(onClickListener);
    }
}

