/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.span;

import android.support.annotation.ColorInt;
import android.support.v4.view.ViewCompat;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;
import com.qmuiteam.qmui.link.ITouchableSpan;

public abstract class QMUITouchableSpan
extends ClickableSpan
implements ITouchableSpan {
    private boolean mIsPressed;
    @ColorInt
    private int mNormalBackgroundColor;
    @ColorInt
    private int mPressedBackgroundColor;
    @ColorInt
    private int mNormalTextColor;
    @ColorInt
    private int mPressedTextColor;
    private boolean mIsNeedUnderline = false;

    public abstract void onSpanClick(View var1);

    @Override
    public final void onClick(View widget) {
        if (ViewCompat.isAttachedToWindow((View)widget)) {
            this.onSpanClick(widget);
        }
    }

    public QMUITouchableSpan(@ColorInt int normalTextColor, @ColorInt int pressedTextColor, @ColorInt int normalBackgroundColor, @ColorInt int pressedBackgroundColor) {
        this.mNormalTextColor = normalTextColor;
        this.mPressedTextColor = pressedTextColor;
        this.mNormalBackgroundColor = normalBackgroundColor;
        this.mPressedBackgroundColor = pressedBackgroundColor;
    }

    public int getNormalBackgroundColor() {
        return this.mNormalBackgroundColor;
    }

    public void setNormalTextColor(int normalTextColor) {
        this.mNormalTextColor = normalTextColor;
    }

    public void setPressedTextColor(int pressedTextColor) {
        this.mPressedTextColor = pressedTextColor;
    }

    public int getNormalTextColor() {
        return this.mNormalTextColor;
    }

    public int getPressedBackgroundColor() {
        return this.mPressedBackgroundColor;
    }

    public int getPressedTextColor() {
        return this.mPressedTextColor;
    }

    @Override
    public void setPressed(boolean isSelected) {
        this.mIsPressed = isSelected;
    }

    public boolean isPressed() {
        return this.mIsPressed;
    }

    public void setIsNeedUnderline(boolean isNeedUnderline) {
        this.mIsNeedUnderline = isNeedUnderline;
    }

    public void updateDrawState(TextPaint ds) {
        ds.setColor(this.mIsPressed ? this.mPressedTextColor : this.mNormalTextColor);
        ds.bgColor = this.mIsPressed ? this.mPressedBackgroundColor : this.mNormalBackgroundColor;
        ds.setUnderlineText(this.mIsNeedUnderline);
    }
}

