/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.qqface;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.link.ITouchableSpan;
import com.qmuiteam.qmui.qqface.QMUIQQFaceCompiler;
import com.qmuiteam.qmui.span.QMUITouchableSpan;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

public class QMUIQQFaceView
extends View {
    private static final String TAG = "QMUIQQFaceView";
    private CharSequence mOriginText;
    private QMUIQQFaceCompiler.ElementList mElementList;
    private QMUIQQFaceCompiler mCompiler;
    private boolean mOpenQQFace = true;
    private TextPaint mPaint;
    private Paint mSpanBgPaint;
    private int mTextSize;
    private int mTextColor;
    private int mLineSpace = -1;
    private int mFontHeight;
    private int mQQFaceSize = 0;
    private int mFirstBaseLine;
    private int mMaxLine = Integer.MAX_VALUE;
    private boolean mIsSingleLine = false;
    private int mLines = 0;
    private HashMap<QMUIQQFaceCompiler.Element, SpanInfo> mSpanInfos = new HashMap();
    private boolean mIsTouchDownInMoreText = false;
    private Rect mMoreHitRect = new Rect();
    private static final String mEllipsizeText = "...";
    private String mMoreActionText;
    private int mMoreActionColor;
    private int mMoreActionTextLength = 0;
    private int mEllipsizeTextLength = 0;
    private TextUtils.TruncateAt mEllipsize = TextUtils.TruncateAt.END;
    private boolean mIsNeedEllipsize = false;
    private int mNeedDrawLine = 0;
    private int mParagraphShowCount = 0;
    private int mQQFaceSizeAddon = 0;
    private QQFaceViewListener mListener;
    private int mMaxWidth = Integer.MAX_VALUE;
    private PressCancelAction mPendingPressCancelAction = null;
    private boolean mJumpHandleMeasureAndDraw = false;
    private Runnable mDelayTextSetter = null;
    private boolean mIncludePad = true;
    private Typeface mTypeface = null;
    private int mParagraphSpace = 0;
    private int mSpecialDrawablePadding = 0;
    private int mGravity = 0;
    SpanInfo mTouchSpanInfo = null;
    private boolean needReCalculateFontHeight = true;
    private int mCurrentCalWidth = 0;
    private int mCurrentCalLine = 0;
    private int mContentCalMaxWidth = 0;
    private boolean mNeedReCalculateLines = false;
    private int mLastCalLimitWidth = 0;
    private int mLastCalContentWidth = 0;
    private int mLastCalLines = 0;
    private int mCurrentDrawBaseLine;
    private int mCurrentDrawLine;
    private int mCurrentDrawUsedWidth;
    private boolean mIsInDrawSpan = false;
    private QMUITouchableSpan mCurrentDrawSpan;
    private int mMiddleEllipsizeWidthRecord = -1;
    private boolean mIsExecutedMiddleEllipsize = false;
    private int mLastNeedStopLineRecord = -1;

    public QMUIQQFaceView(Context context) {
        this(context, null);
    }

    public QMUIQQFaceView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUIQQFaceStyle);
    }

    public QMUIQQFaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.QMUIQQFaceView, defStyleAttr, 0);
        this.mQQFaceSizeAddon = -QMUIDisplayHelper.dp2px(context, 2);
        this.mTextSize = array.getDimensionPixelSize(R.styleable.QMUIQQFaceView_android_textSize, QMUIDisplayHelper.dp2px(context, 14));
        this.mTextColor = array.getColor(R.styleable.QMUIQQFaceView_android_textColor, -16777216);
        this.mIsSingleLine = array.getBoolean(R.styleable.QMUIQQFaceView_android_singleLine, false);
        this.mMaxLine = array.getInt(R.styleable.QMUIQQFaceView_android_maxLines, this.mMaxLine);
        int lineSpace = array.getDimensionPixelOffset(R.styleable.QMUIQQFaceView_android_lineSpacingExtra, 0);
        this.setLineSpace(lineSpace);
        int ellipsize = -1;
        ellipsize = array.getInt(R.styleable.QMUIQQFaceView_android_ellipsize, ellipsize);
        switch (ellipsize) {
            case 1: {
                this.mEllipsize = TextUtils.TruncateAt.START;
                break;
            }
            case 2: {
                this.mEllipsize = TextUtils.TruncateAt.MIDDLE;
                break;
            }
            case 3: {
                this.mEllipsize = TextUtils.TruncateAt.END;
            }
            default: {
                this.mEllipsize = null;
            }
        }
        this.mMaxWidth = array.getDimensionPixelSize(R.styleable.QMUIQQFaceView_android_maxWidth, this.mMaxWidth);
        this.mSpecialDrawablePadding = array.getDimensionPixelSize(R.styleable.QMUIQQFaceView_qmui_special_drawable_padding, 0);
        final String text = array.getString(R.styleable.QMUIQQFaceView_android_text);
        if (!QMUILangHelper.isNullOrEmpty(text)) {
            this.mDelayTextSetter = new Runnable(){

                @Override
                public void run() {
                    QMUIQQFaceView.this.setText(text);
                }
            };
        }
        this.mMoreActionText = array.getString(R.styleable.QMUIQQFaceView_qmui_more_action_text);
        this.mMoreActionColor = array.getColor(R.styleable.QMUIQQFaceView_qmui_more_action_color, this.mTextColor);
        array.recycle();
        this.mPaint = new TextPaint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setColor(this.mTextColor);
        this.mEllipsizeTextLength = (int)Math.ceil(this.mPaint.measureText(mEllipsizeText));
        this.measureMoreActionTextLength();
        this.mSpanBgPaint = new Paint();
        this.mSpanBgPaint.setAntiAlias(true);
        this.mSpanBgPaint.setStyle(Paint.Style.FILL);
    }

    public void setOpenQQFace(boolean openQQFace) {
        this.mOpenQQFace = openQQFace;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setMaxWidth(int maxWidth) {
        if (this.mMaxWidth != maxWidth) {
            this.mMaxWidth = maxWidth;
            this.requestLayout();
        }
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (this.mSpanInfos.isEmpty() && this.mMoreHitRect.isEmpty()) {
            return super.onTouchEvent(event);
        }
        int action = event.getAction();
        if (action != 0 && !this.mIsTouchDownInMoreText && this.mTouchSpanInfo == null) {
            return super.onTouchEvent(event);
        }
        if (this.mPendingPressCancelAction != null) {
            this.mPendingPressCancelAction.run();
            this.mPendingPressCancelAction = null;
        }
        switch (action) {
            case 0: {
                this.mTouchSpanInfo = null;
                this.mIsTouchDownInMoreText = false;
                if (this.mMoreHitRect.contains(x, y)) {
                    this.mIsTouchDownInMoreText = true;
                } else {
                    for (SpanInfo spanInfo : this.mSpanInfos.values()) {
                        if (!spanInfo.onTouch(x, y)) continue;
                        this.mTouchSpanInfo = spanInfo;
                        break;
                    }
                }
                if (this.mTouchSpanInfo != null) {
                    this.mTouchSpanInfo.setPressed(true);
                    this.mTouchSpanInfo.invalidateSpan();
                    break;
                }
                if (this.mIsTouchDownInMoreText) break;
                return super.onTouchEvent(event);
            }
            case 3: {
                this.mPendingPressCancelAction = null;
                if (this.mTouchSpanInfo == null) break;
                this.mTouchSpanInfo.setPressed(false);
                this.mTouchSpanInfo.invalidateSpan();
                break;
            }
            case 2: {
                if (this.mTouchSpanInfo == null || this.mTouchSpanInfo.onTouch(x, y)) break;
                this.mTouchSpanInfo.setPressed(false);
                this.mTouchSpanInfo.invalidateSpan();
                this.mTouchSpanInfo = null;
                break;
            }
            case 1: {
                if (this.mTouchSpanInfo != null) {
                    this.mTouchSpanInfo.onClick();
                    this.mPendingPressCancelAction = new PressCancelAction(this.mTouchSpanInfo);
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (QMUIQQFaceView.this.mPendingPressCancelAction != null) {
                                QMUIQQFaceView.this.mPendingPressCancelAction.run();
                            }
                        }
                    }, 100L);
                    break;
                }
                if (!this.mIsTouchDownInMoreText) break;
                if (this.mListener != null) {
                    this.mListener.onMoreTextClick();
                    break;
                }
                if (!this.isClickable()) break;
                this.performClick();
            }
        }
        return true;
    }

    public void setCompiler(QMUIQQFaceCompiler compiler) {
        this.mCompiler = compiler;
        if (this.mDelayTextSetter != null) {
            this.mDelayTextSetter.run();
        }
    }

    public void setTypeface(Typeface typeface) {
        if (this.mTypeface != typeface) {
            this.mTypeface = typeface;
            this.needReCalculateFontHeight = true;
            this.mPaint.setTypeface(typeface);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTypeface(Typeface tf, int style) {
        if (style > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style) : Typeface.create((Typeface)tf, (int)style);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style & ~typefaceStyle;
            this.mPaint.setFakeBoldText((need & 1) != 0);
            this.mPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mPaint.setFakeBoldText(false);
            this.mPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    public void setParagraphSpace(int paragraphSpace) {
        if (this.mParagraphSpace != paragraphSpace) {
            this.mParagraphSpace = paragraphSpace;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMoreActionText(String moreActionText) {
        if (this.mMoreActionText == null || !this.mMoreActionText.equals(moreActionText)) {
            this.mMoreActionText = moreActionText;
            this.measureMoreActionTextLength();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMoreActionColor(int color2) {
        if (color2 != this.mMoreActionColor) {
            this.mMoreActionColor = color2;
            this.invalidate();
        }
    }

    private void measureMoreActionTextLength() {
        this.mMoreActionTextLength = QMUILangHelper.isNullOrEmpty(this.mMoreActionText) ? 0 : (int)Math.ceil(this.mPaint.measureText(this.mMoreActionText));
    }

    public void setSpecialDrawablePadding(int specialDrawablePadding) {
        if (this.mSpecialDrawablePadding != specialDrawablePadding) {
            this.mSpecialDrawablePadding = specialDrawablePadding;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setIncludeFontPadding(boolean includepad) {
        if (this.mIncludePad != includepad) {
            this.needReCalculateFontHeight = true;
            this.mIncludePad = includepad;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setQQFaceSizeAddon(int QQFaceSizeAddon) {
        if (this.mQQFaceSizeAddon != QQFaceSizeAddon) {
            this.mQQFaceSizeAddon = QQFaceSizeAddon;
            this.mNeedReCalculateLines = true;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setLineSpace(int lineSpace) {
        if (this.mLineSpace != lineSpace) {
            this.mLineSpace = lineSpace;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        if (this.mEllipsize != where) {
            this.mEllipsize = where;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMaxLine(int maxLine) {
        if (this.mMaxLine != maxLine) {
            this.mMaxLine = maxLine;
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getMaxLine() {
        return this.mMaxLine;
    }

    public int getLineCount() {
        return this.mLines;
    }

    public boolean isNeedEllipsize() {
        return this.mIsNeedEllipsize;
    }

    public void setSingleLine(boolean singleLine) {
        if (this.mIsSingleLine != singleLine) {
            this.mIsSingleLine = singleLine;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTextColor(@ColorInt int textColor) {
        if (this.mTextColor != textColor) {
            this.mTextColor = textColor;
            this.mPaint.setColor(textColor);
            this.invalidate();
        }
    }

    public TextPaint getPaint() {
        return this.mPaint;
    }

    public void setTextSize(int textSize) {
        if (this.mTextSize != textSize) {
            this.mTextSize = textSize;
            this.mPaint.setTextSize((float)this.mTextSize);
            this.needReCalculateFontHeight = true;
            this.mNeedReCalculateLines = true;
            this.mEllipsizeTextLength = (int)Math.ceil(this.mPaint.measureText(mEllipsizeText));
            this.measureMoreActionTextLength();
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public CharSequence getText() {
        return this.mOriginText;
    }

    public Rect getMoreHitRect() {
        return this.mMoreHitRect;
    }

    public void setText(CharSequence charSequence) {
        int i;
        this.mDelayTextSetter = null;
        CharSequence oldText = this.mOriginText;
        if (this.mOriginText != null && this.mOriginText.equals(charSequence)) {
            return;
        }
        this.mOriginText = charSequence;
        this.setContentDescription(charSequence);
        if (this.mOpenQQFace && this.mCompiler == null) {
            throw new RuntimeException("mCompiler == null");
        }
        this.mSpanInfos.clear();
        if (QMUILangHelper.isNullOrEmpty(this.mOriginText)) {
            if (!QMUILangHelper.isNullOrEmpty(oldText)) {
                this.mElementList = null;
                this.requestLayout();
                this.invalidate();
            }
            return;
        }
        if (this.mOpenQQFace && this.mCompiler != null) {
            this.mElementList = this.mCompiler.compile(this.mOriginText);
            List<QMUIQQFaceCompiler.Element> elements = this.mElementList.getElements();
            if (elements != null) {
                for (i = 0; i < elements.size(); ++i) {
                    QMUIQQFaceCompiler.Element element = elements.get(i);
                    if (element.getType() != QMUIQQFaceCompiler.ElementType.SPAN) continue;
                    this.mSpanInfos.put(element, new SpanInfo(element.getTouchableSpan()));
                }
            }
        } else {
            this.mElementList = new QMUIQQFaceCompiler.ElementList(0, this.mOriginText.length());
            String[] strings = this.mOriginText.toString().split("\\n");
            for (i = 0; i < strings.length; ++i) {
                this.mElementList.add(QMUIQQFaceCompiler.Element.createTextElement(strings[i]));
                if (i == strings.length - 1) continue;
                this.mElementList.add(QMUIQQFaceCompiler.Element.createNextLineElement());
            }
        }
        this.mNeedReCalculateLines = true;
        if (this.getLayoutParams() == null) {
            return;
        }
        if (this.getLayoutParams().width == -2 || this.getLayoutParams().height == -2) {
            this.requestLayout();
            this.invalidate();
            return;
        }
        int paddingHor = this.getPaddingLeft() + this.getPaddingRight();
        int paddingVer = this.getPaddingBottom() + this.getPaddingTop();
        if (this.getWidth() > paddingHor && this.getHeight() > paddingVer) {
            this.mLines = 0;
            this.calculateLinesAndContentWidth(this.getWidth());
            int oldDrawLine = this.mNeedDrawLine;
            int maxLine = Math.min((this.getHeight() - paddingVer + this.mLineSpace) / (this.mFontHeight + this.mLineSpace), this.mMaxLine);
            this.calculateNeedDrawLine(maxLine);
            if (oldDrawLine == this.mNeedDrawLine) {
                this.invalidate();
            } else {
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    protected int calculateFontHeight() {
        if (this.needReCalculateFontHeight) {
            Paint.FontMetricsInt fontMetricsInt = this.mPaint.getFontMetricsInt();
            if (fontMetricsInt == null) {
                this.mQQFaceSize = 0;
                this.mFontHeight = 0;
            } else {
                this.needReCalculateFontHeight = false;
                int top = this.getFontHeightCalTop(fontMetricsInt, this.mIncludePad);
                int bottom = this.getFontHeightCalBottom(fontMetricsInt, this.mIncludePad);
                int fontHeight = bottom - top;
                this.mQQFaceSize = fontHeight + this.mQQFaceSizeAddon;
                int specialMaxDrawableHeight = this.mCompiler.getSpecialBoundsMaxHeight();
                int drawableSize = Math.max(this.mQQFaceSize, specialMaxDrawableHeight);
                if (fontHeight >= drawableSize) {
                    this.mFontHeight = fontHeight;
                    this.mFirstBaseLine = -top;
                } else {
                    this.mFontHeight = drawableSize;
                    this.mFirstBaseLine = -top + (drawableSize - fontHeight) / 2;
                }
            }
        }
        return this.mFontHeight;
    }

    public int getFontHeight() {
        return this.mFontHeight;
    }

    public int getLineSpace() {
        return this.mLineSpace;
    }

    protected int getFontHeightCalTop(Paint.FontMetricsInt fontMetricsInt, boolean includePad) {
        return includePad ? fontMetricsInt.top : fontMetricsInt.ascent;
    }

    protected int getFontHeightCalBottom(Paint.FontMetricsInt fontMetricsInt, boolean includePad) {
        return includePad ? fontMetricsInt.bottom : fontMetricsInt.descent;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.getPaddingLeft() != left || this.getPaddingRight() != right) {
            this.mNeedReCalculateLines = true;
        }
        super.setPadding(left, top, right, bottom);
    }

    protected int calculateLinesAndContentWidth(int limitWidth) {
        if (limitWidth <= this.getPaddingRight() + this.getPaddingLeft() || this.isElementEmpty()) {
            this.mLines = 0;
            this.mParagraphShowCount = 0;
            this.mLastCalLines = 0;
            this.mLastCalContentWidth = 0;
            return this.mLastCalContentWidth;
        }
        if (!this.mNeedReCalculateLines && this.mLastCalLimitWidth == limitWidth) {
            this.mLines = this.mLastCalLines;
            return this.mLastCalContentWidth;
        }
        this.mLastCalLimitWidth = limitWidth;
        List<QMUIQQFaceCompiler.Element> elements = this.mElementList.getElements();
        this.mCurrentCalLine = 1;
        this.mCurrentCalWidth = this.getPaddingLeft();
        this.calculateLinesInner(elements, limitWidth);
        if (this.mCurrentCalLine != this.mLines) {
            if (this.mListener != null) {
                this.mListener.onCalculateLinesChange(this.mCurrentCalLine);
            }
            this.mLines = this.mCurrentCalLine;
        }
        this.mLastCalContentWidth = this.mLines == 1 ? this.mCurrentCalWidth + this.getPaddingRight() : limitWidth;
        this.mLastCalLines = this.mLines;
        return this.mLastCalContentWidth;
    }

    private void calculateNeedDrawLine(int maxline) {
        this.mNeedDrawLine = this.mLines;
        if (this.mIsSingleLine) {
            this.mNeedDrawLine = Math.min(1, this.mLines);
        } else if (maxline < this.mLines) {
            this.mNeedDrawLine = maxline;
        }
        this.mIsNeedEllipsize = this.mLines > this.mNeedDrawLine;
    }

    private void calculateLinesInner(List<QMUIQQFaceCompiler.Element> elements, int limitWidth) {
        int widthStart = this.getPaddingLeft();
        int widthEnd = limitWidth - this.getPaddingRight();
        for (int i = 0; !(i >= elements.size() || this.mJumpHandleMeasureAndDraw || this.mCurrentCalLine > this.mMaxLine && this.mEllipsize == TextUtils.TruncateAt.END && Build.VERSION.SDK_INT < 21); ++i) {
            QMUIQQFaceCompiler.Element element = elements.get(i);
            if (element.getType() == QMUIQQFaceCompiler.ElementType.DRAWABLE) {
                if (this.mCurrentCalWidth + this.mQQFaceSize > widthEnd) {
                    this.gotoCalNextLine(widthStart);
                    this.mCurrentCalWidth += this.mQQFaceSize;
                } else if (this.mCurrentCalWidth + this.mQQFaceSize == widthEnd) {
                    this.gotoCalNextLine(widthStart);
                } else {
                    this.mCurrentCalWidth += this.mQQFaceSize;
                }
                if (widthEnd - widthStart >= this.mQQFaceSize) continue;
                this.mJumpHandleMeasureAndDraw = true;
                continue;
            }
            if (element.getType() == QMUIQQFaceCompiler.ElementType.TEXT) {
                CharSequence text = element.getText();
                this.measureText(text, widthStart, widthEnd);
                continue;
            }
            if (element.getType() == QMUIQQFaceCompiler.ElementType.SPAN) {
                QMUIQQFaceCompiler.ElementList spanElementList = element.getChildList();
                QMUITouchableSpan span = element.getTouchableSpan();
                if (spanElementList == null || spanElementList.getElements().size() <= 0) continue;
                if (span == null) {
                    this.calculateLinesInner(spanElementList.getElements(), limitWidth);
                    continue;
                }
                this.calculateLinesInner(spanElementList.getElements(), limitWidth);
                continue;
            }
            if (element.getType() == QMUIQQFaceCompiler.ElementType.NEXTLINE) {
                this.gotoCalNextLine(widthStart, true);
                continue;
            }
            if (element.getType() != QMUIQQFaceCompiler.ElementType.SPECIAL_BOUNDS_DRAWABLE) continue;
            Drawable drawable2 = element.getSpecialBoundsDrawable();
            int width = drawable2.getIntrinsicWidth();
            width = i == 0 || i == elements.size() - 1 ? (width += this.mSpecialDrawablePadding) : (width += this.mSpecialDrawablePadding * 2);
            if (this.mCurrentCalWidth + width > widthEnd) {
                this.gotoCalNextLine(widthStart);
                this.mCurrentCalWidth += width;
            } else if (this.mCurrentCalWidth + width == widthEnd) {
                this.gotoCalNextLine(widthStart);
            } else {
                this.mCurrentCalWidth += width;
            }
            if (widthEnd - widthStart >= width) continue;
            this.mJumpHandleMeasureAndDraw = true;
        }
    }

    private boolean isElementEmpty() {
        return this.mElementList == null || this.mElementList.getElements() == null || this.mElementList.getElements().isEmpty();
    }

    private void setContentCalMaxWidth(int width) {
        this.mContentCalMaxWidth = Math.max(width, this.mContentCalMaxWidth);
    }

    private void gotoCalNextLine(int widthStart) {
        this.gotoCalNextLine(widthStart, false);
    }

    private void gotoCalNextLine(int widthStart, boolean nextParagraph) {
        ++this.mCurrentCalLine;
        this.setContentCalMaxWidth(this.mCurrentCalWidth);
        this.mCurrentCalWidth = widthStart;
        if (nextParagraph) {
            if (this.mEllipsize == null) {
                ++this.mParagraphShowCount;
            } else if (this.mEllipsize == TextUtils.TruncateAt.END && this.mCurrentCalLine <= this.mMaxLine) {
                ++this.mParagraphShowCount;
            }
        }
    }

    private void measureText(CharSequence text, int widthStart, int widthEnd) {
        float[] widths = new float[text.length()];
        this.mPaint.getTextWidths(text.toString(), widths);
        int contentWidth = widthEnd - widthStart;
        long loop_start = System.currentTimeMillis();
        for (int i = 0; i < widths.length; ++i) {
            if ((float)contentWidth < widths[i]) {
                this.mJumpHandleMeasureAndDraw = true;
                return;
            }
            if (System.currentTimeMillis() - loop_start > 2000L) {
                QMUILog.d(TAG, "measureText: text = %s, mCurrentCalWidth = %d, widthStart = %d, widthEnd = %d", text, this.mCurrentCalWidth, widthStart, widthEnd);
                this.mJumpHandleMeasureAndDraw = true;
                break;
            }
            if ((float)this.mCurrentCalWidth + widths[i] > (float)widthEnd) {
                this.gotoCalNextLine(widthStart);
            }
            this.mCurrentCalWidth = (int)((double)this.mCurrentCalWidth + Math.ceil(widths[i]));
        }
    }

    public void setListener(QQFaceViewListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        long start = System.currentTimeMillis();
        this.mJumpHandleMeasureAndDraw = false;
        this.calculateFontHeight();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Log.i((String)TAG, (String)("widthSize = " + widthSize + "; heightSize = " + heightSize));
        this.mLines = 0;
        this.mParagraphShowCount = 0;
        switch (widthMode) {
            default: {
                if (this.mOriginText == null || this.mOriginText.length() == 0) {
                    width = 0;
                    break;
                }
                width = this.calculateLinesAndContentWidth(Math.min(widthSize, this.mMaxWidth));
                break;
            }
            case 0: 
            case 0x40000000: {
                width = widthSize;
                this.calculateLinesAndContentWidth(width);
            }
        }
        if (this.mJumpHandleMeasureAndDraw) {
            this.setMeasuredDimension(width, heightMode == Integer.MIN_VALUE ? 0 : heightSize);
            return;
        }
        int maxLine = this.mMaxLine;
        switch (heightMode) {
            case -2147483648: {
                maxLine = (heightSize - this.getPaddingTop() - this.getPaddingBottom() + this.mLineSpace) / (this.mFontHeight + this.mLineSpace);
                maxLine = Math.min(maxLine, this.mMaxLine);
                this.calculateNeedDrawLine(maxLine);
                height = this.getPaddingTop() + this.getPaddingBottom();
                if (this.mNeedDrawLine < 2) {
                    height += this.mNeedDrawLine * this.mFontHeight;
                    break;
                }
                height += (this.mNeedDrawLine - 1) * (this.mFontHeight + this.mLineSpace) + this.mFontHeight + this.mParagraphShowCount * this.mParagraphSpace;
                break;
            }
            default: {
                this.calculateNeedDrawLine(this.mMaxLine);
                height = this.getPaddingTop() + this.getPaddingBottom();
                if (this.mNeedDrawLine < 2) {
                    height += this.mNeedDrawLine * this.mFontHeight;
                    break;
                }
                height += (this.mNeedDrawLine - 1) * (this.mFontHeight + this.mLineSpace) + this.mFontHeight + this.mParagraphShowCount * this.mParagraphSpace;
                break;
            }
            case 0x40000000: {
                height = heightSize;
                maxLine = (height - this.getPaddingTop() - this.getPaddingBottom() + this.mLineSpace) / (this.mFontHeight + this.mLineSpace);
                maxLine = Math.min(maxLine, this.mMaxLine);
                this.calculateNeedDrawLine(maxLine);
            }
        }
        this.setMeasuredDimension(width, height);
        Log.i((String)TAG, (String)("mLines = " + this.mLines + " ; width = " + width + " ; height = " + height + " ; maxLine = " + maxLine + "; measure time = " + (System.currentTimeMillis() - start)));
    }

    protected void onDraw(Canvas canvas) {
        if (this.mJumpHandleMeasureAndDraw || this.mOriginText == null || this.mLines == 0 || this.isElementEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        List<QMUIQQFaceCompiler.Element> elements = this.mElementList.getElements();
        this.mCurrentDrawBaseLine = this.getPaddingTop() + this.mFirstBaseLine;
        this.mCurrentDrawLine = 1;
        this.setStartDrawUsedWidth(this.getPaddingLeft(), this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
        this.mIsExecutedMiddleEllipsize = false;
        this.drawElements(canvas, elements, this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
        Log.i((String)TAG, (String)("onDraw spend time = " + (System.currentTimeMillis() - start)));
    }

    private void drawElements(Canvas canvas, List<QMUIQQFaceCompiler.Element> elements, int usefulWidth) {
        int startLeft = this.getPaddingLeft();
        int endWidth = usefulWidth + startLeft;
        if (this.mIsNeedEllipsize && this.mEllipsize == TextUtils.TruncateAt.START) {
            canvas.drawText(mEllipsizeText, 0, mEllipsizeText.length(), (float)startLeft, (float)this.mFirstBaseLine, (Paint)this.mPaint);
        }
        for (int i = 0; i < elements.size(); ++i) {
            QMUIQQFaceCompiler.Element element = elements.get(i);
            QMUIQQFaceCompiler.ElementType type = element.getType();
            if (type == QMUIQQFaceCompiler.ElementType.DRAWABLE) {
                this.onDrawQQFace(canvas, element.getDrawableRes(), null, startLeft, endWidth, i == 0, i == elements.size() - 1);
                continue;
            }
            if (type == QMUIQQFaceCompiler.ElementType.SPECIAL_BOUNDS_DRAWABLE) {
                this.onDrawQQFace(canvas, 0, element.getSpecialBoundsDrawable(), startLeft, endWidth, i == 0, i == elements.size() - 1);
                continue;
            }
            if (type == QMUIQQFaceCompiler.ElementType.TEXT) {
                CharSequence text = element.getText();
                float[] fontWidths = new float[text.length()];
                this.mPaint.getTextWidths(text.toString(), fontWidths);
                this.onDrawText(canvas, text, fontWidths, 0, startLeft, endWidth);
                continue;
            }
            if (type == QMUIQQFaceCompiler.ElementType.SPAN) {
                QMUIQQFaceCompiler.ElementList spanElementList = element.getChildList();
                this.mCurrentDrawSpan = element.getTouchableSpan();
                SpanInfo spanInfo = this.mSpanInfos.get(element);
                if (spanElementList == null || spanElementList.getElements().isEmpty()) continue;
                if (this.mCurrentDrawSpan == null) {
                    this.drawElements(canvas, spanElementList.getElements(), usefulWidth);
                    continue;
                }
                this.mIsInDrawSpan = true;
                if (spanInfo != null) {
                    spanInfo.setStart(this.mCurrentDrawLine, this.mCurrentDrawUsedWidth);
                }
                int spanColor = this.mCurrentDrawSpan.isPressed() ? this.mCurrentDrawSpan.getPressedTextColor() : this.mCurrentDrawSpan.getNormalTextColor();
                this.mPaint.setColor(spanColor == 0 ? this.mTextColor : spanColor);
                this.drawElements(canvas, spanElementList.getElements(), usefulWidth);
                this.mPaint.setColor(this.mTextColor);
                if (spanInfo != null) {
                    spanInfo.setEnd(this.mCurrentDrawLine, this.mCurrentDrawUsedWidth);
                }
                this.mIsInDrawSpan = false;
                continue;
            }
            if (type != QMUIQQFaceCompiler.ElementType.NEXTLINE) continue;
            int ellipsizeLength = this.mEllipsizeTextLength + this.mMoreActionTextLength;
            if (this.mIsNeedEllipsize && this.mEllipsize == TextUtils.TruncateAt.END && this.mCurrentDrawUsedWidth <= endWidth - ellipsizeLength && this.mCurrentDrawLine == this.mNeedDrawLine) {
                this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                this.drawMoreActionText(canvas, endWidth);
                return;
            }
            this.toNewDrawLine(startLeft, true, usefulWidth);
        }
    }

    private void drawMoreActionText(Canvas canvas, int widthEnd) {
        if (!QMUILangHelper.isNullOrEmpty(this.mMoreActionText)) {
            this.mPaint.setColor(this.mMoreActionColor);
            int top = this.getPaddingTop();
            if (this.mCurrentDrawLine > 1) {
                top = (this.mCurrentDrawLine - 1) * (this.mFontHeight + this.mLineSpace) + top;
            }
            this.mMoreHitRect.set(this.mCurrentDrawUsedWidth, top, widthEnd, top + this.mFontHeight);
            canvas.drawText(this.mMoreActionText, 0, this.mMoreActionText.length(), (float)this.mCurrentDrawUsedWidth, (float)this.mCurrentDrawBaseLine, (Paint)this.mPaint);
            this.mPaint.setColor(this.mTextColor);
        }
    }

    private void toNewDrawLine(int startLeft, int usefulWidth) {
        this.toNewDrawLine(startLeft, false, usefulWidth);
    }

    private void toNewDrawLine(int startLeft, boolean paragraph, int usefulWidth) {
        int addOn = (paragraph && (this.mEllipsize == null || this.mEllipsize == TextUtils.TruncateAt.END) ? this.mParagraphSpace : 0) + this.mLineSpace;
        ++this.mCurrentDrawLine;
        if (this.mIsNeedEllipsize) {
            if (this.mEllipsize == TextUtils.TruncateAt.START) {
                if (this.mCurrentDrawLine > this.mLines - this.mNeedDrawLine + 1) {
                    this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
                }
            } else if (this.mEllipsize == TextUtils.TruncateAt.MIDDLE) {
                if (!this.mIsExecutedMiddleEllipsize || this.mMiddleEllipsizeWidthRecord == -1) {
                    this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
                }
            } else {
                this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
            }
            if (this.mEllipsize != null && this.mEllipsize != TextUtils.TruncateAt.END && this.mCurrentDrawBaseLine > this.getHeight() - this.getPaddingBottom()) {
                QMUILog.d(TAG, "draw outside the visible height, the ellipsize is inaccurate: mEllipsize = %s; mCurrentDrawLine = %d; mNeedDrawLine = %d;viewWidth = %d; viewHeight = %d; paddingLeft = %d; paddingRight = %d; paddingTop = %d; paddingBottom = %d; text = %s", this.mEllipsize.name(), this.mCurrentDrawLine, this.mNeedDrawLine, this.getWidth(), this.getHeight(), this.getPaddingLeft(), this.getPaddingRight(), this.getPaddingTop(), this.getPaddingBottom(), this.mOriginText);
            }
        } else {
            this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
        }
        this.setStartDrawUsedWidth(startLeft, usefulWidth);
    }

    private void setStartDrawUsedWidth(int startLeft, int usefulWidth) {
        if (this.mIsNeedEllipsize) {
            this.mCurrentDrawUsedWidth = startLeft;
            return;
        }
        this.mCurrentDrawUsedWidth = this.mCurrentDrawLine == this.mNeedDrawLine ? (this.mGravity == 17 ? (usefulWidth - (this.mCurrentCalWidth - startLeft)) / 2 + startLeft : (this.mGravity == 5 ? usefulWidth - (this.mCurrentCalWidth - startLeft) + startLeft : startLeft)) : startLeft;
    }

    private void onRealDrawText(Canvas canvas, CharSequence text, float[] fontWidths, int offset, int widthStart, int widthEnd) {
        int startPos = offset;
        int targetUsedWidth = this.mCurrentDrawUsedWidth;
        for (int i = offset; i < fontWidths.length; ++i) {
            if ((float)targetUsedWidth + fontWidths[i] > (float)widthEnd) {
                this.drawText(canvas, text, startPos, i, widthEnd - this.mCurrentDrawUsedWidth);
                this.toNewDrawLine(widthStart, widthEnd - widthStart);
                targetUsedWidth = this.mCurrentDrawUsedWidth;
                startPos = i;
            }
            targetUsedWidth = (int)((float)targetUsedWidth + fontWidths[i]);
        }
        if (startPos < fontWidths.length) {
            this.drawText(canvas, text, startPos, fontWidths.length, targetUsedWidth - this.mCurrentDrawUsedWidth);
            this.mCurrentDrawUsedWidth = targetUsedWidth;
        }
    }

    private int getMiddleEllipsizeLine() {
        int ellipsizeLine = this.mNeedDrawLine % 2 == 0 ? this.mNeedDrawLine / 2 : (this.mNeedDrawLine + 1) / 2;
        return ellipsizeLine;
    }

    private void onDrawText(Canvas canvas, CharSequence text, float[] fontWidths, int offset, int widthStart, int widthEnd) {
        if (offset >= text.length()) {
            return;
        }
        if (this.mIsNeedEllipsize) {
            if (this.mEllipsize == TextUtils.TruncateAt.START) {
                if (this.mCurrentDrawLine > this.mLines - this.mNeedDrawLine) {
                    this.onRealDrawText(canvas, text, fontWidths, offset, widthStart, widthEnd);
                } else if (this.mCurrentDrawLine < this.mLines - this.mNeedDrawLine) {
                    for (int i = offset; i < text.length(); ++i) {
                        if (!((float)this.mCurrentDrawUsedWidth + fontWidths[i] <= (float)widthEnd)) {
                            this.toNewDrawLine(widthStart, widthEnd - widthStart);
                            this.onDrawText(canvas, text, fontWidths, i, widthStart, widthEnd);
                            return;
                        }
                        this.mCurrentDrawUsedWidth = (int)((float)this.mCurrentDrawUsedWidth + fontWidths[i]);
                    }
                } else {
                    int needStopWidth = this.mCurrentCalWidth + this.mEllipsizeTextLength;
                    for (int i = offset; i < text.length(); ++i) {
                        if (!((float)this.mCurrentDrawUsedWidth + fontWidths[i] <= (float)needStopWidth)) {
                            int newStart = i + 1;
                            if (this.mCurrentDrawUsedWidth > needStopWidth) {
                                newStart = i;
                            }
                            this.toNewDrawLine(widthStart + this.mEllipsizeTextLength, widthEnd - widthStart);
                            this.onDrawText(canvas, text, fontWidths, newStart, widthStart, widthEnd);
                            return;
                        }
                        this.mCurrentDrawUsedWidth = (int)((float)this.mCurrentDrawUsedWidth + fontWidths[i]);
                    }
                }
            } else if (this.mEllipsize == TextUtils.TruncateAt.MIDDLE) {
                int ellipsizeLine = this.getMiddleEllipsizeLine();
                if (this.mCurrentDrawLine < ellipsizeLine) {
                    int targetDrawWidth = this.mCurrentDrawUsedWidth;
                    for (int i = offset; i < fontWidths.length; ++i) {
                        if (!((float)targetDrawWidth + fontWidths[i] <= (float)widthEnd)) {
                            this.drawText(canvas, text, offset, i, widthEnd - this.mCurrentDrawUsedWidth);
                            this.toNewDrawLine(widthStart, widthEnd - widthStart);
                            this.onDrawText(canvas, text, fontWidths, i, widthStart, widthEnd);
                            return;
                        }
                        targetDrawWidth = (int)((float)targetDrawWidth + fontWidths[i]);
                    }
                    this.drawText(canvas, text, offset, text.length(), targetDrawWidth - this.mCurrentDrawUsedWidth);
                    this.mCurrentDrawUsedWidth = targetDrawWidth;
                } else if (this.mCurrentDrawLine == ellipsizeLine) {
                    if (this.mIsExecutedMiddleEllipsize) {
                        this.handleTextAfterMiddleEllipsize(canvas, text, fontWidths, offset, ellipsizeLine, widthStart, widthEnd);
                    } else {
                        int needStop = (widthEnd + widthStart) / 2 - this.mEllipsizeTextLength / 2;
                        int targetDrawWidth = this.mCurrentDrawUsedWidth;
                        for (int i = offset; i < fontWidths.length; ++i) {
                            if (!((float)targetDrawWidth + fontWidths[i] <= (float)needStop)) {
                                this.drawText(canvas, text, offset, i, targetDrawWidth - this.mCurrentDrawUsedWidth);
                                this.mCurrentDrawUsedWidth = targetDrawWidth;
                                this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                                this.mMiddleEllipsizeWidthRecord = this.mCurrentDrawUsedWidth + this.mEllipsizeTextLength;
                                this.mIsExecutedMiddleEllipsize = true;
                                this.handleTextAfterMiddleEllipsize(canvas, text, fontWidths, i, ellipsizeLine, widthStart, widthEnd);
                                return;
                            }
                            targetDrawWidth = (int)((float)targetDrawWidth + fontWidths[i]);
                        }
                        this.drawText(canvas, text, offset, text.length(), targetDrawWidth - this.mCurrentDrawUsedWidth);
                        this.mCurrentDrawUsedWidth = targetDrawWidth;
                    }
                } else {
                    this.handleTextAfterMiddleEllipsize(canvas, text, fontWidths, offset, ellipsizeLine, widthStart, widthEnd);
                }
            } else if (this.mCurrentDrawLine < this.mNeedDrawLine) {
                int targetUsedWidth = this.mCurrentDrawUsedWidth;
                for (int i = offset; i < fontWidths.length; ++i) {
                    if (!((float)targetUsedWidth + fontWidths[i] <= (float)widthEnd)) {
                        this.drawText(canvas, text, offset, i, widthEnd - this.mCurrentDrawUsedWidth);
                        this.toNewDrawLine(widthStart, widthEnd - widthStart);
                        this.onDrawText(canvas, text, fontWidths, i, widthStart, widthEnd);
                        return;
                    }
                    targetUsedWidth = (int)((float)targetUsedWidth + fontWidths[i]);
                }
                this.drawText(canvas, text, offset, fontWidths.length, targetUsedWidth - this.mCurrentDrawUsedWidth);
                this.mCurrentDrawUsedWidth = targetUsedWidth;
            } else if (this.mCurrentDrawLine == this.mNeedDrawLine) {
                int ellipsizeLength = this.mMoreActionTextLength;
                if (this.mEllipsize == TextUtils.TruncateAt.END) {
                    ellipsizeLength += this.mEllipsizeTextLength;
                }
                int targetUsedWidth = this.mCurrentDrawUsedWidth;
                for (int i = offset; i < fontWidths.length; ++i) {
                    if (!((float)targetUsedWidth + fontWidths[i] <= (float)(widthEnd - ellipsizeLength))) {
                        this.drawText(canvas, text, offset, i, targetUsedWidth - this.mCurrentDrawUsedWidth);
                        this.mCurrentDrawUsedWidth = targetUsedWidth;
                        if (this.mEllipsize == TextUtils.TruncateAt.END) {
                            this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                            this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                        }
                        this.drawMoreActionText(canvas, widthEnd);
                        this.toNewDrawLine(widthStart, widthEnd - widthStart);
                        return;
                    }
                    targetUsedWidth = (int)((float)targetUsedWidth + fontWidths[i]);
                }
                this.drawText(canvas, text, offset, fontWidths.length, targetUsedWidth - this.mCurrentDrawUsedWidth);
                this.mCurrentDrawUsedWidth = targetUsedWidth;
            }
        } else {
            this.onRealDrawText(canvas, text, fontWidths, 0, widthStart, widthEnd);
        }
    }

    private void handleTextAfterMiddleEllipsize(Canvas canvas, CharSequence text, float[] fontWidths, int offset, int ellipsizeLine, int widthStart, int widthEnd) {
        int needStopWidth;
        if (offset >= text.length()) {
            return;
        }
        if (this.mMiddleEllipsizeWidthRecord == -1) {
            this.onRealDrawText(canvas, text, fontWidths, offset, widthStart, widthEnd);
            return;
        }
        int endLines = this.mNeedDrawLine - ellipsizeLine;
        int borrowWidth = widthEnd - this.mCurrentCalWidth - (this.mMiddleEllipsizeWidthRecord - widthStart);
        int needStopLine = borrowWidth > 0 ? this.mLines - endLines - 1 : this.mLines - endLines;
        int n = needStopWidth = borrowWidth > 0 ? widthEnd - borrowWidth : this.mMiddleEllipsizeWidthRecord - (widthEnd - this.mCurrentCalWidth);
        if (this.mCurrentDrawLine < needStopLine) {
            for (int i = offset; i < fontWidths.length; ++i) {
                if (!((float)this.mCurrentDrawUsedWidth + fontWidths[i] <= (float)widthEnd)) {
                    this.toNewDrawLine(widthStart, widthStart - widthEnd);
                    this.handleTextAfterMiddleEllipsize(canvas, text, fontWidths, i, ellipsizeLine, widthStart, widthEnd);
                    return;
                }
                this.mCurrentDrawUsedWidth = (int)((float)this.mCurrentDrawUsedWidth + fontWidths[i]);
            }
        } else if (this.mCurrentDrawLine == needStopLine) {
            for (int i = offset; i < fontWidths.length; ++i) {
                if (!((float)this.mCurrentDrawUsedWidth + fontWidths[i] <= (float)needStopWidth)) {
                    int newStart = i + 1;
                    if (this.mCurrentDrawUsedWidth >= needStopWidth) {
                        newStart = i;
                    }
                    this.mCurrentDrawUsedWidth = this.mMiddleEllipsizeWidthRecord;
                    this.mMiddleEllipsizeWidthRecord = -1;
                    this.mLastNeedStopLineRecord = needStopLine;
                    this.onRealDrawText(canvas, text, fontWidths, newStart, widthStart, widthEnd);
                    return;
                }
                this.mCurrentDrawUsedWidth = (int)((float)this.mCurrentDrawUsedWidth + fontWidths[i]);
            }
        } else {
            this.onRealDrawText(canvas, text, fontWidths, offset, widthStart, widthEnd);
        }
    }

    private void drawText(Canvas canvas, CharSequence text, int start, int end, int textWidth) {
        if (end <= start || end > text.length() || start >= text.length()) {
            return;
        }
        if (this.mIsInDrawSpan && this.mCurrentDrawSpan != null) {
            int color2;
            int n = color2 = this.mCurrentDrawSpan.isPressed() ? this.mCurrentDrawSpan.getPressedBackgroundColor() : this.mCurrentDrawSpan.getNormalBackgroundColor();
            if (color2 != 0) {
                this.mSpanBgPaint.setColor(color2);
                canvas.drawRect((float)this.mCurrentDrawUsedWidth, (float)(this.mCurrentDrawBaseLine - this.mFirstBaseLine), (float)(this.mCurrentDrawUsedWidth + textWidth), (float)(this.mCurrentDrawBaseLine - this.mFirstBaseLine + this.mFontHeight), this.mSpanBgPaint);
            }
        }
        canvas.drawText(text, start, end, (float)this.mCurrentDrawUsedWidth, (float)this.mCurrentDrawBaseLine, (Paint)this.mPaint);
    }

    private void onDrawQQFace(Canvas canvas, int res, @Nullable Drawable specialDrawable, int widthStart, int widthEnd, boolean isFirst, boolean isLast) {
        int size;
        int n = res != -1 || specialDrawable == null ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (this.mIsNeedEllipsize) {
            if (this.mEllipsize == TextUtils.TruncateAt.START) {
                if (this.mCurrentDrawLine > this.mLines - this.mNeedDrawLine) {
                    this.onRealDrawQQFace(canvas, res, specialDrawable, this.mNeedDrawLine - this.mLines, widthStart, widthEnd, isFirst, isLast);
                } else if (this.mCurrentDrawLine < this.mLines - this.mNeedDrawLine) {
                    if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                        this.toNewDrawLine(widthStart, widthEnd - widthStart);
                        this.onDrawQQFace(canvas, res, specialDrawable, widthStart, widthEnd, isFirst, isLast);
                    } else {
                        this.mCurrentDrawUsedWidth += size;
                    }
                } else {
                    int needStopWidth = this.mCurrentCalWidth + this.mEllipsizeTextLength;
                    if (size + this.mCurrentDrawUsedWidth < needStopWidth) {
                        this.mCurrentDrawUsedWidth += size;
                    } else {
                        this.toNewDrawLine(widthStart + this.mEllipsizeTextLength, widthEnd - widthStart);
                    }
                }
            } else if (this.mEllipsize == TextUtils.TruncateAt.MIDDLE) {
                int ellipsizeLine = this.getMiddleEllipsizeLine();
                if (this.mCurrentDrawLine < ellipsizeLine) {
                    if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                        this.onRealDrawQQFace(canvas, res, specialDrawable, 0, widthStart, widthEnd, isFirst, isLast);
                    } else {
                        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                        this.mCurrentDrawUsedWidth += size;
                    }
                } else if (this.mCurrentDrawLine == ellipsizeLine) {
                    int needStop = this.getWidth() / 2 - this.mEllipsizeTextLength / 2;
                    if (this.mIsExecutedMiddleEllipsize) {
                        this.handleQQFaceAfterMiddleEllipsize(canvas, res, specialDrawable, widthStart, widthEnd, ellipsizeLine, isFirst, isLast);
                    } else if (size + this.mCurrentDrawUsedWidth <= needStop) {
                        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                        this.mCurrentDrawUsedWidth += size;
                    } else {
                        this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                        this.mMiddleEllipsizeWidthRecord = this.mCurrentDrawUsedWidth + this.mEllipsizeTextLength;
                        this.mIsExecutedMiddleEllipsize = true;
                        this.handleQQFaceAfterMiddleEllipsize(canvas, res, specialDrawable, widthStart, widthEnd, ellipsizeLine, isFirst, isLast);
                    }
                } else {
                    this.handleQQFaceAfterMiddleEllipsize(canvas, res, specialDrawable, widthStart, widthEnd, ellipsizeLine, isFirst, isLast);
                }
            } else if (this.mCurrentDrawLine == this.mNeedDrawLine) {
                int ellipsizeLength = this.mMoreActionTextLength;
                if (this.mEllipsize == TextUtils.TruncateAt.END) {
                    ellipsizeLength += this.mEllipsizeTextLength;
                }
                if (size + this.mCurrentDrawUsedWidth >= widthEnd - ellipsizeLength) {
                    if (size + this.mCurrentDrawUsedWidth == widthEnd - ellipsizeLength) {
                        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                        this.mCurrentDrawUsedWidth += size;
                    }
                    if (this.mEllipsize == TextUtils.TruncateAt.END) {
                        this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                        this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                    }
                    this.drawMoreActionText(canvas, widthEnd);
                    this.toNewDrawLine(widthStart, widthEnd - widthStart);
                } else {
                    this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                    this.mCurrentDrawUsedWidth += size;
                }
            } else if (this.mCurrentDrawLine < this.mNeedDrawLine) {
                if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                    this.onRealDrawQQFace(canvas, res, specialDrawable, 0, widthStart, widthEnd, isFirst, isLast);
                } else {
                    this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                    this.mCurrentDrawUsedWidth += size;
                }
            }
        } else {
            this.onRealDrawQQFace(canvas, res, specialDrawable, 0, widthStart, widthEnd, isFirst, isLast);
        }
    }

    private void handleQQFaceAfterMiddleEllipsize(Canvas canvas, int res, Drawable specialDrawable, int widthStart, int widthEnd, int ellipsizeLine, boolean isFirst, boolean isLast) {
        int needStopWidth;
        int size;
        int n = res != 0 ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (this.mMiddleEllipsizeWidthRecord == -1) {
            this.onRealDrawQQFace(canvas, res, specialDrawable, ellipsizeLine - this.mLastNeedStopLineRecord, widthStart, widthEnd, isFirst, isLast);
            return;
        }
        int endLines = this.mNeedDrawLine - ellipsizeLine;
        int borrowWidth = widthEnd - this.mCurrentCalWidth - (this.mMiddleEllipsizeWidthRecord - widthStart);
        int needStopLine = borrowWidth > 0 ? this.mLines - endLines - 1 : this.mLines - endLines;
        int n2 = needStopWidth = borrowWidth > 0 ? widthEnd - borrowWidth : this.mMiddleEllipsizeWidthRecord - (widthEnd - this.mCurrentCalWidth);
        if (this.mCurrentDrawLine < needStopLine) {
            if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                this.toNewDrawLine(widthStart, widthEnd - widthStart);
                this.onDrawQQFace(canvas, res, specialDrawable, widthStart, widthEnd, isFirst, isLast);
            } else {
                this.mCurrentDrawUsedWidth += size;
            }
        } else if (this.mCurrentDrawLine == needStopLine) {
            if (size + this.mCurrentDrawUsedWidth <= needStopWidth) {
                this.mCurrentDrawUsedWidth += size;
            } else {
                boolean drawCurrentFace = false;
                if (this.mCurrentDrawUsedWidth >= needStopWidth) {
                    drawCurrentFace = true;
                }
                this.mCurrentDrawUsedWidth = this.mMiddleEllipsizeWidthRecord;
                this.mMiddleEllipsizeWidthRecord = -1;
                this.mLastNeedStopLineRecord = needStopLine;
                if (drawCurrentFace) {
                    this.onDrawQQFace(canvas, res, specialDrawable, widthStart, widthEnd, isFirst, isLast);
                }
            }
        } else {
            this.onRealDrawQQFace(canvas, res, specialDrawable, ellipsizeLine - needStopLine, widthStart, widthEnd, isFirst, isLast);
        }
    }

    private void onRealDrawQQFace(Canvas canvas, int res, @Nullable Drawable specialDrawable, int adjustLine, int widthStart, int widthEnd, boolean isFirst, boolean isLast) {
        int size;
        int n = res != 0 || specialDrawable == null ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (this.mCurrentDrawUsedWidth + size > widthEnd) {
            this.toNewDrawLine(widthStart, widthEnd - widthStart);
        }
        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine + adjustLine, isFirst, isLast);
        this.mCurrentDrawUsedWidth += size;
    }

    private void drawQQFace(Canvas canvas, int res, @Nullable Drawable specialDrawable, int line, boolean isFirst, boolean isLast) {
        int size;
        Drawable drawable2;
        Drawable drawable3 = drawable2 = res != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)res) : specialDrawable;
        int n = res != 0 || specialDrawable == null ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (drawable2 == null) {
            return;
        }
        if (res != 0) {
            int drawableTop = (this.mFontHeight - this.mQQFaceSize) / 2;
            drawable2.setBounds(0, drawableTop, this.mQQFaceSize, drawableTop + this.mQQFaceSize);
        } else {
            int left = isLast ? this.mSpecialDrawablePadding : 0;
            int drawableWidth = drawable2.getIntrinsicWidth();
            int drawableHeight = drawable2.getIntrinsicHeight();
            if (drawableHeight > this.mFontHeight) {
                float scale = (float)this.mFontHeight / (float)drawableHeight;
                drawableHeight = this.mFontHeight;
                drawableWidth = (int)((float)drawableWidth * scale);
            }
            int drawableTop = (this.mFontHeight - drawableHeight) / 2;
            drawable2.setBounds(left, drawableTop, left + drawableWidth, drawableTop + drawableHeight);
        }
        int top = this.getPaddingTop();
        if (line > 1) {
            top = (line - 1) * (this.mFontHeight + this.mLineSpace) + top;
        }
        canvas.save();
        canvas.translate((float)this.mCurrentDrawUsedWidth, (float)top);
        if (this.mIsInDrawSpan && this.mCurrentDrawSpan != null) {
            int color2;
            int n2 = color2 = this.mCurrentDrawSpan.isPressed() ? this.mCurrentDrawSpan.getPressedBackgroundColor() : this.mCurrentDrawSpan.getNormalBackgroundColor();
            if (color2 != 0) {
                this.mSpanBgPaint.setColor(color2);
                canvas.drawRect(0.0f, 0.0f, (float)size, (float)this.mFontHeight, this.mSpanBgPaint);
            }
        }
        drawable2.draw(canvas);
        canvas.restore();
    }

    public static interface QQFaceViewListener {
        public void onCalculateLinesChange(int var1);

        public void onMoreTextClick();
    }

    public static class PressCancelAction
    implements Runnable {
        private WeakReference<SpanInfo> mWeakReference;

        public PressCancelAction(SpanInfo spanInfo) {
            this.mWeakReference = new WeakReference<SpanInfo>(spanInfo);
        }

        @Override
        public void run() {
            SpanInfo spanInfo = (SpanInfo)this.mWeakReference.get();
            if (spanInfo != null) {
                spanInfo.setPressed(false);
                spanInfo.invalidateSpan();
            }
        }
    }

    private class SpanInfo {
        public static final int NOT_SET = -1;
        private ITouchableSpan mTouchableSpan;
        private int mStartPoint = -1;
        private int mEndPoint = -1;
        private int mStartLine = -1;
        private int mEndLine = -1;

        public SpanInfo(ITouchableSpan touchableSpan) {
            this.mTouchableSpan = touchableSpan;
        }

        public void setStart(int startLine, int startPoint) {
            this.mStartLine = startLine;
            this.mStartPoint = startPoint;
        }

        public void setPressed(boolean pressed) {
            this.mTouchableSpan.setPressed(pressed);
        }

        public void setEnd(int endLine, int endPoint) {
            this.mEndLine = endLine;
            this.mEndPoint = endPoint;
        }

        public void onClick() {
            this.mTouchableSpan.onClick(QMUIQQFaceView.this);
        }

        public void invalidateSpan() {
            int top = QMUIQQFaceView.this.getPaddingTop();
            if (this.mStartLine > 1) {
                top = (this.mStartLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + top;
            }
            int bottom = (this.mEndLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + top + QMUIQQFaceView.this.mFontHeight;
            Rect bounds = new Rect();
            bounds.top = top;
            bounds.bottom = bottom;
            bounds.left = QMUIQQFaceView.this.getPaddingLeft();
            bounds.right = QMUIQQFaceView.this.getWidth() - QMUIQQFaceView.this.getPaddingRight();
            if (this.mStartLine == this.mEndLine) {
                bounds.left = this.mStartPoint;
                bounds.right = this.mEndPoint;
            }
            QMUIQQFaceView.this.invalidate(bounds);
        }

        public boolean onTouch(int x, int y) {
            int top = QMUIQQFaceView.this.getPaddingTop();
            if (this.mStartLine > 1) {
                top = (this.mStartLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + top;
            }
            int bottom = (this.mEndLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + QMUIQQFaceView.this.getPaddingTop() + QMUIQQFaceView.this.mFontHeight;
            if (y < top || y > bottom) {
                return false;
            }
            if (this.mStartLine == this.mEndLine) {
                return x >= this.mStartPoint && x <= this.mEndPoint;
            }
            int startLineBottom = top + QMUIQQFaceView.this.mFontHeight;
            int endLineTop = bottom - QMUIQQFaceView.this.mFontHeight;
            if (y > startLineBottom && y < endLineTop) {
                if (this.mEndLine - this.mStartLine == 1) {
                    return x >= this.mStartPoint && x <= this.mEndPoint;
                }
                return true;
            }
            if (y <= startLineBottom) {
                return x >= this.mStartPoint;
            }
            return x <= this.mEndPoint;
        }
    }
}

