/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;

public class QMUIDraggableScrollBar
extends View {
    private int[] STATE_PRESSED = new int[]{16842919};
    private int[] STATE_NORMAL = new int[0];
    private Drawable mDragDrawable;
    private int mKeepShownTime = 800;
    private int mTransitionDuration = 100;
    private long mStartTransitionTime = 0L;
    private float mCurrentAlpha = 0.0f;
    private float mPercent = 0.0f;
    private Runnable mDelayInvalidateRunnable = new Runnable(){

        @Override
        public void run() {
            QMUIDraggableScrollBar.this.invalidate();
        }
    };
    private boolean mIsInDragging = false;
    private Callback mCallback;
    private int mDrawableDrawTop = -1;
    private float mDragInnerTop = 0.0f;
    private int mAdjustDistanceProtection = QMUIDisplayHelper.dp2px(this.getContext(), 20);
    private int mAdjustMaxDistanceOnce = QMUIDisplayHelper.dp2px(this.getContext(), 4);
    private boolean enableFadeInAndOut = true;

    public QMUIDraggableScrollBar(Context context) {
        this(context, (AttributeSet)null);
    }

    public QMUIDraggableScrollBar(Context context, @NonNull Drawable dragDrawable) {
        this(context, (AttributeSet)null);
        this.mDragDrawable = dragDrawable.mutate();
    }

    public QMUIDraggableScrollBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setKeepShownTime(int keepShownTime) {
        this.mKeepShownTime = keepShownTime;
    }

    public void setTransitionDuration(int transitionDuration) {
        this.mTransitionDuration = transitionDuration;
    }

    public void setEnableFadeInAndOut(boolean enableFadeInAndOut) {
        this.enableFadeInAndOut = enableFadeInAndOut;
    }

    public boolean isEnableFadeInAndOut() {
        return this.enableFadeInAndOut;
    }

    public void setDragDrawable(Drawable dragDrawable) {
        this.mDragDrawable = dragDrawable.mutate();
        this.invalidate();
    }

    public void setPercent(float percent) {
        if (!this.mIsInDragging) {
            this.setPercentInternal(percent);
        }
    }

    private void setPercentInternal(float percent) {
        this.mPercent = percent;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable2 = this.mDragDrawable;
        if (drawable2 == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)drawable2.getIntrinsicWidth(), (int)0x40000000), heightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent event) {
        Drawable drawable2 = this.mDragDrawable;
        if (drawable2 == null) {
            return super.onTouchEvent(event);
        }
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        if (action == 0) {
            this.mIsInDragging = false;
            if (this.mCurrentAlpha > 0.0f && x > (float)(this.getWidth() - drawable2.getIntrinsicWidth()) && y >= (float)this.mDrawableDrawTop && y <= (float)(this.mDrawableDrawTop + drawable2.getIntrinsicHeight())) {
                this.mDragInnerTop = y - (float)this.mDrawableDrawTop;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.mIsInDragging = true;
                if (this.mCallback != null) {
                    this.mCallback.onDragStarted();
                    this.mDragDrawable.setState(this.STATE_PRESSED);
                }
            }
        } else if (action == 2) {
            if (this.mIsInDragging) {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.onDragging(drawable2, y);
            }
        } else if ((action == 1 || action == 3) && this.mIsInDragging) {
            this.mIsInDragging = false;
            this.onDragging(drawable2, y);
            if (this.mCallback != null) {
                this.mCallback.onDragEnd();
                this.mDragDrawable.setState(this.STATE_NORMAL);
            }
        }
        return this.mIsInDragging;
    }

    private void onDragging(Drawable drawable2, float currentY) {
        float percent = (currentY - (float)this.getScrollBarTopMargin() - this.mDragInnerTop) / (float)(this.getHeight() - this.getScrollBarBottomMargin() - this.getScrollBarTopMargin() - drawable2.getIntrinsicHeight());
        percent = QMUILangHelper.constrain(percent, 0.0f, 1.0f);
        if (this.mCallback != null) {
            this.mCallback.onDragToPercent(percent);
        }
        this.setPercentInternal(percent);
    }

    public void awakenScrollBar() {
        long current;
        if (this.mDragDrawable == null) {
            this.mDragDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.qmui_icon_scroll_bar);
        }
        if ((current = System.currentTimeMillis()) - this.mStartTransitionTime > (long)this.mTransitionDuration) {
            this.mStartTransitionTime = current - (long)this.mTransitionDuration;
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable drawable2 = this.mDragDrawable;
        if (drawable2 == null) {
            return;
        }
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        if (drawableWidth <= 0 || drawableHeight <= 0) {
            return;
        }
        int needInvalidate = -1;
        if (this.enableFadeInAndOut) {
            long timeAfterStartShow = System.currentTimeMillis() - this.mStartTransitionTime;
            if (timeAfterStartShow < (long)this.mTransitionDuration) {
                this.mCurrentAlpha = (float)timeAfterStartShow * 1.0f / (float)this.mTransitionDuration;
                needInvalidate = 0;
            } else if (timeAfterStartShow - (long)this.mTransitionDuration < (long)this.mKeepShownTime) {
                this.mCurrentAlpha = 1.0f;
                needInvalidate = (int)((long)this.mKeepShownTime - (timeAfterStartShow - (long)this.mTransitionDuration));
            } else {
                long timeAfterEndShow = timeAfterStartShow - (long)this.mTransitionDuration - (long)this.mKeepShownTime;
                if (timeAfterEndShow < (long)this.mTransitionDuration) {
                    this.mCurrentAlpha = 1.0f - (float)timeAfterEndShow * 1.0f / (float)this.mTransitionDuration;
                    needInvalidate = 0;
                } else {
                    this.mCurrentAlpha = 0.0f;
                }
            }
            if (this.mCurrentAlpha <= 0.0f) {
                return;
            }
        } else {
            this.mCurrentAlpha = 1.0f;
        }
        drawable2.setAlpha((int)(this.mCurrentAlpha * 255.0f));
        int totalHeight = this.getHeight() - this.getScrollBarTopMargin() - this.getScrollBarBottomMargin();
        int totalWidth = this.getWidth();
        int top = this.getScrollBarTopMargin() + (int)((float)(totalHeight - drawableHeight) * this.mPercent);
        int left = totalWidth - drawableWidth;
        if (!this.mIsInDragging && this.mDrawableDrawTop > 0) {
            int moveDistance = top - this.mDrawableDrawTop;
            if (moveDistance > this.mAdjustMaxDistanceOnce && moveDistance < this.mAdjustDistanceProtection) {
                top = this.mDrawableDrawTop + this.mAdjustMaxDistanceOnce;
                needInvalidate = 0;
            } else if (moveDistance < -this.mAdjustMaxDistanceOnce && moveDistance > -this.mAdjustDistanceProtection) {
                top = this.mDrawableDrawTop - this.mAdjustMaxDistanceOnce;
                needInvalidate = 0;
            }
        }
        drawable2.setBounds(0, 0, drawableWidth, drawableHeight);
        canvas.save();
        canvas.translate((float)left, (float)top);
        drawable2.draw(canvas);
        canvas.restore();
        this.mDrawableDrawTop = top;
        if (needInvalidate == 0) {
            this.invalidate();
        } else if (needInvalidate > 0) {
            ViewCompat.postOnAnimationDelayed((View)this, (Runnable)this.mDelayInvalidateRunnable, (long)needInvalidate);
        }
    }

    protected int getScrollBarTopMargin() {
        return 0;
    }

    protected int getScrollBarBottomMargin() {
        return 0;
    }

    static interface Callback {
        public void onDragStarted();

        public void onDragToPercent(float var1);

        public void onDragEnd();
    }
}

