/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedBottomView;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedScrollCommon;

public class QMUIContinuousNestedBottomRecyclerView
extends RecyclerView
implements IQMUIContinuousNestedBottomView {
    public static final String KEY_SCROLL_INFO_POSITION = "@qmui_scroll_info_bottom_rv_pos";
    public static final String KEY_SCROLL_INFO_OFFSET = "@qmui_scroll_info_bottom_rv_offset";
    private IQMUIContinuousNestedScrollCommon.OnScrollNotifier mOnScrollNotifier;
    private final int[] mScrollConsumed = new int[2];

    public QMUIContinuousNestedBottomRecyclerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public QMUIContinuousNestedBottomRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public QMUIContinuousNestedBottomRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                if (QMUIContinuousNestedBottomRecyclerView.this.mOnScrollNotifier != null) {
                    if (newState == 0) {
                        QMUIContinuousNestedBottomRecyclerView.this.mOnScrollNotifier.onScrollStateChange((View)recyclerView, 0);
                    } else if (newState == 2) {
                        QMUIContinuousNestedBottomRecyclerView.this.mOnScrollNotifier.onScrollStateChange((View)recyclerView, 2);
                    } else if (newState == 1) {
                        QMUIContinuousNestedBottomRecyclerView.this.mOnScrollNotifier.onScrollStateChange((View)recyclerView, 1);
                    }
                }
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                if (QMUIContinuousNestedBottomRecyclerView.this.mOnScrollNotifier != null) {
                    QMUIContinuousNestedBottomRecyclerView.this.mOnScrollNotifier.notify(recyclerView.computeVerticalScrollOffset(), Math.max(0, recyclerView.computeVerticalScrollRange() - recyclerView.getHeight()));
                }
            }
        });
    }

    @Override
    public void consumeScroll(int yUnconsumed) {
        if (yUnconsumed == Integer.MIN_VALUE) {
            this.scrollToPosition(0);
        } else if (yUnconsumed == Integer.MAX_VALUE) {
            RecyclerView.Adapter adapter = this.getAdapter();
            if (adapter != null) {
                this.scrollToPosition(adapter.getItemCount() - 1);
            }
        } else {
            boolean reStartNestedScroll = false;
            if (!this.hasNestedScrollingParent(0)) {
                reStartNestedScroll = true;
                this.startNestedScroll(2, 0);
                this.mScrollConsumed[0] = 0;
                this.mScrollConsumed[1] = 0;
                this.dispatchNestedPreScroll(0, yUnconsumed, this.mScrollConsumed, null, 0);
                yUnconsumed -= this.mScrollConsumed[1];
            }
            this.scrollBy(0, yUnconsumed);
            if (reStartNestedScroll) {
                this.stopNestedScroll(0);
            }
        }
    }

    @Override
    public int getContentHeight() {
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            return 0;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null) {
            return 0;
        }
        int scrollRange = this.computeVerticalScrollRange();
        if (scrollRange > this.getHeight()) {
            return -1;
        }
        return scrollRange;
    }

    @Override
    public void injectScrollNotifier(IQMUIContinuousNestedScrollCommon.OnScrollNotifier notifier) {
        this.mOnScrollNotifier = notifier;
    }

    @Override
    public int getCurrentScroll() {
        return this.computeVerticalScrollOffset();
    }

    @Override
    public int getScrollOffsetRange() {
        return Math.max(0, this.computeVerticalScrollRange() - this.getHeight());
    }

    @Override
    public void smoothScrollYBy(int dy, int duration) {
        this.startNestedScroll(2, 1);
        this.smoothScrollBy(0, dy, null);
    }

    @Override
    public void saveScrollInfo(@NonNull Bundle bundle) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager lm = (LinearLayoutManager)layoutManager;
            int pos = lm.findFirstVisibleItemPosition();
            View firstView = lm.findViewByPosition(pos);
            int offset = firstView == null ? 0 : firstView.getTop();
            bundle.putInt(KEY_SCROLL_INFO_POSITION, pos);
            bundle.putInt(KEY_SCROLL_INFO_OFFSET, offset);
        }
    }

    @Override
    public void restoreScrollInfo(@NonNull Bundle bundle) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            int pos = bundle.getInt(KEY_SCROLL_INFO_POSITION, 0);
            int offset = bundle.getInt(KEY_SCROLL_INFO_OFFSET, 0);
            ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(pos, offset);
            if (this.mOnScrollNotifier != null) {
                this.mOnScrollNotifier.notify(this.getCurrentScroll(), this.getScrollOffsetRange());
            }
        }
    }
}

