/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.GravityCompat;
import android.view.View;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedTopView;
import com.qmuiteam.qmui.nestedScroll.QMUIViewOffsetBehavior;
import java.util.List;

public class QMUIContinuousNestedBottomAreaBehavior
extends QMUIViewOffsetBehavior<View> {
    private final Rect tempRect1 = new Rect();
    private final Rect tempRect2 = new Rect();
    private int mTopInset = 0;

    public void setTopInset(int topInset) {
        this.mTopInset = topInset;
    }

    public boolean onMeasureChild(@NonNull CoordinatorLayout parent, @NonNull View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        int childLpHeight = child.getLayoutParams().height;
        if (childLpHeight == -1 || childLpHeight == -2) {
            int availableHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec);
            if (availableHeight == 0) {
                availableHeight = parent.getHeight();
            }
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(availableHeight -= this.mTopInset), (int)(childLpHeight == -1 ? 0x40000000 : Integer.MIN_VALUE));
            parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, heightMeasureSpec, heightUsed);
            return true;
        }
        return false;
    }

    @Override
    protected void layoutChild(CoordinatorLayout parent, View child, int layoutDirection) {
        List dependencies = parent.getDependencies(child);
        if (!dependencies.isEmpty()) {
            View topView = (View)dependencies.get(0);
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            Rect available = this.tempRect1;
            available.set(parent.getPaddingLeft() + lp.leftMargin, topView.getBottom() + lp.topMargin, parent.getWidth() - parent.getPaddingRight() - lp.rightMargin, parent.getHeight() + topView.getBottom() - parent.getPaddingBottom() - lp.bottomMargin);
            Rect out = this.tempRect2;
            GravityCompat.apply((int)QMUIContinuousNestedBottomAreaBehavior.resolveGravity(lp.gravity), (int)child.getMeasuredWidth(), (int)child.getMeasuredHeight(), (Rect)available, (Rect)out, (int)layoutDirection);
            child.layout(out.left, out.top, out.right, out.bottom);
        } else {
            super.layoutChild(parent, child, layoutDirection);
        }
    }

    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, View child, int layoutDirection) {
        boolean ret = super.onLayoutChild(parent, child, layoutDirection);
        List dependencies = parent.getDependencies(child);
        if (!dependencies.isEmpty()) {
            View topView = (View)dependencies.get(0);
            this.setTopAndBottomOffset(topView.getBottom() - this.getLayoutTop());
        }
        return ret;
    }

    private static int resolveGravity(int gravity) {
        return gravity == 0 ? 0x800033 : gravity;
    }

    public boolean layoutDependsOn(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        return dependency instanceof IQMUIContinuousNestedTopView;
    }

    public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        this.setTopAndBottomOffset(dependency.getBottom() - this.getLayoutTop());
        return false;
    }
}

