/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.layout;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import com.qmuiteam.qmui.alpha.QMUIAlphaLinearLayout;
import com.qmuiteam.qmui.layout.IQMUILayout;
import com.qmuiteam.qmui.layout.QMUILayoutHelper;

public class QMUILinearLayout
extends QMUIAlphaLinearLayout
implements IQMUILayout {
    private QMUILayoutHelper mLayoutHelper;

    public QMUILinearLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public QMUILinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public QMUILinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mLayoutHelper = new QMUILayoutHelper(context, attrs, defStyleAttr, (View)this);
        this.setChangeAlphaWhenPress(false);
        this.setChangeAlphaWhenDisable(false);
    }

    @Override
    public void updateTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.updateTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void updateBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.updateBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void updateLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.updateLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void updateRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.updateRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.onlyShowTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.onlyShowBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.onlyShowLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.onlyShowRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void setTopDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setTopDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setBottomDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setBottomDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setLeftDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setLeftDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setRightDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setRightDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        widthMeasureSpec = this.mLayoutHelper.getMeasuredWidthSpec(widthMeasureSpec);
        heightMeasureSpec = this.mLayoutHelper.getMeasuredHeightSpec(heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int minW = this.mLayoutHelper.handleMiniWidth(widthMeasureSpec, this.getMeasuredWidth());
        int minH = this.mLayoutHelper.handleMiniHeight(heightMeasureSpec, this.getMeasuredHeight());
        if (widthMeasureSpec != minW || heightMeasureSpec != minH) {
            super.onMeasure(minW, minH);
        }
    }

    @Override
    public void setRadiusAndShadow(int radius, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, int shadowColor, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowColor, shadowAlpha);
    }

    @Override
    public void setRadius(int radius) {
        this.mLayoutHelper.setRadius(radius);
    }

    @Override
    public void setRadius(int radius, int hideRadiusSide) {
        this.mLayoutHelper.setRadius(radius, hideRadiusSide);
    }

    @Override
    public int getRadius() {
        return this.mLayoutHelper.getRadius();
    }

    @Override
    public void setOutlineInset(int left, int top, int right, int bottom) {
        this.mLayoutHelper.setOutlineInset(left, top, right, bottom);
    }

    @Override
    public void setBorderColor(@ColorInt int borderColor) {
        this.mLayoutHelper.setBorderColor(borderColor);
        this.invalidate();
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.mLayoutHelper.setBorderWidth(borderWidth);
        this.invalidate();
    }

    @Override
    public void setShowBorderOnlyBeforeL(boolean showBorderOnlyBeforeL) {
        this.mLayoutHelper.setShowBorderOnlyBeforeL(showBorderOnlyBeforeL);
        this.invalidate();
    }

    @Override
    public void setHideRadiusSide(int hideRadiusSide) {
        this.mLayoutHelper.setHideRadiusSide(hideRadiusSide);
    }

    @Override
    public int getHideRadiusSide() {
        return this.mLayoutHelper.getHideRadiusSide();
    }

    @Override
    public boolean setWidthLimit(int widthLimit) {
        if (this.mLayoutHelper.setWidthLimit(widthLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public boolean setHeightLimit(int heightLimit) {
        if (this.mLayoutHelper.setHeightLimit(heightLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public void setUseThemeGeneralShadowElevation() {
        this.mLayoutHelper.setUseThemeGeneralShadowElevation();
    }

    @Override
    public void setOutlineExcludePadding(boolean outlineExcludePadding) {
        this.mLayoutHelper.setOutlineExcludePadding(outlineExcludePadding);
    }

    @Override
    public void setShadowElevation(int elevation) {
        this.mLayoutHelper.setShadowElevation(elevation);
    }

    @Override
    public int getShadowElevation() {
        return this.mLayoutHelper.getShadowElevation();
    }

    @Override
    public void setShadowAlpha(float shadowAlpha) {
        this.mLayoutHelper.setShadowAlpha(shadowAlpha);
    }

    @Override
    public void setShadowColor(int shadowColor) {
        this.mLayoutHelper.setShadowColor(shadowColor);
    }

    @Override
    public int getShadowColor() {
        return this.mLayoutHelper.getShadowColor();
    }

    @Override
    public void setOuterNormalColor(int color2) {
        this.mLayoutHelper.setOuterNormalColor(color2);
    }

    @Override
    public float getShadowAlpha() {
        return this.mLayoutHelper.getShadowAlpha();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.mLayoutHelper.drawDividers(canvas, this.getWidth(), this.getHeight());
        this.mLayoutHelper.dispatchRoundBorderDraw(canvas);
    }
}

