/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIResHelper;

public class QMUIDialogView
extends QMUILinearLayout {
    private int mMinWidth;
    private int mMaxWidth;
    private OnDecorationListener mOnDecorationListener;

    public QMUIDialogView(Context context) {
        this(context, null);
    }

    public QMUIDialogView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIDialogView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mMinWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_min_width);
        this.mMaxWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_max_width);
    }

    public void setOnDecorationListener(OnDecorationListener onDecorationListener) {
        this.mOnDecorationListener = onDecorationListener;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureWidth;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (this.mMaxWidth > 0 && widthSize > this.mMaxWidth) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)widthMode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (widthMode == Integer.MIN_VALUE && (measureWidth = this.getMeasuredWidth()) < this.mMinWidth && this.mMinWidth < widthSize) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMinWidth, (int)0x40000000);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mOnDecorationListener != null) {
            this.mOnDecorationListener.onDraw(canvas, this);
        }
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mOnDecorationListener != null) {
            this.mOnDecorationListener.onDrawOver(canvas, this);
        }
    }

    public static interface OnDecorationListener {
        public void onDraw(Canvas var1, QMUIDialogView var2);

        public void onDrawOver(Canvas var1, QMUIDialogView var2);
    }
}

