/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIRelativeLayout;
import com.qmuiteam.qmui.util.QMUIViewHelper;

public class QMUIDialogMenuItemView
extends QMUIRelativeLayout {
    private int index = -1;
    private MenuItemViewListener mListener;
    private boolean mIsChecked = false;

    public QMUIDialogMenuItemView(Context context) {
        super(context, null, R.attr.qmui_dialog_menu_item_style);
    }

    public static TextView createItemTextView(Context context) {
        TextView tv = new TextView(context);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuTextStyleDef, R.attr.qmui_dialog_menu_item_style, 0);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.QMUIDialogMenuTextStyleDef_android_gravity) {
                tv.setGravity(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogMenuTextStyleDef_android_textColor) {
                tv.setTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 != R.styleable.QMUIDialogMenuTextStyleDef_android_textSize) continue;
            tv.setTextSize(0, (float)a.getDimensionPixelSize(attr2, 0));
        }
        a.recycle();
        tv.setSingleLine(true);
        tv.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        tv.setDuplicateParentStateEnabled(false);
        return tv;
    }

    public int getMenuIndex() {
        return this.index;
    }

    public void setMenuIndex(int index) {
        this.index = index;
    }

    protected void notifyCheckChange(boolean isChecked) {
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void setChecked(boolean checked) {
        this.mIsChecked = checked;
        this.notifyCheckChange(this.mIsChecked);
    }

    public void setListener(MenuItemViewListener listener) {
        if (!this.isClickable()) {
            this.setClickable(true);
        }
        this.mListener = listener;
    }

    public boolean performClick() {
        if (this.mListener != null) {
            this.mListener.onClick(this.index);
        }
        return super.performClick();
    }

    @SuppressLint(value={"ViewConstructor"})
    public static class CheckItemView
    extends QMUIDialogMenuItemView {
        private Context mContext;
        private TextView mTextView;
        private ImageView mCheckedView;

        public CheckItemView(Context context, boolean right) {
            super(context);
            this.mContext = context;
            this.mCheckedView = new ImageView(this.mContext);
            this.mCheckedView.setId(QMUIViewHelper.generateViewId());
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuCheckDef, R.attr.qmui_dialog_menu_item_style, 0);
            int markMarginHor = 0;
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogMenuCheckDef_qmui_dialog_menu_item_check_mark_margin_hor) {
                    markMarginHor = a.getDimensionPixelSize(attr2, 0);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogMenuCheckDef_qmui_dialog_menu_item_check_drawable) continue;
                this.mCheckedView.setImageDrawable(a.getDrawable(attr2));
            }
            a.recycle();
            RelativeLayout.LayoutParams checkLp = new RelativeLayout.LayoutParams(-2, -2);
            checkLp.addRule(15, -1);
            if (right) {
                checkLp.addRule(11, -1);
                checkLp.leftMargin = markMarginHor;
            } else {
                checkLp.addRule(9, -1);
                checkLp.rightMargin = markMarginHor;
            }
            this.addView((View)this.mCheckedView, (ViewGroup.LayoutParams)checkLp);
            this.mTextView = CheckItemView.createItemTextView(this.mContext);
            RelativeLayout.LayoutParams tvLp = new RelativeLayout.LayoutParams(-1, -1);
            if (right) {
                tvLp.addRule(0, this.mCheckedView.getId());
            } else {
                tvLp.addRule(1, this.mCheckedView.getId());
            }
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)tvLp);
        }

        public CheckItemView(Context context, boolean right, CharSequence text) {
            this(context, right);
            this.setText(text);
        }

        public void setText(CharSequence text) {
            this.mTextView.setText(text);
        }

        public CharSequence getText() {
            return this.mTextView.getText();
        }

        @Override
        protected void notifyCheckChange(boolean isChecked) {
            QMUIViewHelper.safeSetImageViewSelected(this.mCheckedView, isChecked);
        }
    }

    public static class MarkItemView
    extends QMUIDialogMenuItemView {
        private Context mContext;
        private TextView mTextView;
        private ImageView mCheckedView;

        public MarkItemView(Context context) {
            super(context);
            this.mContext = context;
            this.mCheckedView = new ImageView(this.mContext);
            this.mCheckedView.setId(QMUIViewHelper.generateViewId());
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuMarkDef, R.attr.qmui_dialog_menu_item_style, 0);
            int markMarginHor = 0;
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogMenuMarkDef_qmui_dialog_menu_item_check_mark_margin_hor) {
                    markMarginHor = a.getDimensionPixelSize(attr2, 0);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogMenuMarkDef_qmui_dialog_menu_item_mark_drawable) continue;
                this.mCheckedView.setImageDrawable(a.getDrawable(attr2));
            }
            a.recycle();
            RelativeLayout.LayoutParams checkLp = new RelativeLayout.LayoutParams(-2, -2);
            checkLp.addRule(15, -1);
            checkLp.addRule(11, -1);
            checkLp.leftMargin = markMarginHor;
            this.addView((View)this.mCheckedView, (ViewGroup.LayoutParams)checkLp);
            this.mTextView = MarkItemView.createItemTextView(this.mContext);
            RelativeLayout.LayoutParams tvLp = new RelativeLayout.LayoutParams(-1, -1);
            tvLp.addRule(9, -1);
            tvLp.addRule(0, this.mCheckedView.getId());
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)tvLp);
        }

        public MarkItemView(Context context, CharSequence text) {
            this(context);
            this.setText(text);
        }

        public void setText(CharSequence text) {
            this.mTextView.setText(text);
        }

        @Override
        protected void notifyCheckChange(boolean isChecked) {
            QMUIViewHelper.safeSetImageViewSelected(this.mCheckedView, isChecked);
        }
    }

    public static class TextItemView
    extends QMUIDialogMenuItemView {
        protected TextView mTextView;

        public TextItemView(Context context) {
            super(context);
            this.init();
        }

        public TextItemView(Context context, CharSequence text) {
            super(context);
            this.init();
            this.setText(text);
        }

        private void init() {
            this.mTextView = TextItemView.createItemTextView(this.getContext());
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }

        public void setText(CharSequence text) {
            this.mTextView.setText(text);
        }

        public void setTextColor(int color2) {
            this.mTextView.setTextColor(color2);
        }
    }

    public static interface MenuItemViewListener {
        public void onClick(int var1);
    }
}

