/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v4.view.WindowInsetsCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.qmuiteam.qmui.util.QMUIWindowInsetHelper;
import com.qmuiteam.qmui.widget.IWindowInsetLayout;
import com.qmuiteam.qmui.widget.QMUIPagerAdapter;

public class QMUIViewPager
extends ViewPager
implements IWindowInsetLayout {
    private static final int DEFAULT_INFINITE_RATIO = 100;
    private boolean mIsSwipeable = true;
    private boolean mIsInMeasure = false;
    private QMUIWindowInsetHelper mQMUIWindowInsetHelper = new QMUIWindowInsetHelper((ViewGroup)this, this);
    private boolean mEnableLoop = false;
    private int mInfiniteRatio = 100;

    public QMUIViewPager(Context context) {
        this(context, null);
    }

    public QMUIViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setSwipeable(boolean enable) {
        this.mIsSwipeable = enable;
    }

    public int getInfiniteRatio() {
        return this.mInfiniteRatio;
    }

    public void setInfiniteRatio(int infiniteRatio) {
        this.mInfiniteRatio = infiniteRatio;
    }

    public boolean isEnableLoop() {
        return this.mEnableLoop;
    }

    public void setEnableLoop(boolean enableLoop) {
        if (this.mEnableLoop != enableLoop) {
            this.mEnableLoop = enableLoop;
            if (this.getAdapter() != null) {
                this.getAdapter().notifyDataSetChanged();
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return this.mIsSwipeable && super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mIsSwipeable && super.onInterceptTouchEvent(ev);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mIsInMeasure = true;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mIsInMeasure = false;
    }

    public boolean isInMeasure() {
        return this.mIsInMeasure;
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            return this.applySystemWindowInsets19(insets);
        }
        return super.fitSystemWindows(insets);
    }

    @Override
    public boolean applySystemWindowInsets19(Rect insets) {
        return this.mQMUIWindowInsetHelper.defaultApplySystemWindowInsets19((ViewGroup)this, insets);
    }

    @Override
    public boolean applySystemWindowInsets21(WindowInsetsCompat insets) {
        return this.mQMUIWindowInsetHelper.defaultApplySystemWindowInsets21((ViewGroup)this, insets);
    }

    public void setAdapter(PagerAdapter adapter) {
        if (adapter instanceof QMUIPagerAdapter) {
            super.setAdapter((PagerAdapter)new WrapperPagerAdapter((QMUIPagerAdapter)adapter));
        } else {
            super.setAdapter(adapter);
        }
    }

    class WrapperPagerAdapter
    extends PagerAdapter {
        private QMUIPagerAdapter mAdapter;

        public WrapperPagerAdapter(QMUIPagerAdapter adapter) {
            this.mAdapter = adapter;
        }

        public int getCount() {
            int count = QMUIViewPager.this.mEnableLoop ? (this.mAdapter.getCount() == 0 ? 0 : this.mAdapter.getCount() * QMUIViewPager.this.mInfiniteRatio) : this.mAdapter.getCount();
            return count;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            int realPosition = position;
            if (QMUIViewPager.this.mEnableLoop && this.mAdapter.getCount() != 0) {
                realPosition = position % this.mAdapter.getCount();
            }
            return this.mAdapter.instantiateItem(container, realPosition);
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            int realPosition = position;
            if (QMUIViewPager.this.mEnableLoop && this.mAdapter.getCount() != 0) {
                realPosition = position % this.mAdapter.getCount();
            }
            this.mAdapter.destroyItem(container, realPosition, object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return this.mAdapter.isViewFromObject(view, object);
        }

        public void restoreState(Parcelable bundle, ClassLoader classLoader) {
            this.mAdapter.restoreState(bundle, classLoader);
        }

        public Parcelable saveState() {
            return this.mAdapter.saveState();
        }

        public void startUpdate(ViewGroup container) {
            this.mAdapter.startUpdate(container);
        }

        public void finishUpdate(ViewGroup container) {
            this.mAdapter.finishUpdate(container);
        }

        public CharSequence getPageTitle(int position) {
            int virtualPosition = position % this.mAdapter.getCount();
            return this.mAdapter.getPageTitle(virtualPosition);
        }

        public float getPageWidth(int position) {
            return this.mAdapter.getPageWidth(position);
        }

        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            this.mAdapter.setPrimaryItem(container, position, object);
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            this.mAdapter.unregisterDataSetObserver(observer);
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            this.mAdapter.registerDataSetObserver(observer);
        }

        public void notifyDataSetChanged() {
            super.notifyDataSetChanged();
            this.mAdapter.notifyDataSetChanged();
        }

        public int getItemPosition(Object object) {
            return this.mAdapter.getItemPosition(object);
        }
    }
}

