/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.util.QMUIDrawableHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;

public class QMUITopBarLayout
extends FrameLayout {
    private QMUITopBar mTopBar;
    private Drawable mTopBarBgWithSeparatorDrawableCache;
    private int mTopBarSeparatorColor;
    private int mTopBarBgColor;
    private int mTopBarSeparatorHeight;

    public QMUITopBarLayout(Context context) {
        this(context, null);
    }

    public QMUITopBarLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUITopBarStyle);
    }

    public QMUITopBarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.QMUITopBar, R.attr.QMUITopBarStyle, 0);
        this.mTopBarSeparatorColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_separator_color, ContextCompat.getColor((Context)context, (int)R.color.qmui_config_color_separator));
        this.mTopBarSeparatorHeight = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_separator_height, 1);
        this.mTopBarBgColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_bg_color, -1);
        boolean hasSeparator = array.getBoolean(R.styleable.QMUITopBar_qmui_topbar_need_separator, true);
        this.mTopBar = new QMUITopBar(context, true);
        this.mTopBar.getCommonFieldFormTypedArray(context, array);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, QMUIResHelper.getAttrDimen(context, R.attr.qmui_topbar_height));
        this.addView((View)this.mTopBar, (ViewGroup.LayoutParams)lp);
        array.recycle();
        this.setBackgroundDividerEnabled(hasSeparator);
    }

    public void setCenterView(View view) {
        this.mTopBar.setCenterView(view);
    }

    public TextView setTitle(int resId) {
        return this.mTopBar.setTitle(resId);
    }

    public TextView setTitle(String title) {
        return this.mTopBar.setTitle(title);
    }

    public TextView setEmojiTitle(String title) {
        return this.mTopBar.setEmojiTitle(title);
    }

    public void showTitlteView(boolean toShow) {
        this.mTopBar.showTitleView(toShow);
    }

    public void setSubTitle(int resId) {
        this.mTopBar.setSubTitle(resId);
    }

    public void setSubTitle(String subTitle) {
        this.mTopBar.setSubTitle(subTitle);
    }

    public void setTitleGravity(int gravity) {
        this.mTopBar.setTitleGravity(gravity);
    }

    public void addLeftView(View view, int viewId) {
        this.mTopBar.addLeftView(view, viewId);
    }

    public void addLeftView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        this.mTopBar.addLeftView(view, viewId, layoutParams);
    }

    public void addRightView(View view, int viewId) {
        this.mTopBar.addRightView(view, viewId);
    }

    public void addRightView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        this.mTopBar.addRightView(view, viewId, layoutParams);
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, int viewId) {
        return this.mTopBar.addRightImageButton(drawableResId, viewId);
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, int viewId) {
        return this.mTopBar.addLeftImageButton(drawableResId, viewId);
    }

    public Button addLeftTextButton(int stringResId, int viewId) {
        return this.mTopBar.addLeftTextButton(stringResId, viewId);
    }

    public Button addLeftTextButton(String buttonText, int viewId) {
        return this.mTopBar.addLeftTextButton(buttonText, viewId);
    }

    public Button addRightTextButton(int stringResId, int viewId) {
        return this.mTopBar.addRightTextButton(stringResId, viewId);
    }

    public Button addRightTextButton(String buttonText, int viewId) {
        return this.mTopBar.addRightTextButton(buttonText, viewId);
    }

    public QMUIAlphaImageButton addLeftBackImageButton() {
        return this.mTopBar.addLeftBackImageButton();
    }

    public void removeAllLeftViews() {
        this.mTopBar.removeAllLeftViews();
    }

    public void removeAllRightViews() {
        this.mTopBar.removeAllRightViews();
    }

    public void removeCenterViewAndTitleView() {
        this.mTopBar.removeCenterViewAndTitleView();
    }

    public void setBackgroundAlpha(int alpha) {
        this.getBackground().setAlpha(alpha);
    }

    public int computeAndSetBackgroundAlpha(int currentOffset, int alphaBeginOffset, int alphaTargetOffset) {
        double alpha = (float)(currentOffset - alphaBeginOffset) / (float)(alphaTargetOffset - alphaBeginOffset);
        alpha = Math.max(0.0, Math.min(alpha, 1.0));
        int alphaInt = (int)(alpha * 255.0);
        this.setBackgroundAlpha(alphaInt);
        return alphaInt;
    }

    public void setBackgroundDividerEnabled(boolean enabled) {
        if (enabled) {
            if (this.mTopBarBgWithSeparatorDrawableCache == null) {
                this.mTopBarBgWithSeparatorDrawableCache = QMUIDrawableHelper.createItemSeparatorBg(this.mTopBarSeparatorColor, this.mTopBarBgColor, this.mTopBarSeparatorHeight, false);
            }
            QMUIViewHelper.setBackgroundKeepingPadding((View)this, this.mTopBarBgWithSeparatorDrawableCache);
        } else {
            QMUIViewHelper.setBackgroundColorKeepPadding((View)this, this.mTopBarBgColor);
        }
    }
}

