/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.qmuiteam.qmui.QMUIInterpolatorStaticHolder;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIColorHelper;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIDrawableHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.QMUIItemViewsAdapter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class QMUITabSegment
extends HorizontalScrollView {
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    public static final int ICON_POSITION_LEFT = 0;
    public static final int ICON_POSITION_TOP = 1;
    public static final int ICON_POSITION_RIGHT = 2;
    public static final int ICON_POSITION_BOTTOM = 3;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_PROGRESS = 1;
    private static final int STATUS_SELECTED = 2;
    private final ArrayList<OnTabSelectedListener> mSelectedListeners = new ArrayList();
    private View mIndicatorView;
    private int mSelectedIndex = Integer.MIN_VALUE;
    private int mPendingSelectedIndex = Integer.MIN_VALUE;
    private Container mContentLayout;
    private int mTabTextSize;
    private boolean mHasIndicator = true;
    private int mIndicatorHeight;
    private boolean mIndicatorTop = false;
    private Drawable mIndicatorDrawable;
    private boolean mIsIndicatorWidthFollowContent = true;
    private int mDefaultNormalColor;
    private int mDefaultSelectedColor;
    private int mDefaultTabIconPosition;
    private int mMode = 1;
    private int mItemSpaceInScrollMode;
    private TypefaceProvider mTypefaceProvider;
    private int mViewPagerScrollState = 0;
    private boolean mIsAnimating;
    private OnTabClickListener mOnTabClickListener;
    private boolean mForceIndicatorNotDoLayoutWhenParentLayout = false;
    protected View.OnClickListener mTabOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (QMUITabSegment.this.mIsAnimating || QMUITabSegment.this.mViewPagerScrollState != 0) {
                return;
            }
            int index = (Integer)v.getTag();
            Tab model = (Tab)QMUITabSegment.this.getAdapter().getItem(index);
            if (model != null) {
                QMUITabSegment.this.selectTab(index, !model.isDynamicChangeIconColor());
            }
            if (QMUITabSegment.this.mOnTabClickListener != null) {
                QMUITabSegment.this.mOnTabClickListener.onTabClick(index);
            }
        }
    };
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    private DataSetObserver mPagerAdapterObserver;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private OnTabSelectedListener mViewPagerSelectedListener;
    private boolean mIsInSelectTab = false;

    public QMUITabSegment(Context context) {
        this(context, null);
    }

    public QMUITabSegment(Context context, boolean hasIndicator) {
        this(context, null);
        this.mHasIndicator = hasIndicator;
    }

    public QMUITabSegment(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUITabSegmentStyle);
    }

    public QMUITabSegment(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
        this.setHorizontalScrollBarEnabled(false);
        this.setClipToPadding(false);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mDefaultSelectedColor = QMUIResHelper.getAttrColor(context, R.attr.qmui_config_color_blue);
        this.mDefaultNormalColor = ContextCompat.getColor((Context)context, (int)R.color.qmui_config_color_gray_5);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUITabSegment, defStyleAttr, 0);
        this.mHasIndicator = array.getBoolean(R.styleable.QMUITabSegment_qmui_tab_has_indicator, true);
        this.mIndicatorHeight = array.getDimensionPixelSize(R.styleable.QMUITabSegment_qmui_tab_indicator_height, this.getResources().getDimensionPixelSize(R.dimen.qmui_tab_segment_indicator_height));
        this.mTabTextSize = array.getDimensionPixelSize(R.styleable.QMUITabSegment_android_textSize, this.getResources().getDimensionPixelSize(R.dimen.qmui_tab_segment_text_size));
        this.mIndicatorTop = array.getBoolean(R.styleable.QMUITabSegment_qmui_tab_indicator_top, false);
        this.mDefaultTabIconPosition = array.getInt(R.styleable.QMUITabSegment_qmui_tab_icon_position, 0);
        this.mMode = array.getInt(R.styleable.QMUITabSegment_qmui_tab_mode, 1);
        this.mItemSpaceInScrollMode = array.getDimensionPixelSize(R.styleable.QMUITabSegment_qmui_tab_space, QMUIDisplayHelper.dp2px(context, 10));
        String typefaceProviderName = array.getString(R.styleable.QMUITabSegment_qmui_tab_typeface_provider);
        array.recycle();
        this.mContentLayout = new Container(context);
        this.addView((View)this.mContentLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        if (this.mHasIndicator) {
            this.createIndicatorView();
        }
        this.createTypefaceProvider(context, typefaceProviderName);
    }

    private void createTypefaceProvider(Context context, String className) {
        if (QMUILangHelper.isNullOrEmpty(className)) {
            return;
        }
        if ((className = className.trim()).length() == 0) {
            return;
        }
        className = this.getFullClassName(context, className);
        try {
            Constructor<TypefaceProvider> constructor;
            ClassLoader classLoader = this.isInEditMode() ? ((Object)((Object)this)).getClass().getClassLoader() : context.getClassLoader();
            Class<TypefaceProvider> providerClass = classLoader.loadClass(className).asSubclass(TypefaceProvider.class);
            try {
                constructor = providerClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Error creating TypefaceProvider " + className, e);
            }
            constructor.setAccessible(true);
            this.mTypefaceProvider = constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find TypefaceProvider " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Could not instantiate the TypefaceProvider: " + className, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate the TypefaceProvider: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access non-public constructor " + className, e);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Class is not a TypefaceProvider " + className, e);
        }
    }

    private String getFullClassName(Context context, String className) {
        if (className.charAt(0) == '.') {
            return context.getPackageName() + className;
        }
        return className;
    }

    public void setTypefaceProvider(TypefaceProvider typefaceProvider) {
        this.mTypefaceProvider = typefaceProvider;
    }

    public QMUITabSegment addTab(Tab item) {
        this.mContentLayout.getTabAdapter().addItem(item);
        return this;
    }

    private TabAdapter getAdapter() {
        return this.mContentLayout.getTabAdapter();
    }

    private void createIndicatorView() {
        if (this.mIndicatorView == null) {
            this.mIndicatorView = new View(this.getContext());
            this.mIndicatorView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, this.mIndicatorHeight));
            if (this.mIndicatorDrawable != null) {
                QMUIViewHelper.setBackgroundKeepingPadding(this.mIndicatorView, this.mIndicatorDrawable);
            } else {
                this.mIndicatorView.setBackgroundColor(this.mDefaultSelectedColor);
            }
            this.mContentLayout.addView(this.mIndicatorView);
        }
    }

    public void setTabTextSize(int tabTextSize) {
        this.mTabTextSize = tabTextSize;
    }

    public void reset() {
        this.mContentLayout.getTabAdapter().clear();
    }

    public void notifyDataChanged() {
        this.getAdapter().setup();
    }

    public void addOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        if (!this.mSelectedListeners.contains(listener)) {
            this.mSelectedListeners.add(listener);
        }
    }

    public void setItemSpaceInScrollMode(int itemSpaceInScrollMode) {
        this.mItemSpaceInScrollMode = itemSpaceInScrollMode;
    }

    public void setIndicatorDrawable(Drawable indicatorDrawable) {
        this.mIndicatorDrawable = indicatorDrawable;
        if (indicatorDrawable != null) {
            this.mIndicatorHeight = indicatorDrawable.getIntrinsicHeight();
        }
        this.mContentLayout.invalidate();
    }

    public void setIndicatorWidthAdjustContent(boolean indicatorWidthFollowContent) {
        this.mIsIndicatorWidthFollowContent = indicatorWidthFollowContent;
    }

    public void setIndicatorPosition(boolean isIndicatorTop) {
        this.mIndicatorTop = isIndicatorTop;
    }

    public void setHasIndicator(boolean hasIndicator) {
        if (this.mHasIndicator != hasIndicator) {
            this.mHasIndicator = hasIndicator;
            if (this.mHasIndicator) {
                this.createIndicatorView();
            } else {
                this.mContentLayout.removeView(this.mIndicatorView);
                this.mIndicatorView = null;
            }
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        if (this.mMode != mode) {
            this.mMode = mode;
            this.mContentLayout.invalidate();
        }
    }

    public void removeOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        this.mSelectedListeners.remove(listener);
    }

    public void clearOnTabSelectedListeners() {
        this.mSelectedListeners.clear();
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        this.setupWithViewPager(viewPager, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean useAdapterTitle) {
        this.setupWithViewPager(viewPager, useAdapterTitle, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean useAdapterTitle, boolean autoRefresh) {
        if (this.mViewPager != null && this.mOnPageChangeListener != null) {
            this.mViewPager.removeOnPageChangeListener(this.mOnPageChangeListener);
        }
        if (this.mViewPagerSelectedListener != null) {
            this.removeOnTabSelectedListener(this.mViewPagerSelectedListener);
            this.mViewPagerSelectedListener = null;
        }
        if (viewPager != null) {
            this.mViewPager = viewPager;
            if (this.mOnPageChangeListener == null) {
                this.mOnPageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            viewPager.addOnPageChangeListener(this.mOnPageChangeListener);
            this.mViewPagerSelectedListener = new ViewPagerOnTabSelectedListener(viewPager);
            this.addOnTabSelectedListener(this.mViewPagerSelectedListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.setPagerAdapter(adapter, useAdapterTitle, autoRefresh);
            }
        } else {
            this.mViewPager = null;
            this.setPagerAdapter(null, false, false);
        }
    }

    private void dispatchTabSelected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabSelected(index);
        }
    }

    private void dispatchTabUnselected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabUnselected(index);
        }
    }

    private void dispatchTabReselected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabReselected(index);
        }
    }

    private void dispatchTabDoubleTap(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onDoubleTap(index);
        }
    }

    public void setDefaultNormalColor(@ColorInt int defaultNormalColor) {
        this.mDefaultNormalColor = defaultNormalColor;
    }

    public void setDefaultSelectedColor(@ColorInt int defaultSelectedColor) {
        this.mDefaultSelectedColor = defaultSelectedColor;
    }

    public void setDefaultTabIconPosition(int defaultTabIconPosition) {
        this.mDefaultTabIconPosition = defaultTabIconPosition;
    }

    private void preventLayoutToChangeTabColor(TextView textView, int color2, Tab model, int status) {
        this.mForceIndicatorNotDoLayoutWhenParentLayout = true;
        this.changeTabColor(textView, color2, model, status);
        this.mForceIndicatorNotDoLayoutWhenParentLayout = false;
    }

    private void changeTabColor(TextView textView, int color2, Tab model, int status) {
        this.changeTabColor(textView, color2, model, status, false);
    }

    private void changeTabColor(TextView textView, int color2, Tab model, int status, boolean preventColorChange) {
        if (!preventColorChange) {
            textView.setTextColor(color2);
        }
        if (!model.isDynamicChangeIconColor()) {
            if (status == 0 || model.getSelectedIcon() == null) {
                this.setDrawable(textView, model.getNormalIcon(), this.getTabIconPosition(model));
            } else if (status == 2) {
                this.setDrawable(textView, model.getSelectedIcon(), this.getTabIconPosition(model));
            }
            return;
        }
        if (!preventColorChange) {
            Drawable drawable = textView.getCompoundDrawables()[this.getTabIconPosition(model)];
            if (drawable == null) {
                return;
            }
            QMUIDrawableHelper.setDrawableTintColor(drawable, color2);
            this.setDrawable(textView, model.getNormalIcon(), this.getTabIconPosition(model));
        }
    }

    public void selectTab(int index) {
        this.selectTab(index, true);
    }

    private void selectTab(final int index, boolean preventAnim) {
        if (this.mIsInSelectTab) {
            return;
        }
        this.mIsInSelectTab = true;
        if (this.mContentLayout.getTabAdapter().getSize() == 0 || this.mContentLayout.getTabAdapter().getSize() <= index) {
            this.mIsInSelectTab = false;
            return;
        }
        if (this.mSelectedIndex == index) {
            this.dispatchTabReselected(index);
            this.mIsInSelectTab = false;
            return;
        }
        if (this.mIsAnimating) {
            this.mPendingSelectedIndex = index;
            this.mIsInSelectTab = false;
            return;
        }
        TabAdapter tabAdapter = this.getAdapter();
        final List listViews = tabAdapter.getViews();
        if (this.mSelectedIndex == Integer.MIN_VALUE) {
            tabAdapter.setup();
            Tab model = (Tab)tabAdapter.getItem(index);
            if (this.mIndicatorView != null && listViews.size() > 1) {
                if (this.mIndicatorDrawable != null) {
                    QMUIViewHelper.setBackgroundKeepingPadding(this.mIndicatorView, this.mIndicatorDrawable);
                } else {
                    this.mIndicatorView.setBackgroundColor(this.getTabSelectedColor(model));
                }
            }
            TextView selectedTv = ((TabItemView)((Object)listViews.get(index))).getTextView();
            this.setTextViewTypeface(selectedTv, true);
            this.changeTabColor(selectedTv, this.getTabSelectedColor(model), model, 2);
            this.dispatchTabSelected(index);
            this.mSelectedIndex = index;
            this.mIsInSelectTab = false;
            return;
        }
        final int prev = this.mSelectedIndex;
        final Tab prevModel = (Tab)tabAdapter.getItem(prev);
        final TabItemView prevView = (TabItemView)((Object)listViews.get(prev));
        final Tab nowModel = (Tab)tabAdapter.getItem(index);
        final TabItemView nowView = (TabItemView)((Object)listViews.get(index));
        if (preventAnim) {
            this.dispatchTabUnselected(prev);
            this.dispatchTabSelected(index);
            this.setTextViewTypeface(prevView.getTextView(), false);
            this.setTextViewTypeface(nowView.getTextView(), true);
            this.changeTabColor(prevView.getTextView(), this.getTabNormalColor(prevModel), prevModel, 0, this.mViewPagerScrollState != 0);
            this.changeTabColor(nowView.getTextView(), this.getTabSelectedColor(nowModel), nowModel, 2, this.mViewPagerScrollState != 0);
            if (this.getScrollX() > nowView.getLeft()) {
                this.smoothScrollTo(nowView.getLeft(), 0);
            } else {
                int realWidth = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                if (this.getScrollX() + realWidth < nowView.getRight()) {
                    this.smoothScrollBy(nowView.getRight() - realWidth - this.getScrollX(), 0);
                }
            }
            this.mSelectedIndex = index;
            this.mIsInSelectTab = false;
            return;
        }
        final int leftDistance = nowModel.getContentLeft() - prevModel.getContentLeft();
        final int widthDistance = nowModel.getContentWidth() - prevModel.getContentWidth();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setInterpolator((TimeInterpolator)QMUIInterpolatorStaticHolder.LINEAR_INTERPOLATOR);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animValue = ((Float)animation.getAnimatedValue()).floatValue();
                if (QMUITabSegment.this.mIndicatorView != null && listViews.size() > 1) {
                    int targetLeft = (int)((float)prevModel.getContentLeft() + (float)leftDistance * animValue);
                    int targetWidth = (int)((float)prevModel.getContentWidth() + (float)widthDistance * animValue);
                    if (QMUITabSegment.this.mIndicatorDrawable == null) {
                        QMUITabSegment.this.mIndicatorView.setBackgroundColor(QMUIColorHelper.computeColor(QMUITabSegment.this.getTabSelectedColor(prevModel), QMUITabSegment.this.getTabSelectedColor(nowModel), animValue));
                    }
                    QMUITabSegment.this.mIndicatorView.layout(targetLeft, QMUITabSegment.this.mIndicatorView.getTop(), targetLeft + targetWidth, QMUITabSegment.this.mIndicatorView.getBottom());
                }
                int preColor = QMUIColorHelper.computeColor(QMUITabSegment.this.getTabSelectedColor(prevModel), QMUITabSegment.this.getTabNormalColor(prevModel), animValue);
                int nowColor = QMUIColorHelper.computeColor(QMUITabSegment.this.getTabNormalColor(nowModel), QMUITabSegment.this.getTabSelectedColor(nowModel), animValue);
                QMUITabSegment.this.preventLayoutToChangeTabColor(prevView.getTextView(), preColor, prevModel, 1);
                QMUITabSegment.this.preventLayoutToChangeTabColor(nowView.getTextView(), nowColor, nowModel, 1);
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                QMUITabSegment.this.mIsAnimating = true;
            }

            public void onAnimationEnd(Animator animation) {
                QMUITabSegment.this.mIsAnimating = false;
                QMUITabSegment.this.changeTabColor(nowView.getTextView(), QMUITabSegment.this.getTabSelectedColor(nowModel), nowModel, 2);
                QMUITabSegment.this.dispatchTabSelected(index);
                QMUITabSegment.this.dispatchTabUnselected(prev);
                QMUITabSegment.this.setTextViewTypeface(prevView.getTextView(), false);
                QMUITabSegment.this.setTextViewTypeface(nowView.getTextView(), true);
                QMUITabSegment.this.mSelectedIndex = index;
                if (QMUITabSegment.this.mPendingSelectedIndex != Integer.MIN_VALUE && QMUITabSegment.this.mPendingSelectedIndex != QMUITabSegment.this.mSelectedIndex) {
                    QMUITabSegment.this.selectTab(index, false);
                }
            }

            public void onAnimationCancel(Animator animation) {
                QMUITabSegment.this.changeTabColor(nowView.getTextView(), QMUITabSegment.this.getTabSelectedColor(nowModel), nowModel, 2);
                QMUITabSegment.this.mIsAnimating = false;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.setDuration(200L);
        animator.start();
        this.mIsInSelectTab = false;
    }

    private void setTextViewTypeface(TextView tv, boolean selected) {
        if (this.mTypefaceProvider == null || tv == null) {
            return;
        }
        boolean isBold = selected ? this.mTypefaceProvider.isSelectedTabBold() : this.mTypefaceProvider.isNormalTabBold();
        tv.setTypeface(null, isBold ? 1 : 0);
    }

    public void updateIndicatorPosition(int index, float offsetPercent) {
        int targetIndex;
        if (this.mIsAnimating || this.mIsInSelectTab || offsetPercent == 0.0f) {
            return;
        }
        if (offsetPercent < 0.0f) {
            targetIndex = index - 1;
            offsetPercent = -offsetPercent;
        } else {
            targetIndex = index + 1;
        }
        TabAdapter tabAdapter = this.getAdapter();
        List listViews = tabAdapter.getViews();
        if (listViews.size() <= index || listViews.size() <= targetIndex) {
            return;
        }
        Tab preModel = (Tab)tabAdapter.getItem(index);
        Tab targetModel = (Tab)tabAdapter.getItem(targetIndex);
        TextView preTv = ((TabItemView)((Object)listViews.get(index))).getTextView();
        TextView nowTv = ((TabItemView)((Object)listViews.get(targetIndex))).getTextView();
        int preColor = QMUIColorHelper.computeColor(this.getTabSelectedColor(preModel), this.getTabNormalColor(preModel), offsetPercent);
        int targetColor = QMUIColorHelper.computeColor(this.getTabNormalColor(targetModel), this.getTabSelectedColor(targetModel), offsetPercent);
        this.preventLayoutToChangeTabColor(preTv, preColor, preModel, 1);
        this.preventLayoutToChangeTabColor(nowTv, targetColor, targetModel, 1);
        this.mForceIndicatorNotDoLayoutWhenParentLayout = false;
        if (this.mIndicatorView != null && listViews.size() > 1) {
            int leftDistance = targetModel.getContentLeft() - preModel.getContentLeft();
            int widthDistance = targetModel.getContentWidth() - preModel.getContentWidth();
            int targetLeft = (int)((float)preModel.getContentLeft() + (float)leftDistance * offsetPercent);
            int targetWidth = (int)((float)preModel.getContentWidth() + (float)widthDistance * offsetPercent);
            if (this.mIndicatorDrawable == null) {
                int indicatorColor = QMUIColorHelper.computeColor(this.getTabSelectedColor(preModel), this.getTabSelectedColor(targetModel), offsetPercent);
                this.mIndicatorView.setBackgroundColor(indicatorColor);
            }
            this.mIndicatorView.layout(targetLeft, this.mIndicatorView.getTop(), targetLeft + targetWidth, this.mIndicatorView.getBottom());
        }
    }

    public void updateTabText(int index, String text) {
        Tab model = (Tab)this.getAdapter().getItem(index);
        if (model == null) {
            return;
        }
        model.setText(text);
        this.notifyDataChanged();
    }

    public void replaceTab(int index, Tab model) {
        try {
            this.getAdapter().replaceItem(index, model);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setOnTabClickListener(OnTabClickListener onTabClickListener) {
        this.mOnTabClickListener = onTabClickListener;
    }

    private void setDrawable(TextView tv, Drawable drawable, int iconPosition) {
        tv.setCompoundDrawables((Drawable)(iconPosition == 0 ? drawable : null), (Drawable)(iconPosition == 1 ? drawable : null), (Drawable)(iconPosition == 2 ? drawable : null), (Drawable)(iconPosition == 3 ? drawable : null));
    }

    private int getTabNormalColor(Tab item) {
        int color2 = item.getNormalColor();
        if (color2 == Integer.MIN_VALUE) {
            color2 = this.mDefaultNormalColor;
        }
        return color2;
    }

    private int getTabIconPosition(Tab item) {
        int iconPosition = item.getIconPosition();
        if (iconPosition == Integer.MIN_VALUE) {
            iconPosition = this.mDefaultTabIconPosition;
        }
        return iconPosition;
    }

    private int getTabSelectedColor(Tab item) {
        int color2 = item.getSelectedColor();
        if (color2 == Integer.MIN_VALUE) {
            color2 = this.mDefaultSelectedColor;
        }
        return color2;
    }

    void populateFromPagerAdapter(boolean useAdapterTitle) {
        int curItem;
        if (this.mPagerAdapter == null) {
            if (useAdapterTitle) {
                this.reset();
            }
            return;
        }
        int adapterCount = this.mPagerAdapter.getCount();
        if (useAdapterTitle) {
            this.reset();
            for (int i = 0; i < adapterCount; ++i) {
                this.addTab(new Tab(this.mPagerAdapter.getPageTitle(i)));
            }
            this.notifyDataChanged();
        }
        if (this.mViewPager != null && adapterCount > 0 && (curItem = this.mViewPager.getCurrentItem()) != this.mSelectedIndex && curItem < adapterCount) {
            this.selectTab(curItem);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            int paddingHor = this.getPaddingLeft() + this.getPaddingRight();
            child.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - paddingHor), (int)0x40000000), heightMeasureSpec);
            if (widthMode == Integer.MIN_VALUE) {
                this.setMeasuredDimension(Math.min(widthSize, child.getMeasuredWidth() + paddingHor), heightMeasureSpec);
                return;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    void setPagerAdapter(@Nullable PagerAdapter adapter, boolean useAdapterTitle, boolean addObserver) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver(useAdapterTitle);
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter(useAdapterTitle);
    }

    public int getSelectedIndex() {
        return this.mSelectedIndex;
    }

    private int getTabCount() {
        return this.getAdapter().getSize();
    }

    public Tab getTab(int index) {
        return (Tab)this.getAdapter().getItem(index);
    }

    public void showSignCountView(Context context, int index, int count) {
        Tab tab = (Tab)this.getAdapter().getItem(index);
        tab.showSignCountView(context, count);
        this.notifyDataChanged();
    }

    public void hideSignCountView(int index) {
        Tab tab = (Tab)this.getAdapter().getItem(index);
        tab.hideSignCountView();
    }

    public int getSignCount(int index) {
        Tab tab = (Tab)this.getAdapter().getItem(index);
        return tab.getSignCount();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mSelectedIndex != Integer.MIN_VALUE && this.mMode == 0) {
            TabAdapter tabAdapter = this.getAdapter();
            TabItemView view = (TabItemView)((Object)tabAdapter.getViews().get(this.mSelectedIndex));
            if (this.getScrollX() > view.getLeft()) {
                this.scrollTo(view.getLeft(), 0);
            } else {
                int realWidth = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                if (this.getScrollX() + realWidth < view.getRight()) {
                    this.scrollBy(view.getRight() - realWidth - this.getScrollX(), 0);
                }
            }
        }
    }

    private final class Container
    extends ViewGroup {
        private int mLastSelectedIndex;
        private TabAdapter mTabAdapter;

        public Container(Context context) {
            super(context);
            this.mLastSelectedIndex = -1;
            this.mTabAdapter = new TabAdapter(this);
        }

        public TabAdapter getTabAdapter() {
            return this.mTabAdapter;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int i;
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            List childViews = this.mTabAdapter.getViews();
            int size = childViews.size();
            int visibleChild = 0;
            for (i = 0; i < size; ++i) {
                View child = (View)childViews.get(i);
                if (child.getVisibility() != 0) continue;
                ++visibleChild;
            }
            if (size == 0 || visibleChild == 0) {
                this.setMeasuredDimension(widthSpecSize, heightSpecSize);
                return;
            }
            int childHeight = heightSpecSize - this.getPaddingTop() - this.getPaddingBottom();
            int resultWidthSize = 0;
            if (QMUITabSegment.this.mMode == 1) {
                resultWidthSize = widthSpecSize;
                int modeFixItemWidth = widthSpecSize / visibleChild;
                for (i = 0; i < size; ++i) {
                    View child = (View)childViews.get(i);
                    if (child.getVisibility() != 0) continue;
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)modeFixItemWidth, (int)0x40000000);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
            } else {
                for (i = 0; i < size; ++i) {
                    View child = (View)childViews.get(i);
                    if (child.getVisibility() != 0) continue;
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSpecSize, (int)Integer.MIN_VALUE);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    resultWidthSize += child.getMeasuredWidth() + QMUITabSegment.this.mItemSpaceInScrollMode;
                }
                resultWidthSize -= QMUITabSegment.this.mItemSpaceInScrollMode;
            }
            if (QMUITabSegment.this.mIndicatorView != null) {
                ViewGroup.LayoutParams bottomLp = QMUITabSegment.this.mIndicatorView.getLayoutParams();
                int bottomWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)resultWidthSize, (int)Integer.MIN_VALUE);
                int bottomHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)bottomLp.height, (int)0x40000000);
                QMUITabSegment.this.mIndicatorView.measure(bottomWidthMeasureSpec, bottomHeightMeasureSpec);
            }
            this.setMeasuredDimension(resultWidthSize, heightSpecSize);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            int i;
            List childViews = this.mTabAdapter.getViews();
            int size = childViews.size();
            int visibleChild = 0;
            for (i = 0; i < size; ++i) {
                View child = (View)childViews.get(i);
                if (child.getVisibility() != 0) continue;
                ++visibleChild;
            }
            if (size == 0 || visibleChild == 0) {
                return;
            }
            int usedLeft = this.getPaddingLeft();
            for (i = 0; i < size; ++i) {
                int newWidth;
                int newLeft;
                TabItemView childView = (TabItemView)((Object)childViews.get(i));
                if (childView.getVisibility() != 0) continue;
                int childMeasureWidth = childView.getMeasuredWidth();
                childView.layout(usedLeft, this.getPaddingTop(), usedLeft + childMeasureWidth, b - t - this.getPaddingBottom());
                Tab model = (Tab)this.mTabAdapter.getItem(i);
                int oldLeft = model.getContentLeft();
                int oldWidth = model.getContentWidth();
                if (QMUITabSegment.this.mMode == 1 && QMUITabSegment.this.mIsIndicatorWidthFollowContent) {
                    TextView contentView = childView.getTextView();
                    newLeft = usedLeft + contentView.getLeft();
                    newWidth = contentView.getWidth();
                } else {
                    newLeft = usedLeft;
                    newWidth = childMeasureWidth;
                }
                if (oldLeft != newLeft || oldWidth != newWidth) {
                    model.setContentLeft(newLeft);
                    model.setContentWidth(newWidth);
                }
                usedLeft = usedLeft + childMeasureWidth + (QMUITabSegment.this.mMode == 0 ? QMUITabSegment.this.mItemSpaceInScrollMode : 0);
            }
            int index = QMUITabSegment.this.mSelectedIndex == Integer.MIN_VALUE ? 0 : QMUITabSegment.this.mSelectedIndex;
            Tab model = (Tab)this.mTabAdapter.getItem(index);
            int lineLeft = model.getContentLeft();
            int lineWidth = model.getContentWidth();
            if (QMUITabSegment.this.mIndicatorView != null) {
                if (visibleChild > 1) {
                    QMUITabSegment.this.mIndicatorView.setVisibility(0);
                    if (QMUITabSegment.this.mIndicatorTop) {
                        QMUITabSegment.this.mIndicatorView.layout(lineLeft, 0, lineLeft + lineWidth, QMUITabSegment.this.mIndicatorHeight);
                    } else {
                        QMUITabSegment.this.mIndicatorView.layout(lineLeft, b - t - QMUITabSegment.this.mIndicatorHeight, lineLeft + lineWidth, b - t);
                    }
                } else {
                    QMUITabSegment.this.mIndicatorView.setVisibility(8);
                }
            }
            this.mLastSelectedIndex = index;
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private final boolean mUseAdapterTitle;

        PagerAdapterObserver(boolean useAdapterTitle) {
            this.mUseAdapterTitle = useAdapterTitle;
        }

        public void onChanged() {
            QMUITabSegment.this.populateFromPagerAdapter(this.mUseAdapterTitle);
        }

        public void onInvalidated() {
            QMUITabSegment.this.populateFromPagerAdapter(this.mUseAdapterTitle);
        }
    }

    public class TabItemView
    extends RelativeLayout {
        private InnerTextView mTextView;
        private GestureDetector mGestureDetector;

        public TabItemView(Context context) {
            super(context);
            this.mGestureDetector = null;
            this.mTextView = new InnerTextView(this.getContext());
            this.mTextView.setSingleLine(true);
            this.mTextView.setGravity(17);
            this.mTextView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
            this.mTextView.setId(R.id.qmui_tab_segment_item_id);
            RelativeLayout.LayoutParams tvLp = new RelativeLayout.LayoutParams(-2, -2);
            tvLp.addRule(15, -1);
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)tvLp);
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onDoubleTap(MotionEvent e) {
                    if (QMUITabSegment.this.mSelectedListeners == null) {
                        return false;
                    }
                    if (QMUITabSegment.this.mIsAnimating) {
                        return false;
                    }
                    int index = (Integer)TabItemView.this.getTag();
                    Tab model = (Tab)QMUITabSegment.this.getAdapter().getItem(index);
                    if (model != null) {
                        QMUITabSegment.this.dispatchTabDoubleTap(index);
                        return true;
                    }
                    return false;
                }
            });
        }

        public TextView getTextView() {
            return this.mTextView;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return this.mGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
        }
    }

    public class InnerTextView
    extends AppCompatTextView {
        public InnerTextView(Context context) {
            super(context);
        }

        public InnerTextView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public void requestLayout() {
            if (QMUITabSegment.this.mForceIndicatorNotDoLayoutWhenParentLayout) {
                return;
            }
            super.requestLayout();
        }
    }

    public class TabAdapter
    extends QMUIItemViewsAdapter<Tab, TabItemView> {
        public TabAdapter(ViewGroup parentView) {
            super(parentView);
        }

        @Override
        protected TabItemView createView(ViewGroup parentView) {
            return new TabItemView(QMUITabSegment.this.getContext());
        }

        @Override
        protected void bind(Tab item, TabItemView view, int position) {
            TextView tv = view.getTextView();
            QMUITabSegment.this.setTextViewTypeface(tv, false);
            List<View> mCustomViews = item.getCustomViews();
            if (mCustomViews != null && mCustomViews.size() > 0) {
                view.setTag(R.id.qmui_view_can_not_cache_tag, true);
                for (View v : mCustomViews) {
                    if (v.getParent() != null) continue;
                    view.addView(v);
                }
            }
            if (QMUITabSegment.this.mMode == 1) {
                int gravity = item.getGravity();
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)tv.getLayoutParams();
                lp.addRule(9, (gravity & 3) == 3 ? -1 : 0);
                lp.addRule(14, (gravity & 0x11) == 17 ? -1 : 0);
                lp.addRule(11, (gravity & 5) == 5 ? -1 : 0);
                tv.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            tv.setText(item.getText());
            if (item.getNormalIcon() == null) {
                tv.setCompoundDrawablePadding(0);
                tv.setCompoundDrawables(null, null, null, null);
            } else {
                Drawable drawable = item.getNormalIcon();
                if (drawable != null) {
                    drawable = drawable.mutate();
                    QMUITabSegment.this.setDrawable(tv, drawable, QMUITabSegment.this.getTabIconPosition(item));
                    tv.setCompoundDrawablePadding(QMUIDisplayHelper.dp2px(QMUITabSegment.this.getContext(), 4));
                } else {
                    tv.setCompoundDrawables(null, null, null, null);
                }
            }
            int textSize = item.getTextSize();
            if (textSize == Integer.MIN_VALUE) {
                textSize = QMUITabSegment.this.mTabTextSize;
            }
            tv.setTextSize(0, (float)textSize);
            if (position == QMUITabSegment.this.mSelectedIndex) {
                if (QMUITabSegment.this.mIndicatorView != null && this.getViews().size() > 1) {
                    if (QMUITabSegment.this.mIndicatorDrawable != null) {
                        QMUIViewHelper.setBackgroundKeepingPadding(QMUITabSegment.this.mIndicatorView, QMUITabSegment.this.mIndicatorDrawable);
                    } else {
                        QMUITabSegment.this.mIndicatorView.setBackgroundColor(QMUITabSegment.this.getTabSelectedColor(item));
                    }
                }
                QMUITabSegment.this.changeTabColor(view.getTextView(), QMUITabSegment.this.getTabSelectedColor(item), item, 2);
            } else {
                QMUITabSegment.this.changeTabColor(view.getTextView(), QMUITabSegment.this.getTabNormalColor(item), item, 0);
            }
            view.setTag(position);
            view.setOnClickListener(QMUITabSegment.this.mTabOnClickListener);
        }
    }

    public static class Tab {
        public static final int USE_TAB_SEGMENT = Integer.MIN_VALUE;
        private int textSize = Integer.MIN_VALUE;
        private int normalColor = Integer.MIN_VALUE;
        private int selectedColor = Integer.MIN_VALUE;
        private Drawable normalIcon = null;
        private Drawable selectedIcon = null;
        private int contentWidth = 0;
        private int contentLeft = 0;
        private int iconPosition = Integer.MIN_VALUE;
        private int gravity = 17;
        private CharSequence text;
        private List<View> mCustomViews;
        private int mSignCountDigits = 2;
        private TextView mSignCountTextView;
        private int mSignCountMarginRight = 0;
        private int mSignCountMarginTop = 0;
        private boolean dynamicChangeIconColor = true;

        public Tab(CharSequence text) {
            this.text = text;
        }

        public Tab(Drawable normalIcon, Drawable selectedIcon, CharSequence text, boolean dynamicChangeIconColor) {
            this(normalIcon, selectedIcon, text, dynamicChangeIconColor, true);
        }

        public Tab(Drawable normalIcon, Drawable selectedIcon, CharSequence text, boolean dynamicChangeIconColor, boolean setIntrinsicSize) {
            this.normalIcon = normalIcon;
            if (this.normalIcon != null && setIntrinsicSize) {
                this.normalIcon.setBounds(0, 0, normalIcon.getIntrinsicWidth(), normalIcon.getIntrinsicHeight());
            }
            this.selectedIcon = selectedIcon;
            if (this.selectedIcon != null && setIntrinsicSize) {
                this.selectedIcon.setBounds(0, 0, selectedIcon.getIntrinsicWidth(), selectedIcon.getIntrinsicHeight());
            }
            this.text = text;
            this.dynamicChangeIconColor = dynamicChangeIconColor;
        }

        public void setmSignCountDigits(int digit) {
            this.mSignCountDigits = digit;
        }

        public void setTextColor(@ColorInt int normalColor, @ColorInt int selectedColor) {
            this.normalColor = normalColor;
            this.selectedColor = selectedColor;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public void setTextSize(int textSize) {
            this.textSize = textSize;
        }

        public CharSequence getText() {
            return this.text;
        }

        public void setText(CharSequence text) {
            this.text = text;
        }

        public int getContentLeft() {
            return this.contentLeft;
        }

        public void setContentLeft(int contentLeft) {
            this.contentLeft = contentLeft;
        }

        public int getContentWidth() {
            return this.contentWidth;
        }

        public void setContentWidth(int contentWidth) {
            this.contentWidth = contentWidth;
        }

        public int getIconPosition() {
            return this.iconPosition;
        }

        public void setIconPosition(int iconPosition) {
            this.iconPosition = iconPosition;
        }

        public int getGravity() {
            return this.gravity;
        }

        public void setGravity(int gravity) {
            this.gravity = gravity;
        }

        public int getNormalColor() {
            return this.normalColor;
        }

        public Drawable getNormalIcon() {
            return this.normalIcon;
        }

        public int getSelectedColor() {
            return this.selectedColor;
        }

        public Drawable getSelectedIcon() {
            return this.selectedIcon;
        }

        public boolean isDynamicChangeIconColor() {
            return this.dynamicChangeIconColor;
        }

        public void addCustomView(@NonNull View view) {
            if (this.mCustomViews == null) {
                this.mCustomViews = new ArrayList<View>();
            }
            if (view.getLayoutParams() == null) {
                view.setLayoutParams((ViewGroup.LayoutParams)this.getDefaultCustomLayoutParam());
            }
            this.mCustomViews.add(view);
        }

        public List<View> getCustomViews() {
            return this.mCustomViews;
        }

        public void setSignCountMargin(int marginRight, int marginTop) {
            this.mSignCountMarginRight = marginRight;
            this.mSignCountMarginTop = marginTop;
            if (this.mSignCountTextView != null && this.mSignCountTextView.getLayoutParams() != null) {
                ((ViewGroup.MarginLayoutParams)this.mSignCountTextView.getLayoutParams()).rightMargin = marginRight;
                ((ViewGroup.MarginLayoutParams)this.mSignCountTextView.getLayoutParams()).topMargin = marginTop;
            }
        }

        private TextView ensureSignCountView(Context context) {
            if (this.mSignCountTextView == null) {
                this.mSignCountTextView = new TextView(context, null, R.attr.qmui_tab_sign_count_view);
                RelativeLayout.LayoutParams signCountLp = new RelativeLayout.LayoutParams(-2, QMUIResHelper.getAttrDimen(context, R.attr.qmui_tab_sign_count_view_minSize));
                signCountLp.addRule(6, R.id.qmui_tab_segment_item_id);
                signCountLp.addRule(1, R.id.qmui_tab_segment_item_id);
                this.mSignCountTextView.setLayoutParams((ViewGroup.LayoutParams)signCountLp);
                this.addCustomView((View)this.mSignCountTextView);
            }
            this.setSignCountMargin(this.mSignCountMarginRight, this.mSignCountMarginTop);
            return this.mSignCountTextView;
        }

        public void showSignCountView(Context context, int count) {
            this.ensureSignCountView(context);
            this.mSignCountTextView.setVisibility(0);
            RelativeLayout.LayoutParams signCountLp = (RelativeLayout.LayoutParams)this.mSignCountTextView.getLayoutParams();
            if (count != 0) {
                signCountLp.height = QMUIResHelper.getAttrDimen(this.mSignCountTextView.getContext(), R.attr.qmui_tab_sign_count_view_minSize_with_text);
                this.mSignCountTextView.setLayoutParams((ViewGroup.LayoutParams)signCountLp);
                this.mSignCountTextView.setMinHeight(QMUIResHelper.getAttrDimen(this.mSignCountTextView.getContext(), R.attr.qmui_tab_sign_count_view_minSize_with_text));
                this.mSignCountTextView.setMinWidth(QMUIResHelper.getAttrDimen(this.mSignCountTextView.getContext(), R.attr.qmui_tab_sign_count_view_minSize_with_text));
                this.mSignCountTextView.setText((CharSequence)this.getNumberDigitsFormattingValue(count));
            } else {
                signCountLp.height = QMUIResHelper.getAttrDimen(this.mSignCountTextView.getContext(), R.attr.qmui_tab_sign_count_view_minSize);
                this.mSignCountTextView.setLayoutParams((ViewGroup.LayoutParams)signCountLp);
                this.mSignCountTextView.setMinHeight(QMUIResHelper.getAttrDimen(this.mSignCountTextView.getContext(), R.attr.qmui_tab_sign_count_view_minSize));
                this.mSignCountTextView.setMinWidth(QMUIResHelper.getAttrDimen(this.mSignCountTextView.getContext(), R.attr.qmui_tab_sign_count_view_minSize));
                this.mSignCountTextView.setText(null);
            }
        }

        public void hideSignCountView() {
            if (this.mSignCountTextView != null) {
                this.mSignCountTextView.setVisibility(8);
            }
        }

        public int getSignCount() {
            if (this.mSignCountTextView != null && !QMUILangHelper.isNullOrEmpty(this.mSignCountTextView.getText())) {
                return Integer.parseInt(this.mSignCountTextView.getText().toString());
            }
            return 0;
        }

        private RelativeLayout.LayoutParams getDefaultCustomLayoutParam() {
            return new RelativeLayout.LayoutParams(-2, -2);
        }

        private String getNumberDigitsFormattingValue(int number) {
            if (QMUILangHelper.getNumberDigits(number) > this.mSignCountDigits) {
                String result = "";
                for (int digit = 1; digit <= this.mSignCountDigits; ++digit) {
                    result = result + "9";
                }
                result = result + "+";
                return result;
            }
            return String.valueOf(number);
        }
    }

    private static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager mViewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onTabSelected(int index) {
            this.mViewPager.setCurrentItem(index, false);
        }

        @Override
        public void onTabUnselected(int index) {
        }

        @Override
        public void onTabReselected(int index) {
        }

        @Override
        public void onDoubleTap(int index) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<QMUITabSegment> mTabSegmentRef;

        public TabLayoutOnPageChangeListener(QMUITabSegment tabSegment) {
            this.mTabSegmentRef = new WeakReference<QMUITabSegment>(tabSegment);
        }

        public void onPageScrollStateChanged(int state) {
            QMUITabSegment tabSegment = (QMUITabSegment)((Object)this.mTabSegmentRef.get());
            if (tabSegment != null) {
                tabSegment.mViewPagerScrollState = state;
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            QMUITabSegment tabSegment = (QMUITabSegment)((Object)this.mTabSegmentRef.get());
            if (tabSegment != null) {
                tabSegment.updateIndicatorPosition(position, positionOffset);
            }
        }

        public void onPageSelected(int position) {
            QMUITabSegment tabSegment = (QMUITabSegment)((Object)this.mTabSegmentRef.get());
            if (tabSegment != null && tabSegment.getSelectedIndex() != position && position < tabSegment.getTabCount()) {
                tabSegment.selectTab(position);
            }
        }
    }

    public static interface TypefaceProvider {
        public boolean isNormalTabBold();

        public boolean isSelectedTabBold();
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1);

        public void onTabUnselected(int var1);

        public void onTabReselected(int var1);

        public void onDoubleTap(int var1);
    }

    public static interface OnTabClickListener {
        public void onTabClick(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

