/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.qmuiteam.qmui.R;

public class QMUIFloatLayout
extends ViewGroup {
    private int mChildHorizontalSpacing;
    private int mChildVerticalSpacing;
    private int mGravity;
    private static final int LINES = 0;
    private static final int NUMBER = 1;
    private int mMaxMode = 0;
    private int mMaximum = Integer.MAX_VALUE;
    private int mLineCount = 0;
    private OnLineCountChangeListener mOnLineCountChangeListener;
    private int[] mItemNumberInEachLine;
    private int[] mWidthSumInEachLine;
    private int measuredChildCount;

    public QMUIFloatLayout(Context context) {
        this(context, null);
    }

    public QMUIFloatLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIFloatLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        int maxNumber;
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIFloatLayout);
        this.mChildHorizontalSpacing = array.getDimensionPixelSize(R.styleable.QMUIFloatLayout_qmui_childHorizontalSpacing, 0);
        this.mChildVerticalSpacing = array.getDimensionPixelSize(R.styleable.QMUIFloatLayout_qmui_childVerticalSpacing, 0);
        this.mGravity = array.getInteger(R.styleable.QMUIFloatLayout_android_gravity, 3);
        int maxLines = array.getInt(R.styleable.QMUIFloatLayout_android_maxLines, -1);
        if (maxLines >= 0) {
            this.setMaxLines(maxLines);
        }
        if ((maxNumber = array.getInt(R.styleable.QMUIFloatLayout_qmui_maxNumber, -1)) >= 0) {
            this.setMaxNumber(maxNumber);
        }
        array.recycle();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int resultHeight;
        int resultWidth;
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int maxLineHeight = 0;
        int count = this.getChildCount();
        this.mItemNumberInEachLine = new int[count];
        this.mWidthSumInEachLine = new int[count];
        int lineIndex = 0;
        if (widthSpecMode == 0x40000000) {
            resultWidth = widthSpecSize;
            this.measuredChildCount = 0;
            int childPositionX = this.getPaddingLeft();
            int childPositionY = this.getPaddingTop();
            int childMaxRight = widthSpecSize - this.getPaddingRight();
            for (int i = 0; !(i >= count || this.mMaxMode == 1 && this.measuredChildCount >= this.mMaximum || this.mMaxMode == 0 && lineIndex >= this.mMaximum); ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                ViewGroup.LayoutParams childLayoutParams = child.getLayoutParams();
                int childWidthMeasureSpec = QMUIFloatLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)childLayoutParams.width);
                int childHeightMeasureSpec = QMUIFloatLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)childLayoutParams.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                int childw = child.getMeasuredWidth();
                maxLineHeight = Math.max(maxLineHeight, child.getMeasuredHeight());
                if (childPositionX + childw > childMaxRight) {
                    if (this.mMaxMode == 0 && lineIndex + 1 >= this.mMaximum) break;
                    int n = lineIndex++;
                    this.mWidthSumInEachLine[n] = this.mWidthSumInEachLine[n] - this.mChildHorizontalSpacing;
                    childPositionX = this.getPaddingLeft();
                    childPositionY += maxLineHeight + this.mChildVerticalSpacing;
                }
                int n = lineIndex;
                this.mItemNumberInEachLine[n] = this.mItemNumberInEachLine[n] + 1;
                int n2 = lineIndex;
                this.mWidthSumInEachLine[n2] = this.mWidthSumInEachLine[n2] + (childw + this.mChildHorizontalSpacing);
                childPositionX += childw + this.mChildHorizontalSpacing;
                ++this.measuredChildCount;
            }
            if (this.mWidthSumInEachLine.length > 0 && this.mWidthSumInEachLine[lineIndex] > 0) {
                int n = lineIndex;
                this.mWidthSumInEachLine[n] = this.mWidthSumInEachLine[n] - this.mChildHorizontalSpacing;
            }
            if (heightSpecMode == 0) {
                resultHeight = childPositionY + maxLineHeight + this.getPaddingBottom();
            } else if (heightSpecMode == Integer.MIN_VALUE) {
                resultHeight = childPositionY + maxLineHeight + this.getPaddingBottom();
                resultHeight = Math.min(resultHeight, heightSpecSize);
            } else {
                resultHeight = heightSpecSize;
            }
        } else {
            resultWidth = this.getPaddingLeft() + this.getPaddingRight();
            this.measuredChildCount = 0;
            for (int i = 0; i < count && !(this.mMaxMode != 1 ? this.mMaxMode == 0 && 1 > this.mMaximum : this.measuredChildCount > this.mMaximum); ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                ViewGroup.LayoutParams childLayoutParams = child.getLayoutParams();
                int childWidthMeasureSpec = QMUIFloatLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)childLayoutParams.width);
                int childHeightMeasureSpec = QMUIFloatLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)childLayoutParams.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                resultWidth += child.getMeasuredWidth();
                maxLineHeight = Math.max(maxLineHeight, child.getMeasuredHeight());
                ++this.measuredChildCount;
            }
            if (this.measuredChildCount > 0) {
                resultWidth += this.mChildHorizontalSpacing * (this.measuredChildCount - 1);
            }
            resultHeight = maxLineHeight + this.getPaddingTop() + this.getPaddingBottom();
            if (this.mItemNumberInEachLine.length > 0) {
                this.mItemNumberInEachLine[lineIndex] = count;
            }
            if (this.mWidthSumInEachLine.length > 0) {
                this.mWidthSumInEachLine[0] = resultWidth;
            }
        }
        this.setMeasuredDimension(resultWidth, resultHeight);
        int meausureLineCount = lineIndex + 1;
        if (this.mLineCount != meausureLineCount) {
            if (this.mOnLineCountChangeListener != null) {
                this.mOnLineCountChangeListener.onChange(this.mLineCount, meausureLineCount);
            }
            this.mLineCount = meausureLineCount;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        switch (this.mGravity & 7) {
            case 3: {
                this.layoutWithGravityLeft(width);
                break;
            }
            case 5: {
                this.layoutWithGravityRight(width);
                break;
            }
            case 1: {
                this.layoutWithGravityCenterHorizontal(width);
                break;
            }
            default: {
                this.layoutWithGravityLeft(width);
            }
        }
    }

    private void layoutWithGravityCenterHorizontal(int parentWidth) {
        View childView;
        int nextChildIndex = 0;
        int nextChildPositionY = this.getPaddingTop();
        int lineHeight = 0;
        for (int i = 0; i < this.mItemNumberInEachLine.length && this.mItemNumberInEachLine[i] != 0 && nextChildIndex <= this.measuredChildCount - 1; nextChildIndex += this.mItemNumberInEachLine[i], ++i) {
            int nextChildPositionX = (parentWidth - this.getPaddingLeft() - this.getPaddingRight() - this.mWidthSumInEachLine[i]) / 2 + this.getPaddingLeft();
            for (int j = nextChildIndex; j < nextChildIndex + this.mItemNumberInEachLine[i]; ++j) {
                childView = this.getChildAt(j);
                if (childView.getVisibility() == 8) continue;
                int childw = childView.getMeasuredWidth();
                int childh = childView.getMeasuredHeight();
                childView.layout(nextChildPositionX, nextChildPositionY, nextChildPositionX + childw, nextChildPositionY + childh);
                lineHeight = Math.max(lineHeight, childh);
                nextChildPositionX += childw + this.mChildHorizontalSpacing;
            }
            nextChildPositionY += lineHeight + this.mChildVerticalSpacing;
            lineHeight = 0;
        }
        int childCount = this.getChildCount();
        if (this.measuredChildCount < childCount) {
            for (int i = this.measuredChildCount; i < childCount; ++i) {
                childView = this.getChildAt(i);
                if (childView.getVisibility() == 8) continue;
                childView.layout(0, 0, 0, 0);
            }
        }
    }

    private void layoutWithGravityLeft(int parentWidth) {
        View child;
        int i;
        int childMaxRight = parentWidth - this.getPaddingRight();
        int childPositionX = this.getPaddingLeft();
        int childPositionY = this.getPaddingTop();
        int lineHeight = 0;
        int childCount = this.getChildCount();
        int childCountToLayout = Math.min(childCount, this.measuredChildCount);
        for (i = 0; i < childCountToLayout; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childw = child.getMeasuredWidth();
            int childh = child.getMeasuredHeight();
            if (childPositionX + childw > childMaxRight) {
                childPositionX = this.getPaddingLeft();
                childPositionY += lineHeight + this.mChildVerticalSpacing;
                lineHeight = 0;
            }
            child.layout(childPositionX, childPositionY, childPositionX + childw, childPositionY + childh);
            childPositionX += childw + this.mChildHorizontalSpacing;
            lineHeight = Math.max(lineHeight, childh);
        }
        if (this.measuredChildCount < childCount) {
            for (i = this.measuredChildCount; i < childCount; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                child.layout(0, 0, 0, 0);
            }
        }
    }

    private void layoutWithGravityRight(int parentWidth) {
        View childView;
        int nextChildIndex = 0;
        int nextChildPositionY = this.getPaddingTop();
        int lineHeight = 0;
        for (int i = 0; i < this.mItemNumberInEachLine.length && this.mItemNumberInEachLine[i] != 0 && nextChildIndex <= this.measuredChildCount - 1; nextChildIndex += this.mItemNumberInEachLine[i], ++i) {
            int nextChildPositionX = parentWidth - this.getPaddingRight() - this.mWidthSumInEachLine[i];
            for (int j = nextChildIndex; j < nextChildIndex + this.mItemNumberInEachLine[i]; ++j) {
                childView = this.getChildAt(j);
                if (childView.getVisibility() == 8) continue;
                int childw = childView.getMeasuredWidth();
                int childh = childView.getMeasuredHeight();
                childView.layout(nextChildPositionX, nextChildPositionY, nextChildPositionX + childw, nextChildPositionY + childh);
                lineHeight = Math.max(lineHeight, childh);
                nextChildPositionX += childw + this.mChildHorizontalSpacing;
            }
            nextChildPositionY += lineHeight + this.mChildVerticalSpacing;
            lineHeight = 0;
        }
        int childCount = this.getChildCount();
        if (this.measuredChildCount < childCount) {
            for (int i = this.measuredChildCount; i < childCount; ++i) {
                childView = this.getChildAt(i);
                if (childView.getVisibility() == 8) continue;
                childView.layout(0, 0, 0, 0);
            }
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setMaxNumber(int maxNumber) {
        this.mMaximum = maxNumber;
        this.mMaxMode = 1;
        this.requestLayout();
    }

    public int getMaxNumber() {
        return this.mMaxMode == 1 ? this.mMaximum : -1;
    }

    public void setMaxLines(int maxLines) {
        this.mMaximum = maxLines;
        this.mMaxMode = 0;
        this.requestLayout();
    }

    public void setOnLineCountChangeListener(OnLineCountChangeListener onLineCountChangeListener) {
        this.mOnLineCountChangeListener = onLineCountChangeListener;
    }

    public int getLineCount() {
        return this.mLineCount;
    }

    public int getMaxLines() {
        return this.mMaxMode == 0 ? this.mMaximum : -1;
    }

    public void setChildHorizontalSpacing(int spacing) {
        this.mChildHorizontalSpacing = spacing;
        this.invalidate();
    }

    public void setChildVerticalSpacing(int spacing) {
        this.mChildVerticalSpacing = spacing;
        this.invalidate();
    }

    public static interface OnLineCountChangeListener {
        public void onChange(int var1, int var2);
    }
}

