/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Rect;
import android.os.Build;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.IWindowInsetLayout;
import java.lang.ref.WeakReference;

public class QMUIWindowInsetHelper {
    private final int KEYBOARD_HEIGHT_BOUNDARY;
    private final WeakReference<IWindowInsetLayout> mWindowInsetLayoutWR;

    public QMUIWindowInsetHelper(ViewGroup viewGroup, IWindowInsetLayout windowInsetLayout) {
        this.mWindowInsetLayoutWR = new WeakReference<IWindowInsetLayout>(windowInsetLayout);
        this.KEYBOARD_HEIGHT_BOUNDARY = QMUIDisplayHelper.dp2px(viewGroup.getContext(), 100);
        ViewCompat.setOnApplyWindowInsetsListener((View)viewGroup, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return QMUIWindowInsetHelper.this.setWindowInsets(insets);
            }
        });
    }

    private WindowInsetsCompat setWindowInsets(WindowInsetsCompat insets) {
        if (Build.VERSION.SDK_INT >= 21 && this.mWindowInsetLayoutWR.get() != null && ((IWindowInsetLayout)this.mWindowInsetLayoutWR.get()).applySystemWindowInsets21(insets)) {
            return insets.consumeSystemWindowInsets();
        }
        return insets;
    }

    @TargetApi(value=19)
    public boolean defaultApplySystemWindowInsets19(ViewGroup viewGroup, Rect insets) {
        boolean consumed = false;
        if (insets.bottom >= this.KEYBOARD_HEIGHT_BOUNDARY) {
            QMUIViewHelper.setPaddingBottom((View)viewGroup, insets.bottom);
            insets.bottom = 0;
        } else {
            QMUIViewHelper.setPaddingBottom((View)viewGroup, 0);
        }
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (QMUIWindowInsetHelper.jumpDispatch(child)) continue;
            Rect childInsets = new Rect(insets);
            this.computeInsetsWithGravity(child, childInsets);
            if (!QMUIWindowInsetHelper.isHandleContainer(child)) {
                child.setPadding(childInsets.left, childInsets.top, childInsets.right, childInsets.bottom);
            } else if (child instanceof IWindowInsetLayout) {
                ((IWindowInsetLayout)child).applySystemWindowInsets19(childInsets);
            } else {
                this.defaultApplySystemWindowInsets19((ViewGroup)child, childInsets);
            }
            consumed = true;
        }
        return consumed;
    }

    @TargetApi(value=21)
    public boolean defaultApplySystemWindowInsets21(ViewGroup viewGroup, WindowInsetsCompat insets) {
        if (!insets.hasSystemWindowInsets()) {
            return false;
        }
        boolean consumed = false;
        boolean showKeyboard = false;
        if (insets.getSystemWindowInsetBottom() >= this.KEYBOARD_HEIGHT_BOUNDARY) {
            showKeyboard = true;
            QMUIViewHelper.setPaddingBottom((View)viewGroup, insets.getSystemWindowInsetBottom());
        } else {
            QMUIViewHelper.setPaddingBottom((View)viewGroup, 0);
        }
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (QMUIWindowInsetHelper.jumpDispatch(child)) continue;
            Rect childInsets = new Rect(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), showKeyboard ? 0 : insets.getSystemWindowInsetBottom());
            this.computeInsetsWithGravity(child, childInsets);
            WindowInsetsCompat windowInsetsCompat = ViewCompat.dispatchApplyWindowInsets((View)child, (WindowInsetsCompat)insets.replaceSystemWindowInsets(childInsets));
            if (!windowInsetsCompat.isConsumed()) continue;
            consumed = true;
        }
        return consumed;
    }

    @TargetApi(value=19)
    public static boolean jumpDispatch(View child) {
        return !child.getFitsSystemWindows() && !QMUIWindowInsetHelper.isHandleContainer(child);
    }

    public static boolean isHandleContainer(View child) {
        return child instanceof IWindowInsetLayout || child instanceof CoordinatorLayout;
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void computeInsetsWithGravity(View view, Rect insets) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        int gravity = -1;
        if (lp instanceof FrameLayout.LayoutParams) {
            gravity = ((FrameLayout.LayoutParams)lp).gravity;
        }
        if (gravity == -1) {
            gravity = 51;
        }
        if (lp.width != -1) {
            int horizontalGravity = gravity & 7;
            switch (horizontalGravity) {
                case 3: {
                    insets.right = 0;
                    break;
                }
                case 5: {
                    insets.left = 0;
                }
            }
        }
        if (lp.height != -1) {
            int verticalGravity = gravity & 0x70;
            switch (verticalGravity) {
                case 48: {
                    insets.bottom = 0;
                    break;
                }
                case 80: {
                    insets.top = 0;
                }
            }
        }
    }
}

