/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.qqface;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.link.ITouchableSpan;
import com.qmuiteam.qmui.qqface.QMUIQQFaceCompiler;
import com.qmuiteam.qmui.span.QMUITouchableSpan;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QMUIQQFaceView
extends View {
    private static final String TAG = "QMUIQQFaceView";
    private CharSequence mOriginText;
    private QMUIQQFaceCompiler.ElementList mElementList;
    private QMUIQQFaceCompiler mCompiler;
    private boolean mOpenQQFace = true;
    private TextPaint mPaint;
    private Paint mSpanBgPaint;
    private int mTextSize;
    private int mTextColor;
    private int mLineSpace = -1;
    private int mFontHeight;
    private int mQQFaceSize = 0;
    private int mFirstBaseLine;
    private int mMaxLine = Integer.MAX_VALUE;
    private boolean mIsSingleLine = false;
    private int mLines = 0;
    private Set<SpanInfo> mSpanInfos = new HashSet<SpanInfo>();
    private static final String mEllipsizeText = "...";
    private String mMoreActionText;
    private int mMoreActionColor;
    private int mMoreActionTextLength = 0;
    private int mEllipsizeTextLength = 0;
    private TextUtils.TruncateAt mEllipsize = TextUtils.TruncateAt.END;
    private boolean mIsNeedEllipsize = false;
    private int mNeedDrawLine = 0;
    private int mQQFaceSizeAddon = 0;
    private QQFaceViewListener mListener;
    private int mMaxWidth = Integer.MAX_VALUE;
    private PressCancelAction mPendingPressCancelAction = null;
    private boolean mJumpHandleMeasureAndDraw = false;
    private Runnable mDelayTextSetter = null;
    private boolean mIncludePad = true;
    private Typeface mTypeface = null;
    private int mParagraphSpace = 0;
    private int mSpecialDrawablePadding = 0;
    SpanInfo mTouchSpanInfo = null;
    private boolean needReCalculateFontHeight = true;
    private int mCurrentCalWidth = 0;
    private int mCurrentCalLine = 0;
    private int mContentCalMaxWidth = 0;
    private boolean mNeedReCalculateLines = false;
    private int mLastCalLimitWidth = 0;
    private int mLastCalContentWidth = 0;
    private int mLastCalLines = 0;
    private int mCurrentDrawBaseLine;
    private int mCurrentDrawLine;
    private int mCurrentDrawUsedWidth;
    private boolean mIsInDrawSpan = false;
    private QMUITouchableSpan mCurrentDrawSpan;
    private int mMiddleEllipsizeWidthRecord = -1;
    private boolean mIsExecutedMiddleEllipsize = false;
    private int mLastNeedStopLineRecord = -1;

    public QMUIQQFaceView(Context context) {
        this(context, null);
    }

    public QMUIQQFaceView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUIQQFaceStyle);
    }

    public QMUIQQFaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.QMUIQQFaceView, defStyleAttr, 0);
        this.mQQFaceSizeAddon = -QMUIDisplayHelper.dp2px(context, 2);
        this.mTextSize = array.getDimensionPixelSize(R.styleable.QMUIQQFaceView_android_textSize, QMUIDisplayHelper.dp2px(context, 14));
        this.mTextColor = array.getColor(R.styleable.QMUIQQFaceView_android_textColor, -16777216);
        this.mIsSingleLine = array.getBoolean(R.styleable.QMUIQQFaceView_android_singleLine, false);
        this.mMaxLine = array.getInt(R.styleable.QMUIQQFaceView_android_maxLines, this.mMaxLine);
        int lineSpace = array.getDimensionPixelOffset(R.styleable.QMUIQQFaceView_android_lineSpacingExtra, 0);
        this.setLineSpace(lineSpace);
        int ellipsize = -1;
        ellipsize = array.getInt(R.styleable.QMUIQQFaceView_android_ellipsize, ellipsize);
        switch (ellipsize) {
            case 1: {
                this.mEllipsize = TextUtils.TruncateAt.START;
                break;
            }
            case 2: {
                this.mEllipsize = TextUtils.TruncateAt.MIDDLE;
                break;
            }
            default: {
                this.mEllipsize = TextUtils.TruncateAt.END;
            }
        }
        this.mMaxWidth = array.getDimensionPixelSize(R.styleable.QMUIQQFaceView_android_maxWidth, this.mMaxWidth);
        this.mSpecialDrawablePadding = array.getDimensionPixelSize(R.styleable.QMUIQQFaceView_qmui_special_drawable_padding, 0);
        final String text = array.getString(R.styleable.QMUIQQFaceView_android_text);
        if (!QMUILangHelper.isNullOrEmpty(text)) {
            this.mDelayTextSetter = new Runnable(){

                @Override
                public void run() {
                    QMUIQQFaceView.this.setText(text);
                }
            };
        }
        this.mMoreActionText = array.getString(R.styleable.QMUIQQFaceView_qmui_more_action_text);
        this.mMoreActionColor = array.getColor(R.styleable.QMUIQQFaceView_qmui_more_action_color, this.mTextColor);
        array.recycle();
        this.mPaint = new TextPaint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setColor(this.mTextColor);
        this.mEllipsizeTextLength = (int)Math.ceil(this.mPaint.measureText(mEllipsizeText));
        this.measureMoreActionTextLength();
        this.mSpanBgPaint = new Paint();
        this.mSpanBgPaint.setAntiAlias(true);
        this.mSpanBgPaint.setStyle(Paint.Style.FILL);
    }

    public void setOpenQQFace(boolean openQQFace) {
        this.mOpenQQFace = openQQFace;
    }

    public void setMaxWidth(int maxWidth) {
        if (this.mMaxWidth != maxWidth) {
            this.mMaxWidth = maxWidth;
            this.requestLayout();
        }
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (this.mSpanInfos.isEmpty()) {
            return super.onTouchEvent(event);
        }
        int action = event.getAction();
        if (this.mTouchSpanInfo == null && action != 0) {
            return super.onTouchEvent(event);
        }
        if (this.mPendingPressCancelAction != null) {
            this.mPendingPressCancelAction.run();
            this.mPendingPressCancelAction = null;
        }
        switch (action) {
            case 0: {
                this.mTouchSpanInfo = null;
                for (SpanInfo spanInfo : this.mSpanInfos) {
                    if (!spanInfo.onTouch(x, y)) continue;
                    this.mTouchSpanInfo = spanInfo;
                    break;
                }
                if (this.mTouchSpanInfo == null) {
                    return super.onTouchEvent(event);
                }
                this.mTouchSpanInfo.setPressed(true);
                this.mTouchSpanInfo.invalidateSpan();
                break;
            }
            case 3: {
                this.mPendingPressCancelAction = null;
                this.mTouchSpanInfo.setPressed(false);
                this.mTouchSpanInfo.invalidateSpan();
                break;
            }
            case 2: {
                if (this.mTouchSpanInfo.onTouch(x, y)) break;
                this.mTouchSpanInfo.setPressed(false);
                this.mTouchSpanInfo.invalidateSpan();
                this.mTouchSpanInfo = null;
                break;
            }
            case 1: {
                this.mTouchSpanInfo.onClick();
                this.mPendingPressCancelAction = new PressCancelAction(this.mTouchSpanInfo);
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (QMUIQQFaceView.this.mPendingPressCancelAction != null) {
                            QMUIQQFaceView.this.mPendingPressCancelAction.run();
                        }
                    }
                }, 100L);
            }
        }
        return true;
    }

    public void setCompiler(QMUIQQFaceCompiler compiler) {
        this.mCompiler = compiler;
        if (this.mDelayTextSetter != null) {
            this.mDelayTextSetter.run();
        }
    }

    public void setTypeface(Typeface typeface) {
        if (this.mTypeface != typeface) {
            this.mTypeface = typeface;
            this.needReCalculateFontHeight = true;
            this.mPaint.setTypeface(typeface);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTypeface(Typeface tf, int style) {
        if (style > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style) : Typeface.create((Typeface)tf, (int)style);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style & ~typefaceStyle;
            this.mPaint.setFakeBoldText((need & 1) != 0);
            this.mPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mPaint.setFakeBoldText(false);
            this.mPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    public void setParagraphSpace(int paragraphSpace) {
        if (this.mParagraphSpace != paragraphSpace) {
            this.mParagraphSpace = paragraphSpace;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMoreActionText(String moreActionText) {
        if (this.mMoreActionText == null || !this.mMoreActionText.equals(moreActionText)) {
            this.mMoreActionText = moreActionText;
            this.measureMoreActionTextLength();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMoreActionColor(int color2) {
        if (color2 != this.mMoreActionColor) {
            this.mMoreActionColor = color2;
            this.invalidate();
        }
    }

    private void measureMoreActionTextLength() {
        this.mMoreActionTextLength = QMUILangHelper.isNullOrEmpty(this.mMoreActionText) ? 0 : (int)Math.ceil(this.mPaint.measureText(this.mMoreActionText));
    }

    public void setSpecialDrawablePadding(int specialDrawablePadding) {
        if (this.mSpecialDrawablePadding != specialDrawablePadding) {
            this.mSpecialDrawablePadding = specialDrawablePadding;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setIncludeFontPadding(boolean includepad) {
        if (this.mIncludePad != includepad) {
            this.needReCalculateFontHeight = true;
            this.mIncludePad = includepad;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setQQFaceSizeAddon(int QQFaceSizeAddon) {
        if (this.mQQFaceSizeAddon != QQFaceSizeAddon) {
            this.mQQFaceSizeAddon = QQFaceSizeAddon;
            this.mNeedReCalculateLines = true;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setLineSpace(int lineSpace) {
        if (this.mLineSpace != lineSpace) {
            this.mLineSpace = lineSpace;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        if (this.mEllipsize != where) {
            this.mEllipsize = where;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMaxLine(int maxLine) {
        if (this.mMaxLine != maxLine) {
            this.mMaxLine = maxLine;
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getMaxLine() {
        return this.mMaxLine;
    }

    public int getLineCount() {
        return this.mLines;
    }

    public void setSingleLine(boolean singleLine) {
        if (this.mIsSingleLine != singleLine) {
            this.mIsSingleLine = singleLine;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTextColor(@ColorInt int textColor) {
        if (this.mTextColor != textColor) {
            this.mTextColor = textColor;
            this.mPaint.setColor(textColor);
            this.invalidate();
        }
    }

    public TextPaint getPaint() {
        return this.mPaint;
    }

    public void setTextSize(int textSize) {
        if (this.mTextSize != textSize) {
            this.mTextSize = textSize;
            this.mPaint.setTextSize((float)this.mTextSize);
            this.needReCalculateFontHeight = true;
            this.mNeedReCalculateLines = true;
            this.mEllipsizeTextLength = (int)Math.ceil(this.mPaint.measureText(mEllipsizeText));
            this.measureMoreActionTextLength();
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public CharSequence getText() {
        return this.mOriginText;
    }

    public void setText(CharSequence charSequence) {
        this.mDelayTextSetter = null;
        CharSequence oldText = this.mOriginText;
        if (this.mOriginText != null && this.mOriginText.equals(charSequence)) {
            return;
        }
        this.mOriginText = charSequence;
        if (this.mOpenQQFace && this.mCompiler == null) {
            throw new RuntimeException("mCompiler == null");
        }
        if (QMUILangHelper.isNullOrEmpty(this.mOriginText)) {
            if (!QMUILangHelper.isNullOrEmpty(oldText)) {
                this.mElementList = null;
                this.requestLayout();
                this.invalidate();
            }
            return;
        }
        if (this.mOpenQQFace && this.mCompiler != null) {
            this.mElementList = this.mCompiler.compile(this.mOriginText);
        } else {
            this.mElementList = new QMUIQQFaceCompiler.ElementList(0, this.mOriginText.length());
            String[] strings = this.mOriginText.toString().split("\\n");
            for (int i = 0; i < strings.length; ++i) {
                this.mElementList.add(QMUIQQFaceCompiler.Element.createTextElement(strings[i]));
                if (i == strings.length - 1) continue;
                this.mElementList.add(QMUIQQFaceCompiler.Element.createNextLineElement());
            }
        }
        this.mNeedReCalculateLines = true;
        int paddingHor = this.getPaddingLeft() + this.getPaddingRight();
        if (this.getLayoutParams() == null) {
            return;
        }
        if (this.getLayoutParams().width == -2) {
            this.requestLayout();
            this.invalidate();
            return;
        }
        if (this.getWidth() > paddingHor) {
            this.mLines = 0;
            this.calculateLinesAndContentWidth(this.getWidth());
            int oldDrawLine = this.mNeedDrawLine;
            this.calculateNeedDrawLine();
            if (oldDrawLine == this.mNeedDrawLine || this.getLayoutParams().height != -2) {
                this.invalidate();
            } else {
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private void calculateFontHeight() {
        if (this.needReCalculateFontHeight) {
            Paint.FontMetricsInt fontMetricsInt = this.mPaint.getFontMetricsInt();
            if (fontMetricsInt == null) {
                this.mQQFaceSize = 0;
                this.mFontHeight = 0;
            } else {
                this.needReCalculateFontHeight = false;
                int top = this.getFontHeightCalTop(fontMetricsInt, this.mIncludePad);
                int bottom = this.getFontHeightCalBottom(fontMetricsInt, this.mIncludePad);
                int fontHeight = bottom - top;
                this.mQQFaceSize = fontHeight + this.mQQFaceSizeAddon;
                int specialMaxDrawableHeight = this.mCompiler.getSpecialBoundsMaxHeight();
                int drawableSize = Math.max(this.mQQFaceSize, specialMaxDrawableHeight);
                if (fontHeight >= drawableSize) {
                    this.mFontHeight = fontHeight;
                    this.mFirstBaseLine = -top;
                } else {
                    this.mFontHeight = drawableSize;
                    this.mFirstBaseLine = -top + (this.mFontHeight - drawableSize) / 2;
                }
            }
        }
    }

    protected int getFontHeightCalTop(Paint.FontMetricsInt fontMetricsInt, boolean includePad) {
        return includePad ? fontMetricsInt.top : fontMetricsInt.ascent;
    }

    protected int getFontHeightCalBottom(Paint.FontMetricsInt fontMetricsInt, boolean includePad) {
        return includePad ? fontMetricsInt.bottom : fontMetricsInt.descent;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.getPaddingLeft() != left || this.getPaddingRight() != right) {
            this.mNeedReCalculateLines = true;
        }
        super.setPadding(left, top, right, bottom);
    }

    private int calculateLinesAndContentWidth(int limitWidth) {
        if (limitWidth <= this.getPaddingRight() + this.getPaddingLeft() || this.isElementEmpty()) {
            this.mLines = 0;
            this.mLastCalLines = 0;
            this.mLastCalContentWidth = 0;
            return this.mLastCalContentWidth;
        }
        if (!this.mNeedReCalculateLines && this.mLastCalLimitWidth == limitWidth) {
            this.mLines = this.mLastCalLines;
            return this.mLastCalContentWidth;
        }
        this.mLastCalLimitWidth = limitWidth;
        List<QMUIQQFaceCompiler.Element> elements = this.mElementList.getElements();
        this.mSpanInfos.clear();
        this.mCurrentCalLine = 1;
        this.mCurrentCalWidth = this.getPaddingLeft();
        this.calculateLinesInner(elements, limitWidth);
        if (this.mCurrentCalLine != this.mLines) {
            if (this.mListener != null) {
                this.mListener.onCalculateLinesChange(this.mCurrentCalLine);
            }
            this.mLines = this.mCurrentCalLine;
        }
        this.mLastCalContentWidth = this.mLines == 1 ? this.mCurrentCalWidth + this.getPaddingRight() : limitWidth;
        this.mLastCalLines = this.mLines;
        return this.mLastCalContentWidth;
    }

    private void calculateNeedDrawLine() {
        this.mNeedDrawLine = this.mLines;
        if (this.mIsSingleLine) {
            this.mNeedDrawLine = Math.min(1, this.mLines);
        } else if (this.mMaxLine < this.mLines) {
            this.mNeedDrawLine = this.mMaxLine;
        }
        this.mIsNeedEllipsize = this.mLines > this.mNeedDrawLine;
    }

    private void calculateLinesInner(List<QMUIQQFaceCompiler.Element> elements, int limitWidth) {
        int widthStart = this.getPaddingLeft();
        int widthEnd = limitWidth - this.getPaddingRight();
        for (int i = 0; !(i >= elements.size() || this.mJumpHandleMeasureAndDraw || this.mCurrentCalLine > this.mMaxLine && this.mEllipsize == TextUtils.TruncateAt.END && Build.VERSION.SDK_INT < 21); ++i) {
            QMUIQQFaceCompiler.Element element = elements.get(i);
            if (element.getType() == QMUIQQFaceCompiler.ElementType.DRAWABLE) {
                if (this.mCurrentCalWidth + this.mQQFaceSize > widthEnd) {
                    this.gotoCalNextLine(widthStart);
                    this.mCurrentCalWidth += this.mQQFaceSize;
                } else if (this.mCurrentCalWidth + this.mQQFaceSize == widthEnd) {
                    this.gotoCalNextLine(widthStart);
                } else {
                    this.mCurrentCalWidth += this.mQQFaceSize;
                }
                if (widthEnd - widthStart >= this.mQQFaceSize) continue;
                this.mJumpHandleMeasureAndDraw = true;
                continue;
            }
            if (element.getType() == QMUIQQFaceCompiler.ElementType.TEXT) {
                CharSequence text = element.getText();
                this.measureText(text, widthStart, widthEnd);
                continue;
            }
            if (element.getType() == QMUIQQFaceCompiler.ElementType.SPAN) {
                QMUIQQFaceCompiler.ElementList spanElementList = element.getChildList();
                QMUITouchableSpan span = element.getTouchableSpan();
                if (spanElementList == null || spanElementList.getElements().size() <= 0) continue;
                if (span == null) {
                    this.calculateLinesInner(spanElementList.getElements(), limitWidth);
                    continue;
                }
                SpanInfo spanInfo = new SpanInfo(span);
                spanInfo.setStart(this.mCurrentCalLine, this.mCurrentCalWidth);
                this.calculateLinesInner(spanElementList.getElements(), limitWidth);
                spanInfo.setEnd(this.mCurrentCalLine, this.mCurrentCalWidth);
                this.mSpanInfos.add(spanInfo);
                continue;
            }
            if (element.getType() == QMUIQQFaceCompiler.ElementType.NEXTLINE) {
                this.gotoCalNextLine(widthStart);
                continue;
            }
            if (element.getType() != QMUIQQFaceCompiler.ElementType.SPECIAL_BOUNDS_DRAWABLE) continue;
            Drawable drawable = element.getSpecialBoundsDrawable();
            int width = drawable.getIntrinsicWidth();
            width = i == 0 || i == elements.size() - 1 ? (width += this.mSpecialDrawablePadding) : (width += this.mSpecialDrawablePadding * 2);
            if (this.mCurrentCalWidth + width > widthEnd) {
                this.gotoCalNextLine(widthStart);
                this.mCurrentCalWidth += width;
            } else if (this.mCurrentCalWidth + width == widthEnd) {
                this.gotoCalNextLine(widthStart);
            } else {
                this.mCurrentCalWidth += width;
            }
            if (widthEnd - widthStart >= width) continue;
            this.mJumpHandleMeasureAndDraw = true;
        }
    }

    private boolean isElementEmpty() {
        return this.mElementList == null || this.mElementList.getElements() == null || this.mElementList.getElements().isEmpty();
    }

    private void setContentCalMaxWidth(int width) {
        this.mContentCalMaxWidth = Math.max(width, this.mContentCalMaxWidth);
    }

    private void gotoCalNextLine(int widthStart) {
        ++this.mCurrentCalLine;
        this.setContentCalMaxWidth(this.mCurrentCalWidth);
        this.mCurrentCalWidth = widthStart;
    }

    private void measureText(CharSequence text, int widthStart, int widthEnd) {
        float[] widths = new float[text.length()];
        this.mPaint.getTextWidths(text.toString(), widths);
        int contentWidth = widthEnd - widthStart;
        long loop_start = System.currentTimeMillis();
        for (int i = 0; i < widths.length; ++i) {
            if ((float)contentWidth < widths[i]) {
                this.mJumpHandleMeasureAndDraw = true;
                return;
            }
            if (System.currentTimeMillis() - loop_start > 2000L) {
                QMUILog.d(TAG, "measureText: text = %s, mCurrentCalWidth = %d, widthStart = %d, widthEnd = %d", text, this.mCurrentCalWidth, widthStart, widthEnd);
                this.mJumpHandleMeasureAndDraw = true;
                break;
            }
            if ((float)this.mCurrentCalWidth + widths[i] > (float)widthEnd) {
                this.gotoCalNextLine(widthStart);
            }
            this.mCurrentCalWidth = (int)((double)this.mCurrentCalWidth + Math.ceil(widths[i]));
        }
    }

    public void setListener(QQFaceViewListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        long start = System.currentTimeMillis();
        this.mJumpHandleMeasureAndDraw = false;
        this.calculateFontHeight();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Log.i((String)TAG, (String)("widthSize = " + widthSize + "; heightSize = " + heightSize));
        this.mLines = 0;
        switch (widthMode) {
            default: {
                if (this.mOriginText == null || this.mOriginText.length() == 0) {
                    width = 0;
                    break;
                }
                width = this.calculateLinesAndContentWidth(Math.min(widthSize, this.mMaxWidth));
                break;
            }
            case 0: 
            case 0x40000000: {
                width = widthSize;
                this.calculateLinesAndContentWidth(width);
            }
        }
        if (this.mJumpHandleMeasureAndDraw) {
            this.setMeasuredDimension(width, heightMode == Integer.MIN_VALUE ? 0 : heightSize);
            return;
        }
        this.calculateNeedDrawLine();
        switch (heightMode) {
            default: {
                height = this.getPaddingTop() + this.getPaddingBottom();
                if (this.mNeedDrawLine < 2) {
                    height += this.mNeedDrawLine * this.mFontHeight;
                    break;
                }
                height += (this.mNeedDrawLine - 1) * (this.mFontHeight + this.mLineSpace) + this.mFontHeight;
                break;
            }
            case 0x40000000: {
                height = heightSize;
            }
        }
        this.setMeasuredDimension(width, height);
        Log.i((String)TAG, (String)("mLines = " + this.mLines + " ; width = " + width + " ; height = " + height + "; measure time = " + (System.currentTimeMillis() - start)));
    }

    protected void onDraw(Canvas canvas) {
        if (this.mJumpHandleMeasureAndDraw || this.mOriginText == null || this.mLines == 0 || this.isElementEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        List<QMUIQQFaceCompiler.Element> elements = this.mElementList.getElements();
        this.mCurrentDrawBaseLine = this.getPaddingTop() + this.mFirstBaseLine;
        this.mCurrentDrawLine = 1;
        this.mCurrentDrawUsedWidth = this.getPaddingLeft();
        this.mIsExecutedMiddleEllipsize = false;
        this.drawElements(canvas, elements, this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
        Log.i((String)TAG, (String)("onDraw spend time = " + (System.currentTimeMillis() - start)));
    }

    private void drawElements(Canvas canvas, List<QMUIQQFaceCompiler.Element> elements, int usefulWidth) {
        int startLeft = this.getPaddingLeft();
        int endWidth = usefulWidth + startLeft;
        if (this.mIsNeedEllipsize && this.mEllipsize == TextUtils.TruncateAt.START) {
            canvas.drawText(mEllipsizeText, 0, mEllipsizeText.length(), (float)startLeft, (float)this.mFirstBaseLine, (Paint)this.mPaint);
        }
        for (int i = 0; i < elements.size(); ++i) {
            QMUIQQFaceCompiler.Element element = elements.get(i);
            QMUIQQFaceCompiler.ElementType type = element.getType();
            if (type == QMUIQQFaceCompiler.ElementType.DRAWABLE) {
                this.onDrawQQFace(canvas, element.getDrawableRes(), null, startLeft, endWidth, i == 0, i == elements.size() - 1);
                continue;
            }
            if (type == QMUIQQFaceCompiler.ElementType.SPECIAL_BOUNDS_DRAWABLE) {
                this.onDrawQQFace(canvas, 0, element.getSpecialBoundsDrawable(), startLeft, endWidth, i == 0, i == elements.size() - 1);
                continue;
            }
            if (type == QMUIQQFaceCompiler.ElementType.TEXT) {
                CharSequence text = element.getText();
                this.onDrawText(canvas, text, startLeft, endWidth);
                continue;
            }
            if (type == QMUIQQFaceCompiler.ElementType.SPAN) {
                QMUIQQFaceCompiler.ElementList spanElementList = element.getChildList();
                this.mCurrentDrawSpan = element.getTouchableSpan();
                if (spanElementList == null || spanElementList.getElements().isEmpty()) continue;
                if (this.mCurrentDrawSpan == null) {
                    this.drawElements(canvas, spanElementList.getElements(), usefulWidth);
                    continue;
                }
                this.mIsInDrawSpan = true;
                int spanColor = this.mCurrentDrawSpan.isPressed() ? this.mCurrentDrawSpan.getPressedTextColor() : this.mCurrentDrawSpan.getNormalTextColor();
                this.mPaint.setColor(spanColor == 0 ? this.mTextColor : spanColor);
                this.drawElements(canvas, spanElementList.getElements(), usefulWidth);
                this.mPaint.setColor(this.mTextColor);
                this.mIsInDrawSpan = false;
                continue;
            }
            if (type != QMUIQQFaceCompiler.ElementType.NEXTLINE) continue;
            int ellipsizeLength = this.mEllipsizeTextLength + this.mMoreActionTextLength;
            if (this.mIsNeedEllipsize && this.mEllipsize == TextUtils.TruncateAt.END && this.mCurrentDrawUsedWidth <= endWidth - ellipsizeLength && this.mCurrentDrawLine == this.mNeedDrawLine) {
                this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                this.drawMoreActionText(canvas);
                return;
            }
            this.toNewDrawLine(startLeft, true);
        }
    }

    private void drawMoreActionText(Canvas canvas) {
        if (!QMUILangHelper.isNullOrEmpty(this.mMoreActionText)) {
            this.mPaint.setColor(this.mMoreActionColor);
            canvas.drawText(this.mMoreActionText, 0, this.mMoreActionText.length(), (float)this.mCurrentDrawUsedWidth, (float)this.mCurrentDrawBaseLine, (Paint)this.mPaint);
            this.mPaint.setColor(this.mTextColor);
        }
    }

    private void toNewDrawLine(int startLeft) {
        this.toNewDrawLine(startLeft, false);
    }

    private void toNewDrawLine(int startLeft, boolean paragraph) {
        int addOn = (paragraph ? this.mParagraphSpace : 0) + this.mLineSpace;
        ++this.mCurrentDrawLine;
        if (this.mIsNeedEllipsize) {
            if (this.mEllipsize == TextUtils.TruncateAt.START) {
                if (this.mCurrentDrawLine > this.mLines - this.mNeedDrawLine + 1) {
                    this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
                }
            } else if (this.mEllipsize == TextUtils.TruncateAt.MIDDLE) {
                if (!this.mIsExecutedMiddleEllipsize || this.mMiddleEllipsizeWidthRecord == -1) {
                    this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
                }
            } else {
                this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
            }
        } else {
            this.mCurrentDrawBaseLine += this.mFontHeight + addOn;
        }
        this.mCurrentDrawUsedWidth = startLeft;
    }

    private void onRealDrawText(Canvas canvas, CharSequence text, int widthStart, int widthEnd) {
        int textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, text.length()));
        while (textWidth + this.mCurrentDrawUsedWidth > widthEnd) {
            int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(widthEnd - this.mCurrentDrawUsedWidth), null);
            this.drawText(canvas, text, 0, breakPoint, widthEnd - this.mCurrentDrawUsedWidth);
            this.toNewDrawLine(widthStart);
            text = text.subSequence(breakPoint, text.length());
            textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, text.length()));
        }
        this.drawText(canvas, text, 0, text.length(), textWidth);
        this.mCurrentDrawUsedWidth += textWidth;
    }

    private int getMiddleEllipsizeLine() {
        int ellipsizeLine = this.mNeedDrawLine % 2 == 0 ? this.mNeedDrawLine / 2 : (this.mNeedDrawLine + 1) / 2;
        return ellipsizeLine;
    }

    private void onDrawText(Canvas canvas, CharSequence text, int widthStart, int widthEnd) {
        if (this.mIsNeedEllipsize) {
            if (this.mEllipsize == TextUtils.TruncateAt.START) {
                if (this.mCurrentDrawLine > this.mLines - this.mNeedDrawLine) {
                    this.onRealDrawText(canvas, text, widthStart, widthEnd);
                } else if (this.mCurrentDrawLine < this.mLines - this.mNeedDrawLine) {
                    int textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, text.length()));
                    if (textWidth + this.mCurrentDrawUsedWidth > widthEnd) {
                        int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(widthEnd - this.mCurrentDrawUsedWidth), null);
                        this.toNewDrawLine(widthStart);
                        this.onDrawText(canvas, text.subSequence(breakPoint, text.length()), widthStart, widthEnd);
                    } else {
                        this.mCurrentDrawUsedWidth += textWidth;
                    }
                } else {
                    int needStopWidth;
                    int textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, text.length()));
                    if (textWidth + this.mCurrentDrawUsedWidth < (needStopWidth = this.mCurrentCalWidth + this.mEllipsizeTextLength + QMUIDisplayHelper.dp2px(this.getContext(), 5))) {
                        this.mCurrentDrawUsedWidth += textWidth;
                    } else if (textWidth + this.mCurrentDrawUsedWidth == needStopWidth) {
                        this.toNewDrawLine(widthStart + this.mEllipsizeTextLength);
                    } else {
                        int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(needStopWidth - this.mCurrentDrawUsedWidth), null);
                        this.toNewDrawLine(widthStart + this.mEllipsizeTextLength);
                        this.onDrawText(canvas, text.subSequence(breakPoint, text.length()), widthStart, widthEnd);
                    }
                }
            } else if (this.mEllipsize == TextUtils.TruncateAt.MIDDLE) {
                int ellipsizeLine = this.getMiddleEllipsizeLine();
                int textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, text.length()));
                if (this.mCurrentDrawLine < ellipsizeLine) {
                    if (textWidth + this.mCurrentDrawUsedWidth > widthEnd) {
                        int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(widthEnd - this.mCurrentDrawUsedWidth), null);
                        this.drawText(canvas, text, 0, breakPoint, widthEnd - this.mCurrentDrawUsedWidth);
                        this.toNewDrawLine(widthStart);
                        text = text.subSequence(breakPoint, text.length());
                        this.onDrawText(canvas, text, widthStart, widthEnd);
                    } else {
                        this.drawText(canvas, text, 0, text.length(), textWidth);
                        this.mCurrentDrawUsedWidth += textWidth;
                    }
                } else if (this.mCurrentDrawLine == ellipsizeLine) {
                    int needStop = this.getWidth() / 2 - this.mEllipsizeTextLength / 2;
                    if (this.mIsExecutedMiddleEllipsize) {
                        this.handleTextAfterMiddleEllipsize(canvas, text, widthStart, widthEnd, ellipsizeLine, textWidth);
                    } else if (textWidth + this.mCurrentDrawUsedWidth < needStop) {
                        this.drawText(canvas, text, 0, text.length(), textWidth);
                        this.mCurrentDrawUsedWidth += textWidth;
                    } else if (textWidth + this.mCurrentDrawUsedWidth == needStop) {
                        this.drawText(canvas, text, 0, text.length(), textWidth);
                        this.mCurrentDrawUsedWidth += textWidth;
                        this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                        this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                        this.mMiddleEllipsizeWidthRecord = this.mCurrentDrawUsedWidth;
                        this.mIsExecutedMiddleEllipsize = true;
                    } else {
                        int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(needStop - this.mCurrentDrawUsedWidth), null);
                        textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, breakPoint));
                        this.drawText(canvas, text, 0, breakPoint, textWidth);
                        this.mCurrentDrawUsedWidth += textWidth;
                        this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                        this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                        this.mMiddleEllipsizeWidthRecord = this.mCurrentDrawUsedWidth;
                        this.mIsExecutedMiddleEllipsize = true;
                        if (breakPoint < text.length()) {
                            text = text.subSequence(breakPoint, text.length());
                            textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, text.length()));
                            this.handleTextAfterMiddleEllipsize(canvas, text, widthStart, widthEnd, ellipsizeLine, textWidth);
                        }
                    }
                } else {
                    this.handleTextAfterMiddleEllipsize(canvas, text, widthStart, widthEnd, ellipsizeLine, textWidth);
                }
            } else {
                int textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, text.length()));
                if (this.mCurrentDrawLine == this.mNeedDrawLine) {
                    int ellipsizeLength = this.mEllipsizeTextLength + this.mMoreActionTextLength;
                    if (textWidth + this.mCurrentDrawUsedWidth >= widthEnd - ellipsizeLength) {
                        if (textWidth + this.mCurrentDrawUsedWidth > widthEnd - ellipsizeLength) {
                            int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(widthEnd - this.mCurrentDrawUsedWidth - ellipsizeLength), null);
                            this.drawText(canvas, text, 0, breakPoint, textWidth);
                            textWidth = (int)Math.ceil(this.mPaint.measureText(text, 0, breakPoint));
                            this.mCurrentDrawUsedWidth += textWidth;
                        } else {
                            this.drawText(canvas, text, 0, text.length(), textWidth);
                            this.mCurrentDrawUsedWidth += textWidth;
                        }
                        this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                        this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                        this.drawMoreActionText(canvas);
                        this.toNewDrawLine(widthStart);
                    } else {
                        this.drawText(canvas, text, 0, text.length(), textWidth);
                        this.mCurrentDrawUsedWidth += textWidth;
                    }
                } else if (this.mCurrentDrawLine < this.mNeedDrawLine) {
                    if (textWidth + this.mCurrentDrawUsedWidth > widthEnd) {
                        int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(widthEnd - this.mCurrentDrawUsedWidth), null);
                        this.drawText(canvas, text, 0, breakPoint, widthEnd - this.mCurrentDrawUsedWidth);
                        this.toNewDrawLine(widthStart);
                        text = text.subSequence(breakPoint, text.length());
                        this.onDrawText(canvas, text, widthStart, widthEnd);
                    } else {
                        this.drawText(canvas, text, 0, text.length(), textWidth);
                        this.mCurrentDrawUsedWidth += textWidth;
                    }
                }
            }
        } else {
            this.onRealDrawText(canvas, text, widthStart, widthEnd);
        }
    }

    private void handleTextAfterMiddleEllipsize(Canvas canvas, CharSequence text, int widthStart, int widthEnd, int ellipsizeLine, int textWidth) {
        if (this.mMiddleEllipsizeWidthRecord == -1) {
            this.onRealDrawText(canvas, text, widthStart, widthEnd);
            return;
        }
        int endLines = this.mNeedDrawLine - ellipsizeLine;
        int borrowWidth = widthEnd - this.mMiddleEllipsizeWidthRecord - this.mCurrentCalWidth;
        int needStopLine = borrowWidth > 0 ? this.mLines - endLines - 1 : this.mLines - endLines;
        int needStopWidth = (borrowWidth > 0 ? widthEnd - borrowWidth : this.mMiddleEllipsizeWidthRecord - (widthEnd - this.mCurrentCalWidth)) + QMUIDisplayHelper.dp2px(this.getContext(), 5);
        if (this.mCurrentDrawLine < needStopLine) {
            if (textWidth + this.mCurrentDrawUsedWidth > widthEnd) {
                int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(widthEnd - this.mCurrentDrawUsedWidth), null);
                this.toNewDrawLine(widthStart);
                this.onDrawText(canvas, text.subSequence(breakPoint, text.length()), widthStart, widthEnd);
            } else {
                this.mCurrentDrawUsedWidth += textWidth;
            }
        } else if (this.mCurrentDrawLine == needStopLine) {
            if (textWidth + this.mCurrentDrawUsedWidth < needStopWidth) {
                this.mCurrentDrawUsedWidth += textWidth;
            } else if (textWidth + this.mCurrentDrawUsedWidth == needStopWidth) {
                this.mCurrentDrawUsedWidth = this.mMiddleEllipsizeWidthRecord;
                this.mMiddleEllipsizeWidthRecord = -1;
                this.mLastNeedStopLineRecord = needStopLine;
            } else {
                int breakPoint = this.mPaint.breakText(text, 0, text.length(), true, (float)(needStopWidth - this.mCurrentDrawUsedWidth), null);
                this.mCurrentDrawUsedWidth = this.mMiddleEllipsizeWidthRecord;
                this.mMiddleEllipsizeWidthRecord = -1;
                this.mLastNeedStopLineRecord = needStopLine;
                this.onRealDrawText(canvas, text.subSequence(breakPoint, text.length()), widthStart, widthEnd);
            }
        } else {
            this.onRealDrawText(canvas, text, widthStart, widthEnd);
        }
    }

    private void drawText(Canvas canvas, CharSequence text, int start, int end, int textWidth) {
        if (this.mIsInDrawSpan && this.mCurrentDrawSpan != null) {
            int color2;
            int n = color2 = this.mCurrentDrawSpan.isPressed() ? this.mCurrentDrawSpan.getPressedBackgroundColor() : this.mCurrentDrawSpan.getNormalBackgroundColor();
            if (color2 != 0) {
                this.mSpanBgPaint.setColor(color2);
                canvas.drawRect((float)this.mCurrentDrawUsedWidth, (float)(this.mCurrentDrawBaseLine - this.mFirstBaseLine), (float)(this.mCurrentDrawUsedWidth + textWidth), (float)(this.mCurrentDrawBaseLine - this.mFirstBaseLine + this.mFontHeight), this.mSpanBgPaint);
            }
        }
        canvas.drawText(text, start, end, (float)this.mCurrentDrawUsedWidth, (float)this.mCurrentDrawBaseLine, (Paint)this.mPaint);
    }

    private void onDrawQQFace(Canvas canvas, int res, Drawable specialDrawable, int widthStart, int widthEnd, boolean isFirst, boolean isLast) {
        int size;
        int n = res != -1 ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (this.mIsNeedEllipsize) {
            if (this.mEllipsize == TextUtils.TruncateAt.START) {
                if (this.mCurrentDrawLine > this.mLines - this.mNeedDrawLine) {
                    this.onRealDrawQQFace(canvas, res, specialDrawable, this.mNeedDrawLine - this.mLines, widthStart, widthEnd, isFirst, isLast);
                } else if (this.mCurrentDrawLine < this.mLines - this.mNeedDrawLine) {
                    if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                        this.toNewDrawLine(widthStart);
                        this.onDrawQQFace(canvas, res, specialDrawable, widthStart, widthEnd, isFirst, isLast);
                    } else {
                        this.mCurrentDrawUsedWidth += size;
                    }
                } else {
                    int needStopWidth = this.mCurrentCalWidth + this.mEllipsizeTextLength;
                    if (size + this.mCurrentDrawUsedWidth < needStopWidth) {
                        this.mCurrentDrawUsedWidth += size;
                    } else {
                        this.toNewDrawLine(widthStart + this.mEllipsizeTextLength);
                    }
                }
            } else if (this.mEllipsize == TextUtils.TruncateAt.MIDDLE) {
                int ellipsizeLine = this.getMiddleEllipsizeLine();
                if (this.mCurrentDrawLine < ellipsizeLine) {
                    if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                        this.onRealDrawQQFace(canvas, res, specialDrawable, 0, widthStart, widthEnd, isFirst, isLast);
                    } else {
                        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                        this.mCurrentDrawUsedWidth += size;
                    }
                } else if (this.mCurrentDrawLine == ellipsizeLine) {
                    int needStop = this.getWidth() / 2 - this.mEllipsizeTextLength / 2;
                    if (this.mIsExecutedMiddleEllipsize) {
                        this.handleQQFaceAfterMiddleEllipsize(canvas, res, specialDrawable, widthStart, widthEnd, ellipsizeLine, isFirst, isLast);
                    } else if (size + this.mCurrentDrawUsedWidth < needStop) {
                        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                        this.mCurrentDrawUsedWidth += size;
                    } else if (size + this.mCurrentDrawUsedWidth == needStop) {
                        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                        this.mCurrentDrawUsedWidth += size;
                        this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                        this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                        this.mMiddleEllipsizeWidthRecord = this.mCurrentDrawUsedWidth;
                        this.mIsExecutedMiddleEllipsize = true;
                    } else {
                        this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                        this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                        this.mMiddleEllipsizeWidthRecord = this.mCurrentDrawUsedWidth;
                        this.mIsExecutedMiddleEllipsize = true;
                    }
                } else {
                    this.handleQQFaceAfterMiddleEllipsize(canvas, res, specialDrawable, widthStart, widthEnd, ellipsizeLine, isFirst, isLast);
                }
            } else if (this.mCurrentDrawLine == this.mNeedDrawLine) {
                int ellipsizeLength = this.mEllipsizeTextLength + this.mMoreActionTextLength;
                if (size + this.mCurrentDrawUsedWidth >= widthEnd - ellipsizeLength) {
                    if (size + this.mCurrentDrawUsedWidth == widthEnd - ellipsizeLength) {
                        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                        this.mCurrentDrawUsedWidth += size;
                    }
                    this.drawText(canvas, mEllipsizeText, 0, mEllipsizeText.length(), this.mEllipsizeTextLength);
                    this.mCurrentDrawUsedWidth += this.mEllipsizeTextLength;
                    this.drawMoreActionText(canvas);
                    this.toNewDrawLine(widthStart);
                } else {
                    this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                    this.mCurrentDrawUsedWidth += size;
                }
            } else if (this.mCurrentDrawLine < this.mNeedDrawLine) {
                if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                    this.onRealDrawQQFace(canvas, res, specialDrawable, 0, widthStart, widthEnd, isFirst, isLast);
                } else {
                    this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine, isFirst, isLast);
                    this.mCurrentDrawUsedWidth += size;
                }
            }
        } else {
            this.onRealDrawQQFace(canvas, res, specialDrawable, 0, widthStart, widthEnd, isFirst, isLast);
        }
    }

    private void handleQQFaceAfterMiddleEllipsize(Canvas canvas, int res, Drawable specialDrawable, int widthStart, int widthEnd, int ellipsizeLine, boolean isFirst, boolean isLast) {
        int size;
        int n = res != 0 ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (this.mMiddleEllipsizeWidthRecord == -1) {
            this.onRealDrawQQFace(canvas, res, specialDrawable, ellipsizeLine - this.mLastNeedStopLineRecord, widthStart, widthEnd, isFirst, isLast);
            return;
        }
        int endLines = this.mNeedDrawLine - ellipsizeLine;
        int borrowWidth = widthEnd - this.mMiddleEllipsizeWidthRecord - this.mCurrentCalWidth;
        int needStopLine = borrowWidth > 0 ? this.mLines - endLines - 1 : this.mLines - endLines;
        int needStopWidth = (borrowWidth > 0 ? widthEnd - borrowWidth : this.mMiddleEllipsizeWidthRecord - (widthEnd - this.mCurrentCalWidth)) + QMUIDisplayHelper.dp2px(this.getContext(), 5);
        if (this.mCurrentDrawLine < needStopLine) {
            if (size + this.mCurrentDrawUsedWidth > widthEnd) {
                this.toNewDrawLine(widthStart);
                this.onDrawQQFace(canvas, res, specialDrawable, widthStart, widthEnd, isFirst, isLast);
            } else {
                this.mCurrentDrawUsedWidth += size;
            }
        } else if (this.mCurrentDrawLine == needStopLine) {
            if (size + this.mCurrentDrawUsedWidth < needStopWidth) {
                this.mCurrentDrawUsedWidth += size;
            } else {
                this.mCurrentDrawUsedWidth = this.mMiddleEllipsizeWidthRecord;
                this.mMiddleEllipsizeWidthRecord = -1;
                this.mLastNeedStopLineRecord = needStopLine;
            }
        } else {
            this.onRealDrawQQFace(canvas, res, specialDrawable, ellipsizeLine - needStopLine, widthStart, widthEnd, isFirst, isLast);
        }
    }

    private void onRealDrawQQFace(Canvas canvas, int res, Drawable specialDrawable, int adjustLine, int widthStart, int widthEnd, boolean isFirst, boolean isLast) {
        int size;
        int n = res != 0 ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (this.mCurrentDrawUsedWidth + size > widthEnd) {
            this.toNewDrawLine(widthStart);
        }
        this.drawQQFace(canvas, res, specialDrawable, this.mCurrentDrawLine + adjustLine, isFirst, isLast);
        this.mCurrentDrawUsedWidth += size;
    }

    private void drawQQFace(Canvas canvas, int res, Drawable specialDrawable, int line, boolean isFirst, boolean isLast) {
        int size;
        Drawable drawable;
        Drawable drawable2 = drawable = res != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)res) : specialDrawable;
        int n = res != 0 ? this.mQQFaceSize : (size = specialDrawable.getIntrinsicWidth() + (isFirst || isLast ? this.mSpecialDrawablePadding : this.mSpecialDrawablePadding * 2));
        if (drawable == null) {
            return;
        }
        if (res != 0) {
            int drawableTop = (this.mFontHeight - this.mQQFaceSize) / 2;
            drawable.setBounds(0, drawableTop, this.mQQFaceSize, drawableTop + this.mQQFaceSize);
        } else {
            int drawableTop = (this.mFontHeight - drawable.getIntrinsicHeight()) / 2;
            int left = isLast ? this.mSpecialDrawablePadding : 0;
            drawable.setBounds(left, drawableTop, left + drawable.getIntrinsicWidth(), drawableTop + drawable.getIntrinsicHeight());
        }
        int top = this.getPaddingTop();
        if (line > 1) {
            top = (line - 1) * (this.mFontHeight + this.mLineSpace) + top;
        }
        canvas.save();
        canvas.translate((float)this.mCurrentDrawUsedWidth, (float)top);
        if (this.mIsInDrawSpan && this.mCurrentDrawSpan != null) {
            int color2;
            int n2 = color2 = this.mCurrentDrawSpan.isPressed() ? this.mCurrentDrawSpan.getPressedBackgroundColor() : this.mCurrentDrawSpan.getNormalBackgroundColor();
            if (color2 != 0) {
                this.mSpanBgPaint.setColor(color2);
                canvas.drawRect(0.0f, 0.0f, (float)size, (float)this.mFontHeight, this.mSpanBgPaint);
            }
        }
        drawable.draw(canvas);
        canvas.restore();
    }

    public static interface QQFaceViewListener {
        public void onCalculateLinesChange(int var1);
    }

    public static class PressCancelAction
    implements Runnable {
        private WeakReference<SpanInfo> mWeakReference;

        public PressCancelAction(SpanInfo spanInfo) {
            this.mWeakReference = new WeakReference<SpanInfo>(spanInfo);
        }

        @Override
        public void run() {
            SpanInfo spanInfo = (SpanInfo)this.mWeakReference.get();
            if (spanInfo != null) {
                spanInfo.setPressed(false);
                spanInfo.invalidateSpan();
            }
        }
    }

    private class SpanInfo {
        private ITouchableSpan mTouchableSpan;
        private int mStartPoint;
        private int mEndPoint;
        private int mStartLine;
        private int mEndLine;

        public SpanInfo(ITouchableSpan touchableSpan) {
            this.mTouchableSpan = touchableSpan;
        }

        public void setStart(int startLine, int startPoint) {
            this.mStartLine = startLine;
            this.mStartPoint = startPoint;
        }

        public void setPressed(boolean pressed) {
            this.mTouchableSpan.setPressed(pressed);
        }

        public void setEnd(int endLine, int endPoint) {
            this.mEndLine = endLine;
            this.mEndPoint = endPoint;
        }

        public void onClick() {
            this.mTouchableSpan.onClick(QMUIQQFaceView.this);
        }

        public void invalidateSpan() {
            int top = QMUIQQFaceView.this.getPaddingTop();
            if (this.mStartLine > 1) {
                top = (this.mStartLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + top;
            }
            int bottom = (this.mEndLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + top + QMUIQQFaceView.this.mFontHeight;
            Rect bounds = new Rect();
            bounds.top = top;
            bounds.bottom = bottom;
            bounds.left = QMUIQQFaceView.this.getPaddingLeft();
            bounds.right = QMUIQQFaceView.this.getWidth() - QMUIQQFaceView.this.getPaddingRight();
            if (this.mStartLine == this.mEndLine) {
                bounds.left = this.mStartPoint;
                bounds.right = this.mEndPoint;
            }
            QMUIQQFaceView.this.invalidate(bounds);
        }

        public boolean onTouch(int x, int y) {
            int top = QMUIQQFaceView.this.getPaddingTop();
            if (this.mStartLine > 1) {
                top = (this.mStartLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + top;
            }
            int bottom = (this.mEndLine - 1) * (QMUIQQFaceView.this.mFontHeight + QMUIQQFaceView.this.mLineSpace) + top + QMUIQQFaceView.this.mFontHeight;
            if (y < top || y > bottom) {
                return false;
            }
            if (this.mStartLine == this.mEndLine) {
                return x >= this.mStartPoint && x <= this.mEndPoint;
            }
            int startLineBottom = top + QMUIQQFaceView.this.mFontHeight;
            int endLineTop = bottom - QMUIQQFaceView.this.mFontHeight;
            if (y > startLineBottom && y < endLineTop) {
                if (this.mEndLine - this.mStartLine == 1) {
                    return x >= this.mStartPoint && x <= this.mEndPoint;
                }
                return true;
            }
            if (y <= startLineBottom) {
                return x >= this.mStartPoint;
            }
            return x <= this.mEndPoint;
        }
    }
}

