/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.link;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.qmuiteam.qmui.link.ITouchableSpan;
import com.qmuiteam.qmui.widget.textview.ISpanTouchFix;

public class QMUILinkTouchDecorHelper {
    private ITouchableSpan mPressedSpan;

    public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent event) {
        if (event.getAction() == 0) {
            this.mPressedSpan = this.getPressedSpan(textView, spannable, event);
            if (this.mPressedSpan != null) {
                this.mPressedSpan.setPressed(true);
                Selection.setSelection((Spannable)spannable, (int)spannable.getSpanStart((Object)this.mPressedSpan), (int)spannable.getSpanEnd((Object)this.mPressedSpan));
            }
            if (textView instanceof ISpanTouchFix) {
                ISpanTouchFix tv = (ISpanTouchFix)textView;
                tv.setTouchSpanHit(this.mPressedSpan != null);
            }
            return this.mPressedSpan != null;
        }
        if (event.getAction() == 2) {
            ITouchableSpan touchedSpan = this.getPressedSpan(textView, spannable, event);
            if (this.mPressedSpan != null && touchedSpan != this.mPressedSpan) {
                this.mPressedSpan.setPressed(false);
                this.mPressedSpan = null;
                Selection.removeSelection((Spannable)spannable);
            }
            if (textView instanceof ISpanTouchFix) {
                ISpanTouchFix tv = (ISpanTouchFix)textView;
                tv.setTouchSpanHit(this.mPressedSpan != null);
            }
            return this.mPressedSpan != null;
        }
        if (event.getAction() == 1) {
            boolean touchSpanHint = false;
            if (this.mPressedSpan != null) {
                touchSpanHint = true;
                this.mPressedSpan.setPressed(false);
                this.mPressedSpan.onClick((View)textView);
            }
            this.mPressedSpan = null;
            Selection.removeSelection((Spannable)spannable);
            if (textView instanceof ISpanTouchFix) {
                ISpanTouchFix tv = (ISpanTouchFix)textView;
                tv.setTouchSpanHit(touchSpanHint);
            }
            return touchSpanHint;
        }
        if (this.mPressedSpan != null) {
            this.mPressedSpan.setPressed(false);
        }
        if (textView instanceof ISpanTouchFix) {
            ISpanTouchFix tv = (ISpanTouchFix)textView;
            tv.setTouchSpanHit(false);
        }
        Selection.removeSelection((Spannable)spannable);
        return false;
    }

    public ITouchableSpan getPressedSpan(TextView textView, Spannable spannable, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= textView.getTotalPaddingLeft();
        y -= textView.getTotalPaddingTop();
        Layout layout = textView.getLayout();
        int line = layout.getLineForVertical(y += textView.getScrollY());
        int off = layout.getOffsetForHorizontal(line, (float)(x += textView.getScrollX()));
        if ((float)x < layout.getLineLeft(line) || (float)x > layout.getLineRight(line)) {
            off = -1;
        }
        ITouchableSpan[] link = (ITouchableSpan[])spannable.getSpans(off, off, ITouchableSpan.class);
        ITouchableSpan touchedSpan = null;
        if (link.length > 0) {
            touchedSpan = link[0];
        }
        return touchedSpan;
    }
}

