/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import com.qmdeve.blurview.R;
import com.qmdeve.blurview.util.Utils;
import com.qmdeve.blurview.widget.BlurView;

public class ProgressiveBlurView
extends BlurView {
    public static final int DIRECTION_BOTTOM_TO_TOP = 0;
    public static final int DIRECTION_TOP_TO_BOTTOM = 1;
    public static final int DIRECTION_RIGHT_TO_LEFT = 2;
    public static final int DIRECTION_LEFT_TO_RIGHT = 3;
    private final Rect mRectSrc = new Rect();
    private final Rect mRectDst = new Rect();
    private int mGradientDirection = 1;
    private final Paint mBlendPaint = new Paint(1);
    private final Paint mOverlayPaint = new Paint(1);
    private int mOverlayColor;
    private float mBlurRadius = 25.0f;

    public ProgressiveBlurView(Context context) {
        this(context, null);
    }

    public ProgressiveBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setCornerRadius(0.0f);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressiveBlurView);
            this.mGradientDirection = a.getInt(R.styleable.ProgressiveBlurView_progressiveDirection, 1);
            this.mOverlayColor = a.getInt(R.styleable.ProgressiveBlurView_progressiveOverlayColor, -1426063361);
            this.mBlurRadius = a.getDimension(R.styleable.ProgressiveBlurView_progressiveBlurRadius, Utils.dp2px(this.getResources(), 25.0f));
            a.recycle();
        }
        super.setBlurRadius(this.mBlurRadius);
        this.mBlendPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    public void setGradientDirection(int direction) {
        if (direction >= 1 && direction <= 2 && this.mGradientDirection != direction) {
            this.mGradientDirection = direction;
            this.invalidate();
        }
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        if (Utils.sIsGlobalCapturing && !this.mIsRendering) {
            return;
        }
        if (this.isInEditMode()) {
            this.drawPreviewProgressiveBackground(canvas);
            return;
        }
        Bitmap blurredBitmap = this.getBlurredBitmap();
        if (blurredBitmap == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)width, (float)height, null);
        this.mRectSrc.set(0, 0, blurredBitmap.getWidth(), blurredBitmap.getHeight());
        this.mRectDst.set(0, 0, width, height);
        canvas.drawBitmap(blurredBitmap, this.mRectSrc, this.mRectDst, null);
        LinearGradient gradient = this.createIntensityGradient(width, height);
        this.mBlendPaint.setShader((Shader)gradient);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mBlendPaint);
        LinearGradient overlayGradient = this.createOverlayGradient(width, height);
        this.mOverlayPaint.setShader((Shader)overlayGradient);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mOverlayPaint);
        canvas.restoreToCount(saveCount);
    }

    private LinearGradient createIntensityGradient(int width, int height) {
        int endAlpha = 255;
        int[] colors = new int[]{Color.argb((int)0, (int)0, (int)0, (int)0), Color.argb((int)endAlpha, (int)0, (int)0, (int)0)};
        float[] pos = new float[]{0.0f, 1.0f};
        return switch (this.mGradientDirection) {
            case 0 -> new LinearGradient(0.0f, (float)height, 0.0f, 0.0f, colors, pos, Shader.TileMode.CLAMP);
            case 3 -> new LinearGradient(0.0f, 0.0f, (float)width, 0.0f, colors, pos, Shader.TileMode.CLAMP);
            case 2 -> new LinearGradient((float)width, 0.0f, 0.0f, 0.0f, colors, pos, Shader.TileMode.CLAMP);
            default -> new LinearGradient(0.0f, 0.0f, 0.0f, (float)height, colors, pos, Shader.TileMode.CLAMP);
        };
    }

    private LinearGradient createOverlayGradient(int width, int height) {
        int transparentColor = this.mOverlayColor & 0xFFFFFF;
        int solidColor = this.mOverlayColor;
        return switch (this.mGradientDirection) {
            case 0 -> new LinearGradient(0.0f, (float)height, 0.0f, 0.0f, new int[]{transparentColor, solidColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
            case 3 -> new LinearGradient(0.0f, 0.0f, (float)width, 0.0f, new int[]{transparentColor, solidColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
            case 2 -> new LinearGradient((float)width, 0.0f, 0.0f, 0.0f, new int[]{transparentColor, solidColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
            default -> new LinearGradient(0.0f, 0.0f, 0.0f, (float)height, new int[]{transparentColor, solidColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        };
    }

    private void drawPreviewProgressiveBackground(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        Paint p = new Paint();
        LinearGradient g = this.createOverlayGradient(width, height);
        p.setShader((Shader)g);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, p);
    }

    @Override
    public void setCornerRadius(float radius) {
        super.setCornerRadius(0.0f);
    }

    @Override
    public void setOverlayColor(int color) {
        if (this.mOverlayColor != color) {
            this.mOverlayColor = color;
            this.invalidate();
        }
    }

    public void setOverlayColorRes(@ColorRes int colorResId) {
        int color = Build.VERSION.SDK_INT >= 23 ? this.getContext().getColor(colorResId) : this.getResources().getColor(colorResId);
        if (this.mOverlayColor != color) {
            this.mOverlayColor = color;
            this.invalidate();
        }
    }

    @Override
    public void setBlurRadius(float radius) {
        if (this.mBlurRadius != radius && radius >= 0.0f) {
            this.mBlurRadius = radius;
            super.setBlurRadius(radius);
            this.invalidate();
        }
    }
}

