/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.qmdeve.blurview.base.BaseBlurViewGroup;
import com.qmdeve.blurview.util.Utils;

public class BlurViewGroup
extends ViewGroup {
    private final BaseBlurViewGroup mBaseBlurViewGroup;

    public BlurViewGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.mBaseBlurViewGroup = new BaseBlurViewGroup(context, attrs);
    }

    public boolean isInEditMode() {
        return super.isInEditMode();
    }

    public void setBlurRadius(float radius) {
        this.mBaseBlurViewGroup.setBlurRadius(radius);
    }

    public void setBlurRounds(int rounds) {
        this.mBaseBlurViewGroup.setBlurRounds(rounds);
    }

    public int getBlurRounds() {
        return this.mBaseBlurViewGroup.getBlurRounds();
    }

    public void setDownsampleFactor(float factor) {
        this.mBaseBlurViewGroup.setDownsampleFactor(factor);
    }

    public void setOverlayColor(int color) {
        this.mBaseBlurViewGroup.setOverlayColor(color);
    }

    public void setCornerRadius(float radius) {
        this.mBaseBlurViewGroup.setCornerRadius(radius);
    }

    public Bitmap getBlurredBitmap() {
        return this.mBaseBlurViewGroup.getBlurredBitmap();
    }

    public int getOverlayColor() {
        return this.mBaseBlurViewGroup.getOverlayColor();
    }

    public void release() {
        this.mBaseBlurViewGroup.release();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mBaseBlurViewGroup.onAttachedToWindow((View)this);
    }

    protected void onDetachedFromWindow() {
        this.mBaseBlurViewGroup.onDetachedFromWindow();
        super.onDetachedFromWindow();
    }

    public void draw(@NonNull Canvas canvas) {
        if (!this.mBaseBlurViewGroup.isRendering()) {
            super.draw(canvas);
        }
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        boolean shouldDrawBlur;
        boolean bl = shouldDrawBlur = !Utils.sIsGlobalCapturing || this.mBaseBlurViewGroup.isRendering();
        if (!this.isInEditMode() && shouldDrawBlur) {
            this.mBaseBlurViewGroup.drawBlurredBitmap(canvas, this.getWidth(), this.getHeight());
        } else if (this.isInEditMode()) {
            this.mBaseBlurViewGroup.drawPreviewBackground(canvas, this.getWidth(), this.getHeight());
        }
        if (this.mBaseBlurViewGroup.getCornerRadius() > 0.0f) {
            canvas.save();
            this.mBaseBlurViewGroup.clipCanvasWithRoundedCorner(canvas, this.getWidth(), this.getHeight());
            super.dispatchDraw(canvas);
            canvas.restore();
        } else {
            super.dispatchDraw(canvas);
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int maxChildWidth = 0;
        int maxChildHeight = 0;
        int childState = 0;
        int[] childMeasuredWidths = new int[count];
        int[] childMeasuredHeights = new int[count];
        boolean[] childMeasured = new boolean[count];
        for (int i = 0; i < count; ++i) {
            LayoutParams lp;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.LayoutParams rawLp = child.getLayoutParams();
            if (rawLp instanceof LayoutParams) {
                lp = (LayoutParams)rawLp;
            } else {
                ViewGroup.LayoutParams generatedLp = this.generateLayoutParams(rawLp);
                lp = generatedLp instanceof LayoutParams ? (LayoutParams)generatedLp : new LayoutParams(generatedLp.width, generatedLp.height);
                child.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            int childWidthMeasureSpec = BlurViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            int childHeightMeasureSpec = BlurViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            childMeasuredWidths[i] = child.getMeasuredWidth();
            childMeasuredHeights[i] = child.getMeasuredHeight();
            childMeasured[i] = true;
            maxChildWidth = Math.max(maxChildWidth, childMeasuredWidths[i] + lp.leftMargin + lp.rightMargin);
            maxChildHeight = Math.max(maxChildHeight, childMeasuredHeights[i] + lp.topMargin + lp.bottomMargin);
            childState = BlurViewGroup.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        maxChildWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxChildHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxChildWidth = Math.max(maxChildWidth, this.getSuggestedMinimumWidth());
        maxChildHeight = Math.max(maxChildHeight, this.getSuggestedMinimumHeight());
        int measuredWidth = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(maxChildWidth, widthSize) : maxChildWidth);
        int measuredHeight = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(maxChildHeight, heightSize) : maxChildHeight);
        this.setMeasuredDimension(measuredWidth, measuredHeight);
        for (int i = 0; i < count; ++i) {
            int availableHeight;
            int availableWidth;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || !childMeasured[i]) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            boolean needRemasure = false;
            int newChildWidthMeasureSpec = 0;
            int newChildHeightMeasureSpec = 0;
            if (lp.width == -1 && (availableWidth = measuredWidth - this.getPaddingLeft() - this.getPaddingRight() - lp.leftMargin - lp.rightMargin) > 0 && availableWidth != childMeasuredWidths[i]) {
                newChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)availableWidth, (int)0x40000000);
                needRemasure = true;
            }
            if (lp.height == -1 && (availableHeight = measuredHeight - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin) > 0 && availableHeight != childMeasuredHeights[i]) {
                newChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)availableHeight, (int)0x40000000);
                needRemasure = true;
            }
            if (lp.gravity != -1) {
                if ((lp.gravity & 7) == 7 && lp.width != -1 && (availableWidth = measuredWidth - this.getPaddingLeft() - this.getPaddingRight() - lp.leftMargin - lp.rightMargin) > 0 && availableWidth != childMeasuredWidths[i]) {
                    newChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)availableWidth, (int)0x40000000);
                    needRemasure = true;
                }
                if ((lp.gravity & 0x70) == 112 && lp.height != -1 && (availableHeight = measuredHeight - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin) > 0 && availableHeight != childMeasuredHeights[i]) {
                    newChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)availableHeight, (int)0x40000000);
                    needRemasure = true;
                }
            }
            if (!needRemasure) continue;
            if (newChildWidthMeasureSpec == 0) {
                newChildWidthMeasureSpec = BlurViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            }
            if (newChildHeightMeasureSpec == 0) {
                newChildHeightMeasureSpec = BlurViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            }
            child.measure(newChildWidthMeasureSpec, newChildHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft();
        int parentTop = this.getPaddingTop();
        int parentRight = r - l - this.getPaddingRight();
        int parentBottom = b - t - this.getPaddingBottom();
        int parentWidth = parentRight - parentLeft;
        int parentHeight = parentBottom - parentTop;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int horizontalGravity = gravity & 7;
            int verticalGravity = gravity & 0x70;
            int childLeft = switch (horizontalGravity) {
                case 1 -> parentLeft + (parentWidth - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                case 5 -> parentRight - childWidth - lp.rightMargin;
                default -> parentLeft + lp.leftMargin;
            };
            int childTop = switch (verticalGravity) {
                case 16 -> parentTop + (parentHeight - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                case 80 -> parentBottom - childHeight - lp.bottomMargin;
                default -> parentTop + lp.topMargin;
            };
            int maxLeft = parentRight - Math.min(childWidth, parentWidth);
            childLeft = Math.max(parentLeft, Math.min(childLeft, maxLeft));
            int maxTop = parentBottom - Math.min(childHeight, parentHeight);
            childTop = Math.max(parentTop, Math.min(childTop, maxTop));
            child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, new int[]{16842931});
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

