/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.qmdeve.blurview.R;
import com.qmdeve.blurview.util.Utils;
import com.qmdeve.blurview.widget.BlurView;

public class BlurTitlebarView
extends BlurView {
    private String mTitle;
    private String mSubtitle;
    private String mMenuText;
    private boolean mShowBack;
    private boolean mCenterTitle;
    private Drawable mBackIcon;
    private Drawable mMenuIcon;
    private int mTitleColor;
    private int mSubtitleColor;
    private int mMenuTextColor;
    private int mBackIconTint;
    private int mMenuIconTint;
    private final Paint mTitlePaint = new Paint(1);
    private final Paint mSubtitlePaint = new Paint(1);
    private final Paint mMenuTextPaint = new Paint(1);
    private final Rect mTextBounds = new Rect();
    private final Rect mBackTouch = new Rect();
    private final Rect mMenuTouch = new Rect();
    private float mStatusBarHeight;
    private float mContentTopOffset;
    private static final float FIXED_HEIGHT_DP = 55.0f;
    private float mTitleOffsetX = 0.0f;
    private float mSubtitleOffsetX = 0.0f;
    private ValueAnimator mTitleAnimator;
    private ValueAnimator mSubtitleAnimator;
    private OnBackClickListener mOnBackClickListener;
    private OnMenuClickListener mOnMenuClickListener;

    public BlurTitlebarView(Context context) {
        this(context, null);
    }

    public BlurTitlebarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setClickable(true);
        this.setFocusable(true);
        this.initAttrs(context, attrs);
        this.setCornerRadius(0.0f);
        this.post(this::adjustForStatusBar);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BlurTitlebarView);
        this.mTitle = a.getString(R.styleable.BlurTitlebarView_titleText);
        this.mSubtitle = a.getString(R.styleable.BlurTitlebarView_subtitleText);
        this.mTitleColor = a.getColor(R.styleable.BlurTitlebarView_titleTextColor, 0);
        this.mSubtitleColor = a.getColor(R.styleable.BlurTitlebarView_subtitleTextColor, 0);
        this.mShowBack = a.getBoolean(R.styleable.BlurTitlebarView_showBack, false);
        this.mCenterTitle = a.getBoolean(R.styleable.BlurTitlebarView_centerTitle, false);
        if (this.mCenterTitle) {
            if (this.getWidth() == 0 || this.mTitle == null) {
                this.post(() -> this.setTitlePositionImmediately(this.mCenterTitle));
                this.post(() -> this.setSubtitlePositionImmediately(this.mCenterTitle));
            } else {
                this.setTitlePositionImmediately(this.mCenterTitle);
                this.setSubtitlePositionImmediately(this.mCenterTitle);
            }
        }
        this.mBackIconTint = a.getColor(R.styleable.BlurTitlebarView_backIconTint, 0);
        this.mMenuIconTint = a.getColor(R.styleable.BlurTitlebarView_menuIconTint, 0);
        int backIconRes = a.getResourceId(R.styleable.BlurTitlebarView_backIcon, 0);
        if (backIconRes != 0) {
            this.mBackIcon = ContextCompat.getDrawable((Context)context, (int)backIconRes);
        }
        this.mMenuText = a.getString(R.styleable.BlurTitlebarView_menuText);
        this.mMenuTextColor = a.getColor(R.styleable.BlurTitlebarView_menuTextColor, 0);
        int menuIconRes = a.getResourceId(R.styleable.BlurTitlebarView_menuIcon, 0);
        if (menuIconRes != 0) {
            this.mMenuIcon = ContextCompat.getDrawable((Context)context, (int)menuIconRes);
        }
        a.recycle();
        this.mTitlePaint.setTextSize(Utils.dp2px(this.getResources(), 18.0f));
        this.mTitlePaint.setFakeBoldText(true);
        this.mSubtitlePaint.setTextSize(Utils.dp2px(this.getResources(), 13.0f));
        this.mMenuTextPaint.setTextSize(Utils.dp2px(this.getResources(), 16.0f));
        this.mMenuTextPaint.setFakeBoldText(true);
        this.updateTextColorByOverlay();
    }

    private void updateTextColorByOverlay() {
        int autoColor;
        int brightness = (int)((double)Color.red((int)this.getOverlayColor()) * 0.299 + (double)Color.green((int)this.getOverlayColor()) * 0.587 + (double)Color.blue((int)this.getOverlayColor()) * 0.114);
        boolean isDark = brightness < 128;
        int n = autoColor = isDark ? -1 : -16777216;
        if (this.mTitleColor == 0) {
            this.mTitleColor = autoColor;
        }
        if (this.mSubtitleColor == 0) {
            this.mSubtitleColor = this.adjustAlpha(autoColor, 0.7f);
        }
        if (this.mMenuTextColor == 0) {
            this.mMenuTextColor = autoColor;
        }
        if (this.mBackIconTint == 0) {
            this.mBackIconTint = autoColor;
        }
        if (this.mMenuIconTint == 0) {
            this.mMenuIconTint = autoColor;
        }
        this.mTitlePaint.setColor(this.mTitleColor);
        this.mSubtitlePaint.setColor(this.mSubtitleColor);
        this.mMenuTextPaint.setColor(this.mMenuTextColor);
    }

    private int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        return color & 0xFFFFFF | alpha << 24;
    }

    private void adjustForStatusBar() {
        int[] loc = new int[2];
        this.getLocationOnScreen(loc);
        if (loc[1] < this.getStatusBarHeight()) {
            this.mStatusBarHeight = this.getStatusBarHeight();
            this.getLayoutParams().height = (int)(Utils.dp2px(this.getResources(), 55.0f) + this.mStatusBarHeight);
            this.requestLayout();
        }
        this.mContentTopOffset = this.mStatusBarHeight;
    }

    private int getStatusBarHeight() {
        int id = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return id > 0 ? this.getResources().getDimensionPixelSize(id) : 0;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = (int)(Utils.dp2px(this.getResources(), 55.0f) + this.mStatusBarHeight);
        this.setMeasuredDimension(width, height);
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        float baseXLeft;
        super.onDraw(canvas);
        float viewHeight = Utils.dp2px(this.getResources(), 55.0f);
        float contentTop = this.mContentTopOffset;
        float centerY = contentTop + viewHeight / 2.0f;
        float leftPad = Utils.dp2px(this.getResources(), 16.0f);
        float iconSize = Utils.dp2px(this.getResources(), 20.0f);
        if (this.mShowBack) {
            float top = centerY - iconSize / 2.0f;
            this.mBackTouch.set((int)leftPad, (int)top, (int)(leftPad + iconSize * 1.5f), (int)(top + iconSize));
            if (this.mBackIcon != null) {
                Drawable d = DrawableCompat.wrap((Drawable)this.mBackIcon.mutate());
                DrawableCompat.setTint((Drawable)d, (int)this.mBackIconTint);
                d.setBounds(this.mBackTouch);
                d.draw(canvas);
            } else {
                Paint p = new Paint(1);
                p.setColor(this.mBackIconTint);
                p.setStrokeWidth(Utils.dp2px(this.getResources(), 2.0f));
                canvas.drawLine(leftPad + Utils.dp2px(this.getResources(), 8.0f), centerY - Utils.dp2px(this.getResources(), 7.0f), leftPad, centerY, p);
                canvas.drawLine(leftPad + Utils.dp2px(this.getResources(), 8.0f), centerY + Utils.dp2px(this.getResources(), 7.0f), leftPad, centerY, p);
            }
        }
        float rightX = (float)this.getWidth() - Utils.dp2px(this.getResources(), 16.0f);
        if (this.mMenuIcon != null) {
            float top = centerY - iconSize / 2.0f;
            this.mMenuTouch.set((int)(rightX - iconSize), (int)top, (int)rightX, (int)(top + iconSize));
            Drawable d = DrawableCompat.wrap((Drawable)this.mMenuIcon.mutate());
            DrawableCompat.setTint((Drawable)d, (int)this.mMenuIconTint);
            d.setBounds(this.mMenuTouch);
            d.draw(canvas);
        } else if (this.mMenuText != null) {
            this.mMenuTextPaint.getTextBounds(this.mMenuText, 0, this.mMenuText.length(), this.mTextBounds);
            float tw = this.mTextBounds.width();
            float th = this.mTextBounds.height();
            float textY = centerY + th / 2.0f - Utils.dp2px(this.getResources(), 1.0f);
            canvas.drawText(this.mMenuText, rightX - tw, textY, this.mMenuTextPaint);
            this.mMenuTouch.set((int)(rightX - tw - Utils.dp2px(this.getResources(), 8.0f)), (int)(centerY - Utils.dp2px(this.getResources(), 20.0f)), (int)(rightX + Utils.dp2px(this.getResources(), 8.0f)), (int)(centerY + Utils.dp2px(this.getResources(), 20.0f)));
        }
        float f = baseXLeft = this.mShowBack ? Utils.dp2px(this.getResources(), 48.0f) : Utils.dp2px(this.getResources(), 16.0f);
        if (this.mTitle != null) {
            this.mTitlePaint.getTextBounds(this.mTitle, 0, this.mTitle.length(), this.mTextBounds);
            float titleH = this.mTextBounds.height();
            float currentTitleX = baseXLeft + this.mTitleOffsetX;
            if (this.mSubtitle == null || this.mSubtitle.isEmpty()) {
                Paint.FontMetrics fm = this.mTitlePaint.getFontMetrics();
                float textHeight = fm.descent - fm.ascent;
                float textCenterOffset = textHeight / 2.0f - fm.descent;
                float visualAdjust = Utils.dp2px(this.getResources(), 1.5f);
                float titleY = centerY + textCenterOffset + visualAdjust;
                canvas.drawText(this.mTitle, currentTitleX, titleY, this.mTitlePaint);
            } else {
                this.mSubtitlePaint.getTextBounds(this.mSubtitle, 0, this.mSubtitle.length(), this.mTextBounds);
                float subH = this.mTextBounds.height();
                float totalH = titleH + Utils.dp2px(this.getResources(), 3.0f) + subH;
                float baseY = centerY - totalH / 2.0f + titleH;
                float currentSubtitleX = baseXLeft + this.mSubtitleOffsetX;
                canvas.drawText(this.mTitle, currentTitleX, baseY - Utils.dp2px(this.getResources(), 1.0f), this.mTitlePaint);
                canvas.drawText(this.mSubtitle, currentSubtitleX, baseY + Utils.dp2px(this.getResources(), 3.0f) + subH, this.mSubtitlePaint);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (e.getAction() == 1) {
            int x = (int)e.getX();
            int y = (int)e.getY();
            if (this.mShowBack && this.mBackTouch.contains(x, y)) {
                if (this.mOnBackClickListener != null) {
                    this.mOnBackClickListener.onBackClick();
                } else if (this.getContext() instanceof Activity) {
                    ((Activity)this.getContext()).onBackPressed();
                }
                return true;
            }
            if ((this.mMenuIcon != null || this.mMenuText != null) && this.mMenuTouch.contains(x, y)) {
                if (this.mOnMenuClickListener != null) {
                    this.mOnMenuClickListener.onMenuClick();
                }
                return true;
            }
        }
        return super.onTouchEvent(e);
    }

    private void setTitlePositionImmediately(boolean center) {
        if (this.mTitle == null) {
            return;
        }
        this.mTitlePaint.getTextBounds(this.mTitle, 0, this.mTitle.length(), this.mTextBounds);
        float titleW = this.mTextBounds.width();
        float baseXLeft = this.mShowBack ? Utils.dp2px(this.getResources(), 48.0f) : Utils.dp2px(this.getResources(), 16.0f);
        float titleCenterX = (float)this.getWidth() / 2.0f - titleW / 2.0f;
        this.mTitleOffsetX = center ? titleCenterX - baseXLeft : 0.0f;
        this.invalidate();
    }

    private void setSubtitlePositionImmediately(boolean center) {
        if (this.mSubtitle == null) {
            return;
        }
        this.mSubtitlePaint.getTextBounds(this.mSubtitle, 0, this.mSubtitle.length(), this.mTextBounds);
        float subtitleW = this.mTextBounds.width();
        float baseXLeft = this.mShowBack ? Utils.dp2px(this.getResources(), 48.0f) : Utils.dp2px(this.getResources(), 16.0f);
        float subtitleCenterX = (float)this.getWidth() / 2.0f - subtitleW / 2.0f;
        this.mSubtitleOffsetX = center ? subtitleCenterX - baseXLeft : 0.0f;
        this.invalidate();
    }

    private void animateTitleToCenter(boolean center) {
        float targetOffset;
        if (this.mTitle == null) {
            return;
        }
        this.mTitlePaint.getTextBounds(this.mTitle, 0, this.mTitle.length(), this.mTextBounds);
        float titleW = this.mTextBounds.width();
        float baseXLeft = this.mShowBack ? Utils.dp2px(this.getResources(), 48.0f) : Utils.dp2px(this.getResources(), 16.0f);
        float titleCenterX = (float)this.getWidth() / 2.0f - titleW / 2.0f;
        float f = targetOffset = center ? titleCenterX - baseXLeft : 0.0f;
        if (this.mTitleAnimator != null && this.mTitleAnimator.isRunning()) {
            this.mTitleAnimator.cancel();
        }
        this.mTitleAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mTitleOffsetX, targetOffset});
        this.mTitleAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mTitleAnimator.setDuration(300L);
        this.mTitleAnimator.addUpdateListener(a -> {
            this.mTitleOffsetX = ((Float)a.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        this.mTitleAnimator.start();
    }

    private void animateSubtitleToCenter(boolean center) {
        float targetOffset;
        if (this.mSubtitle == null) {
            return;
        }
        this.mSubtitlePaint.getTextBounds(this.mSubtitle, 0, this.mSubtitle.length(), this.mTextBounds);
        float subtitleW = this.mTextBounds.width();
        float baseXLeft = this.mShowBack ? Utils.dp2px(this.getResources(), 48.0f) : Utils.dp2px(this.getResources(), 16.0f);
        float subtitleCenterX = (float)this.getWidth() / 2.0f - subtitleW / 2.0f;
        float f = targetOffset = center ? subtitleCenterX - baseXLeft : 0.0f;
        if (this.mSubtitleAnimator != null && this.mSubtitleAnimator.isRunning()) {
            this.mSubtitleAnimator.cancel();
        }
        this.mSubtitleAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mSubtitleOffsetX, targetOffset});
        this.mSubtitleAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mSubtitleAnimator.setDuration(300L);
        this.mSubtitleAnimator.addUpdateListener(a -> {
            this.mSubtitleOffsetX = ((Float)a.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        this.mSubtitleAnimator.start();
    }

    public void setCenterTitle(boolean center) {
        if (this.mCenterTitle == center) {
            return;
        }
        this.mCenterTitle = center;
        if (this.getWidth() == 0 || this.mTitle == null) {
            this.post(() -> this.animateTitleToCenter(center));
            this.post(() -> this.animateSubtitleToCenter(center));
        } else {
            this.animateTitleToCenter(center);
            this.animateSubtitleToCenter(center);
        }
    }

    public void setTitle(String title) {
        this.mTitle = title;
        this.invalidate();
    }

    public void setSubtitle(String subtitle) {
        this.mSubtitle = subtitle;
        this.invalidate();
    }

    public void setShowBack(boolean show) {
        this.mShowBack = show;
        this.invalidate();
    }

    public void setBackIcon(Drawable d) {
        this.mBackIcon = d;
        this.invalidate();
    }

    public void setBackIconTint(int color) {
        this.mBackIconTint = color;
        this.invalidate();
    }

    public void setMenuText(String text) {
        this.mMenuText = text;
        this.invalidate();
    }

    public void setMenuIcon(Drawable d) {
        this.mMenuIcon = d;
        this.invalidate();
    }

    public void setMenuIconTint(int color) {
        this.mMenuIconTint = color;
        this.invalidate();
    }

    public void setOnBackClickListener(OnBackClickListener l) {
        this.mOnBackClickListener = l;
    }

    public void setOnMenuClickListener(OnMenuClickListener l) {
        this.mOnMenuClickListener = l;
    }

    public static interface OnBackClickListener {
        public void onBackClick();
    }

    public static interface OnMenuClickListener {
        public void onMenuClick();
    }
}

