/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.widget;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qmdeve.blurview.R;
import com.qmdeve.blurview.widget.BlurView;

public class BlurSwitchButtonView
extends BlurView {
    private static final float WIDTH_HEIGHT_RATIO = 2.0f;
    private boolean isChecked = false;
    private final Paint mTrackPaint = new Paint(1);
    private final Paint mThumbPaint = new Paint(1);
    private final Paint mHighlightPaint = new Paint(1);
    private final Path mTrackPath = new Path();
    private final Path mThumbPath = new Path();
    private float thumbCenterX = 0.0f;
    private float thumbRadius = 0.0f;
    private float thumbStartX = 0.0f;
    private float thumbEndX = 0.0f;
    private int mBaseColor = -16686606;
    private int mTrackOnColor;
    private int mTrackOffColor;
    private int mCurrentTrackColor;
    private float mHighlightAlpha = 0.0f;
    private ValueAnimator mThumbAnimator;
    private ValueAnimator mColorAnimator;
    private ValueAnimator mSpringAnimator;
    private final ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private static final long BASE_ANIM_DURATION = 200L;
    private boolean isDragging = false;
    private float lastTouchX;
    private float dragStartX;
    private boolean dragStarted = false;
    private static final float DRAG_THRESHOLD = 4.0f;
    private boolean dimensionsCalculated = false;
    private boolean mUseSolidColorMode = false;
    private int mSolidOnColor;
    private int mSolidOffColor;
    private OnCheckedChangeListener listener;

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.listener = listener;
    }

    public BlurSwitchButtonView(Context context) {
        this(context, null);
    }

    public BlurSwitchButtonView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BlurSwitchButtonView);
        this.mBaseColor = a.getColor(R.styleable.BlurSwitchButtonView_baseColor, -16686606);
        this.mUseSolidColorMode = a.getBoolean(R.styleable.BlurSwitchButtonView_useSolidColorMode, false);
        int solidOnColor = a.getColor(R.styleable.BlurSwitchButtonView_solidOnColor, 0);
        int solidOffColor = a.getColor(R.styleable.BlurSwitchButtonView_solidOffColor, 0);
        this.setBlurRadius(16.0f);
        this.setCornerRadius(100.0f);
        this.setOverlayColor(0x10FFFFFF);
        this.calculateColors();
        if (this.mUseSolidColorMode) {
            if (solidOnColor != 0) {
                this.mSolidOnColor = solidOnColor;
            }
            if (solidOffColor != 0) {
                this.mSolidOffColor = solidOffColor;
            }
        }
        this.mTrackPaint.setStyle(Paint.Style.FILL);
        this.mThumbPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredHeight;
        int measuredWidth;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000 && heightMode == 0x40000000) {
            float widthBasedOnHeight = (float)heightSize * 2.0f;
            float heightBasedOnWidth = (float)widthSize / 2.0f;
            if (widthBasedOnHeight <= (float)widthSize) {
                measuredWidth = (int)widthBasedOnHeight;
                measuredHeight = heightSize;
            } else {
                measuredWidth = widthSize;
                measuredHeight = (int)heightBasedOnWidth;
            }
        } else if (widthMode == 0x40000000) {
            measuredWidth = widthSize;
            measuredHeight = (int)((float)widthSize / 2.0f);
        } else if (heightMode == 0x40000000) {
            measuredHeight = heightSize;
            measuredWidth = (int)((float)heightSize * 2.0f);
        } else {
            int defaultSize = (int)(60.0f * this.getResources().getDisplayMetrics().density);
            measuredWidth = widthMode == Integer.MIN_VALUE ? Math.min(defaultSize, widthSize) : defaultSize;
            measuredHeight = (int)((float)measuredWidth / 2.0f);
            if (heightMode == Integer.MIN_VALUE && measuredHeight > heightSize) {
                measuredHeight = heightSize;
                measuredWidth = (int)((float)measuredHeight * 2.0f);
            }
        }
        if (measuredWidth <= 0) {
            measuredWidth = 1;
        }
        if (measuredHeight <= 0) {
            measuredHeight = 1;
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    private void calculateColors() {
        if (this.mUseSolidColorMode) {
            this.calculateSolidColors();
        } else {
            this.calculateBlurColors();
        }
    }

    private void calculateBlurColors() {
        int pureColor = this.mBaseColor;
        if (Color.alpha((int)this.mBaseColor) < 255) {
            pureColor = this.mBaseColor | 0xFF000000;
        }
        this.mTrackOnColor = pureColor & 0xFFFFFF | 0x90000000;
        this.mTrackOffColor = this.makeColorDarkerAndTransparent(pureColor);
    }

    private void calculateSolidColors() {
        int pureColor = this.mBaseColor;
        if (Color.alpha((int)this.mBaseColor) < 255) {
            pureColor = this.mBaseColor | 0xFF000000;
        }
        this.mSolidOnColor = pureColor;
        this.mSolidOffColor = this.makeColorLighterGray(pureColor);
    }

    private int makeColorLighterGray(int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[1] = hsv[1] * 0.2f;
        hsv[2] = Math.min(1.0f, hsv[2] * 1.1f);
        int grayColor = Color.HSVToColor((float[])hsv);
        return grayColor & 0xFFFFFF | 0xCC000000;
    }

    private int makeColorDarkerAndTransparent(int color) {
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        float darkenFactor = 0.75f;
        red = (int)((float)red * darkenFactor);
        green = (int)((float)green * darkenFactor);
        blue = (int)((float)blue * darkenFactor);
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 102;
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.calculateDimensions(w, h);
            this.updateThumbPositionToCurrentState(false);
            this.dimensionsCalculated = true;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed && this.getWidth() > 0 && this.getHeight() > 0 && !this.dimensionsCalculated) {
            this.calculateDimensions(this.getWidth(), this.getHeight());
            this.updateThumbPositionToCurrentState(false);
            this.dimensionsCalculated = true;
        }
    }

    private void calculateDimensions(float w, float h) {
        this.thumbRadius = h / 2.0f * 0.75f;
        float thumbMargin = h * 0.15f;
        this.thumbStartX = thumbMargin + this.thumbRadius;
        this.thumbEndX = w - thumbMargin - this.thumbRadius;
    }

    private void updateThumbPositionToCurrentState(boolean animate) {
        if (!this.dimensionsCalculated) {
            return;
        }
        float targetX = this.isChecked ? this.thumbEndX : this.thumbStartX;
        int targetColor = this.getTargetTrackColor();
        if (!animate) {
            this.thumbCenterX = targetX;
            this.mCurrentTrackColor = targetColor;
            this.invalidate();
        } else {
            this.startSwitchAnimation();
        }
    }

    private int getTargetTrackColor() {
        if (this.mUseSolidColorMode) {
            return this.isChecked ? this.mSolidOnColor : this.mSolidOffColor;
        }
        return this.isChecked ? this.mTrackOnColor : this.mTrackOffColor;
    }

    private Path createG3RoundedRectPath(float right, float bottom, float radius) {
        Path path = new Path();
        if (radius <= 0.0f) {
            path.addRect(0.0f, 0.0f, right, bottom, Path.Direction.CW);
            return path;
        }
        float maxRadius = Math.min((right - 0.0f) / 2.0f, (bottom - 0.0f) / 2.0f);
        radius = Math.min(radius, maxRadius);
        float controlOffset = radius * 0.5522848f;
        path.moveTo(0.0f + radius, 0.0f);
        path.lineTo(right - radius, 0.0f);
        path.cubicTo(right - radius + controlOffset, 0.0f, right, 0.0f + radius - controlOffset, right, 0.0f + radius);
        path.lineTo(right, bottom - radius);
        path.cubicTo(right, bottom - radius + controlOffset, right - radius + controlOffset, bottom, right - radius, bottom);
        path.lineTo(0.0f + radius, bottom);
        path.cubicTo(0.0f + radius - controlOffset, bottom, 0.0f, bottom - radius + controlOffset, 0.0f, bottom - radius);
        path.lineTo(0.0f, 0.0f + radius);
        path.cubicTo(0.0f, 0.0f + radius - controlOffset, 0.0f + radius - controlOffset, 0.0f, 0.0f + radius, 0.0f);
        path.close();
        return path;
    }

    private Path createG3RoundedCirclePath(float centerX, float centerY, float radius) {
        Path path = new Path();
        if (radius <= 0.0f) {
            path.addCircle(centerX, centerY, 1.0f, Path.Direction.CW);
            return path;
        }
        float controlOffset = radius * 0.5522848f;
        path.moveTo(centerX, centerY - radius);
        path.cubicTo(centerX + controlOffset, centerY - radius, centerX + radius, centerY - controlOffset, centerX + radius, centerY);
        path.cubicTo(centerX + radius, centerY + controlOffset, centerX + controlOffset, centerY + radius, centerX, centerY + radius);
        path.cubicTo(centerX - controlOffset, centerY + radius, centerX - radius, centerY + controlOffset, centerX - radius, centerY);
        path.cubicTo(centerX - radius, centerY - controlOffset, centerX - controlOffset, centerY - radius, centerX, centerY - radius);
        path.close();
        return path;
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        float w = this.getWidth();
        float h = this.getHeight();
        if (w == 0.0f || h == 0.0f) {
            return;
        }
        if (!this.dimensionsCalculated) {
            this.calculateDimensions(w, h);
            this.dimensionsCalculated = true;
        }
        if (this.thumbCenterX == 0.0f) {
            this.thumbCenterX = this.isChecked ? this.thumbEndX : this.thumbStartX;
            this.mCurrentTrackColor = this.getTargetTrackColor();
        }
        if (this.thumbCenterX < this.thumbStartX) {
            this.thumbCenterX = this.thumbStartX;
        }
        if (this.thumbCenterX > this.thumbEndX) {
            this.thumbCenterX = this.thumbEndX;
        }
        float trackRadius = h / 2.0f;
        this.mTrackPath.reset();
        this.mTrackPath.set(this.createG3RoundedRectPath(w, h, trackRadius));
        this.mTrackPaint.setColor(this.mCurrentTrackColor);
        canvas.drawPath(this.mTrackPath, this.mTrackPaint);
        this.mThumbPath.reset();
        this.mThumbPath.set(this.createG3RoundedCirclePath(this.thumbCenterX, h / 2.0f, this.thumbRadius));
        this.mThumbPaint.setColor(-1073741825);
        canvas.drawPath(this.mThumbPath, this.mThumbPaint);
        if (this.thumbRadius > 0.0f) {
            float highlightLeft = this.thumbCenterX - this.thumbRadius * 0.6f;
            float highlightRight = this.thumbCenterX + this.thumbRadius * 0.6f;
            LinearGradient highlightGradient = new LinearGradient(highlightLeft, 0.0f, highlightRight, 0.0f, new int[]{0xFFFFFF, 0x33FFFFFF, 0xFFFFFF}, null, Shader.TileMode.CLAMP);
            this.mHighlightPaint.setShader((Shader)highlightGradient);
            this.mHighlightPaint.setAlpha((int)(this.mHighlightAlpha * 255.0f));
            canvas.drawPath(this.mThumbPath, this.mHighlightPaint);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.dimensionsCalculated) {
            return super.onTouchEvent(event);
        }
        float currentX = event.getX();
        switch (event.getAction()) {
            case 0: {
                this.lastTouchX = currentX;
                this.dragStartX = currentX;
                this.dragStarted = false;
                this.isDragging = false;
                return true;
            }
            case 2: {
                float deltaX = currentX - this.lastTouchX;
                if (!this.dragStarted && Math.abs(currentX - this.dragStartX) > 4.0f) {
                    this.dragStarted = true;
                    this.isDragging = true;
                    this.cancelAnimations();
                }
                if (this.isDragging) {
                    this.thumbCenterX += deltaX;
                    this.thumbCenterX = Math.max(this.thumbStartX, Math.min(this.thumbEndX, this.thumbCenterX));
                    float progress = (this.thumbCenterX - this.thumbStartX) / (this.thumbEndX - this.thumbStartX);
                    this.mCurrentTrackColor = this.mUseSolidColorMode ? ((Integer)this.argbEvaluator.evaluate(progress, (Object)this.mSolidOffColor, (Object)this.mSolidOnColor)).intValue() : ((Integer)this.argbEvaluator.evaluate(progress, (Object)this.mTrackOffColor, (Object)this.mTrackOnColor)).intValue();
                    this.invalidate();
                }
                this.lastTouchX = currentX;
                return true;
            }
            case 1: 
            case 3: {
                if (this.isDragging) {
                    boolean newChecked;
                    float switchCenter = (this.thumbStartX + this.thumbEndX) / 2.0f;
                    boolean bl = newChecked = this.thumbCenterX > switchCenter;
                    if (this.isChecked != newChecked) {
                        this.isChecked = newChecked;
                        if (this.listener != null) {
                            this.listener.onCheckedChanged(this.isChecked);
                        }
                    }
                    this.updateThumbPositionToCurrentState(true);
                } else {
                    this.toggle();
                }
                this.isDragging = false;
                this.dragStarted = false;
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void cancelAnimations() {
        if (this.mThumbAnimator != null) {
            this.mThumbAnimator.cancel();
            this.mThumbAnimator = null;
        }
        if (this.mColorAnimator != null) {
            this.mColorAnimator.cancel();
            this.mColorAnimator = null;
        }
        if (this.mSpringAnimator != null) {
            this.mSpringAnimator.cancel();
            this.mSpringAnimator = null;
        }
    }

    public void toggle() {
        this.setChecked(!this.isChecked, true);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked, boolean animate) {
        if (this.isChecked == checked) {
            return;
        }
        this.isChecked = checked;
        this.updateThumbPositionToCurrentState(animate);
        if (this.listener != null) {
            this.listener.onCheckedChanged(this.isChecked);
        }
    }

    private void startSwitchAnimation() {
        if (!this.dimensionsCalculated) {
            return;
        }
        float startX = this.thumbCenterX;
        float endX = this.isChecked ? this.thumbEndX : this.thumbStartX;
        int startColor = this.mCurrentTrackColor;
        int endColor = this.getTargetTrackColor();
        this.cancelAnimations();
        this.mThumbAnimator = ValueAnimator.ofFloat((float[])new float[]{startX, endX});
        this.mThumbAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mThumbAnimator.setDuration(200L);
        this.mThumbAnimator.addUpdateListener(a -> {
            this.thumbCenterX = ((Float)a.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        this.mColorAnimator = ValueAnimator.ofObject((TypeEvaluator)this.argbEvaluator, (Object[])new Object[]{startColor, endColor});
        this.mColorAnimator.setDuration(200L);
        this.mColorAnimator.addUpdateListener(a -> {
            this.mCurrentTrackColor = (Integer)a.getAnimatedValue();
            this.invalidate();
        });
        ValueAnimator highlightAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f, 0.0f});
        highlightAnim.setDuration(280L);
        highlightAnim.addUpdateListener(a -> {
            this.mHighlightAlpha = ((Float)a.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        this.mSpringAnimator = this.createSpringAnimator(startX, endX);
        this.mThumbAnimator.start();
        this.mColorAnimator.start();
        highlightAnim.start();
    }

    private ValueAnimator createSpringAnimator(float startX, float endX) {
        ValueAnimator springAnim = ValueAnimator.ofFloat((float[])new float[]{startX, endX});
        springAnim.setInterpolator((TimeInterpolator)new SpringInterpolator(0.4f, 1.2f));
        springAnim.setDuration(250L);
        springAnim.addUpdateListener(a -> {
            this.thumbCenterX = ((Float)a.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        return springAnim;
    }

    public void setBaseColor(int color) {
        this.mBaseColor = color;
        this.calculateColors();
        this.mCurrentTrackColor = this.getTargetTrackColor();
        this.invalidate();
    }

    public void setUseSolidColorMode(boolean useSolidColorMode) {
        if (this.mUseSolidColorMode != useSolidColorMode) {
            this.mUseSolidColorMode = useSolidColorMode;
            this.calculateColors();
            this.mCurrentTrackColor = this.getTargetTrackColor();
            this.invalidate();
        }
    }

    public boolean isUseSolidColorMode() {
        return this.mUseSolidColorMode;
    }

    public void setSolidColors(int onColor, int offColor) {
        this.mSolidOnColor = onColor;
        this.mSolidOffColor = offColor;
        if (this.mUseSolidColorMode) {
            this.mCurrentTrackColor = this.getTargetTrackColor();
            this.invalidate();
        }
    }

    public int getSolidOnColor() {
        return this.mSolidOnColor;
    }

    public int getSolidOffColor() {
        return this.mSolidOffColor;
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(boolean var1);
    }

    private static class SpringInterpolator
    implements Interpolator {
        private final float factor;
        private final float overshoot;

        SpringInterpolator(float factor, float overshoot) {
            this.factor = factor;
            this.overshoot = overshoot;
        }

        public float getInterpolation(float input) {
            return (float)(-Math.pow(2.0, -10.0f * input) * Math.sin((double)(input - this.factor / 4.0f) * (Math.PI * 2) / (double)this.factor) + 1.0 + (double)(this.overshoot * Math.min(input, 0.5f)));
        }
    }
}

