/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.qmdeve.blurview.R;
import com.qmdeve.blurview.util.Utils;
import com.qmdeve.blurview.widget.BlurView;

public class BlurFloatingButtonView
extends BlurView {
    public static final int POSITION_LEFT = 0;
    public static final int POSITION_RIGHT = 1;
    private int mPosition = 1;
    private Drawable mIconDrawable;
    private float mButtonSize = 55.0f;
    private float mIconSize = 30.0f;
    private int mIconTint = -13421773;
    private float mRippleCornerRadius = 30.0f;
    private OnLongPressListener mLongPressListener;

    public BlurFloatingButtonView(Context context) {
        this(context, null);
    }

    public BlurFloatingButtonView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mIconDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_add);
        this.setClickable(true);
        this.setFocusable(true);
        this.setLongClickable(true);
        this.mRippleCornerRadius = Utils.dp2px(this.getResources(), 12.0f);
        this.setCornerRadius(this.mRippleCornerRadius);
        this.setBlurRadius(Utils.dp2px(this.getResources(), 16.0f));
        this.setOverlayColor(-1);
        this.setElevation(Utils.dp2px(this.getResources(), 5.0f));
        this.applyRippleEffect();
        super.setOnLongClickListener(v -> {
            if (this.mLongPressListener != null) {
                this.mLongPressListener.onLongPress(this);
                return true;
            }
            return false;
        });
    }

    private void applyRippleEffect() {
        int rippleColor = 0x22000000;
        float[] outerRadii = new float[]{this.mRippleCornerRadius, this.mRippleCornerRadius, this.mRippleCornerRadius, this.mRippleCornerRadius, this.mRippleCornerRadius, this.mRippleCornerRadius, this.mRippleCornerRadius, this.mRippleCornerRadius};
        ShapeDrawable mask = new ShapeDrawable((Shape)new RoundRectShape(outerRadii, null, null));
        RippleDrawable ripple = new RippleDrawable(ColorStateList.valueOf((int)rippleColor), null, (Drawable)mask);
        if (Build.VERSION.SDK_INT >= 23) {
            this.setForeground((Drawable)ripple);
        }
        this.setOutlineProvider(new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), BlurFloatingButtonView.this.mRippleCornerRadius);
            }
        });
        this.setClipToOutline(true);
    }

    public void setPosition(int position) {
        this.mPosition = position == 0 ? 0 : 1;
        this.requestLayout();
    }

    public void setIcon(@DrawableRes int resId) {
        this.mIconDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
        this.applyIconTint();
        this.invalidate();
    }

    public void setIconDrawable(@Nullable Drawable drawable2) {
        this.mIconDrawable = drawable2;
        this.applyIconTint();
        this.invalidate();
    }

    public void setIconTint(@ColorInt int color) {
        int rgb = color & 0xFFFFFF;
        this.mIconTint = 0xCC000000 | rgb;
        this.applyIconTint();
        this.invalidate();
    }

    public void setIconSize(float dp) {
        this.mIconSize = dp;
        this.invalidate();
    }

    public void setButtonSize(float dp) {
        this.mButtonSize = dp;
        this.requestLayout();
    }

    private void applyIconTint() {
        if (this.mIconDrawable != null) {
            this.mIconDrawable.mutate();
            this.mIconDrawable.setColorFilter(this.mIconTint, PorterDuff.Mode.SRC_IN);
        }
    }

    @Override
    public void setCornerRadius(float radius) {
        super.setCornerRadius(radius);
        this.mRippleCornerRadius = radius;
        this.post(this::applyRippleEffect);
    }

    @Override
    public void setOverlayColor(@ColorInt int color) {
        int rgb = color & 0xFFFFFF;
        int finalColor = 0xB7000000 | rgb;
        super.setOverlayColor(finalColor);
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (this.mIconDrawable != null) {
            int size = (int)Utils.dp2px(this.getResources(), this.mIconSize);
            int left = (this.getWidth() - size) / 2;
            int top = (this.getHeight() - size) / 2;
            this.mIconDrawable.setBounds(left, top, left + size, top + size);
            this.mIconDrawable.draw(canvas);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.post(() -> {
            View parent = (View)this.getParent();
            if (parent != null) {
                int parentHeight = parent.getHeight();
                int parentWidth = parent.getWidth();
                float bottomMargin = Utils.dp2px(this.getResources(), 32.0f) + (float)Utils.getNavigationBarHeight(this);
                float side = Utils.dp2px(this.getResources(), 34.0f);
                float x = this.mPosition == 1 ? (float)(parentWidth - this.getWidth()) - side : side;
                float y = (float)(parentHeight - this.getHeight()) - bottomMargin;
                this.setX(x);
                this.setY(y);
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int size = (int)Utils.dp2px(this.getResources(), this.mButtonSize);
        this.setMeasuredDimension(size, size);
    }

    public void setOnLongPressListener(@Nullable OnLongPressListener listener) {
        this.mLongPressListener = listener;
    }

    public static interface OnLongPressListener {
        public void onLongPress(BlurFloatingButtonView var1);
    }
}

