/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.util;

import com.qiwenshare.ufop.exception.UFOPException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ResourceUtils;

public class UFOPUtils {
    public static String LOCAL_STORAGE_PATH;
    public static String ROOT_PATH;
    public static final String[] IMG_FILE;
    public static final String[] DOC_FILE;
    public static final String[] VIDEO_FILE;
    public static final String[] MUSIC_FILE;
    public static final String[] TXT_FILE;
    public static final int IMAGE_TYPE = 1;
    public static final int DOC_TYPE = 2;
    public static final int VIDEO_TYPE = 3;
    public static final int MUSIC_TYPE = 4;
    public static final int OTHER_TYPE = 5;
    public static final int SHARE_FILE = 6;
    public static final int RECYCLE_FILE = 7;

    public static boolean isImageFile(String extendName) {
        for (String extend : IMG_FILE) {
            if (!extendName.equalsIgnoreCase(extend)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVideoFile(String extendName) {
        for (String extend : VIDEO_FILE) {
            if (!extendName.equalsIgnoreCase(extend)) continue;
            return true;
        }
        return false;
    }

    public static String pathSplitFormat(String filePath) {
        return filePath.replace("///", "/").replace("//", "/").replace("\\\\\\", "/").replace("\\\\", "/");
    }

    public static File getLocalSaveFile(String fileUrl) {
        String localSavePath = UFOPUtils.getStaticPath() + fileUrl;
        return new File(localSavePath);
    }

    public static File getCacheFile(String fileUrl) {
        String cachePath = UFOPUtils.getStaticPath() + "cache" + File.separator + fileUrl;
        return new File(cachePath);
    }

    public static File getTempFile(String fileUrl) {
        String tempPath = UFOPUtils.getStaticPath() + "temp" + File.separator + fileUrl;
        File tempFile = new File(tempPath);
        File parentFile = tempFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return tempFile;
    }

    public static File getProcessFile(String fileUrl) {
        String processPath = UFOPUtils.getStaticPath() + "temp" + File.separator + "process" + File.separator + fileUrl;
        File processFile = new File(processPath);
        File parentFile = processFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return processFile;
    }

    public static String getProjectRootPath() {
        String absolutePath;
        try {
            String url = ResourceUtils.getURL((String)"classpath:").getPath();
            absolutePath = UFOPUtils.urlDecode(new File(url).getAbsolutePath()) + File.separator;
        }
        catch (FileNotFoundException e) {
            throw new UFOPException(e);
        }
        return absolutePath;
    }

    public static String urlDecode(String url) {
        String decodeUrl;
        try {
            decodeUrl = URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UFOPException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f", e);
        }
        return decodeUrl;
    }

    public static String getStaticPath() {
        String localStoragePath = LOCAL_STORAGE_PATH;
        if (StringUtils.isNotEmpty((CharSequence)localStoragePath)) {
            return new File(localStoragePath).getPath() + File.separator;
        }
        String projectRootAbsolutePath = UFOPUtils.getProjectRootPath();
        int index = projectRootAbsolutePath.indexOf("file:");
        if (index != -1) {
            projectRootAbsolutePath = projectRootAbsolutePath.substring(0, index);
        }
        return new File(projectRootAbsolutePath + "static").getPath() + File.separator;
    }

    public static String getUploadFileUrl(String identifier, String extendName) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd");
        String path = ROOT_PATH + "/" + formater.format(new Date()) + "/";
        File dir = new File(UFOPUtils.getStaticPath() + path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        path = path + identifier + "." + extendName;
        return path;
    }

    public static String getAliyunObjectNameByFileUrl(String fileUrl) {
        if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
            fileUrl = fileUrl.substring(1);
        }
        return fileUrl;
    }

    public static String formatPath(String path) {
        if ("/".equals(path = UFOPUtils.pathSplitFormat(path))) {
            return path;
        }
        if (path.endsWith("/")) {
            int length = path.length();
            return path.substring(0, length - 1);
        }
        return path;
    }

    static {
        IMG_FILE = new String[]{"bmp", "jpg", "png", "tif", "gif", "jpeg"};
        DOC_FILE = new String[]{"doc", "docx", "ppt", "pptx", "xls", "xlsx", "txt", "hlp", "wps", "rtf", "html", "pdf"};
        VIDEO_FILE = new String[]{"avi", "mp4", "mpg", "mov", "swf"};
        MUSIC_FILE = new String[]{"wav", "aif", "au", "mp3", "ram", "wma", "mmf", "amr", "aac", "flac"};
        TXT_FILE = new String[]{"txt", "html", "java", "xml", "js", "css", "json", "sql"};
    }
}

