/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.write.product;

import com.qiwenshare.ufop.exception.operation.WriteException;
import com.qiwenshare.ufop.operation.write.Writer;
import com.qiwenshare.ufop.operation.write.domain.WriteFile;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorageWriter
extends Writer {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageWriter.class);

    @Override
    public void write(InputStream inputStream, WriteFile writeFile) {
        try (FileOutputStream out = new FileOutputStream(UFOPUtils.getStaticPath() + writeFile.getFileUrl());){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            throw new WriteException("\u5f85\u5199\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728:{}", e);
        }
        catch (IOException e) {
            throw new WriteException("IO\u5f02\u5e38:{}", e);
        }
    }
}

