/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.upload.product;

import com.github.tobato.fastdfs.domain.StorePath;
import com.github.tobato.fastdfs.exception.FdfsServerException;
import com.github.tobato.fastdfs.proto.storage.DownloadByteArray;
import com.github.tobato.fastdfs.proto.storage.DownloadCallback;
import com.github.tobato.fastdfs.service.AppendFileStorageClient;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.qiwenshare.ufop.constant.StorageTypeEnum;
import com.qiwenshare.ufop.constant.UploadFileStatusEnum;
import com.qiwenshare.ufop.exception.operation.UploadException;
import com.qiwenshare.ufop.operation.upload.Uploader;
import com.qiwenshare.ufop.operation.upload.domain.UploadFile;
import com.qiwenshare.ufop.operation.upload.domain.UploadFileResult;
import com.qiwenshare.ufop.operation.upload.request.QiwenMultipartFile;
import com.qiwenshare.ufop.util.RedisUtil;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FastDFSUploader
extends Uploader {
    private static final Logger log = LoggerFactory.getLogger(FastDFSUploader.class);
    @Resource
    AppendFileStorageClient defaultAppendFileStorageClient;
    @Autowired
    private FastFileStorageClient fastFileStorageClient;
    @Resource
    RedisUtil redisUtil;

    @Override
    public void doUploadFileChunk(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) throws IOException {
        if (uploadFile.getChunkNumber() <= 1) {
            log.info("\u4e0a\u4f20\u7b2c\u4e00\u5757");
            StorePath storePath = this.defaultAppendFileStorageClient.uploadAppenderFile("group1", qiwenMultipartFile.getUploadInputStream(), qiwenMultipartFile.getSize(), qiwenMultipartFile.getExtendName());
            this.redisUtil.set("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":uploaded_size", String.valueOf(qiwenMultipartFile.getSize()), 3600000L);
            log.info("\u7b2c\u4e00\u5757\u4e0a\u4f20\u5b8c\u6210");
            if (storePath == null) {
                this.redisUtil.set("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":current_upload_chunk_number", String.valueOf(uploadFile.getChunkNumber()), 3600000L);
                log.info("\u83b7\u53d6\u8fdc\u7a0b\u6587\u4ef6\u8def\u5f84\u51fa\u9519");
                throw new UploadException("\u83b7\u53d6\u8fdc\u7a0b\u6587\u4ef6\u8def\u5f84\u51fa\u9519");
            }
            this.redisUtil.set("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":storage_path", storePath.getPath(), 3600000L);
            log.info("\u4e0a\u4f20\u6587\u4ef6 result = {}", (Object)storePath.getPath());
        } else {
            log.info("\u6b63\u5728\u4e0a\u4f20\u7b2c{}\u5757\uff1a", (Object)uploadFile.getChunkNumber());
            String path = this.redisUtil.getObject("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":storage_path");
            if (path == null) {
                log.error("\u65e0\u6cd5\u83b7\u53d6\u5df2\u4e0a\u4f20\u670d\u52a1\u5668\u6587\u4ef6\u5730\u5740");
                throw new UploadException("\u65e0\u6cd5\u83b7\u53d6\u5df2\u4e0a\u4f20\u670d\u52a1\u5668\u6587\u4ef6\u5730\u5740");
            }
            String uploadedSizeStr = this.redisUtil.getObject("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":uploaded_size");
            long alreadySize = Long.parseLong(uploadedSizeStr);
            this.defaultAppendFileStorageClient.modifyFile("group1", path, qiwenMultipartFile.getUploadInputStream(), qiwenMultipartFile.getSize(), alreadySize);
            this.redisUtil.set("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":uploaded_size", String.valueOf(alreadySize + qiwenMultipartFile.getSize()), 3600000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UploadFileResult organizationalResults(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        UploadFileResult uploadFileResult = new UploadFileResult();
        String path = this.redisUtil.getObject("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":storage_path");
        uploadFileResult.setFileUrl(path);
        uploadFileResult.setFileName(qiwenMultipartFile.getFileName());
        uploadFileResult.setExtendName(qiwenMultipartFile.getExtendName());
        uploadFileResult.setFileSize(uploadFile.getTotalSize());
        if (uploadFile.getTotalChunks() == 1) {
            uploadFileResult.setFileSize(qiwenMultipartFile.getSize());
        }
        uploadFileResult.setStorageType(StorageTypeEnum.FAST_DFS);
        uploadFileResult.setIdentifier(uploadFile.getIdentifier());
        if (uploadFile.getChunkNumber() == uploadFile.getTotalChunks()) {
            log.info("\u5206\u7247\u4e0a\u4f20\u5b8c\u6210");
            this.redisUtil.deleteKey("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":current_upload_chunk_number");
            this.redisUtil.deleteKey("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":storage_path");
            this.redisUtil.deleteKey("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":uploaded_size");
            if (UFOPUtils.isImageFile(uploadFileResult.getExtendName())) {
                String group = "group1";
                String path1 = uploadFileResult.getFileUrl().substring(uploadFileResult.getFileUrl().indexOf("/") + 1);
                DownloadByteArray downloadByteArray = new DownloadByteArray();
                byte[] bytes = (byte[])this.defaultAppendFileStorageClient.downloadFile(group, path1, (DownloadCallback)downloadByteArray);
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                try {
                    BufferedImage src = ImageIO.read(is);
                    uploadFileResult.setBufferedImage(src);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            uploadFileResult.setStatus(UploadFileStatusEnum.SUCCESS);
        } else {
            uploadFileResult.setStatus(UploadFileStatusEnum.UNCOMPLATE);
        }
        return uploadFileResult;
    }

    @Override
    public void cancelUpload(UploadFile uploadFile) {
        String path = this.redisUtil.getObject("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":storage_path");
        try {
            this.fastFileStorageClient.deleteFile(path.replace("M00", "group1"));
        }
        catch (FdfsServerException e) {
            log.error(e.getMessage());
        }
    }
}

