/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.preview.product;

import com.qiwenshare.ufop.config.MinioConfig;
import com.qiwenshare.ufop.domain.ThumbImage;
import com.qiwenshare.ufop.operation.preview.Previewer;
import com.qiwenshare.ufop.operation.preview.domain.PreviewFile;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.errors.MinioException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioPreviewer
extends Previewer {
    private static final Logger log = LoggerFactory.getLogger(MinioPreviewer.class);
    private MinioConfig minioConfig;

    public MinioPreviewer() {
    }

    public MinioPreviewer(MinioConfig minioConfig, ThumbImage thumbImage) {
        this.setMinioConfig(minioConfig);
        this.setThumbImage(thumbImage);
    }

    @Override
    protected InputStream getInputStream(PreviewFile previewFile) {
        GetObjectResponse inputStream = null;
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.minioConfig.getEndpoint()).credentials(this.minioConfig.getAccessKey(), this.minioConfig.getSecretKey()).build();
            inputStream = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(previewFile.getFileUrl())).build());
        }
        catch (MinioException e) {
            System.out.println("Error occurred: " + (Object)((Object)e));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
        return inputStream;
    }

    public MinioConfig getMinioConfig() {
        return this.minioConfig;
    }

    public void setMinioConfig(MinioConfig minioConfig) {
        this.minioConfig = minioConfig;
    }
}

