/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.preview.product;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.OSSObject;
import com.qiwenshare.ufop.config.AliyunConfig;
import com.qiwenshare.ufop.domain.ThumbImage;
import com.qiwenshare.ufop.operation.preview.Previewer;
import com.qiwenshare.ufop.operation.preview.domain.PreviewFile;
import com.qiwenshare.ufop.util.AliyunUtils;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSPreviewer
extends Previewer {
    private static final Logger log = LoggerFactory.getLogger(AliyunOSSPreviewer.class);
    private AliyunConfig aliyunConfig;

    public AliyunOSSPreviewer() {
    }

    public AliyunOSSPreviewer(AliyunConfig aliyunConfig, ThumbImage thumbImage) {
        this.aliyunConfig = aliyunConfig;
        this.setThumbImage(thumbImage);
    }

    @Override
    protected InputStream getInputStream(PreviewFile previewFile) {
        OSS ossClient = AliyunUtils.getOSSClient(this.aliyunConfig);
        OSSObject ossObject = ossClient.getObject(this.aliyunConfig.getOss().getBucketName(), UFOPUtils.getAliyunObjectNameByFileUrl(previewFile.getFileUrl()));
        InputStream inputStream = ossObject.getObjectContent();
        previewFile.setOssClient(ossClient);
        return inputStream;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AliyunOSSPreviewer)) {
            return false;
        }
        AliyunOSSPreviewer other = (AliyunOSSPreviewer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AliyunConfig this$aliyunConfig = this.getAliyunConfig();
        AliyunConfig other$aliyunConfig = other.getAliyunConfig();
        return !(this$aliyunConfig == null ? other$aliyunConfig != null : !((Object)this$aliyunConfig).equals(other$aliyunConfig));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AliyunOSSPreviewer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AliyunConfig $aliyunConfig = this.getAliyunConfig();
        result = result * 59 + ($aliyunConfig == null ? 43 : ((Object)$aliyunConfig).hashCode());
        return result;
    }

    public AliyunConfig getAliyunConfig() {
        return this.aliyunConfig;
    }

    public void setAliyunConfig(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    @Override
    public String toString() {
        return "AliyunOSSPreviewer(aliyunConfig=" + this.getAliyunConfig() + ")";
    }
}

