/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.download.product;

import com.qiniu.util.Auth;
import com.qiwenshare.common.util.HttpsUtils;
import com.qiwenshare.ufop.config.QiniuyunConfig;
import com.qiwenshare.ufop.operation.download.Downloader;
import com.qiwenshare.ufop.operation.download.domain.DownloadFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiniuyunKodoDownloader
extends Downloader {
    private static final Logger log = LoggerFactory.getLogger(QiniuyunKodoDownloader.class);
    private QiniuyunConfig qiniuyunConfig;

    public QiniuyunKodoDownloader() {
    }

    public QiniuyunKodoDownloader(QiniuyunConfig qiniuyunConfig) {
        this.qiniuyunConfig = qiniuyunConfig;
    }

    @Override
    public InputStream getInputStream(DownloadFile downloadFile) {
        Auth auth = Auth.create((String)this.qiniuyunConfig.getKodo().getAccessKey(), (String)this.qiniuyunConfig.getKodo().getSecretKey());
        String urlString = auth.privateDownloadUrl(this.qiniuyunConfig.getKodo().getDomain() + "/" + downloadFile.getFileUrl());
        InputStream inputStream = HttpsUtils.doGet((String)urlString, null);
        try {
            if (downloadFile.getRange() != null) {
                inputStream.skip(downloadFile.getRange().getStart());
                byte[] bytes = new byte[downloadFile.getRange().getLength()];
                IOUtils.read((InputStream)inputStream, (byte[])bytes);
                inputStream = new ByteArrayInputStream(bytes);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return inputStream;
    }
}

