/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage.model;

public class BucketReferAntiLeech {
    int mode = 0;
    boolean allowEmptyReferer = true;
    String pattern;
    final boolean enableSource = true;

    public BucketReferAntiLeech setMode(int mode) throws Exception {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new Exception("Referer anti_leech_mode must be in [0, 1, 2]");
        }
        this.mode = mode;
        return this;
    }

    public BucketReferAntiLeech setAllowEmptyReferer(boolean allowEmptyReferer) {
        this.allowEmptyReferer = allowEmptyReferer;
        return this;
    }

    public BucketReferAntiLeech setPattern(String pattern) throws Exception {
        if (pattern == null || pattern.isEmpty()) {
            throw new Exception("Empty pattern is not allowed");
        }
        this.pattern = pattern;
        return this;
    }

    public BucketReferAntiLeech addPattern(String pattern) throws Exception {
        if (pattern == null || pattern.isEmpty()) {
            throw new Exception("Empty pattern is not allowed");
        }
        if (this.pattern.endsWith(";")) {
            this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
        }
        this.pattern = String.join((CharSequence)this.pattern, ";", pattern);
        return this;
    }

    public String asQueryString() {
        int allowEmptyReferer = this.allowEmptyReferer ? 1 : 0;
        int enableSource = this.enableSource;
        return String.format("mode=%d&norefer=%d&pattern=%s&source_enabled=%d", this.mode, allowEmptyReferer, null == this.pattern ? "" : this.pattern, enableSource);
    }
}

