/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import android.util.Log;
import com.qiniu.android.utils.StringUtils;
import java.util.Date;

public class LogUtil {
    private static boolean enableLog = false;
    private static int logLevel = 2;
    private static boolean enableDate = false;
    private static boolean enableFile = true;
    private static boolean enableFunction = false;

    private LogUtil() {
    }

    public static void enableLog(boolean enable) {
        enableLog = enable;
    }

    public static void enableDate(boolean enable) {
        enableDate = enable;
    }

    public static void enableFile(boolean enable) {
        enableFile = enable;
    }

    public static void enableFunction(boolean enable) {
        enableFunction = enable;
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static int v(String msg) {
        return LogUtil.println(2, null, msg, null);
    }

    public static int v(String tag, String msg) {
        return LogUtil.println(2, tag, msg, null);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return LogUtil.println(2, tag, msg, tr);
    }

    public static int d(String msg) {
        return LogUtil.println(3, null, msg, null);
    }

    public static int d(String tag, String msg) {
        return LogUtil.println(3, tag, msg, null);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return LogUtil.println(3, tag, msg, tr);
    }

    public static int i(String msg) {
        return LogUtil.println(4, null, msg, null);
    }

    public static int i(String tag, String msg) {
        return LogUtil.println(4, tag, msg, null);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return LogUtil.println(4, tag, msg, tr);
    }

    public static int w(String msg) {
        return LogUtil.println(5, null, msg, null);
    }

    public static int w(String tag, String msg) {
        return LogUtil.println(5, tag, msg, null);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return LogUtil.println(5, tag, msg, tr);
    }

    public static int w(String tag, Throwable tr) {
        return LogUtil.println(5, tag, null, tr);
    }

    public static int e(String msg) {
        return LogUtil.println(6, null, msg, null);
    }

    public static int e(String tag, String msg) {
        return LogUtil.println(6, tag, msg, null);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return LogUtil.println(6, tag, msg, tr);
    }

    private static int println(int logLevel, String tag, String msg, Throwable tr) {
        if (LogUtil.shouldLog(logLevel, tag, msg, tr)) {
            switch (logLevel) {
                case 2: {
                    if (tr == null) {
                        return Log.v((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.v((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 3: {
                    if (tr == null) {
                        return Log.d((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.d((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 4: {
                    if (tr == null) {
                        return Log.i((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.i((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 5: {
                    if (tr == null) {
                        return Log.w((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.w((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 6: {
                    if (tr == null) {
                        return Log.e((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.e((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
            }
            return -10001;
        }
        return -10000;
    }

    private static boolean shouldLog(int logLevel, String tag, String msg, Throwable tr) {
        return enableLog && logLevel >= LogUtil.logLevel && (msg != null && msg.length() != 0 || tr != null);
    }

    private static String recreateLogTag(String tag) {
        tag = tag != null ? tag + ":" : "";
        String date = enableDate ? "" + new Date() : "";
        Thread currentThread = Thread.currentThread();
        String threadInfo = StringUtils.toNonnullString(currentThread.getName()) + ":" + StringUtils.toNonnullString(currentThread.getId()) + " ";
        StackTraceElement[] elements = currentThread.getStackTrace();
        if (elements.length > 5 && elements[5] != null) {
            StackTraceElement element = elements[5];
            String fileName = enableFile ? StringUtils.toNonnullString(element.getFileName()) : "";
            String methodName = enableFunction ? "->" + StringUtils.toNonnullString(element.getMethodName()) : "";
            String lineNumber = "->" + element.getLineNumber();
            return date + "[QiNiu:" + threadInfo + tag + fileName + methodName + lineNumber + "]";
        }
        return date + "[QiNiu:" + threadInfo + tag + "]";
    }

    private static String recreateLogMessage(String msg) {
        return msg != null ? msg : "";
    }
}

