/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import java.util.ArrayList;

public class GroupTaskThread
extends Thread {
    public final GroupTaskCompleteHandler completeHandler;
    private ArrayList<GroupTask> tasks = new ArrayList();

    public GroupTaskThread(GroupTaskCompleteHandler completeHandler) {
        this.completeHandler = completeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        while (!this.isInterrupted()) {
            boolean isAllTasksCompleted = false;
            GroupTaskThread groupTaskThread = this;
            synchronized (groupTaskThread) {
                isAllTasksCompleted = this.isAllTasksCompleted();
            }
            if (isAllTasksCompleted) {
                this.completeAction();
                break;
            }
            GroupTask task = this.getNextWaitingTask();
            if (task != null) {
                task.state = GroupTask.State.Running;
                task.run(task);
                continue;
            }
            try {
                GroupTaskThread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(GroupTask task) {
        GroupTaskThread groupTaskThread = this;
        synchronized (groupTaskThread) {
            if (!this.isAllTasksCompleted()) {
                this.tasks.add(task);
            }
        }
    }

    private GroupTask getNextWaitingTask() {
        GroupTask task = null;
        for (int i = 0; i < this.tasks.size(); ++i) {
            GroupTask taskP = this.tasks.get(i);
            if (taskP.state != GroupTask.State.Waiting) continue;
            task = taskP;
            break;
        }
        return task;
    }

    private boolean isAllTasksCompleted() {
        if (this.tasks.size() == 0) {
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < this.tasks.size(); ++i) {
            GroupTask task = this.tasks.get(i);
            if (task.state == GroupTask.State.Complete) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private void completeAction() {
        if (this.completeHandler != null) {
            this.completeHandler.complete();
        }
    }

    public static interface GroupTaskCompleteHandler {
        public void complete();
    }

    public static abstract class GroupTask {
        protected State state = State.Waiting;
        public final String id;

        public GroupTask() {
            this.id = null;
        }

        public GroupTask(String id) {
            this.id = id;
        }

        public abstract void run(GroupTask var1);

        public void taskComplete() {
            this.state = State.Complete;
        }

        protected static enum State {
            Waiting,
            Running,
            Complete;

        }
    }
}

