/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.net.Uri;
import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.collect.UploadInfoReporter;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetchTransaction;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.metrics.UploadTaskMetrics;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.ConcurrentResumeUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.FormUpload;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.PartsUpload;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.storage.UploadSourceFile;
import com.qiniu.android.storage.UploadSourceStream;
import com.qiniu.android.storage.UploadSourceUri;
import com.qiniu.android.storage.serverConfig.ServerConfigMonitor;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.Utils;
import com.qiniu.android.utils.Wait;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONObject;

public class UploadManager {
    private final Configuration config;

    public UploadManager(Recorder recorder) {
        this(recorder, null);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGen) {
        this(new Configuration.Builder().recorder(recorder, keyGen).build());
    }

    public UploadManager() {
        this(new Configuration.Builder().build());
    }

    public UploadManager(Configuration config) {
        this.config = config != null ? config : new Configuration.Builder().build();
        DnsPrefetchTransaction.addDnsLocalLoadTransaction();
        DnsPrefetchTransaction.setDnsCheckWhetherCachedValidTransactionAction();
        ServerConfigMonitor.startMonitor();
    }

    public void put(byte[] data, String key, String token, UpCompletionHandler complete, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, data, complete)) {
            return;
        }
        this.putData(data, null, key, token, options, complete);
    }

    public void put(String filePath, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, filePath, completionHandler)) {
            return;
        }
        this.put(new File(filePath), key, token, completionHandler, options);
    }

    public void put(File file, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, file, completionHandler)) {
            return;
        }
        this.putSource(new UploadSourceFile(file), key, token, options, completionHandler);
    }

    @TargetApi(value=19)
    public void put(Uri uri, ContentResolver resolver, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, uri, completionHandler)) {
            return;
        }
        this.putSource(new UploadSourceUri(uri, resolver), key, token, options, completionHandler);
    }

    public void put(InputStream inputStream, String id, long size, String fileName, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, inputStream, completionHandler)) {
            return;
        }
        UploadSourceStream stream = new UploadSourceStream(inputStream);
        stream.setId(id);
        stream.setSize(size);
        stream.setFileName(fileName);
        this.putSource(stream, key, token, options, completionHandler);
    }

    public ResponseInfo syncPut(byte[] data, String key, String token, UploadOptions options) {
        final ArrayList responseInfos = new ArrayList();
        final Wait wait = new Wait();
        UpCompletionHandler completionHandler = new UpCompletionHandler(){
            final /* synthetic */ UploadManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(String key, ResponseInfo info, JSONObject response) {
                if (info != null) {
                    responseInfos.add(info);
                }
                wait.stopWait();
            }
        };
        if (!this.checkAndNotifyError(key, token, data, completionHandler)) {
            this.putData(data, null, key, token, options, completionHandler);
        }
        wait.startWait();
        if (responseInfos.size() > 0) {
            return (ResponseInfo)responseInfos.get(0);
        }
        return null;
    }

    public ResponseInfo syncPut(String file, String key, String token, UploadOptions options) {
        return this.syncPut(new File(file), key, token, options);
    }

    public ResponseInfo syncPut(File file, String key, String token, UploadOptions options) {
        return this.syncPut(new UploadSourceFile(file), key, token, options);
    }

    @TargetApi(value=19)
    public ResponseInfo syncPut(Uri uri, ContentResolver resolver, String key, String token, UploadOptions options) {
        return this.syncPut(new UploadSourceUri(uri, resolver), key, token, options);
    }

    public ResponseInfo syncPut(InputStream inputStream, String id, long size, String fileName, String key, String token, UploadOptions options) {
        UploadSourceStream stream = new UploadSourceStream(inputStream);
        stream.setId(id);
        stream.setSize(size);
        stream.setFileName(fileName);
        return this.syncPut(stream, key, token, options);
    }

    private ResponseInfo syncPut(UploadSource source, String key, String token, UploadOptions options) {
        final ArrayList responseInfos = new ArrayList();
        final Wait wait = new Wait();
        UpCompletionHandler completionHandler = new UpCompletionHandler(){
            final /* synthetic */ UploadManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(String key, ResponseInfo info, JSONObject response) {
                if (info != null) {
                    responseInfos.add(info);
                }
                wait.stopWait();
            }
        };
        if (!this.checkAndNotifyError(key, token, source, completionHandler)) {
            this.putSource(source, key, token, options, completionHandler);
        }
        wait.startWait();
        if (responseInfos.size() > 0) {
            return (ResponseInfo)responseInfos.get(0);
        }
        return null;
    }

    private void putData(final byte[] data, String fileName, String key, final String token, UploadOptions option, final UpCompletionHandler completionHandler) {
        UpToken t = UpToken.parse(token);
        if (t == null || !t.isValid()) {
            ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            this.completeAction(token, key, data, info, null, null, completionHandler);
            return;
        }
        DnsPrefetchTransaction.addDnsCheckAndPrefetchTransaction(this.config, this.config.zone, t);
        ServerConfigMonitor.setToken(token);
        BaseUpload.UpTaskCompletionHandler completionHandlerP = new BaseUpload.UpTaskCompletionHandler(){
            final /* synthetic */ UploadManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(ResponseInfo responseInfo, String key, UploadTaskMetrics requestMetrics, JSONObject response) {
                this.this$0.completeAction(token, key, data, responseInfo, response, requestMetrics, completionHandler);
            }
        };
        FormUpload up = new FormUpload(data, key, fileName, t, option, this.config, completionHandlerP);
        AsyncRun.runInBack(up);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putSource(final UploadSource source, String key, final String token, UploadOptions option, final UpCompletionHandler completionHandler) {
        if (this.checkAndNotifyError(key, token, source, completionHandler)) {
            return;
        }
        UpToken t = UpToken.parse(token);
        if (t == null || !t.isValid()) {
            ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            this.completeAction(token, key, source, info, null, null, completionHandler);
            return;
        }
        DnsPrefetchTransaction.addDnsCheckAndPrefetchTransaction(this.config, this.config.zone, t);
        ServerConfigMonitor.setToken(token);
        if (source.getSize() > 0L && source.getSize() <= (long)this.config.putThreshold) {
            ResponseInfo errorInfo = null;
            byte[] data = null;
            try {
                data = source.readData((int)source.getSize(), 0L);
            }
            catch (IOException e) {
                errorInfo = ResponseInfo.localIOError("get upload file data error:" + e.getMessage());
            }
            finally {
                source.close();
            }
            if (errorInfo == null) {
                this.putData(data, source.getFileName(), key, token, option, completionHandler);
            } else {
                this.completeAction(token, key, source, errorInfo, null, null, completionHandler);
            }
            return;
        }
        String recorderKey = key;
        if (this.config.recorder != null && this.config.keyGen != null) {
            recorderKey = this.config.keyGen.gen(key, source.getId());
        }
        BaseUpload.UpTaskCompletionHandler completionHandlerP = new BaseUpload.UpTaskCompletionHandler(){
            final /* synthetic */ UploadManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(ResponseInfo responseInfo, String key, UploadTaskMetrics requestMetrics, JSONObject response) {
                this.this$0.completeAction(token, key, source, responseInfo, response, requestMetrics, completionHandler);
            }
        };
        if (this.config.useConcurrentResumeUpload) {
            ConcurrentResumeUpload up = new ConcurrentResumeUpload(source, key, t, option, this.config, this.config.recorder, recorderKey, completionHandlerP);
            AsyncRun.runInBack(up);
        } else {
            PartsUpload up = new PartsUpload(source, key, t, option, this.config, this.config.recorder, recorderKey, completionHandlerP);
            AsyncRun.runInBack(up);
        }
    }

    private boolean checkAndNotifyError(String key, String token, Object input, UpCompletionHandler completionHandler) {
        if (completionHandler == null) {
            throw new NullPointerException("complete handler is null");
        }
        ResponseInfo responseInfo = null;
        if (input == null) {
            responseInfo = ResponseInfo.zeroSize("no input data");
        } else if (input instanceof byte[] && ((byte[])input).length == 0) {
            responseInfo = ResponseInfo.zeroSize("no input data");
        } else if (input instanceof File && ((File)input).length() == 0L) {
            responseInfo = ResponseInfo.zeroSize("file is empty");
        } else if (input instanceof UploadSource && ((UploadSource)input).getSize() == 0L) {
            responseInfo = ResponseInfo.zeroSize("file is empty");
        } else if (token == null || token.length() == 0) {
            responseInfo = ResponseInfo.invalidToken("no token");
        }
        if (responseInfo != null) {
            this.completeAction(token, key, null, responseInfo, responseInfo.response, null, completionHandler);
            return true;
        }
        return false;
    }

    private void completeAction(String token, final String key, Object source, final ResponseInfo responseInfo, final JSONObject response, UploadTaskMetrics taskMetrics, final UpCompletionHandler completionHandler) {
        this.reportQuality(key, source, responseInfo, taskMetrics, token);
        if (completionHandler != null) {
            final Wait wait = new Wait();
            AsyncRun.runInMain(new Runnable(){
                final /* synthetic */ UploadManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    completionHandler.complete(key, responseInfo, response);
                    wait.stopWait();
                }
            });
            wait.startWait();
        }
    }

    private void reportQuality(String key, Object source, ResponseInfo responseInfo, UploadTaskMetrics taskMetrics, String token) {
        UploadSingleRequestMetrics lastSingleMetrics;
        UpToken upToken = UpToken.parse(token);
        if (upToken == null || !upToken.isValid()) {
            return;
        }
        UploadTaskMetrics taskMetricsP = taskMetrics != null ? taskMetrics : new UploadTaskMetrics(null);
        ReportItem item = new ReportItem();
        item.setReport("quality", "log_type");
        item.setReport(taskMetricsP.getUpType(), "up_type");
        item.setReport(Utils.currentTimestamp() / 1000L, "up_time");
        item.setReport(ReportItem.qualityResult(responseInfo), "result");
        item.setReport(key, "target_key");
        item.setReport(upToken.bucket, "target_bucket");
        item.setReport(taskMetricsP.totalElapsedTime(), "total_elapsed_time");
        if (taskMetricsP.getUcQueryMetrics() != null) {
            item.setReport(taskMetricsP.getUcQueryMetrics().totalElapsedTime(), "uc_query_elapsed_time");
        }
        item.setReport(taskMetricsP.requestCount(), "requests_count");
        item.setReport(taskMetricsP.regionCount(), "regions_count");
        item.setReport(taskMetricsP.bytesSend(), "bytes_sent");
        item.setReport(Utils.systemName(), "os_name");
        item.setReport(Utils.systemVersion(), "os_version");
        item.setReport(Utils.sdkLanguage(), "sdk_name");
        item.setReport(Utils.sdkVerion(), "sdk_version");
        UploadRegionRequestMetrics lastRegionMetrics = taskMetricsP.lastMetrics();
        if (lastRegionMetrics != null && (lastSingleMetrics = lastRegionMetrics.lastMetrics()) != null) {
            item.setReport(lastSingleMetrics.getHijacked(), "hijacking");
        }
        String errorType = ReportItem.requestReportErrorType(responseInfo);
        item.setReport(errorType, "error_type");
        if (responseInfo != null && errorType != null) {
            String errorDesc = responseInfo.error != null ? responseInfo.error : responseInfo.message;
            item.setReport(errorDesc, "error_description");
        }
        long fileSize = 0L;
        if (source instanceof UploadSource) {
            fileSize = ((UploadSource)source).getSize();
        } else if (source instanceof byte[]) {
            fileSize = ((byte[])source).length;
        }
        item.setReport(fileSize, "file_size");
        if (source != null && responseInfo.isOK() && taskMetrics.totalElapsedTime() > 0L && fileSize > 0L) {
            item.setReport(Utils.calculateSpeed(fileSize, taskMetrics.totalElapsedTime()), "perceptive_speed");
        }
        UploadInfoReporter.getInstance().report(item, token);
    }
}

