/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.utils.UrlSafeBase64;
import java.util.Date;
import org.json.JSONObject;

public final class UpToken {
    public final String token;
    public final String accessKey;
    public final String bucket;
    private long deadline = -1L;
    private String returnUrl = null;

    private UpToken(String returnUrl, String token, String accessKey, String bucket) {
        this.returnUrl = returnUrl;
        this.token = token;
        this.accessKey = accessKey;
        this.bucket = bucket;
    }

    public static UpToken parse(String token) {
        long deadline;
        JSONObject obj;
        String[] t;
        if (token == null) {
            return null;
        }
        try {
            t = token.split(":");
        }
        catch (Exception e) {
            return null;
        }
        if (t.length != 3) {
            return null;
        }
        byte[] dtoken = UrlSafeBase64.decode(t[2]);
        try {
            String dtokenString = new String(dtoken);
            obj = new JSONObject(dtokenString);
        }
        catch (Exception e) {
            return null;
        }
        String scope = obj.optString("scope");
        String bucket = "";
        if (scope.equals("")) {
            return null;
        }
        String[] scopeSlice = new String[2];
        try {
            scopeSlice = scope.split(":");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scopeSlice.length > 0) {
            bucket = scopeSlice[0];
        }
        if ((deadline = (long)obj.optInt("deadline")) == 0L) {
            return null;
        }
        UpToken upToken = new UpToken(obj.optString("returnUrl"), token, t[0], bucket);
        upToken.deadline = deadline;
        return upToken;
    }

    public static UpToken getInvalidToken() {
        UpToken token = new UpToken("", "", "", "");
        token.deadline = -1L;
        return token;
    }

    public static boolean isInvalid(UpToken token) {
        return token == null || !token.isValid();
    }

    public boolean isValid() {
        return this.accessKey != null && !this.accessKey.isEmpty() && this.bucket != null && !this.bucket.isEmpty();
    }

    public String toString() {
        return this.token;
    }

    public boolean hasReturnUrl() {
        return !this.returnUrl.equals("");
    }

    public String index() {
        String index = "";
        if (this.accessKey != null) {
            index = index + this.accessKey;
        }
        if (this.bucket != null) {
            index = index + this.bucket;
        }
        return index;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public boolean isValidForDuration(long duration) {
        return this.isValidBeforeTimestamp(new Date().getTime() / 1000L + duration);
    }

    public boolean isValidBeforeDate(Date date) {
        if (date == null) {
            return false;
        }
        return this.isValidBeforeTimestamp(date.getTime() / 1000L);
    }

    private boolean isValidBeforeTimestamp(long timestamp) {
        if (this.deadline < 0L) {
            return false;
        }
        return timestamp < this.deadline;
    }
}

